/*
 * Decompiled with CFR 0.152.
 */
package shedar.mods.ic2.nuclearcontrol.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import shedar.mods.ic2.nuclearcontrol.api.PanelString;

public class DataSorter {
    private List<Integer> customOrder;

    public DataSorter() {
        this.customOrder = new ArrayList<Integer>();
    }

    public DataSorter(int size) {
        this.resetOrder(size);
    }

    public DataSorter(int[] order) {
        this.customOrder = order != null ? Arrays.stream(order).boxed().collect(Collectors.toList()) : new ArrayList<Integer>();
    }

    public void saveCustomOrder(List<Integer> newOrder) {
        this.customOrder = new ArrayList<Integer>(newOrder);
    }

    public void resetOrder() {
        int size = this.customOrder.size();
        this.customOrder = new ArrayList<Integer>();
        for (int i = 0; i < size; ++i) {
            this.customOrder.add(i);
        }
    }

    public void resetOrder(int size) {
        this.customOrder = new ArrayList<Integer>();
        for (int i = 0; i < size; ++i) {
            this.customOrder.add(i);
        }
    }

    public <T> void sortList(List<T> data) {
        if (this.customOrder.isEmpty()) {
            this.resetOrder(data.size());
        }
        ArrayList<T> reordered = new ArrayList<T>(data.size());
        HashSet<Integer> addedIndices = new HashSet<Integer>();
        for (int index : this.customOrder) {
            if (index < 0 || index >= data.size()) continue;
            reordered.add(data.get(index));
            addedIndices.add(index);
        }
        for (int i = 0; i < data.size(); ++i) {
            if (addedIndices.contains(i)) continue;
            reordered.add(data.get(i));
        }
        data.clear();
        data.addAll(reordered);
    }

    public void sortListByPrefix(List<PanelString> data, List<PanelString> originalList) {
        if (this.customOrder.isEmpty()) {
            this.resetOrder(originalList.size());
        }
        HashMap<String, Integer> prefixOrderMap = new HashMap<String, Integer>();
        for (int i = 0; i < this.customOrder.size(); ++i) {
            int index = this.customOrder.get(i);
            if (index < 0 || index >= originalList.size()) continue;
            PanelString item = originalList.get(index);
            String prefix = this.getPrefix(item.toString());
            prefixOrderMap.put(prefix, i);
        }
        data.sort((a, b) -> {
            int aIndex = prefixOrderMap.getOrDefault(this.getPrefix(a.toString()), Integer.MAX_VALUE);
            int bIndex = prefixOrderMap.getOrDefault(this.getPrefix(b.toString()), Integer.MAX_VALUE);
            return Integer.compare(aIndex, bIndex);
        });
    }

    private String getPrefix(String s) {
        int colonIndex = s.indexOf(58);
        return colonIndex == -1 ? s : s.substring(0, colonIndex);
    }

    public <T> void computeSortOrder(List<T> listA, List<T> listB) {
        if (listA.size() != listB.size()) {
            throw new IllegalArgumentException("Lists must be the same size and contain the same elements.");
        }
        HashMap<T, Integer> indexMap = new HashMap<T, Integer>();
        for (int i = 0; i < listA.size(); ++i) {
            indexMap.put(listA.get(i), i);
        }
        ArrayList<Integer> sortOrder = new ArrayList<Integer>();
        for (T item : listB) {
            sortOrder.add((Integer)indexMap.get(item));
        }
        this.customOrder = sortOrder;
    }

    public int[] getArray() {
        return this.customOrder.stream().mapToInt(Integer::intValue).toArray();
    }

    public static void setDataSorter(ItemStack stack, DataSorter dataSorter) {
        NBTTagCompound compound = stack.func_77978_p();
        compound.func_74783_a("DataSorter", dataSorter.getArray());
    }
}

