/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.items.sigil;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.api.items.interfaces.ArmourUpgrade;
import WayofTime.alchemicalWizardry.api.items.interfaces.IBindable;
import WayofTime.alchemicalWizardry.api.items.interfaces.ISigil;
import WayofTime.alchemicalWizardry.common.items.EnergyItems;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.SpellHelper;
import WayofTime.alchemicalWizardry.common.tileEntity.TESpectralContainer;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class SigilOfSupression
extends EnergyItems
implements ArmourUpgrade,
ISigil {
    @SideOnly(value=Side.CLIENT)
    private IIcon activeIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon passiveIcon;
    private int radius = 5;
    private int refresh = 100;

    public SigilOfSupression() {
        this.field_77777_bU = 1;
        this.setEnergyUsed(AlchemicalWizardry.sigilSuppressionCost);
        this.func_77637_a(AlchemicalWizardry.tabBloodMagic);
    }

    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        par3List.add(StatCollector.func_74838_a((String)"tooltip.sigilofsupression.desc"));
        this.addBindingInformation(par1ItemStack, par3List);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("AlchemicalWizardry:SigilOfSupression_deactivated");
        this.activeIcon = iconRegister.func_94245_a("AlchemicalWizardry:SigilOfSupression_activated");
        this.passiveIcon = iconRegister.func_94245_a("AlchemicalWizardry:SigilOfSupression_deactivated");
    }

    public IIcon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        if (IBindable.isActive(stack)) {
            return this.activeIcon;
        }
        return this.passiveIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int par1) {
        if (par1 == 1) {
            return this.activeIcon;
        }
        return this.passiveIcon;
    }

    public ItemStack func_77659_a(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        if (!IBindable.checkAndSetItemOwner(par1ItemStack, par3EntityPlayer) || SpellHelper.isFakePlayer(par2World, par3EntityPlayer)) {
            return par1ItemStack;
        }
        if (par3EntityPlayer.func_70093_af()) {
            return par1ItemStack;
        }
        this.toggleSigil(par1ItemStack, par2World, par3EntityPlayer);
        return par1ItemStack;
    }

    public void func_77663_a(ItemStack par1ItemStack, World par2World, Entity par3Entity, int par4, boolean par5) {
        if (!(par3Entity instanceof EntityPlayer)) {
            return;
        }
        if (SpellHelper.isFakePlayer(par2World, (EntityPlayer)par3Entity)) {
            return;
        }
        EntityPlayer par3EntityPlayer = (EntityPlayer)par3Entity;
        if (par1ItemStack.func_77978_p() == null) {
            par1ItemStack.func_77982_d(new NBTTagCompound());
        }
        if (IBindable.isActive(par1ItemStack) && !par2World.field_72995_K) {
            Vec3 blockVec = SpellHelper.getEntityBlockVector((Entity)par3EntityPlayer);
            int x = (int)blockVec.field_72450_a;
            int y = (int)blockVec.field_72448_b;
            int z = (int)blockVec.field_72449_c;
            for (int i = -this.radius; i <= this.radius; ++i) {
                for (int j = -this.radius; j <= this.radius; ++j) {
                    for (int k = -this.radius; k <= this.radius; ++k) {
                        if ((float)(i * i + j * j + k * k) >= ((float)this.radius + 0.5f) * ((float)this.radius + 0.5f)) continue;
                        Block block = par2World.func_147439_a(x + i, y + j, z + k);
                        if (SpellHelper.isBlockFluid(block)) {
                            if (par2World.func_147438_o(x + i, y + j, z + k) != null) {
                                par2World.func_147468_f(x + i, y + j, z + k);
                            }
                            TESpectralContainer.createSpectralBlockAtLocation(par2World, x + i, y + j, z + k, this.refresh);
                            continue;
                        }
                        TileEntity tile = par2World.func_147438_o(x + i, y + j, z + k);
                        if (!(tile instanceof TESpectralContainer)) continue;
                        ((TESpectralContainer)tile).resetDuration(this.refresh);
                    }
                }
            }
        }
        this.checkPassiveDrain(par1ItemStack, par2World, par3EntityPlayer);
    }

    @Override
    public void onArmourUpdate(World world, EntityPlayer player, ItemStack thisItemStack) {
        Vec3 blockVec = SpellHelper.getEntityBlockVector((Entity)player);
        int x = (int)blockVec.field_72450_a;
        int y = (int)blockVec.field_72448_b;
        int z = (int)blockVec.field_72449_c;
        for (int i = -this.radius; i <= this.radius; ++i) {
            for (int j = -this.radius; j <= this.radius; ++j) {
                for (int k = -this.radius; k <= this.radius; ++k) {
                    if ((float)(i * i + j * j + k * k) >= ((float)this.radius + 0.5f) * ((float)this.radius + 0.5f)) continue;
                    Block block = world.func_147439_a(x + i, y + j, z + k);
                    if (SpellHelper.isBlockFluid(block)) {
                        if (world.func_147438_o(x + i, y + j, z + k) != null) {
                            world.func_147468_f(x + i, y + j, z + k);
                        }
                        TESpectralContainer.createSpectralBlockAtLocation(world, x + i, y + j, z + k, this.refresh);
                        continue;
                    }
                    TileEntity tile = world.func_147438_o(x + i, y + j, z + k);
                    if (!(tile instanceof TESpectralContainer)) continue;
                    ((TESpectralContainer)tile).resetDuration(this.refresh);
                }
            }
        }
    }

    @Override
    public boolean isUpgrade() {
        return true;
    }

    @Override
    public int getEnergyForTenSeconds() {
        return 200;
    }
}

