/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.demonVillage;

import WayofTime.alchemicalWizardry.ModBlocks;
import WayofTime.alchemicalWizardry.api.Int3;
import WayofTime.alchemicalWizardry.common.demonVillage.tileEntity.IRoadWard;
import WayofTime.alchemicalWizardry.common.demonVillage.tileEntity.TEDemonPortal;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class DemonVillagePath {
    public int xPos;
    public int yPos;
    public int zPos;
    public ForgeDirection dir;
    public int length;
    public static boolean canGoDown = true;
    public static boolean tunnelIfObstructed = false;
    public static boolean createBridgeInAirIfObstructed = false;

    public DemonVillagePath(int xi, int yi, int zi, ForgeDirection dir, int length) {
        this.xPos = xi;
        this.yPos = yi;
        this.zPos = zi;
        this.dir = dir;
        this.length = length;
    }

    public Int3AndBool constructFullPath(TEDemonPortal portal, World world, int clearance) {
        int xi = this.xPos;
        int yi = this.yPos;
        int zi = this.zPos;
        int rad = this.getRoadRadius();
        int value = 0;
        int finalYPos = this.constructPartialPath(portal, world, clearance, xi - rad * this.dir.offsetX, yi, zi - rad * this.dir.offsetZ, this.dir, this.length + rad, false);
        for (int i = -rad; i <= rad; ++i) {
            value = Math.max(this.constructPartialPath(portal, world, clearance, xi - rad * this.dir.offsetX + i * this.dir.offsetZ, yi, zi - rad * this.dir.offsetZ + i * this.dir.offsetX, this.dir, this.length + 2 * rad, true), value);
            if (!TEDemonPortal.printDebug) continue;
            System.out.println("" + (this.length + 2 * rad) + ", " + value + "");
        }
        Int3 position = new Int3(xi, finalYPos, zi);
        boolean bool = value >= this.length + 2 * rad;
        return new Int3AndBool(position, bool);
    }

    public int constructPartialPath(TEDemonPortal portal, World world, int clearance, int xi, int yi, int zi, ForgeDirection dir, int length, boolean doConstruct) {
        for (int i = 0; i < length; ++i) {
            int xOffset = i * dir.offsetX;
            int zOffset = i * dir.offsetZ;
            boolean completed = false;
            for (int yOffset = 0; yOffset <= clearance; ++yOffset) {
                int sign = 1;
                Block block1 = world.func_147439_a(xi + xOffset, yi + sign * yOffset, zi + zOffset);
                Block highBlock1 = world.func_147439_a(xi + xOffset, yi + sign * yOffset + 1, zi + zOffset);
                if (this.forceReplaceBlock(block1) || !block1.isReplaceable((IBlockAccess)world, xi + xOffset, yi + sign * yOffset, zi + zOffset) && this.isBlockReplaceable(block1) && (this.forceCanTunnelUnder(highBlock1) || highBlock1.isReplaceable((IBlockAccess)world, xi + xOffset, yi + sign * yOffset + 1, zi + zOffset))) {
                    if (doConstruct) {
                        world.func_147465_d(xi + xOffset, yi + sign * yOffset, zi + zOffset, portal.getRoadBlock(), portal.getRoadMeta(), 3);
                    }
                    yi += sign * yOffset;
                    completed = true;
                    break;
                }
                if (!canGoDown) continue;
                sign = -1;
                Block block2 = world.func_147439_a(xi + xOffset, yi + sign * yOffset, zi + zOffset);
                Block highBlock2 = world.func_147439_a(xi + xOffset, yi + sign * yOffset + 1, zi + zOffset);
                if (!this.forceReplaceBlock(block2) && (block2.isReplaceable((IBlockAccess)world, xi + xOffset, yi + sign * yOffset, zi + zOffset) || !this.isBlockReplaceable(block2) || !this.forceCanTunnelUnder(highBlock2) && !highBlock2.isReplaceable((IBlockAccess)world, xi + xOffset, yi + sign * yOffset + 1, zi + zOffset))) continue;
                if (doConstruct) {
                    world.func_147465_d(xi + xOffset, yi + sign * yOffset, zi + zOffset, portal.getRoadBlock(), portal.getRoadMeta(), 3);
                }
                yi += sign * yOffset;
                completed = true;
                break;
            }
            if (completed) continue;
            boolean returnAmount = true;
            if (createBridgeInAirIfObstructed) {
                Block block1 = world.func_147439_a(xi + xOffset, yi, zi + zOffset);
                if (block1.isReplaceable((IBlockAccess)world, xi + xOffset, yi, zi + zOffset) || !this.isBlockReplaceable(block1) || !this.forceReplaceBlock(block1)) {
                    returnAmount = false;
                    if (doConstruct) {
                        world.func_147465_d(xi + xOffset, yi, zi + zOffset, portal.getRoadBlock(), portal.getRoadMeta(), 3);
                    }
                } else {
                    returnAmount = true;
                }
            } else if (tunnelIfObstructed) {
                Block block1 = world.func_147439_a(xi + xOffset, yi, zi + zOffset);
                if (!block1.isReplaceable((IBlockAccess)world, xi + xOffset, yi, zi + zOffset) || this.isBlockReplaceable(block1) || !this.forceReplaceBlock(block1)) {
                    returnAmount = false;
                    if (doConstruct) {
                        world.func_147465_d(xi + xOffset, yi, zi + zOffset, portal.getRoadBlock(), portal.getRoadMeta(), 3);
                        world.func_147468_f(xi + xOffset, yi + 1, zi + zOffset);
                        world.func_147468_f(xi + xOffset, yi + 2, zi + zOffset);
                        world.func_147468_f(xi + xOffset, yi + 3, zi + zOffset);
                    }
                } else {
                    returnAmount = true;
                }
            }
            if (!returnAmount) continue;
            return doConstruct ? i : yi;
        }
        return doConstruct ? length : yi;
    }

    public Int3 getFinalLocation(World world, int clearance) {
        int xi = this.xPos;
        int yi = this.yPos;
        int zi = this.zPos;
        block0: for (int i = 0; i < this.length; ++i) {
            int xOffset = i * this.dir.offsetX;
            int zOffset = i * this.dir.offsetZ;
            for (int yOffset = 0; yOffset <= clearance; ++yOffset) {
                int sign = 1;
                Block block1 = world.func_147439_a(xi + xOffset, yi + sign * yOffset, zi + zOffset);
                Block highBlock1 = world.func_147439_a(xi + xOffset, yi + sign * yOffset + 1, zi + zOffset);
                if (this.forceReplaceBlock(block1) || !block1.isReplaceable((IBlockAccess)world, xi + xOffset, yi + sign * yOffset, zi + zOffset) && this.isBlockReplaceable(block1) && (this.forceCanTunnelUnder(highBlock1) || highBlock1.isReplaceable((IBlockAccess)world, xi + xOffset, yi + sign * yOffset + 1, zi + zOffset))) {
                    yi += sign * yOffset;
                    continue block0;
                }
                sign = -1;
                Block block2 = world.func_147439_a(xi + xOffset, yi + sign * yOffset, zi + zOffset);
                Block highBlock2 = world.func_147439_a(xi + xOffset, yi + sign * yOffset + 1, zi + zOffset);
                if (!this.forceReplaceBlock(block2) && (block2.isReplaceable((IBlockAccess)world, xi + xOffset, yi + sign * yOffset, zi + zOffset) || !this.isBlockReplaceable(block2) || !this.forceCanTunnelUnder(highBlock2) && !highBlock2.isReplaceable((IBlockAccess)world, xi + xOffset, yi + sign * yOffset + 1, zi + zOffset))) continue;
                yi += sign * yOffset;
                continue block0;
            }
        }
        return new Int3(xi, yi, zi);
    }

    public int getRoadRadius() {
        return 1;
    }

    public boolean isBlockReplaceable(Block block) {
        return block.func_149688_o() != Material.field_151584_j && block.func_149688_o() != Material.field_151582_l && !(block instanceof IRoadWard) && !block.equals(ModBlocks.blockDemonPortal);
    }

    public boolean forceReplaceBlock(Block block) {
        return block.func_149688_o().func_76224_d();
    }

    public boolean forceCanTunnelUnder(Block block) {
        return block instanceof BlockFlower || block == Blocks.field_150398_cm;
    }

    public class Int3AndBool {
        public Int3 coords;
        public boolean bool;

        public Int3AndBool(Int3 int3, boolean bool) {
            this.coords = int3;
            this.bool = bool;
        }
    }
}

