/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.TileEntities;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;
import vswe.stevescarts.Carts.MinecartModular;
import vswe.stevescarts.Containers.ContainerBase;
import vswe.stevescarts.Containers.ContainerDetector;
import vswe.stevescarts.Helpers.DetectorType;
import vswe.stevescarts.Helpers.LogicObject;
import vswe.stevescarts.Interfaces.GuiBase;
import vswe.stevescarts.Interfaces.GuiDetector;
import vswe.stevescarts.TileEntities.TileEntityBase;

public class TileEntityDetector
extends TileEntityBase {
    public LogicObject mainObj = new LogicObject(1, 0);
    private int activeTimer = 20;
    private short oldData;
    private boolean hasOldData;

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiBase getGui(InventoryPlayer inv) {
        return new GuiDetector(inv, this);
    }

    @Override
    public ContainerBase getContainer(InventoryPlayer inv) {
        return new ContainerDetector((IInventory)inv, this);
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        int count = nbttagcompound.func_74771_c("LogicObjectCount");
        for (int i = 0; i < count; ++i) {
            this.loadLogicObjectFromInteger(nbttagcompound.func_74762_e("LogicObject" + i));
        }
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        int count = this.saveLogicObject(nbttagcompound, this.mainObj, 0, false);
        nbttagcompound.func_74774_a("LogicObjectCount", (byte)count);
    }

    private int saveLogicObject(NBTTagCompound nbttagcompound, LogicObject obj, int id, boolean saveMe) {
        if (saveMe) {
            nbttagcompound.func_74768_a("LogicObject" + id++, this.saveLogicObjectToInteger(obj));
        }
        for (LogicObject child : obj.getChilds()) {
            id = this.saveLogicObject(nbttagcompound, child, id, true);
        }
        return id;
    }

    private int saveLogicObjectToInteger(LogicObject obj) {
        int returnVal = 0;
        returnVal |= obj.getId() << 24;
        returnVal |= obj.getParent().getId() << 16;
        returnVal |= obj.getExtra() << 8;
        return returnVal |= obj.getData() << 0;
    }

    private void loadLogicObjectFromInteger(int val) {
        byte id = (byte)(val >> 24 & 0xFF);
        byte parent = (byte)(val >> 16 & 0xFF);
        byte extra = (byte)(val >> 8 & 0xFF);
        byte data = (byte)(val >> 0 & 0xFF);
        this.createObject(id, parent, extra, data);
    }

    public void func_145845_h() {
        if (this.activeTimer > 0 && --this.activeTimer == 0) {
            DetectorType.getTypeFromMeta(this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e)).deactivate(this);
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) & 0xFFFFFFF7, 3);
        }
    }

    @Override
    public void receivePacket(int id, byte[] data, EntityPlayer player) {
        if (id == 0) {
            byte lowestId = -1;
            for (int i = 0; i < 128; ++i) {
                if (this.isIdOccupied(this.mainObj, i)) continue;
                lowestId = (byte)i;
                break;
            }
            if (lowestId == -1) {
                return;
            }
            this.createObject(lowestId, data[0], data[1], data[2]);
        } else if (id == 1) {
            this.removeObject(this.mainObj, data[0]);
        }
    }

    private void createObject(byte id, byte parentId, byte extra, byte data) {
        LogicObject newObject = new LogicObject(id, extra, data);
        LogicObject parent = this.getObjectFromId(this.mainObj, parentId);
        if (parent != null) {
            newObject.setParent(parent);
        }
    }

    private LogicObject getObjectFromId(LogicObject object, int id) {
        if (object.getId() == id) {
            return object;
        }
        for (LogicObject child : object.getChilds()) {
            LogicObject result = this.getObjectFromId(child, id);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private boolean removeObject(LogicObject object, int idToRemove) {
        if (object.getId() == idToRemove) {
            object.setParent(null);
            return true;
        }
        for (LogicObject child : object.getChilds()) {
            if (!this.removeObject(child, idToRemove)) continue;
            return true;
        }
        return false;
    }

    private boolean isIdOccupied(LogicObject object, int id) {
        if (object.getId() == id) {
            return true;
        }
        for (LogicObject child : object.getChilds()) {
            if (!this.isIdOccupied(child, id)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void initGuiData(Container con, ICrafting crafting) {
    }

    @Override
    public void checkGuiData(Container con, ICrafting crafting) {
        this.sendUpdatedLogicObjects(con, crafting, this.mainObj, ((ContainerDetector)con).mainObj);
    }

    private void sendUpdatedLogicObjects(Container con, ICrafting crafting, LogicObject real, LogicObject cache) {
        LogicObject clone;
        if (!real.equals(cache)) {
            LogicObject parent = cache.getParent();
            cache.setParent(null);
            clone = real.copy(parent);
            this.removeLogicObject(con, crafting, cache);
            this.sendLogicObject(con, crafting, clone);
            cache = clone;
        }
        while (real.getChilds().size() > cache.getChilds().size()) {
            int i = cache.getChilds().size();
            clone = real.getChilds().get(i).copy(cache);
            this.sendLogicObject(con, crafting, clone);
        }
        while (real.getChilds().size() < cache.getChilds().size()) {
            int i = real.getChilds().size();
            LogicObject toBeRemoved = cache.getChilds().get(i);
            toBeRemoved.setParent(null);
            this.removeLogicObject(con, crafting, toBeRemoved);
        }
        for (int i = 0; i < real.getChilds().size(); ++i) {
            this.sendUpdatedLogicObjects(con, crafting, real.getChilds().get(i), cache.getChilds().get(i));
        }
    }

    private void sendAllLogicObjects(Container con, ICrafting crafting, LogicObject obj) {
        this.sendLogicObject(con, crafting, obj);
        for (LogicObject child : obj.getChilds()) {
            this.sendAllLogicObjects(con, crafting, child);
        }
    }

    private void sendLogicObject(Container con, ICrafting crafting, LogicObject obj) {
        if (obj.getParent() == null) {
            return;
        }
        short data = (short)(obj.getId() << 8 | obj.getParent().getId());
        short data2 = (short)(obj.getExtra() << 8 | obj.getData());
        this.updateGuiData(con, crafting, 0, data);
        this.updateGuiData(con, crafting, 1, data2);
    }

    private void removeLogicObject(Container con, ICrafting crafting, LogicObject obj) {
        this.updateGuiData(con, crafting, 2, obj.getId());
    }

    @Override
    public void receiveGuiData(int id, short data) {
        if (id == 0) {
            this.oldData = data;
            this.hasOldData = true;
        } else if (id == 1) {
            if (!this.hasOldData) {
                System.out.println("Doesn't have the other part of the data");
                return;
            }
            byte logicid = (byte)((this.oldData & 0xFF00) >> 8);
            byte parent = (byte)(this.oldData & 0xFF);
            byte extra = (byte)((data & 0xFF00) >> 8);
            byte logicdata = (byte)(data & 0xFF);
            this.createObject(logicid, parent, extra, logicdata);
            this.recalculateTree();
            this.hasOldData = false;
        } else if (id == 2) {
            this.removeObject(this.mainObj, data);
            this.recalculateTree();
        }
    }

    public void recalculateTree() {
        this.mainObj.generatePosition(5, 60, 245, 0);
    }

    public boolean evaluate(MinecartModular cart, int depth) {
        return this.mainObj.evaluateLogicTree(this, cart, depth);
    }

    public void handleCart(MinecartModular cart) {
        boolean isOn;
        boolean truthValue = this.evaluate(cart, 0);
        int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        boolean bl = isOn = (meta & 8) != 0;
        if (truthValue != isOn) {
            if (truthValue) {
                DetectorType.getTypeFromMeta(meta).activate(this, cart);
                meta |= 8;
            } else {
                DetectorType.getTypeFromMeta(meta).deactivate(this);
                meta &= 0xFFFFFFF7;
            }
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, meta, 3);
        }
        if (truthValue) {
            this.activeTimer = 20;
        }
    }

    @Override
    public boolean isUseableByPlayer(EntityPlayer entityplayer) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return entityplayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }
}

