/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.Helpers;

import java.util.Collection;
import java.util.HashMap;
import net.minecraft.tileentity.TileEntity;
import vswe.stevescarts.Carts.MinecartModular;
import vswe.stevescarts.Helpers.DetectorType;
import vswe.stevescarts.Helpers.Localization;
import vswe.stevescarts.Helpers.LogicObject;
import vswe.stevescarts.TileEntities.TileEntityDetector;

public class OperatorObject {
    private static HashMap<Byte, OperatorObject> allOperators = new HashMap();
    private byte ID;
    private Localization.GUI.DETECTOR name;
    private int childs;

    public static Collection<OperatorObject> getOperatorList(int meta) {
        return DetectorType.getTypeFromMeta(meta).getOperators().values();
    }

    public static HashMap<Byte, OperatorObject> getAllOperators() {
        return allOperators;
    }

    public OperatorObject(HashMap<Byte, OperatorObject> operators, int ID, Localization.GUI.DETECTOR name, int childs) {
        this.ID = (byte)ID;
        this.name = name;
        this.childs = childs;
        operators.put(this.ID, this);
        allOperators.put(this.ID, this);
    }

    public byte getID() {
        return this.ID;
    }

    public String getName() {
        return this.name.translate(new String[0]);
    }

    public int getChildCount() {
        return this.childs;
    }

    public boolean inTab() {
        return true;
    }

    public boolean isChildValid(OperatorObject child) {
        return true;
    }

    public boolean evaluate(TileEntityDetector detector, MinecartModular cart, int depth, LogicObject A, LogicObject B) {
        return false;
    }

    static {
        HashMap<Byte, OperatorObject> operators = new HashMap<Byte, OperatorObject>();
        new OperatorObject((HashMap)operators, 0, Localization.GUI.DETECTOR.OUTPUT, 1){

            @Override
            public boolean inTab() {
                return false;
            }

            @Override
            public boolean evaluate(TileEntityDetector detector, MinecartModular cart, int depth, LogicObject A, LogicObject B) {
                return A.evaluateLogicTree(detector, cart, depth);
            }
        };
        new OperatorObject((HashMap)operators, 1, Localization.GUI.DETECTOR.AND, 2){

            @Override
            public boolean evaluate(TileEntityDetector detector, MinecartModular cart, int depth, LogicObject A, LogicObject B) {
                return A.evaluateLogicTree(detector, cart, depth) && B.evaluateLogicTree(detector, cart, depth);
            }
        };
        new OperatorObject((HashMap)operators, 2, Localization.GUI.DETECTOR.OR, 2){

            @Override
            public boolean evaluate(TileEntityDetector detector, MinecartModular cart, int depth, LogicObject A, LogicObject B) {
                return A.evaluateLogicTree(detector, cart, depth) || B.evaluateLogicTree(detector, cart, depth);
            }
        };
        new OperatorObject((HashMap)operators, 3, Localization.GUI.DETECTOR.NOT, 1){

            @Override
            public boolean isChildValid(OperatorObject child) {
                return this.getID() != child.ID;
            }

            @Override
            public boolean evaluate(TileEntityDetector detector, MinecartModular cart, int depth, LogicObject A, LogicObject B) {
                return !A.evaluateLogicTree(detector, cart, depth);
            }
        };
        new OperatorObject((HashMap)operators, 4, Localization.GUI.DETECTOR.XOR, 2){

            @Override
            public boolean evaluate(TileEntityDetector detector, MinecartModular cart, int depth, LogicObject A, LogicObject B) {
                return A.evaluateLogicTree(detector, cart, depth) != B.evaluateLogicTree(detector, cart, depth);
            }
        };
        new OperatorObjectRedirector(operators, 5, Localization.GUI.DETECTOR.TOP, 0, 1, 0);
        new OperatorObjectRedirector(operators, 6, Localization.GUI.DETECTOR.BOT, 0, -1, 0);
        new OperatorObjectRedirector(operators, 7, Localization.GUI.DETECTOR.NORTH, 0, 0, -1);
        new OperatorObjectRedirector(operators, 8, Localization.GUI.DETECTOR.WEST, -1, 0, 0);
        new OperatorObjectRedirector(operators, 9, Localization.GUI.DETECTOR.SOUTH, 0, 0, 1);
        new OperatorObjectRedirector(operators, 10, Localization.GUI.DETECTOR.EAST, 1, 0, 0);
        for (DetectorType type : DetectorType.values()) {
            type.initOperators(new HashMap<Byte, OperatorObject>(operators));
        }
    }

    public static class OperatorObjectRedirector
    extends OperatorObject {
        private int x;
        private int y;
        private int z;

        public OperatorObjectRedirector(HashMap<Byte, OperatorObject> operators, int ID, Localization.GUI.DETECTOR name, int x, int y, int z) {
            super(operators, ID, name, 0);
            this.x = x;
            this.y = y;
            this.z = z;
        }

        @Override
        public boolean evaluate(TileEntityDetector detector, MinecartModular cart, int depth, LogicObject A, LogicObject B) {
            int x = this.x + detector.field_145851_c;
            int y = this.y + detector.field_145848_d;
            int z = this.z + detector.field_145849_e;
            TileEntity tileentity = detector.func_145831_w().func_147438_o(x, y, z);
            if (tileentity != null && tileentity instanceof TileEntityDetector) {
                return ((TileEntityDetector)tileentity).evaluate(cart, depth);
            }
            return false;
        }
    }

    public static class OperatorObjectRedstone
    extends OperatorObject {
        private int x;
        private int y;
        private int z;

        public OperatorObjectRedstone(HashMap<Byte, OperatorObject> operators, int ID, Localization.GUI.DETECTOR name, int x, int y, int z) {
            super(operators, ID, name, 0);
            this.x = x;
            this.y = y;
            this.z = z;
        }

        @Override
        public boolean evaluate(TileEntityDetector detector, MinecartModular cart, int depth, LogicObject A, LogicObject B) {
            int x = this.x + detector.field_145851_c;
            int y = this.y + detector.field_145848_d;
            int z = this.z + detector.field_145849_e;
            if (this.x == 0 && this.y == 0 && this.z == 0) {
                return detector.func_145831_w().func_72864_z(x, y, z);
            }
            int direction = this.y > 0 ? 0 : (this.y < 0 ? 1 : (this.x > 0 ? 4 : (this.x < 0 ? 5 : (this.z > 0 ? 2 : 3))));
            return detector.func_145831_w().func_72878_l(x, y, z, direction) > 0;
        }
    }
}

