/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.entities.ai;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;

public class TargetPredicate {
    public static final TargetPredicate DEFAULT = new TargetPredicate();
    private double baseMaxDistance = -1.0;
    private boolean includeInvulnerable;
    private boolean includeTeammates;
    private boolean includeHidden;
    private boolean ignoreEntityTargetRules;
    private boolean useDistanceScalingFactor = true;
    private Predicate<EntityLivingBase> predicate;

    public TargetPredicate setBaseMaxDistance(double baseMaxDistance) {
        this.baseMaxDistance = baseMaxDistance;
        return this;
    }

    public TargetPredicate includeInvulnerable() {
        this.includeInvulnerable = true;
        return this;
    }

    public TargetPredicate includeTeammates() {
        this.includeTeammates = true;
        return this;
    }

    public TargetPredicate includeHidden() {
        this.includeHidden = true;
        return this;
    }

    public TargetPredicate ignoreEntityTargetRules() {
        this.ignoreEntityTargetRules = true;
        return this;
    }

    public TargetPredicate ignoreDistanceScalingFactor() {
        this.useDistanceScalingFactor = false;
        return this;
    }

    public TargetPredicate setPredicate(@Nullable Predicate<EntityLivingBase> predicate) {
        this.predicate = predicate;
        return this;
    }

    public boolean test(@Nullable EntityLiving baseEntity, EntityLivingBase targetEntity) {
        if (baseEntity == targetEntity) {
            return false;
        }
        if (!targetEntity.func_70089_S()) {
            return false;
        }
        if (!this.includeInvulnerable && targetEntity.func_85032_ar()) {
            return false;
        }
        if (this.predicate != null && !this.predicate.test(targetEntity)) {
            return false;
        }
        if (baseEntity != null) {
            if (this.baseMaxDistance > 0.0) {
                double d = 1.0;
                double e = Math.max(this.baseMaxDistance * d, 2.0);
                double f = baseEntity.func_70092_e(targetEntity.field_70165_t, targetEntity.field_70163_u, targetEntity.field_70161_v);
                if (f > e * e) {
                    return false;
                }
            }
            if (!this.includeHidden && !baseEntity.func_70635_at().func_75522_a((Entity)targetEntity)) {
                return false;
            }
        }
        return true;
    }
}

