/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.configuration.configs;

import ganymedes01.etfuturum.configuration.ConfigBase;
import java.io.File;

public class ConfigTweaks
extends ConfigBase {
    public static boolean dyableShulkers;
    public static boolean enableOldGravel;
    public static boolean enableRoses;
    public static boolean shulkersSpawnAnywhere;
    public static boolean spawnAnywhereShulkerColors;
    public static boolean deepslateReplacesCobblestone;
    public static boolean stonecutterSawHurts;
    public static boolean squidsBlindPlayers;
    public static boolean stopBoatRotationLock;
    public static float creativeFlightVerticalModifier;
    public static final String catAbandoned = "abandoned ideas";
    public static final String catCustomTweaks = "custom tweaks";
    public static final String catBedrockParity = "bedrock parity";

    public ConfigTweaks(File file) {
        super(file);
        this.setCategoryComment(catBedrockParity, "Features that differ from Bedrock Edition in one way or another, or new content that isn't in Java Edition at all.");
        this.setCategoryComment(catAbandoned, "Scrapped concepts, abandoned ideas, old versions of changed content, etc.");
        this.setCategoryComment(catCustomTweaks, "Tweaks made that are original and not vanilla in any way.");
        this.configCats.add(this.getCategory(catBedrockParity));
        this.configCats.add(this.getCategory(catAbandoned));
    }

    @Override
    protected void syncConfigOptions() {
        dyableShulkers = this.getBoolean("dyableShulkers", catBedrockParity, true, "Clicking a Shulker to dye them. As an added bonus, you can also click them with a water bucket (water is not consumed) or pour water on them to remove the dye.");
        enableRoses = this.getBoolean("enableOldRoses", catAbandoned, true, "");
        enableOldGravel = this.getBoolean("enableOldGravel", catAbandoned, true, "");
        shulkersSpawnAnywhere = this.getBoolean("shulkersSpawnAnywhere", catCustomTweaks, false, "For compatibility reasons, you may want the Shulker to spawn anywhere in the End in random groups like Endermen. These are uncommon.\nShulkers spawned in this way will despawn naturally, unless seated, given armor through a dispenser, or name tagged. Right now Shulkers are otherwise inacessible.");
        spawnAnywhereShulkerColors = this.getBoolean("spawnAnywhereShulkerColors", catCustomTweaks, true, "If spawn anywhere is enabled, spawn Shulkers matching the color of modded biome blocks. Currently supports Enderlicious and Hardcore Ender Expansion terrain blocks.");
        deepslateReplacesCobblestone = this.getBoolean("deepslateReplacesCobblestone", catCustomTweaks, false, "If you want cobblestone to be replaced with cobbled deepslate during world generation.");
        stonecutterSawHurts = this.getBoolean("stonecutterSawHurts", catCustomTweaks, false, "If you want stonecutters to deal damage to players standing on them.");
        squidsBlindPlayers = this.getBoolean("squidsBlindPlayers", catCustomTweaks, false, "Squids will blind players when they take damage.");
        stopBoatRotationLock = this.getBoolean("stopBoatRotationLock", catCustomTweaks, false, "Stops the boat view rotation lock, body rotates with camera.");
        creativeFlightVerticalModifier = this.getFloat("creativeFlightVerticalModifier", catCustomTweaks, 1.0f, 1.0f, 5.0f, "When greater than 1, boosts vertical(up/down) creative flight speed when sprinting.");
    }
}

