/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.blocks.ores.modded;

import com.google.common.collect.Lists;
import ganymedes01.etfuturum.blocks.BaseSubtypesBlock;
import ganymedes01.etfuturum.client.sound.ModSounds;
import ganymedes01.etfuturum.configuration.configs.ConfigFunctions;
import ganymedes01.etfuturum.core.utils.DummyWorld;
import ganymedes01.etfuturum.core.utils.IInitAction;
import ganymedes01.etfuturum.core.utils.Utils;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import org.apache.commons.lang3.StringUtils;

public class BlockGeneralModdedDeepslateOre
extends BaseSubtypesBlock
implements IInitAction {
    public final String[] ores;
    private final float[] hardnesses;
    private final float[] resistances;
    public static final List<BlockGeneralModdedDeepslateOre> loaded = Lists.newLinkedList();

    public BlockGeneralModdedDeepslateOre(String ... names) {
        super(Material.field_151576_e, names);
        this.ores = new String[names.length];
        for (int i = 0; i < names.length; ++i) {
            this.ores[i] = "ore" + StringUtils.capitalize((String)names[i].replaceFirst("^deepslate_", "").replace("_ore", ""));
        }
        this.hardnesses = new float[this.ores.length];
        this.resistances = new float[this.ores.length];
        this.func_149663_c(Utils.getUnlocalisedName("modded_deepslate_ore"));
        this.setBlockSound(ModSounds.soundDeepslate);
        this.func_149711_c(ConfigFunctions.useStoneHardnessForDeepslate ? 3.0f : 4.5f);
        this.func_149752_b(3.0f);
        this.setHarvestLevel("pickaxe", 1);
    }

    @Override
    public void func_149666_a(Item item, CreativeTabs tabs, List<ItemStack> list) {
        for (int i = 0; i < this.ores.length; ++i) {
            ItemStack stack = new ItemStack(item, 1, i);
            if (!Utils.listGeneralModdedDeepslateOre(this.ores[i]) && !Utils.listGeneralModdedDeepslateOre(this.ores[i].replace("Mythril", "Mithril"))) continue;
            list.add(stack);
        }
    }

    @Override
    public String getTextureDomain() {
        return "etfuturum";
    }

    @Override
    public float func_149712_f(World world, int x, int y, int z) {
        return this.hardnesses[Math.min(world.func_72805_g(x, y, z), this.hardnesses.length - 1)];
    }

    @Override
    public float getExplosionResistance(Entity par1Entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        return this.resistances[Math.min(world.func_72805_g(x, y, z), this.resistances.length - 1)];
    }

    @Override
    public void postInitAction() {
        loaded.add(this);
    }

    @Override
    public void onLoadAction() {
        DummyWorld world = new DummyWorld();
        for (int i = 0; i < this.ores.length; ++i) {
            ItemStack stack = Utils.getFirstNonDeepslateBlockFromTag(this.ores[i], new ItemStack(Blocks.field_150366_p));
            Block block = Block.func_149634_a((Item)stack.func_77973_b());
            world.func_147465_d(0, 0, 0, block, stack.func_77960_j(), 0);
            try {
                if (block.getHarvestTool(stack.func_77960_j()) != null) {
                    this.setHarvestLevel("pickaxe", block.getHarvestLevel(stack.func_77960_j()), i);
                }
                this.hardnesses[i] = ConfigFunctions.useStoneHardnessForDeepslate ? block.func_149712_f((World)world, 0, 0, 0) : block.func_149712_f((World)world, 0, 0, 0) * 1.5f;
                this.resistances[i] = block.getExplosionResistance(null, (World)world, 0, 0, 0, 0.0, 0.0, 0.0);
                continue;
            }
            catch (Exception e) {
                this.setHarvestLevel("pickaxe", 1, i);
                this.hardnesses[i] = ConfigFunctions.useStoneHardnessForDeepslate ? Blocks.field_150366_p.field_149782_v : Blocks.field_150366_p.field_149782_v * 1.5f;
                this.resistances[i] = Blocks.field_150366_p.field_149781_w;
            }
        }
        world.clearBlocksCache();
    }
}

