/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ganymedes01.etfuturum.ModBlocks;
import ganymedes01.etfuturum.blocks.BaseBlock;
import ganymedes01.etfuturum.client.sound.ModSounds;
import ganymedes01.etfuturum.entities.EntityNewBoat;
import ganymedes01.etfuturum.lib.RenderIDs;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class BlockHoney
extends BaseBlock {
    private IIcon bottomIcon;
    private IIcon topIcon;

    public BlockHoney() {
        super(Material.field_151571_B);
        this.setNames("honey_block");
        this.setBlockSound(ModSounds.soundHoneyBlock);
    }

    public void func_149746_a(World world, int x, int y, int z, Entity entity, float fallDistance) {
        world.func_72956_a(entity, "minecraft_1.21:block.honey_block.slide", 1.0f, 1.0f);
        BlockHoney.showJumpParticles(entity);
        entity.field_70143_R *= 0.2f;
    }

    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        if (this.isSlidingDown(entity, x, y, z)) {
            this.doSlideMovement(entity);
            this.maybeDoSlideEffects(world, entity);
        }
        if (entity.field_70122_E) {
            entity.field_70159_w *= 0.4;
            entity.field_70179_y *= 0.4;
        }
        super.func_149670_a(world, x, y, z, entity);
    }

    private boolean isSlidingDown(Entity p_54009_, int x, int y, int z) {
        if (p_54009_.field_70122_E || p_54009_.field_70163_u > (double)y + 0.9375 - 1.0E-7 || p_54009_.field_70181_x >= -0.08) {
            return false;
        }
        double d0 = Math.abs((double)x + 0.5 - p_54009_.field_70165_t);
        double d1 = Math.abs((double)z + 0.5 - p_54009_.field_70161_v);
        double d2 = 0.4375 + (double)p_54009_.field_70130_N * 0.5;
        return d0 + 1.0E-7 > d2 || d1 + 1.0E-7 > d2;
    }

    private void doSlideMovement(Entity p_54020_) {
        if (p_54020_.field_70181_x < -0.13) {
            double d0 = -0.05 / p_54020_.field_70181_x;
            p_54020_.field_70159_w *= d0;
            p_54020_.field_70179_y *= d0;
        }
        p_54020_.field_70181_x = -0.05;
        p_54020_.field_70143_R = 0.0f;
    }

    private void maybeDoSlideEffects(World world, Entity entity) {
        if (BlockHoney.doesEntityDoHoneyBlockSlideEffects(entity) && world.field_73012_v.nextInt(5) == 0) {
            world.func_72956_a(entity, "minecraft_1.21:block.honey_block.slide", 1.0f, 1.0f);
            BlockHoney.showSlideParticles(entity);
        }
    }

    public static void showSlideParticles(Entity p_53987_) {
        BlockHoney.showParticles(p_53987_, 5);
    }

    public static void showJumpParticles(Entity p_54011_) {
        BlockHoney.showParticles(p_54011_, 10);
    }

    private static void showParticles(Entity p_53989_, int p_53990_) {
        if (p_53989_.field_70170_p.field_72995_K) {
            for (int i = 0; i < p_53990_; ++i) {
                p_53989_.field_70170_p.func_72869_a("blockcrack_" + Block.func_149682_b((Block)ModBlocks.HONEY_BLOCK.get()) + "_0", p_53989_.field_70165_t, p_53989_.field_70163_u - (double)p_53989_.field_70131_O, p_53989_.field_70161_v, 0.0, 0.0, 0.0);
            }
        }
    }

    private static boolean doesEntityDoHoneyBlockSlideEffects(Entity p_54013_) {
        return p_54013_ instanceof EntityLivingBase || p_54013_ instanceof EntityMinecart || p_54013_ instanceof EntityTNTPrimed || p_54013_ instanceof EntityBoat || p_54013_ instanceof EntityNewBoat;
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        float f = 0.0625f;
        return AxisAlignedBB.func_72330_a((double)((float)x + f), (double)((float)y + f), (double)((float)z + f), (double)((float)(x + 1) - f), (double)((float)(y + 1) - f), (double)((float)(z + 1) - f));
    }

    public IIcon func_149691_a(int side, int meta) {
        return side == 0 ? this.bottomIcon : (side == 1 ? this.topIcon : this.field_149761_L);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        this.field_149761_L = reg.func_94245_a(this.func_149641_N() + "_side");
        this.topIcon = reg.func_94245_a(this.func_149641_N() + "_top");
        this.bottomIcon = reg.func_94245_a(this.func_149641_N() + "_bottom");
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149701_w() {
        return 1;
    }

    public int func_149645_b() {
        return RenderIDs.HONEY_BLOCK;
    }
}

