/*
 * Decompiled with CFR 0.152.
 */
package elan.tweaks.common.gui.dto;

import elan.tweaks.common.gui.dto.Scale;
import elan.tweaks.common.gui.dto.Vector3D;
import elan.tweaks.common.gui.dto.VectorXY;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0011\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\fH\u0096\u0002J\u0011\u0010\r\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0003H\u0096\u0002J\u0011\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u0003H\u0096\u0002J\u0011\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0010H\u0096\u0002J\u0011\u0010\u000e\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0086\u0002J\u0011\u0010\r\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0086\u0002J\u0011\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0001H\u0096\u0002J\u0011\u0010\r\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0001H\u0096\u0002J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0012\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u001d"}, d2={"Lelan/tweaks/common/gui/dto/Vector2D;", "Lelan/tweaks/common/gui/dto/VectorXY;", "x", "", "y", "<init>", "(II)V", "getX", "()I", "getY", "times", "scalar", "", "minus", "plus", "scale", "Lelan/tweaks/common/gui/dto/Scale;", "Lelan/tweaks/common/gui/dto/Vector3D;", "other", "component1", "component2", "copy", "equals", "", "", "hashCode", "toString", "", "Companion", "ThaumcraftResearchTweaks"})
public final class Vector2D
implements VectorXY {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int x;
    private final int y;
    @NotNull
    private static final Vector2D ZERO = new Vector2D(0, 0);

    public Vector2D(int x, int y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    @NotNull
    public VectorXY times(double scalar) {
        return new Vector2D(MathKt.roundToInt((double)((double)this.getX() * scalar)), MathKt.roundToInt((double)((double)this.getY() * scalar)));
    }

    @Override
    @NotNull
    public Vector2D minus(int scalar) {
        return new Vector2D(this.getX() - scalar, this.getY() - scalar);
    }

    @Override
    @NotNull
    public VectorXY plus(int scalar) {
        return new Vector2D(this.getX() + scalar, this.getY() + scalar);
    }

    @Override
    @NotNull
    public Vector2D plus(@NotNull Scale scale) {
        Intrinsics.checkNotNullParameter((Object)scale, (String)"scale");
        return new Vector2D(this.getX() + scale.getWidth(), this.getY() + scale.getHeight());
    }

    @NotNull
    public final Vector3D plus(@NotNull Vector3D other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Vector3D.copy$default(other, this.getX() + other.getX(), this.getY() + other.getY(), 0.0, 4, null);
    }

    @NotNull
    public final Vector3D minus(@NotNull Vector3D other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Vector3D.copy$default(other, this.getX() - other.getX(), this.getY() - other.getY(), 0.0, 4, null);
    }

    @Override
    @NotNull
    public Vector2D plus(@NotNull VectorXY other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new Vector2D(this.getX() + other.getX(), this.getY() + other.getY());
    }

    @Override
    @NotNull
    public Vector2D minus(@NotNull VectorXY other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new Vector2D(this.getX() - other.getX(), this.getY() - other.getY());
    }

    public final int component1() {
        return this.x;
    }

    public final int component2() {
        return this.y;
    }

    @NotNull
    public final Vector2D copy(int x, int y) {
        return new Vector2D(x, y);
    }

    public static /* synthetic */ Vector2D copy$default(Vector2D vector2D, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = vector2D.x;
        }
        if ((n3 & 2) != 0) {
            n2 = vector2D.y;
        }
        return vector2D.copy(n, n2);
    }

    @NotNull
    public String toString() {
        return "Vector2D(x=" + this.x + ", y=" + this.y + ')';
    }

    public int hashCode() {
        int result = Integer.hashCode(this.x);
        result = result * 31 + Integer.hashCode(this.y);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Vector2D)) {
            return false;
        }
        Vector2D vector2D = (Vector2D)other;
        if (this.x != vector2D.x) {
            return false;
        }
        return this.y == vector2D.y;
    }

    @Override
    public int compareTo(@NotNull VectorXY other) {
        return VectorXY.DefaultImpls.compareTo(this, other);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lelan/tweaks/common/gui/dto/Vector2D$Companion;", "", "<init>", "()V", "ZERO", "Lelan/tweaks/common/gui/dto/Vector2D;", "getZERO", "()Lelan/tweaks/common/gui/dto/Vector2D;", "ThaumcraftResearchTweaks"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Vector2D getZERO() {
            return ZERO;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

