/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.storage.liquid;

import codechicken.core.ClientUtils;
import codechicken.core.fluid.FluidUtils;
import codechicken.enderstorage.EnderStorage;
import codechicken.enderstorage.api.EnderStorageManager;
import codechicken.enderstorage.common.RenderCustomEndPortal;
import codechicken.enderstorage.common.RenderEnderStorage;
import codechicken.enderstorage.internal.EnderStorageClientProxy;
import codechicken.enderstorage.storage.liquid.TileEnderTank;
import codechicken.lib.math.MathHelper;
import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCModelLibrary;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.RenderUtils;
import codechicken.lib.render.uv.UVTranslation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.SwapYZ;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class EnderTankRenderer
extends TileEntitySpecialRenderer {
    private static final ResourceLocation ENDERTANK_TEXTURE = new ResourceLocation("enderstorage:textures/endertank.png");
    private static final ResourceLocation BUTTONS_TEXTURE = new ResourceLocation("enderstorage:textures/buttons.png");
    private static final ResourceLocation HEDRON_TEXTURE = new ResourceLocation("enderstorage:textures/hedronmap.png");
    private static final CCModel tankModel;
    private static final CCModel valveModel;
    private static final CCModel[] buttons;
    private static final UVTranslation[] UVTranslationButtons;
    private static final UVTranslation UVTvalveOwned;
    private static final UVTranslation UVTvalveNotOwned;
    private static final Vector3 Y;
    private static final Vector3 Z;
    private static final Vector3 point;
    private static final RenderCustomEndPortal renderEndPortal;

    public void func_147500_a(TileEntity tile, double x, double y, double z, float f) {
        TileEnderTank tank = (TileEnderTank)tile;
        CCRenderState state = CCRenderState.instance();
        state.resetInstance();
        state.pullLightmapInstance();
        state.useNormals = true;
        EnderTankRenderer.renderTank(state, tank.rotation, (float)MathHelper.interpolate((double)tank.pressure_state.b_rotate, (double)tank.pressure_state.a_rotate, (double)f) * 0.01745f, tank.freq, !tank.owner.equals("global"), x, y, z, EnderStorageClientProxy.getTimeOffset(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e), EnderTankRenderer.shouldRenderFx(tile));
        EnderTankRenderer.renderLiquid(tank.liquid_state.c_liquid, x, y, z);
    }

    private static boolean shouldRenderFx(TileEntity tile) {
        TileEntityRendererDispatcher info = TileEntityRendererDispatcher.field_147556_a;
        double viewX = info.field_147560_j;
        double viewY = info.field_147561_k;
        double viewZ = info.field_147558_l;
        return tile.func_145835_a(viewX, viewY, viewZ) < 256.0;
    }

    public static void renderTank(CCRenderState state, int rotation, float valve, int freq, boolean owned, double x, double y, double z, int offset, boolean renderFx) {
        if (renderFx && !EnderStorage.disableFXTank) {
            renderEndPortal.renderAt(x, y, z);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)2977);
        GL11.glPushMatrix();
        GL11.glTranslated((double)(x + 0.5), (double)y, (double)(z + 0.5));
        GL11.glRotatef((float)(-90 * (rotation + 2)), (float)0.0f, (float)1.0f, (float)0.0f);
        CCRenderState.changeTexture((ResourceLocation)ENDERTANK_TEXTURE);
        state.startDrawingInstance(4);
        tankModel.render(new CCRenderState.IVertexOperation[0]);
        state.drawInstance();
        CCRenderState.changeTexture((ResourceLocation)BUTTONS_TEXTURE);
        state.startDrawingInstance(7);
        for (int i = 0; i < 3; ++i) {
            int colour = EnderStorageManager.getColourFromFreq(freq, i);
            buttons[i].render(new CCRenderState.IVertexOperation[]{UVTranslationButtons[colour]});
        }
        state.drawInstance();
        new Rotation((double)valve, Z).at(point).glApply();
        CCRenderState.changeTexture((ResourceLocation)ENDERTANK_TEXTURE);
        state.startDrawingInstance(4);
        valveModel.render(new CCRenderState.IVertexOperation[]{owned ? UVTvalveOwned : UVTvalveNotOwned});
        state.drawInstance();
        GL11.glPopMatrix();
        GL11.glDisable((int)2977);
        if (renderFx) {
            double time = ClientUtils.getRenderTime() + (double)offset;
            Matrix4 pearlMat = CCModelLibrary.getRenderMatrix((double)(x + 0.5), (double)(y + 0.45 + (double)(EnderStorageClientProxy.getPearlBob(time) * 2.0f)), (double)(z + 0.5), (Rotation)new Rotation(time / 3.0, Y), (double)0.04);
            GL11.glDisable((int)2896);
            CCRenderState.changeTexture((ResourceLocation)HEDRON_TEXTURE);
            state.startDrawingInstance(4);
            CCModelLibrary.icosahedron4.render(new CCRenderState.IVertexOperation[]{pearlMat});
            state.drawInstance();
            GL11.glEnable((int)2896);
        }
    }

    public static void renderLiquid(FluidStack liquid, double x, double y, double z) {
        RenderUtils.renderFluidCuboid((FluidStack)liquid, (Cuboid6)new Cuboid6(0.22 + x, 0.12 + y, 0.22 + z, 0.78 + x, 0.751 + y, 0.78 + z), (double)((double)liquid.amount / ((double)EnderStorage.enderTankSize * (double)FluidUtils.B)), (double)0.75);
    }

    static {
        UVTranslationButtons = new UVTranslation[16];
        UVTvalveOwned = new UVTranslation(0.0, 0.203125);
        UVTvalveNotOwned = new UVTranslation(0.0, 0.0);
        Y = new Vector3(0.0, 1.0, 0.0);
        Z = new Vector3(0.0, 0.0, 1.0);
        point = new Vector3(0.0, 0.4165, 0.0);
        renderEndPortal = new RenderCustomEndPortal(0.1205, 0.24, 0.76, 0.24, 0.76);
        Map models = CCModel.parseObjModels((ResourceLocation)new ResourceLocation("enderstorage", "models/endertank.obj"), (Transformation)new SwapYZ());
        ArrayList tankParts = new ArrayList();
        tankParts.add(models.get("Blazerod1"));
        tankParts.add(models.get("Blazerod2"));
        tankParts.add(models.get("Blazerod3"));
        tankParts.add(models.get("Blazerod4"));
        tankParts.add(models.get("Top"));
        tankParts.add(models.get("Top2"));
        tankParts.add(models.get("Base"));
        tankParts.add(models.get("Glass"));
        tankParts.add(models.get("Valvebase"));
        Translation fix = new Translation(-0.5099, 0.0, -0.5027);
        tankModel = CCModel.combine(tankParts).apply((Transformation)fix).computeNormals();
        valveModel = ((CCModel)models.get("Valve")).apply((Transformation)fix).computeNormals();
        buttons = new CCModel[3];
        for (int i = 0; i < 3; ++i) {
            EnderTankRenderer.buttons[i] = RenderEnderStorage.button.copy().apply((Transformation)TileEnderTank.buttonT[i].with((Transformation)new Translation(-0.5, 0.0, -0.5)));
        }
        for (int colour = 0; colour < 16; ++colour) {
            EnderTankRenderer.UVTranslationButtons[colour] = new UVTranslation(0.25 * (double)(colour % 4), 0.25 * (double)(colour / 4));
        }
    }
}

