/*
 * Decompiled with CFR 0.152.
 */
package com.arc.bloodarsenal.common.tileentity;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.SpellHelper;
import com.arc.bloodarsenal.common.items.tool.IFillable;
import com.arc.bloodarsenal.common.tileentity.FluidTankRestricted;
import com.arc.bloodarsenal.common.tileentity.PacketHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class TileLifeInfuser
extends TileEntity
implements IInventory,
IFluidTank,
IFluidHandler {
    private ItemStack[] inv;
    public static final int sizeInv = 1;
    public int ticksExisted = 0;
    public static int damageLastTick = 0;
    public boolean tookLastTick = true;
    protected FluidStack fluid;
    public int capacity = 20000;
    private boolean canBeFilled;
    protected FluidStack fluidInput;
    private int bufferCapacity = 1000;
    public FluidTank[] tanks = new FluidTank[]{new FluidTankRestricted(20000, "Life Essence")};

    public TileLifeInfuser() {
        this.inv = new ItemStack[1];
        this.fluid = new FluidStack(AlchemicalWizardry.lifeEssenceFluid, 0);
        this.fluidInput = new FluidStack(AlchemicalWizardry.lifeEssenceFluid, 0);
    }

    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        NBTTagList tagList = par1NBTTagCompound.func_150295_c("Inventory", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            byte slot = tag.func_74771_c("Slot");
            if (slot < 0 || slot >= this.inv.length) continue;
            this.inv[slot] = ItemStack.func_77949_a((NBTTagCompound)tag);
        }
        if (!par1NBTTagCompound.func_74764_b("Empty")) {
            FluidStack fluidIn;
            FluidStack fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)par1NBTTagCompound);
            if (fluid != null) {
                this.setMainFluid(fluid);
            }
            if ((fluidIn = new FluidStack(AlchemicalWizardry.lifeEssenceFluid, par1NBTTagCompound.func_74762_e("inputAmount"))) != null) {
                this.setInputFluid(fluidIn);
            }
        }
        this.canBeFilled = par1NBTTagCompound.func_74767_n("canBeFilled");
        this.capacity = par1NBTTagCompound.func_74762_e("capacity");
        this.bufferCapacity = par1NBTTagCompound.func_74762_e("bufferCapacity");
    }

    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.inv.length; ++i) {
            if (this.inv[i] == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("Slot", (byte)i);
            this.inv[i].func_77955_b(tag);
            itemList.func_74742_a((NBTBase)tag);
        }
        par1NBTTagCompound.func_74782_a("Inventory", (NBTBase)itemList);
        if (this.fluid != null) {
            this.fluid.writeToNBT(par1NBTTagCompound);
        } else {
            par1NBTTagCompound.func_74778_a("Empty", "");
        }
        if (this.fluidInput != null) {
            par1NBTTagCompound.func_74768_a("inputAmount", this.fluidInput.amount);
        }
        par1NBTTagCompound.func_74782_a("Inventory", (NBTBase)itemList);
        par1NBTTagCompound.func_74757_a("canBeFilled", this.canBeFilled);
        par1NBTTagCompound.func_74768_a("capacity", this.capacity);
        par1NBTTagCompound.func_74768_a("bufferCapacity", this.bufferCapacity);
    }

    public int func_70302_i_() {
        return 1;
    }

    public ItemStack func_70301_a(int slot) {
        return this.inv[slot];
    }

    public ItemStack func_70298_a(int slot, int amt) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            if (stack.field_77994_a <= amt) {
                this.func_70299_a(slot, null);
            } else {
                stack = stack.func_77979_a(amt);
                if (stack.field_77994_a == 0) {
                    this.func_70299_a(slot, null);
                }
            }
        }
        return stack;
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            this.func_70299_a(slot, null);
        }
        return stack;
    }

    public void func_70299_a(int slot, ItemStack itemStack) {
        this.inv[slot] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return "TileLifeInfuser";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer entityPlayer) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && entityPlayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) < 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.func_72820_D() % 10L == 0L) {
            int intakeMax = 500;
            int fluidInputted = Math.min(intakeMax, this.capacity - this.fluid.amount);
            fluidInputted = Math.min(this.fluidInput.amount, fluidInputted);
            this.fluid.amount += fluidInputted;
            this.fluidInput.amount -= fluidInputted;
        }
        if (++this.ticksExisted % 10 == 0) {
            ItemStack inputStack = this.inv[0];
            if (inputStack != null) {
                if (inputStack.func_77973_b() instanceof IFillable) {
                    IFillable fillable = (IFillable)inputStack.func_77973_b();
                    int fillAmount = 200;
                    if (fillable.getLPStored(inputStack) < fillable.getMaxLP() && fillable.getLPStored(inputStack) + fillAmount <= fillable.getMaxLP() && this.getFluidAmount() >= fillAmount) {
                        this.fluid.amount -= fillAmount;
                        fillable.incrementLPStored(inputStack, fillAmount);
                        SpellHelper.sendIndexedParticleToAllAround((World)this.field_145850_b, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (int)20, (int)this.field_145850_b.field_73011_w.field_76574_g, (int)1, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e);
                    }
                } else if (inputStack.func_77973_b().func_77645_m() && inputStack.func_77973_b().isDamaged(inputStack)) {
                    int lpCost = 300;
                    int damage = inputStack.func_77960_j();
                    if (this.getFluidAmount() >= lpCost) {
                        this.fluid.amount -= lpCost;
                    } else {
                        return;
                    }
                    inputStack.func_77964_b(Math.max(0, damage - 1));
                    this.processInput();
                    this.func_70296_d();
                    if (damageLastTick != 0 && damageLastTick != damage) {
                        SpellHelper.sendIndexedParticleToAllAround((World)this.field_145850_b, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (int)20, (int)this.field_145850_b.field_73011_w.field_76574_g, (int)1, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e);
                        this.tookLastTick = true;
                    } else {
                        this.tookLastTick = false;
                    }
                }
            } else {
                this.tookLastTick = false;
            }
            int n = damageLastTick = inputStack == null ? 0 : inputStack.func_77960_j();
        }
        if (this.field_145850_b != null) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public boolean func_94041_b(int slot, ItemStack itemstack) {
        return slot == 0;
    }

    public void sendChatInfoToPlayer(EntityPlayer player) {
        player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"message.tile.contains") + " " + this.getFluidAmount() + "LE"));
    }

    public Packet func_145844_m() {
        return PacketHandler.getPacket(this);
    }

    public void handlePacketData(int[] intData, int[] fluidData, int capacity) {
        if (intData == null) {
            return;
        }
        if (intData.length == 3) {
            for (int i = 0; i < 1; ++i) {
                ItemStack is;
                this.inv[i] = intData[i * 3 + 2] != 0 ? (is = new ItemStack(Item.func_150899_d((int)intData[i * 3]), intData[i * 3 + 2], intData[i * 3 + 1])) : null;
            }
        }
        FluidStack flMain = new FluidStack(this.fluid, fluidData[1]);
        FluidStack flIn = new FluidStack(this.fluidInput, fluidData[3]);
        this.setMainFluid(flMain);
        this.setInputFluid(flIn);
        this.capacity = capacity;
    }

    public int[] buildIntDataList() {
        int[] sortList = new int[3];
        for (ItemStack is : this.inv) {
            int pos = 0;
            if (is != null) {
                sortList[pos++] = Item.func_150891_b((Item)is.func_77973_b());
                sortList[pos++] = is.func_77960_j();
                sortList[pos++] = is.field_77994_a;
                continue;
            }
            sortList[pos++] = 0;
            sortList[pos++] = 0;
            sortList[pos++] = 0;
        }
        return sortList;
    }

    public FluidTank[] getTanks() {
        return this.tanks;
    }

    public int fillMainTank(int amount) {
        int filledAmount = Math.min(this.capacity - this.fluid.amount, amount);
        this.fluid.amount += filledAmount;
        return filledAmount;
    }

    public boolean processInput() {
        for (int i = 0; i < this.getTanks().length; ++i) {
            int c = this.fluidAmount();
            if (c <= 0 || this.getTanks()[i].getFluidAmount() < this.fluidAmount()) continue;
            this.getTanks()[i].drain(this.fluidAmount(), true);
            return true;
        }
        return false;
    }

    public int fluidAmount() {
        return this.fluid.amount;
    }

    public int fill(FluidStack resource, boolean doFill) {
        TileLifeInfuser tile = this;
        if (resource == null) {
            return 0;
        }
        if (resource.getFluid().getID() != this.fluidInput.getFluid().getID()) {
            return 0;
        }
        if (!doFill) {
            if (this.fluidInput == null) {
                return Math.min(this.bufferCapacity, resource.amount);
            }
            if (!this.fluidInput.isFluidEqual(resource)) {
                return 0;
            }
            return Math.min(this.bufferCapacity - this.fluidInput.amount, resource.amount);
        }
        if (this.fluidInput == null) {
            this.fluidInput = new FluidStack(resource, resource.amount);
            FluidEvent.fireEvent((FluidEvent)new FluidEvent.FluidFillingEvent(this.fluidInput, tile.func_145831_w(), tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, (IFluidTank)this, this.fluidInput.amount));
            return this.fluidInput.amount;
        }
        if (!this.fluidInput.isFluidEqual(resource)) {
            return 0;
        }
        int filled = this.bufferCapacity - this.fluidInput.amount;
        if (resource.amount < filled) {
            this.fluidInput.amount += resource.amount;
            filled = resource.amount;
        } else {
            this.fluidInput.amount = this.bufferCapacity;
        }
        FluidEvent.fireEvent((FluidEvent)new FluidEvent.FluidFillingEvent(this.fluidInput, tile.func_145831_w(), tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, (IFluidTank)this, filled));
        return filled;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        resource = resource.copy();
        int totalUsed = 0;
        int used = this.fill(resource, doFill);
        resource.amount -= used;
        return totalUsed += used;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxEmpty, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.fluidInput != null && this.fluid.getFluid().equals(this.fluidInput.getFluid());
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public void setMainFluid(FluidStack fluid) {
        this.fluid = fluid;
    }

    public void setInputFluid(FluidStack fluid) {
        this.fluidInput = fluid;
    }

    public FluidStack getFluid() {
        return this.fluid;
    }

    public int getFluidAmount() {
        if (this.fluid == null) {
            return 0;
        }
        return this.fluid.amount;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public FluidTankInfo getInfo() {
        return new FluidTankInfo((IFluidTank)this);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        FluidTank compositeTank = new FluidTank(this.capacity);
        compositeTank.setFluid(this.fluid);
        return new FluidTankInfo[]{compositeTank.getInfo()};
    }

    public int[] buildFluidList() {
        int[] sortList = new int[4];
        if (this.fluid == null) {
            sortList[0] = AlchemicalWizardry.lifeEssenceFluid.getID();
            sortList[1] = 0;
        } else {
            sortList[0] = this.fluid.getFluid().getID();
            sortList[1] = this.fluid.amount;
        }
        if (this.fluidInput == null) {
            sortList[2] = AlchemicalWizardry.lifeEssenceFluid.getID();
            sortList[3] = 0;
        } else {
            sortList[2] = this.fluidInput.getFluid().getID();
            sortList[3] = this.fluidInput.amount;
        }
        return sortList;
    }
}

