/*
 * Decompiled with CFR 0.152.
 */
package net.glease.structurecompat;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.implementations.items.IAEItemPowerStorage;
import appeng.api.implementations.tiles.IViewCellStorage;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.items.contents.WirelessTerminalViewCells;
import com.gtnewhorizon.structurelib.util.InventoryUtility;
import net.glease.structurecompat.Compat;
import net.glease.structurecompat.MEInventoryStackExtractor;
import net.glease.structurecompat.WirelessTerminalStackExtractor;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;

@Compat(value={"appliedenergistics2"})
public class CompatAppliedEnergistics {
    public CompatAppliedEnergistics() {
        InventoryUtility.registerStackExtractor((String)"1000-ae2-wireless", (InventoryUtility.ItemStackExtractor)new WirelessTerminalStackExtractor(){

            @Override
            protected IViewCellStorage getViewCellStorage(ItemStack is) {
                return () -> new WirelessTerminalViewCells(is);
            }
        });
        InventoryUtility.registerStackExtractor((String)"1000-ae2-portable-cell", (InventoryUtility.ItemStackExtractor)new MEInventoryStackExtractor(){

            @Override
            protected Pair<IEnergySource, IMEInventoryHandler<IAEItemStack>> fromItem(ItemStack source, EntityPlayerMP player) {
                if (!AEApi.instance().definitions().items().portableCell().isSameAs(source)) {
                    return null;
                }
                IEnergySource energySource = (amt, mode, usePowerMultiplier) -> {
                    IAEItemPowerStorage item = (IAEItemPowerStorage)source.func_77973_b();
                    amt = usePowerMultiplier.multiply(amt);
                    if (mode == Actionable.SIMULATE) {
                        return usePowerMultiplier.divide(Math.min(amt, item.getAECurrentPower(source)));
                    }
                    return usePowerMultiplier.divide(item.extractAEPower(source, amt));
                };
                return Pair.of((Object)energySource, (Object)CompatAppliedEnergistics.getCellInventory(source));
            }
        });
    }

    private static IMEInventoryHandler<IAEItemStack> getCellInventory(ItemStack source) {
        return AEApi.instance().registries().cell().getCellInventory(source, null, StorageChannel.ITEMS);
    }
}

