/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.crossmod.thaumcraft;

import appeng.api.storage.data.IAEFluidStack;
import appeng.util.item.AEFluidStack;
import cpw.mods.fml.common.Optional;
import java.util.Objects;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.MutablePair;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.IEssentiaContainerItem;
import thaumcraft.common.Thaumcraft;
import thaumicenergistics.api.ThEApi;
import thaumicenergistics.api.storage.IAspectStack;
import thaumicenergistics.common.fluids.GaseousEssentia;
import thaumicenergistics.common.integration.tc.EssentiaItemContainerHelper;
import thaumicenergistics.common.storage.AspectStack;

public class AspectUtil {
    public static final EssentiaItemContainerHelper HELPER = EssentiaItemContainerHelper.INSTANCE;
    public static int R = 128;

    @Optional.Method(modid="thaumicenergistics")
    public static void init() {
        R = ThEApi.instance().config().conversionMultiplier();
    }

    public static boolean isPlayerDiscoveredAspect(EntityPlayer player, Aspect aspect) {
        if (player != null && aspect != null) {
            return Thaumcraft.proxy.getPlayerKnowledge().hasDiscoveredAspect(player.func_70005_c_(), aspect);
        }
        return false;
    }

    public static boolean isEssentiaGas(Fluid fluid) {
        return fluid instanceof GaseousEssentia;
    }

    public static boolean isEssentiaGas(FluidStack fluid) {
        return fluid != null && fluid.getFluid() instanceof GaseousEssentia;
    }

    public static boolean isEssentiaGas(IAEFluidStack fluid) {
        return fluid != null && fluid.getFluid() instanceof GaseousEssentia;
    }

    public static Aspect getAspectFromGas(FluidStack fluid) {
        if (!AspectUtil.isEssentiaGas(fluid)) {
            return null;
        }
        GaseousEssentia gas = (GaseousEssentia)fluid.getFluid();
        return gas.getAspect();
    }

    public static Aspect getAspectFromJar(ItemStack stack) {
        if (AspectUtil.isEssentiaContainer(stack)) {
            return HELPER.getAspectInContainer(stack);
        }
        return null;
    }

    public static Aspect getAspectFromGas(IAEFluidStack fluid) {
        if (AspectUtil.isEssentiaGas(fluid)) {
            return null;
        }
        GaseousEssentia gas = (GaseousEssentia)fluid.getFluid();
        return gas.getAspect();
    }

    public static FluidStack getGasFromAspect(IAspectStack aspectStack) {
        if (aspectStack == null || aspectStack.isEmpty()) {
            return null;
        }
        return new FluidStack((Fluid)GaseousEssentia.getGasFromAspect((Aspect)aspectStack.getAspect()), (int)aspectStack.getStackSize() * R);
    }

    public static boolean isEssentiaContainer(ItemStack stack) {
        return HELPER.getItemType(stack) != EssentiaItemContainerHelper.AspectItemType.Invalid && HELPER.getItemType(stack) != EssentiaItemContainerHelper.AspectItemType.ItemAspect;
    }

    public static AEFluidStack getAEGasFromContainer(ItemStack stack) {
        if (AspectUtil.isEssentiaContainer(stack) && !AspectUtil.isEmptyEssentiaContainer(stack)) {
            IAspectStack aspectStack = HELPER.getAspectStackFromContainer(stack);
            aspectStack.setStackSize((long)stack.field_77994_a * aspectStack.getStackSize());
            FluidStack gas = AspectUtil.getGasFromAspect(aspectStack);
            return AEFluidStack.create((Object)gas);
        }
        return null;
    }

    public static boolean isEmptyEssentiaContainer(ItemStack stack) {
        return HELPER.isContainerEmpty(stack) && AspectUtil.isEssentiaContainer(stack);
    }

    public static ItemStack setAspectAmount(ItemStack itemStack, int amount, Aspect aspect) {
        if (AspectUtil.isEssentiaContainer(itemStack)) {
            IEssentiaContainerItem container = (IEssentiaContainerItem)itemStack.func_77973_b();
            assert (container != null);
            container.getAspects((ItemStack)itemStack).aspects.put(aspect, amount);
            return itemStack;
        }
        return null;
    }

    public static MutablePair<Integer, ItemStack> fillEssentiaFromGas(ItemStack itemStack, FluidStack fluid) {
        if (AspectUtil.isEssentiaContainer(itemStack) && AspectUtil.isEssentiaGas(fluid)) {
            int cap;
            int tryFill;
            ImmutablePair result;
            if (itemStack.field_77994_a != 1) {
                return null;
            }
            Aspect aspect = AspectUtil.getAspectFromGas(fluid);
            int amount = fluid.amount / R;
            EssentiaItemContainerHelper.AspectItemType iType = HELPER.getItemType(itemStack);
            if (iType == EssentiaItemContainerHelper.AspectItemType.JarLabel) {
                ItemStack label = itemStack.func_77946_l();
                HELPER.setLabelAspect(label, aspect);
            }
            return (result = HELPER.injectIntoContainer(itemStack, (IAspectStack)new AspectStack(aspect, (long)(tryFill = Math.min(cap = HELPER.getContainerCapacity(itemStack), amount))))) != null ? new MutablePair((Object)((Integer)result.left * R), (Object)((ItemStack)result.right)) : null;
        }
        return null;
    }

    public static MutablePair<Integer, ItemStack> drainEssentiaFromGas(ItemStack itemStack, FluidStack fluid) {
        if (AspectUtil.isEssentiaContainer(itemStack) && AspectUtil.isEssentiaGas(fluid)) {
            int drained;
            Aspect aspect = AspectUtil.getAspectFromGas(fluid);
            int amount = fluid.amount / R;
            IAspectStack contents = HELPER.getAspectStackFromContainer(itemStack);
            ItemStack stack = null;
            if (contents == null || !Objects.equals(contents.getAspect(), aspect)) {
                drained = 0;
            } else {
                ImmutablePair result = HELPER.extractFromContainer(itemStack, (IAspectStack)new AspectStack(aspect, (long)amount));
                drained = result == null ? 0 : (Integer)result.left;
                stack = result == null ? null : (ItemStack)result.right;
            }
            return stack == null ? null : new MutablePair((Object)(drained * R), stack);
        }
        return null;
    }
}

