/*
 * Decompiled with CFR 0.152.
 */
package gttweaker.mods.gregtech.machines;

import gregtech.api.enums.GTValues;
import gregtech.api.enums.ItemList;
import gregtech.api.interfaces.IRecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gttweaker.mods.AddMultipleRecipeAction;
import gttweaker.util.ArrayHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.annotations.ModOnly;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidStack;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.gregtech.Centrifuge")
@ModOnly(value={"gregtech"})
public class Centrifuge {
    @ZenMethod
    public static void addRecipe(IItemStack[] outputs, ILiquidStack fluidOutput, IIngredient input1, IIngredient input2, ILiquidStack fluidInput, int[] chances, int durationTicks, int euPerTick) {
        if (outputs.length < 1) {
            MineTweakerAPI.logError((String)"Centrifuge must have at least 1 output");
        } else if (outputs.length != chances.length) {
            MineTweakerAPI.logError((String)"Number of Outputs does not equal number of Chances");
        } else {
            MineTweakerAPI.apply((IUndoableAction)new AddMultipleRecipeAction("Adding Centrifuge recipe with Fluids for " + input1, new Object[]{input1, input2, fluidOutput, fluidInput, outputs[0], ArrayHelper.itemOrNull(outputs, 1), ArrayHelper.itemOrNull(outputs, 2), ArrayHelper.itemOrNull(outputs, 3), ArrayHelper.itemOrNull(outputs, 4), ArrayHelper.itemOrNull(outputs, 5), chances, durationTicks, euPerTick}){

                @Override
                protected void applySingleRecipe(AddMultipleRecipeAction.ArgIterator i) {
                    ItemStack input1 = i.nextItem();
                    ItemStack input2 = i.nextItem();
                    FluidStack fluidInput = i.nextFluid();
                    FluidStack fluidOutput = i.nextFluid();
                    ArrayList<ItemStack> outputs = new ArrayList<ItemStack>(Arrays.asList(i.nextItem(), i.nextItem(), i.nextItem(), i.nextItem(), i.nextItem(), i.nextItem()));
                    outputs.removeIf(Objects::isNull);
                    int[] chances = i.nextIntArr();
                    int duration = i.nextInt();
                    int eut = i.nextInt();
                    GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{input1, input2}).itemOutputs(outputs.toArray(new ItemStack[0])).fluidInputs(new FluidStack[]{fluidInput}).fluidOutputs(new FluidStack[]{fluidOutput}).outputChances(chances).duration(duration).eut(eut).addTo((IRecipeMap)RecipeMaps.centrifugeRecipes);
                }
            });
        }
    }

    @ZenMethod
    public static void addRecipeFuelCan(IItemStack[] outputs, IIngredient input, int numCans, int duration) {
        Centrifuge.addRecipe(outputs, input, -numCans, duration);
    }

    @ZenMethod
    public static void addRecipe(IItemStack[] outputs, IIngredient input, int cells, int durationTicks) {
        if (outputs.length < 1) {
            MineTweakerAPI.logError((String)"Centrifuge must have at least 1 output");
        } else {
            MineTweakerAPI.apply((IUndoableAction)new AddMultipleRecipeAction("Adding centrifuge recipe with input " + input, new Object[]{input, cells, outputs[0], ArrayHelper.itemOrNull(outputs, 1), ArrayHelper.itemOrNull(outputs, 2), ArrayHelper.itemOrNull(outputs, 3), ArrayHelper.itemOrNull(outputs, 4), ArrayHelper.itemOrNull(outputs, 5), durationTicks}){

                @Override
                protected void applySingleRecipe(AddMultipleRecipeAction.ArgIterator i) {
                    ItemStack input1 = i.nextItem();
                    int cellNumber = i.nextInt();
                    ItemStack input2 = cellNumber > 0 ? ItemList.Cell_Empty.get((long)cellNumber, new Object[0]) : null;
                    ArrayList<ItemStack> inputs = new ArrayList<ItemStack>(Arrays.asList(input1, input2));
                    inputs.removeIf(Objects::isNull);
                    FluidStack fluidInput = i.nextFluid();
                    FluidStack fluidOutput = i.nextFluid();
                    ArrayList<ItemStack> outputs = new ArrayList<ItemStack>(Arrays.asList(i.nextItem(), i.nextItem(), i.nextItem(), i.nextItem(), i.nextItem(), i.nextItem()));
                    outputs.removeIf(Objects::isNull);
                    int[] chances = i.nextIntArr();
                    int duration = i.nextInt();
                    GTValues.RA.stdBuilder().itemInputs(inputs.toArray(new ItemStack[0])).itemOutputs(outputs.toArray(new ItemStack[0])).fluidInputs(new FluidStack[]{fluidInput}).fluidOutputs(new FluidStack[]{fluidOutput}).outputChances(chances).duration(duration).eut(5).addTo((IRecipeMap)RecipeMaps.centrifugeRecipes);
                }
            });
        }
    }
}

