/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core.libmc.fx;

import codechicken.lib.vec.Vector3;
import mrtjp.core.math.MathLib;
import mrtjp.projectred.core.libmc.fx.ParticleLogic;

public class ParticleLogicArcToPoint
extends ParticleLogic {
    private final Vector3 start;
    private final Vector3 target;
    private Vector3 firstControl;
    private Vector3 secondControl;
    private float percent;
    private float speed;
    private final float offsetFactor;
    private final float halfOffsetFactor;

    public ParticleLogicArcToPoint(Vector3 start2, Vector3 end) {
        this.start = start2.copy();
        this.target = end.copy();
        this.percent = 0.0f;
        this.speed = 0.03f;
        this.offsetFactor = 10.0f;
        this.halfOffsetFactor = this.offsetFactor / 2.0f;
        this.generateControlPoints();
    }

    public ParticleLogicArcToPoint generateControlPoints() {
        this.firstControl = new Vector3(this.start.x + (this.target.x - this.start.x) / 3.0, this.start.y + (this.target.y - this.start.y) / 3.0, this.start.z + (this.target.z - this.start.z) / 3.0);
        this.secondControl = new Vector3(this.start.x + (this.target.x - this.start.x) / 3.0 * 2.0, this.start.y + (this.target.y - this.start.y) / 3.0 * 2.0, this.start.z + (this.target.z - this.start.z) / 3.0 * 2.0);
        double offsetX = this.rand.nextFloat() * this.offsetFactor - this.halfOffsetFactor;
        double offsetZ = this.rand.nextFloat() * this.offsetFactor - this.halfOffsetFactor;
        double offsetY = this.rand.nextFloat() * this.offsetFactor - this.halfOffsetFactor;
        Vector3 offset = new Vector3(offsetX, offsetY, offsetZ);
        this.firstControl = this.firstControl.add(offset);
        this.secondControl = this.secondControl.add(offset);
        return this;
    }

    public ParticleLogicArcToPoint setControlPoints(Vector3 first, Vector3 second) {
        this.firstControl = first;
        this.secondControl = second;
        return this;
    }

    public ParticleLogicArcToPoint setSpeed(float speed) {
        this.speed = speed;
        return this;
    }

    @Override
    public void doUpdate() {
        this.percent += this.speed;
        if (this.percent >= 1.0f) {
            this.finishLogic();
            return;
        }
        Vector3 bez = MathLib.bezier((Vector3)this.start, (Vector3)this.firstControl, (Vector3)this.secondControl, (Vector3)this.target, (float)this.percent);
        this.particle.func_70107_b(bez.x, bez.y, bez.z);
    }

    @Override
    public ParticleLogic clone() {
        return new ParticleLogicArcToPoint(this.particle.position(), this.target).setSpeed(this.speed).setControlPoints(this.firstControl, this.secondControl).setFinal(this.finalLogic).setPriority(this.priority);
    }
}

