/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.util;

import cpw.mods.fml.common.registry.GameRegistry;
import java.io.Serializable;
import net.minecraftforge.common.DimensionManager;

public class BlockSnapshot
implements Serializable {
    private static final boolean DEBUG = Boolean.parseBoolean(System.getProperty("forge.debugBlockSnapshot", "false"));
    public final int x;
    public final int y;
    public final int z;
    public final int dimId;
    public transient aji replacedBlock;
    public final int meta;
    public int flag;
    private final dh nbt;
    public transient ahb world;
    public final GameRegistry.UniqueIdentifier blockIdentifier;

    public BlockSnapshot(ahb world, int x, int y2, int z2, aji block, int meta) {
        this.world = world;
        this.dimId = world.t.i;
        this.x = x;
        this.y = y2;
        this.z = z2;
        this.replacedBlock = block;
        this.blockIdentifier = GameRegistry.findUniqueIdentifierFor(block);
        this.meta = meta;
        this.flag = 3;
        aor te2 = world.o(x, y2, z2);
        if (te2 != null) {
            this.nbt = new dh();
            te2.b(this.nbt);
        } else {
            this.nbt = null;
        }
        if (DEBUG) {
            System.out.printf("Created BlockSnapshot - [World: %s ][Location: %d,%d,%d ][Block: %s ][Meta: %d ]", world.N().k(), x, y2, z2, block, meta);
        }
    }

    public BlockSnapshot(ahb world, int x, int y2, int z2, aji block, int meta, dh nbt) {
        this.world = world;
        this.dimId = world.t.i;
        this.x = x;
        this.y = y2;
        this.z = z2;
        this.replacedBlock = block;
        this.blockIdentifier = GameRegistry.findUniqueIdentifierFor(block);
        this.meta = meta;
        this.flag = 3;
        this.nbt = nbt;
        if (DEBUG) {
            System.out.printf("Created BlockSnapshot - [World: %s ][Location: %d,%d,%d ][Block: %s ][Meta: %d ]", world.N().k(), x, y2, z2, block, meta);
        }
    }

    public BlockSnapshot(ahb world, int x, int y2, int z2, aji block, int meta, int flag) {
        this(world, x, y2, z2, block, meta);
        this.flag = flag;
    }

    public BlockSnapshot(int dimension, int x, int y2, int z2, String modid, String blockName, int meta, int flag, dh nbt) {
        this.dimId = dimension;
        this.x = x;
        this.y = y2;
        this.z = z2;
        this.meta = meta;
        this.flag = flag;
        this.blockIdentifier = new GameRegistry.UniqueIdentifier(modid + ":" + blockName);
        this.nbt = nbt;
    }

    public static BlockSnapshot getBlockSnapshot(ahb world, int x, int y2, int z2) {
        return new BlockSnapshot(world, x, y2, z2, world.a(x, y2, z2), world.e(x, y2, z2));
    }

    public static BlockSnapshot getBlockSnapshot(ahb world, int x, int y2, int z2, int flag) {
        return new BlockSnapshot(world, x, y2, z2, world.a(x, y2, z2), world.e(x, y2, z2), flag);
    }

    public static BlockSnapshot readFromNBT(dh tag) {
        dh nbt = tag.n("hasTE") ? null : tag.m("tileEntity");
        return new BlockSnapshot(tag.f("dimension"), tag.f("posX"), tag.f("posY"), tag.f("posZ"), tag.j("blockMod"), tag.j("blockName"), tag.f("metadata"), tag.f("flag"), nbt);
    }

    public aji getCurrentBlock() {
        return this.world.a(this.x, this.y, this.z);
    }

    public ahb getWorld() {
        if (this.world == null) {
            this.world = DimensionManager.getWorld(this.dimId);
        }
        return this.world;
    }

    public aji getReplacedBlock() {
        if (this.replacedBlock == null) {
            this.replacedBlock = GameRegistry.findBlock(this.blockIdentifier.modId, this.blockIdentifier.name);
        }
        return this.replacedBlock;
    }

    public aor getTileEntity() {
        if (this.nbt != null) {
            return aor.c((dh)this.nbt);
        }
        return null;
    }

    public boolean restore() {
        return this.restore(false);
    }

    public boolean restore(boolean force) {
        return this.restore(force, true);
    }

    public boolean restore(boolean force, boolean applyPhysics) {
        if (this.getCurrentBlock() != this.getReplacedBlock() || this.world.e(this.x & 0xF, this.y, this.z & 0xF) != this.meta) {
            if (force) {
                this.world.d(this.x, this.y, this.z, this.getReplacedBlock(), this.meta, applyPhysics ? 3 : 2);
            } else {
                return false;
            }
        }
        this.world.a(this.x, this.y, this.z, this.meta, applyPhysics ? 3 : 2);
        this.world.g(this.x, this.y, this.z);
        aor te2 = null;
        if (this.nbt != null && (te2 = this.world.o(this.x, this.y, this.z)) != null) {
            te2.a(this.nbt);
        }
        if (DEBUG) {
            System.out.printf("Restored BlockSnapshot with data [World: %s ][Location: %d,%d,%d ][Meta: %d ][Block: %s ][TileEntity: %s ][force: %s ][applyPhysics: %s]", this.world.N().k(), this.x, this.y, this.z, this.meta, this.getReplacedBlock(), te2, force, applyPhysics);
        }
        return true;
    }

    public boolean restoreToLocation(ahb world, int x, int y2, int z2, boolean force, boolean applyPhysics) {
        if (this.getCurrentBlock() != this.getReplacedBlock() || world.e(x & 0xF, y2, z2 & 0xF) != this.meta) {
            if (force) {
                world.d(x, y2, z2, this.getReplacedBlock(), this.meta, applyPhysics ? 3 : 2);
            } else {
                return false;
            }
        }
        world.a(x, y2, z2, this.meta, applyPhysics ? 3 : 2);
        world.g(x, y2, z2);
        aor te2 = null;
        if (this.nbt != null && (te2 = world.o(x, y2, z2)) != null) {
            te2.a(this.nbt);
        }
        if (DEBUG) {
            System.out.printf("Restored BlockSnapshot with data [World: %s ][Location: %d,%d,%d ][Meta: %d ][Block: %s ][TileEntity: %s ][force: %s ][applyPhysics: %s]", world.N().k(), x, y2, z2, this.meta, this.getReplacedBlock(), te2, force, applyPhysics);
        }
        return true;
    }

    public void writeToNBT(dh compound) {
        compound.a("blockMod", this.blockIdentifier.modId);
        compound.a("blockName", this.blockIdentifier.name);
        compound.a("posX", this.x);
        compound.a("posY", this.y);
        compound.a("posZ", this.z);
        compound.a("flag", this.flag);
        compound.a("dimension", this.dimId);
        compound.a("metadata", this.meta);
        compound.a("hasTE", this.nbt != null);
        if (this.nbt != null) {
            compound.a("tileEntity", (dy)this.nbt);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BlockSnapshot other = (BlockSnapshot)obj;
        if (this.x != other.x) {
            return false;
        }
        if (this.y != other.y) {
            return false;
        }
        if (this.z != other.z) {
            return false;
        }
        if (this.meta != other.meta) {
            return false;
        }
        if (this.dimId != other.dimId) {
            return false;
        }
        if (!(this.nbt == other.nbt || this.nbt != null && this.nbt.equals((Object)other.nbt))) {
            return false;
        }
        if (!(this.world == other.world || this.world != null && this.world.equals(other.world))) {
            return false;
        }
        return this.blockIdentifier == other.blockIdentifier || this.blockIdentifier != null && this.blockIdentifier.equals(other.blockIdentifier);
    }

    public int hashCode() {
        int hash = 7;
        hash = 73 * hash + this.x;
        hash = 73 * hash + this.y;
        hash = 73 * hash + this.z;
        hash = 73 * hash + this.meta;
        hash = 73 * hash + this.dimId;
        hash = 73 * hash + (this.nbt != null ? this.nbt.hashCode() : 0);
        hash = 73 * hash + (this.world != null ? this.world.hashCode() : 0);
        hash = 73 * hash + (this.blockIdentifier != null ? this.blockIdentifier.hashCode() : 0);
        return hash;
    }
}

