/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.ItemPanels;
import codechicken.nei.ItemQuantityField;
import codechicken.nei.ItemsGrid;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.NEIController;
import codechicken.nei.Widget;
import codechicken.nei.guihook.IContainerTooltipHandler;
import codechicken.nei.recipe.GuiCraftingRecipe;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.GuiUsageRecipe;
import codechicken.nei.recipe.StackInfo;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class ItemHistoryPanel
extends Widget
implements IContainerTooltipHandler {
    protected int mouseDownItemIndex = -1;
    protected ItemsGrid<ItemsGrid.ItemsGridSlot, ItemsGrid.MouseContext> grid = new ItemsGrid<ItemsGrid.ItemsGridSlot, ItemsGrid.MouseContext>(){
        protected List<ItemsGrid.ItemsGridSlot> gridMask;

        @Override
        protected void onGridChanged() {
            this.gridMask = null;
            super.onGridChanged();
        }

        @Override
        public List<ItemsGrid.ItemsGridSlot> getMask() {
            if (this.gridMask == null) {
                this.gridMask = new ArrayList<ItemsGrid.ItemsGridSlot>();
                for (int slotIndex = 0; slotIndex < Math.min(this.size(), this.rows * this.columns); ++slotIndex) {
                    this.gridMask.add(new ItemsGrid.ItemsGridSlot(slotIndex, slotIndex, this.getItem(slotIndex)));
                }
            }
            return this.gridMask;
        }

        @Override
        protected ItemsGrid.MouseContext getMouseContext(int mousex, int mousey) {
            Object hovered = this.getSlotMouseOver(mousex, mousey);
            if (hovered != null) {
                return new ItemsGrid.MouseContext(((ItemsGrid.ItemsGridSlot)hovered).slotIndex, ((ItemsGrid.ItemsGridSlot)hovered).slotIndex / this.columns, ((ItemsGrid.ItemsGridSlot)hovered).slotIndex % this.columns);
            }
            return null;
        }
    };

    public boolean isEmpty() {
        return this.grid.isEmpty();
    }

    @Override
    public void draw(int mousex, int mousey) {
        if (NEIClientConfig.getIntSetting("inventory.history.splittingMode") == 0) {
            GuiDraw.drawRect((int)this.x, (int)this.y, (int)this.w, (int)this.h, (int)NEIClientConfig.getSetting("inventory.history.historyColor").getHexValue());
        } else {
            this.drawSplittingArea(this.x, this.y, this.w, this.h, NEIClientConfig.getSetting("inventory.history.historyColor").getHexValue());
        }
        this.grid.draw(mousex, mousey);
    }

    @Override
    public void update() {
        this.grid.update();
    }

    public void addItem(ItemStack stack) {
        if (stack != null) {
            ItemStack is = StackInfo.loadFromNBT(StackInfo.itemStackToNBT(stack), 0L);
            this.grid.realItems.removeIf(historyStack -> StackInfo.equalItemAndNBT(historyStack, stack, true));
            this.grid.realItems.add(0, is);
            if (this.grid.realItems.size() > Math.max(50, this.grid.rows * this.grid.columns)) {
                this.grid.realItems.remove(this.grid.realItems.size() - 1);
            }
            this.grid.onItemsChanged();
        }
    }

    public void resize(GuiContainer gui) {
        this.grid.setGridSize(this.x, this.y + 4, this.w, this.h - 8);
        this.grid.refresh(gui);
    }

    @Override
    public ItemStack getStackMouseOver(int mousex, int mousey) {
        ItemsGrid.ItemsGridSlot slot = this.getSlotMouseOver(mousex, mousey);
        return slot == null ? null : slot.getItemStack();
    }

    public ItemsGrid.ItemsGridSlot getSlotMouseOver(int mousex, int mousey) {
        return this.grid.getSlotMouseOver(mousex, mousey);
    }

    private void drawSplittingArea(int x, int y, int width, int height, int color) {
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        GL11.glPushMatrix();
        GL11.glDisable((int)3553);
        GL11.glEnable((int)2852);
        GL11.glColor4f((float)red, (float)green, (float)blue, (float)alpha);
        GL11.glLineWidth((float)2.0f);
        GL11.glLineStipple((int)2, (short)255);
        GL11.glBegin((int)2);
        GL11.glVertex2i((int)x, (int)y);
        GL11.glVertex2i((int)(x + width), (int)y);
        GL11.glVertex2i((int)(x + width), (int)(y + height));
        GL11.glVertex2i((int)x, (int)(y + height));
        GL11.glEnd();
        GL11.glLineStipple((int)1, (short)-1);
        GL11.glLineWidth((float)1.0f);
        GL11.glDisable((int)2852);
        GL11.glEnable((int)3553);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    @Override
    public void mouseDragged(int mousex, int mousey, int button, long heldTime) {
        ItemsGrid.ItemsGridSlot mouseOverSlot;
        if (this.mouseDownItemIndex >= 0 && ItemPanels.itemPanel.draggedStack == null && NEIClientUtils.getHeldItem() == null && NEIClientConfig.hasSMPCounterPart() && ((mouseOverSlot = this.getSlotMouseOver(mousex, mousey)) == null || mouseOverSlot.itemIndex != this.mouseDownItemIndex || heldTime > 500L)) {
            ItemPanels.itemPanel.draggedStack = this.getDraggedStackWithQuantity(this.grid.getItem(this.mouseDownItemIndex));
            this.mouseDownItemIndex = -1;
        }
    }

    @Override
    public boolean handleClick(int mousex, int mousey, int button) {
        if (this.handleClickExt(mousex, mousey, button)) {
            return true;
        }
        ItemsGrid.ItemsGridSlot hoverSlot = this.grid.getSlotMouseOver(mousex, mousey);
        if (hoverSlot != null) {
            if (button == 2) {
                ItemPanels.itemPanel.draggedStack = this.getDraggedStackWithQuantity(hoverSlot.getItemStack());
            } else {
                this.mouseDownItemIndex = hoverSlot.itemIndex;
            }
            return true;
        }
        return false;
    }

    protected ItemStack getDraggedStackWithQuantity(ItemStack itemStack) {
        return ItemQuantityField.prepareStackWithQuantity(itemStack, 0L);
    }

    public ItemStack getStackMouseOverWithQuantity(int mousex, int mousey) {
        ItemStack hoverSlot = this.getStackMouseOver(mousex, mousey);
        return hoverSlot != null ? this.getDraggedStackWithQuantity(hoverSlot) : null;
    }

    @Override
    public void mouseUp(int mousex, int mousey, int button) {
        ItemsGrid.ItemsGridSlot hoverSlot = this.getSlotMouseOver(mousex, mousey);
        if (hoverSlot != null && hoverSlot.itemIndex == this.mouseDownItemIndex && ItemPanels.itemPanel.draggedStack == null) {
            if (NEIController.manager.window instanceof GuiRecipe || NEIClientUtils.shiftKey() || !NEIClientConfig.canCheatItem(hoverSlot.getItemStack())) {
                if (button == 0) {
                    GuiCraftingRecipe.openRecipeGui("item", hoverSlot.getItemStack().func_77946_l());
                } else if (button == 1) {
                    GuiUsageRecipe.openRecipeGui("item", hoverSlot.getItemStack().func_77946_l());
                }
            } else {
                NEIClientUtils.cheatItem(this.getDraggedStackWithQuantity(hoverSlot.getItemStack()), button, -1);
            }
        }
        this.mouseDownItemIndex = -1;
    }
}

