/*
 * Decompiled with CFR 0.152.
 */
package net.fuzzycraft.botanichorizons.addons.tileentity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.fuzzycraft.botanichorizons.addons.tileentity.AutomationTileEntity;
import net.fuzzycraft.botanichorizons.util.InventoryHelper;
import net.fuzzycraft.botanichorizons.util.multiblock.MultiblockHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInvBasic;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public abstract class SimpleAutomationTileEntity<R>
extends AutomationTileEntity
implements IInventory,
IInvBasic {
    public final InventoryBasic inventoryHandler = new InventoryBasic("name", false, 4);
    static final int INPUT_SIZE = 2;
    static final int OUTPUT_SIZE = 2;
    private static final String KEY_INVENTORY = "inv";

    @Nullable
    public abstract R findMatchingRecipe(ItemStack var1);

    public abstract int getAvailableParallels(@Nonnull R var1);

    @Nonnull
    public abstract ItemStack getRecipeOutput(@Nonnull R var1);

    public abstract int getRecipeInputStackSize(@Nonnull R var1);

    public SimpleAutomationTileEntity(MultiblockHelper structure) {
        super(structure);
        this.inventoryHandler.func_110134_a((IInvBasic)this);
    }

    public void handleCrafts() {
        int parallel = 64;
        ItemStack currentLastSlot = this.inventoryHandler.func_70301_a(3);
        if (currentLastSlot != null && currentLastSlot.field_77994_a > 0) {
            return;
        }
        ItemStack craftStack = this.inventoryHandler.func_70301_a(0);
        if (craftStack == null || craftStack.func_77973_b() == null) {
            return;
        }
        int max_input_parallel = craftStack.field_77994_a;
        if ((parallel = Math.min(parallel, max_input_parallel)) <= 0) {
            return;
        }
        R recipe = this.findMatchingRecipe(craftStack);
        if ((parallel = Math.min(parallel, this.getAvailableParallels(recipe))) <= 0) {
            return;
        }
        if (recipe == null) {
            this.inventoryHandler.func_70299_a(3, craftStack.func_77946_l());
            this.inventoryHandler.func_70299_a(0, null);
            return;
        }
        int recipe_input_width = this.getRecipeInputStackSize(recipe);
        if (recipe_input_width > 1) {
            int max_input_width = craftStack.field_77994_a / recipe_input_width;
            parallel = Math.min(parallel, max_input_width);
        }
        ItemStack output_instance = this.getRecipeOutput(recipe);
        int max_output_parallel = 64 / output_instance.field_77994_a;
        if ((parallel = Math.min(parallel, max_output_parallel)) <= 0 || recipe_input_width <= 0) {
            return;
        }
        ItemStack output = output_instance.func_77946_l();
        output.field_77994_a *= parallel;
        this.inventoryHandler.func_70299_a(3, output);
        this.inventoryHandler.func_70298_a(0, parallel * recipe_input_width);
    }

    public void handleOutputs() {
        if (this.field_145848_d < 1) {
            return;
        }
        for (int slot = 2; slot < 4; ++slot) {
            ItemStack stack = this.inventoryHandler.func_70301_a(slot);
            if (stack == null || stack.func_77973_b() == null || stack.field_77994_a == 0) continue;
            TileEntity outputEntity = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
            if (outputEntity instanceof IInventory) {
                IInventory outputInventory = (IInventory)outputEntity;
                ItemStack remainingItems = InventoryHelper.pushToInventory(outputInventory, stack);
                this.inventoryHandler.func_70299_a(slot, remainingItems);
                continue;
            }
            if (!this.field_145850_b.func_147437_c(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e)) continue;
        }
    }

    public void cleanupInventory(int start, int end) {
        for (int checkSlot = start + 1; checkSlot < end; ++checkSlot) {
            ItemStack sourceStack = this.inventoryHandler.func_70301_a(checkSlot);
            if (sourceStack == null) continue;
            boolean done = false;
            for (int refSlot = start; refSlot < checkSlot && !done; ++refSlot) {
                ItemStack destinationStack = this.inventoryHandler.func_70301_a(refSlot);
                if (destinationStack == null) {
                    this.inventoryHandler.func_70299_a(refSlot, sourceStack);
                    this.inventoryHandler.func_70299_a(checkSlot, null);
                    done = true;
                    continue;
                }
                int itemsToMove = InventoryHelper.itemsToMove(destinationStack, sourceStack);
                if (itemsToMove <= 0) continue;
                ItemStack newDestinationStack = destinationStack.func_77946_l();
                ItemStack newSourceStack = sourceStack.func_77946_l();
                newDestinationStack.field_77994_a += itemsToMove;
                newSourceStack.field_77994_a -= itemsToMove;
                this.inventoryHandler.func_70299_a(refSlot, newDestinationStack);
                if (newSourceStack.field_77994_a == 0) {
                    this.inventoryHandler.func_70299_a(checkSlot, null);
                    done = true;
                    continue;
                }
                this.inventoryHandler.func_70299_a(checkSlot, newSourceStack);
                sourceStack = newSourceStack;
            }
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound compound) {
        super.writeCustomNBT(compound);
        compound.func_74782_a(KEY_INVENTORY, (NBTBase)InventoryHelper.saveInventoryToNBT((IInventory)this.inventoryHandler));
    }

    @Override
    public void readCustomNBT(NBTTagCompound compound) {
        super.readCustomNBT(compound);
        InventoryHelper.readInventoryFromNBT((IInventory)this.inventoryHandler, compound.func_74775_l(KEY_INVENTORY));
    }

    public int func_70302_i_() {
        return this.inventoryHandler.func_70302_i_();
    }

    public ItemStack func_70301_a(int slotIn) {
        return this.inventoryHandler.func_70301_a(slotIn);
    }

    public ItemStack func_70298_a(int index, int count) {
        if (index < 2 && count > 0) {
            return null;
        }
        return this.inventoryHandler.func_70298_a(index, count);
    }

    public ItemStack func_70304_b(int index) {
        return this.inventoryHandler.func_70304_b(index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventoryHandler.func_70299_a(index, stack);
    }

    public String func_145825_b() {
        return this.inventoryHandler.func_145825_b();
    }

    public boolean func_145818_k_() {
        return this.inventoryHandler.func_145818_k_();
    }

    public int func_70297_j_() {
        return this.inventoryHandler.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.inventoryHandler.func_70300_a(player);
    }

    public void func_70295_k_() {
        this.inventoryHandler.func_70295_k_();
    }

    public void func_70305_f() {
        this.inventoryHandler.func_70305_f();
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index >= 2 || index < 0) {
            return false;
        }
        if (stack == null || stack.func_77973_b() == null) {
            return false;
        }
        return this.findMatchingRecipe(stack) != null;
    }

    public void func_76316_a(InventoryBasic p_76316_1_) {
        this.func_70296_d();
    }

    public void dropItems(World world, int x, int y, int z) {
        for (int slot = 0; slot < this.inventoryHandler.func_70302_i_(); ++slot) {
            ItemStack drop = this.inventoryHandler.func_70301_a(slot);
            if (drop == null || drop.field_77994_a <= 0) continue;
            ItemStack copy = drop.func_77946_l();
            this.inventoryHandler.func_70299_a(slot, null);
            EntityItem entity = new EntityItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, copy);
            InventoryHelper.setRandomDropDirection(entity, world);
            world.func_72838_d((Entity)entity);
        }
    }
}

