/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.archaicfix.mixins.client.renderdistance;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.RenderList;
import org.embeddedt.archaicfix.config.ArchaicConfig;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={RenderGlobal.class}, priority=-10)
public class MixinRenderGlobal {
    @Shadow
    private RenderList[] field_72754_S;

    @ModifyArg(method={"<init>"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/GLAllocation;generateDisplayLists(I)I"), index=0)
    private int generateDisplayLists(int original) {
        int chunkNum = ArchaicConfig.newMaxRenderDistance * 2 + 2;
        return chunkNum * chunkNum * 16 * 3;
    }

    @ModifyArg(method={"<init>"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/GLAllocation;createDirectIntBuffer(I)Ljava/nio/IntBuffer;"), index=0)
    private int createOcclusionBuffer(int original) {
        int chunkNum = ArchaicConfig.newMaxRenderDistance * 2 + 2;
        return chunkNum * chunkNum * 16;
    }

    @ModifyArg(method={"<init>"}, at=@At(value="INVOKE", target="Ljava/nio/IntBuffer;limit(I)Ljava/nio/Buffer;"), index=0)
    private int limitOcclusionBuffer(int i) {
        int chunkNum = ArchaicConfig.newMaxRenderDistance * 2 + 2;
        return chunkNum * chunkNum * 16;
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void resizeAllRenderLists(Minecraft p_i1249_1_, CallbackInfo ci) {
        int sideLength = Math.max(2, ArchaicConfig.newMaxRenderDistance / 16);
        if (this.field_72754_S.length >= sideLength * sideLength) {
            return;
        }
        this.field_72754_S = new RenderList[sideLength * sideLength];
        for (int i = 0; i < this.field_72754_S.length; ++i) {
            this.field_72754_S[i] = new RenderList();
        }
    }
}

