/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.parts;

import appeng.api.AEApi;
import appeng.api.implementations.items.IItemGroup;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartHelper;
import appeng.api.parts.IPartItem;
import appeng.api.util.AEColor;
import appeng.client.texture.TextureUtils;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.features.AEFeature;
import appeng.core.features.ActivityState;
import appeng.core.features.ItemStackSrc;
import appeng.core.features.NameResolver;
import appeng.core.localization.GuiText;
import appeng.integration.IntegrationRegistry;
import appeng.integration.IntegrationType;
import appeng.items.AEBaseItem;
import appeng.items.parts.PartType;
import com.google.common.base.Preconditions;
import com.mojang.realmsclient.gui.ChatFormatting;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public final class ItemMultiPart
extends AEBaseItem
implements IPartItem,
IItemGroup {
    private static final int INITIAL_REGISTERED_CAPACITY = PartType.values().length;
    private static final Comparator<Map.Entry<Integer, PartTypeWithVariant>> REGISTERED_COMPARATOR = new RegisteredComparator();
    public static ItemMultiPart instance;
    private final NameResolver nameResolver;
    private final Map<Integer, PartTypeWithVariant> registered;

    public ItemMultiPart(IPartHelper partHelper) {
        Preconditions.checkNotNull((Object)partHelper);
        this.registered = new HashMap<Integer, PartTypeWithVariant>(INITIAL_REGISTERED_CAPACITY);
        this.nameResolver = new NameResolver(this.getClass());
        this.setFeature(EnumSet.of(AEFeature.Core));
        partHelper.setItemBusRenderer(this);
        this.func_77627_a(true);
        instance = this;
    }

    @Nonnull
    public final ItemStackSrc createPart(PartType mat) {
        Preconditions.checkNotNull((Object)((Object)mat));
        return this.createPart(mat, 0, false);
    }

    @Nonnull
    public ItemStackSrc createPart(PartType mat, AEColor color, boolean deprecated) {
        Preconditions.checkNotNull((Object)((Object)mat));
        Preconditions.checkNotNull((Object)color);
        int varID = color.ordinal();
        return this.createPart(mat, varID, deprecated);
    }

    @Nonnull
    private ItemStackSrc createPart(PartType mat, int varID, boolean deprecated) {
        assert (mat != null);
        assert (varID >= 0);
        for (PartTypeWithVariant partTypeWithVariant : this.registered.values()) {
            if (partTypeWithVariant.part != mat || partTypeWithVariant.variant != varID) continue;
            throw new IllegalStateException("Cannot create the same material twice...");
        }
        boolean enabled = true;
        for (AEFeature f : mat.getFeature()) {
            enabled = enabled && AEConfig.instance.isFeatureEnabled(f);
        }
        for (IntegrationType integrationType : mat.getIntegrations()) {
            enabled &= IntegrationRegistry.INSTANCE.isEnabled(integrationType);
        }
        int n = mat.getBaseDamage() + varID;
        ActivityState state = ActivityState.from(enabled);
        ItemStackSrc output = new ItemStackSrc(this, n, state);
        PartTypeWithVariant pti = new PartTypeWithVariant(mat, varID, deprecated);
        this.processMetaOverlap(enabled, n, mat, pti);
        return output;
    }

    private void processMetaOverlap(boolean enabled, int partDamage, PartType mat, PartTypeWithVariant pti) {
        assert (partDamage >= 0);
        assert (mat != null);
        assert (pti != null);
        PartTypeWithVariant registeredPartType = this.registered.get(partDamage);
        if (registeredPartType != null) {
            throw new IllegalStateException("Meta Overlap detected with type " + (Object)((Object)mat) + " and damage " + partDamage + ". Found " + registeredPartType + " there already.");
        }
        if (enabled) {
            this.registered.put(partDamage, pti);
        }
    }

    public int getDamageByType(PartType t) {
        Preconditions.checkNotNull((Object)((Object)t));
        for (Map.Entry<Integer, PartTypeWithVariant> pt : this.registered.entrySet()) {
            if (pt.getValue().part != t) continue;
            return pt.getKey();
        }
        return -1;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_94901_k() {
        return 0;
    }

    public IIcon func_77617_a(int dmg) {
        PartTypeWithVariant registeredType = this.registered.get(dmg);
        if (registeredType != null) {
            return registeredType.ico;
        }
        String formattedRegistered = Arrays.toString(this.registered.keySet().toArray());
        AELog.error("Tried to get the icon from a non-existent part with damage value " + dmg + ". There were registered: " + formattedRegistered + '.', new Object[0]);
        return TextureUtils.getMissingItem();
    }

    public boolean func_77648_a(ItemStack is, EntityPlayer player, World w, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (this.getTypeByStack(is) == PartType.InvalidType) {
            return false;
        }
        return AEApi.instance().partHelper().placeBus(is, x, y, z, side, player, w);
    }

    public String func_77667_c(ItemStack is) {
        return "item.appliedenergistics2." + this.getName(is);
    }

    public String func_77653_i(ItemStack is) {
        PartType pt = this.getTypeByStack(is);
        if (pt.isCable()) {
            AEColor[] variants = AEColor.values();
            int itemDamage = is.func_77960_j();
            PartTypeWithVariant registeredPartType = this.registered.get(itemDamage);
            if (registeredPartType != null) {
                return super.func_77653_i(is) + " - " + variants[registeredPartType.variant].getLocal();
            }
        }
        if (pt.getExtraName() != null) {
            return super.func_77653_i(is) + " - " + pt.getExtraName().getLocal();
        }
        return super.func_77653_i(is);
    }

    public void func_94581_a(IIconRegister iconRegister) {
        for (Map.Entry<Integer, PartTypeWithVariant> part : this.registered.entrySet()) {
            String tex = "appliedenergistics2:" + this.getName(new ItemStack((Item)this, 1, part.getKey().intValue()));
            part.getValue().ico = iconRegister.func_94245_a(tex);
        }
    }

    @Override
    protected void getCheckedSubItems(Item sameItem, CreativeTabs creativeTab, List<ItemStack> itemStacks) {
        ArrayList<Map.Entry<Integer, PartTypeWithVariant>> types = new ArrayList<Map.Entry<Integer, PartTypeWithVariant>>(this.registered.entrySet());
        types.sort(REGISTERED_COMPARATOR);
        for (Map.Entry entry : types) {
            itemStacks.add(new ItemStack((Item)this, 1, ((Integer)entry.getKey()).intValue()));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void addCheckedInformation(ItemStack stack, EntityPlayer player, List<String> lines, boolean displayMoreInfo) {
        super.addCheckedInformation(stack, player, lines, displayMoreInfo);
        int damage = stack.func_77960_j();
        PartTypeWithVariant part = this.registered.get(damage);
        if (part != null && part.deprecated) {
            lines.add(ChatFormatting.RED + GuiText.Deprecated.getLocal());
        }
    }

    private String getName(ItemStack is) {
        Preconditions.checkNotNull((Object)is);
        PartType stackType = this.getTypeByStack(is);
        String typeName = stackType.name();
        return this.nameResolver.getName(typeName);
    }

    @Nonnull
    public PartType getTypeByStack(ItemStack is) {
        Preconditions.checkNotNull((Object)is);
        PartTypeWithVariant pt = this.registered.get(is.func_77960_j());
        if (pt != null) {
            return pt.part;
        }
        return PartType.InvalidType;
    }

    @Override
    @Nullable
    public IPart createPartFromItemStack(ItemStack is) {
        PartType type = this.getTypeByStack(is);
        Class<? extends IPart> part = type.getPart();
        if (part == null) {
            return null;
        }
        try {
            if (type.getConstructor() == null) {
                type.setConstructor(part.getConstructor(ItemStack.class));
            }
            return type.getConstructor().newInstance(is);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("Unable to construct IBusPart from IBusItem : " + part.getName() + " ; Possibly didn't have correct constructor( ItemStack )", e);
        }
    }

    public int variantOf(int itemDamage) {
        PartTypeWithVariant registeredPartType = this.registered.get(itemDamage);
        if (registeredPartType != null) {
            return registeredPartType.variant;
        }
        return 0;
    }

    @Override
    @Nullable
    public String getUnlocalizedGroupName(Set<ItemStack> others, ItemStack is) {
        boolean importBus = false;
        boolean exportBus = false;
        boolean group = false;
        PartType u = this.getTypeByStack(is);
        for (ItemStack stack : others) {
            if (stack.func_77973_b() != this) continue;
            PartType pt = this.getTypeByStack(stack);
            switch (pt) {
                case ImportBus: {
                    importBus = true;
                    if (u != pt) break;
                    group = true;
                    break;
                }
                case ExportBus: {
                    exportBus = true;
                    if (u != pt) break;
                    group = true;
                    break;
                }
            }
        }
        if (group && importBus && exportBus) {
            return GuiText.IOBuses.getUnlocalized();
        }
        return null;
    }

    private static final class PartTypeWithVariant {
        private final PartType part;
        private final int variant;
        private final boolean deprecated;
        @SideOnly(value=Side.CLIENT)
        private IIcon ico;

        private PartTypeWithVariant(PartType part, int variant) {
            this(part, variant, false);
        }

        private PartTypeWithVariant(PartType part, int variant, boolean deprecated) {
            assert (part != null);
            assert (variant >= 0);
            this.part = part;
            this.variant = variant;
            this.deprecated = deprecated;
        }

        public String toString() {
            return "PartTypeWithVariant{part=" + (Object)((Object)this.part) + ", variant=" + this.variant + ", ico=" + this.ico + '}';
        }
    }

    private static final class RegisteredComparator
    implements Comparator<Map.Entry<Integer, PartTypeWithVariant>> {
        private RegisteredComparator() {
        }

        @Override
        public int compare(Map.Entry<Integer, PartTypeWithVariant> o1, Map.Entry<Integer, PartTypeWithVariant> o2) {
            return o1.getValue().part.name().compareTo(o2.getValue().part.name());
        }
    }
}

