/*
 * Decompiled with CFR 0.152.
 */
package com.recursive_pineapple.matter_manipulator.common.items.manipulator;

import appeng.api.features.INetworkEncodable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.MapMaker;
import com.gtnewhorizons.modularui.api.UIInfos;
import com.gtnewhorizons.modularui.api.drawable.AdaptableUITexture;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.OffsetDrawable;
import com.gtnewhorizons.modularui.api.drawable.shapes.Rectangle;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.math.Color;
import com.gtnewhorizons.modularui.api.math.CrossAxisAlignment;
import com.gtnewhorizons.modularui.api.math.MainAxisAlignment;
import com.gtnewhorizons.modularui.api.math.Pos2d;
import com.gtnewhorizons.modularui.api.math.Size;
import com.gtnewhorizons.modularui.api.screen.ModularUIContext;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.internal.network.NetworkUtils;
import com.gtnewhorizons.modularui.common.internal.wrapper.ModularGui;
import com.gtnewhorizons.modularui.common.internal.wrapper.ModularUIContainer;
import com.gtnewhorizons.modularui.common.widget.Column;
import com.gtnewhorizons.modularui.common.widget.DynamicTextWidget;
import com.gtnewhorizons.modularui.common.widget.MultiChildWidget;
import com.gtnewhorizons.modularui.common.widget.Row;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import com.gtnewhorizons.modularui.common.widget.VanillaButtonWidget;
import com.gtnewhorizons.modularui.common.widget.textfield.NumericWidget;
import com.recursive_pineapple.matter_manipulator.GlobalMMConfig;
import com.recursive_pineapple.matter_manipulator.MMMod;
import com.recursive_pineapple.matter_manipulator.client.gui.DirectionDrawable;
import com.recursive_pineapple.matter_manipulator.client.gui.RadialMenuBuilder;
import com.recursive_pineapple.matter_manipulator.common.building.BlockSpec;
import com.recursive_pineapple.matter_manipulator.common.building.IBuildable;
import com.recursive_pineapple.matter_manipulator.common.building.InteropConstants;
import com.recursive_pineapple.matter_manipulator.common.building.PendingBlock;
import com.recursive_pineapple.matter_manipulator.common.building.PendingBuild;
import com.recursive_pineapple.matter_manipulator.common.building.PendingMove;
import com.recursive_pineapple.matter_manipulator.common.data.WeightedSpecList;
import com.recursive_pineapple.matter_manipulator.common.items.MMItemList;
import com.recursive_pineapple.matter_manipulator.common.items.MMUpgrades;
import com.recursive_pineapple.matter_manipulator.common.items.manipulator.Location;
import com.recursive_pineapple.matter_manipulator.common.items.manipulator.MMState;
import com.recursive_pineapple.matter_manipulator.common.items.manipulator.Transform;
import com.recursive_pineapple.matter_manipulator.common.networking.Messages;
import com.recursive_pineapple.matter_manipulator.common.utils.MMUtils;
import com.recursive_pineapple.matter_manipulator.common.utils.MMValues;
import com.recursive_pineapple.matter_manipulator.common.utils.Mods;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.IElectricItemManager;
import ic2.api.item.ISpecialElectricItem;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import org.joml.Vector3i;
import org.joml.Vector3ic;

@Optional.InterfaceList(value={@Optional.Interface(modid="appliedenergistics2", iface="appeng.api.features.INetworkEncodable", striprefs=true), @Optional.Interface(modid="IC2", iface="ic2.api.item.ISpecialElectricItem"), @Optional.Interface(modid="IC2", iface="ic2.api.item.IElectricItemManager", striprefs=true)})
public class ItemMatterManipulator
extends Item
implements ISpecialElectricItem,
IElectricItemManager,
INetworkEncodable {
    public final ManipulatorTier tier;
    private static int counter = 0;
    public static final int CONNECTS_TO_AE = 1 << counter++;
    public static final int CONNECTS_TO_UPLINK = 1 << counter++;
    public static final int ALLOW_REMOVING = 1 << counter++;
    public static final int ALLOW_GEOMETRY = 1 << counter++;
    public static final int ALLOW_CONFIGURING = 1 << counter++;
    public static final int ALLOW_COPYING = 1 << counter++;
    public static final int ALLOW_EXCHANGING = 1 << counter++;
    public static final int ALLOW_MOVING = 1 << counter++;
    public static final int ALLOW_CABLES = 1 << counter++;
    public static final int ALL_MODES = ALLOW_GEOMETRY | ALLOW_COPYING | ALLOW_EXCHANGING | ALLOW_MOVING | ALLOW_CABLES;
    private static boolean ttAEWorks;
    private static boolean ttUplinkWorks;
    private long lastTooltipQueryMS;
    static final Map<EntityPlayer, IBuildable> PENDING_BUILDS;
    private static final IDrawable[] BACKGROUND;
    private static final AdaptableUITexture DISPLAY;

    public ItemMatterManipulator(ManipulatorTier tier) {
        String name = "itemMatterManipulator" + tier.tier;
        this.func_77637_a(CreativeTabs.field_78040_i);
        this.func_77655_b(name);
        this.func_77625_d(1);
        this.func_111206_d("matter-manipulator:" + name);
        this.tier = tier;
        GameRegistry.registerItem((Item)this, (String)name);
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    public Item getEmptyItem(ItemStack itemStack) {
        return this;
    }

    public boolean canProvideEnergy(ItemStack itemStack) {
        return false;
    }

    public double getMaxCharge(ItemStack itemStack) {
        return this.tier.maxCharge;
    }

    public int getTier(ItemStack itemStack) {
        return this.tier.voltageTier;
    }

    public double getTransferLimit(ItemStack itemStack) {
        return MMValues.V[this.tier.voltageTier] * 16L;
    }

    public Item getChargedItem(ItemStack itemStack) {
        return this;
    }

    public IElectricItemManager getManager(ItemStack arg0) {
        return this;
    }

    public final double charge(ItemStack stack, double toCharge, int voltageTier, boolean ignoreTransferLimit, boolean simulate) {
        NBTTagCompound tag = ItemMatterManipulator.getOrCreateNbtData(stack);
        double maxTransfer = ignoreTransferLimit ? toCharge : Math.min(toCharge, this.getTransferLimit(stack));
        double currentCharge = tag.func_74769_h("charge");
        double remainingSpace = (double)this.tier.maxCharge - currentCharge;
        double toConsume = Math.min(maxTransfer, remainingSpace);
        if (!simulate) {
            tag.func_74780_a("charge", currentCharge + toConsume);
        }
        return toConsume;
    }

    public final double discharge(ItemStack stack, double toDischarge, int voltageTier, boolean ignoreTransferLimit, boolean batteryLike, boolean simulate) {
        if (voltageTier != Integer.MAX_VALUE && voltageTier > this.tier.voltageTier) {
            return 0.0;
        }
        NBTTagCompound tag = ItemMatterManipulator.getOrCreateNbtData(stack);
        double maxTransfer = ignoreTransferLimit ? toDischarge : Math.min(toDischarge, this.getTransferLimit(stack));
        double currentCharge = tag.func_74769_h("charge");
        double toConsume = Math.min(maxTransfer, currentCharge);
        if (!simulate) {
            tag.func_74780_a("charge", currentCharge - toConsume);
        }
        return toConsume;
    }

    public final double getCharge(ItemStack stack) {
        NBTTagCompound tag = ItemMatterManipulator.getOrCreateNbtData(stack);
        return tag.func_74769_h("charge");
    }

    public final boolean canUse(ItemStack stack, double amount) {
        return this.getCharge(stack) >= amount;
    }

    public final boolean use(ItemStack stack, double toDischarge, EntityLivingBase holder) {
        double toTransfer;
        if (holder instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)holder;
            if (player.field_71075_bZ.field_75098_d) {
                return true;
            }
        }
        if (Math.abs((toTransfer = this.discharge(stack, toDischarge, Integer.MAX_VALUE, true, false, true)) - toDischarge) < 1.0E-7) {
            this.discharge(stack, toDischarge, Integer.MAX_VALUE, true, false, false);
            return true;
        }
        this.discharge(stack, toDischarge, Integer.MAX_VALUE, true, false, false);
        return false;
    }

    public final void chargeFromArmor(ItemStack heldStack, EntityLivingBase holder) {
    }

    public final String getToolTip(ItemStack aStack) {
        return null;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - this.getCharge(stack) / (double)this.tier.maxCharge;
    }

    public void refillPower(ItemStack stack, MMState state) {
        if (!state.hasUpgrade(MMUpgrades.PowerP2P)) {
            return;
        }
        if (!state.connectToUplink()) {
            return;
        }
        ItemMatterManipulator manipulator = (ItemMatterManipulator)stack.func_77973_b();
        assert (manipulator != null);
        double toFill = manipulator.getMaxCharge(stack) - manipulator.getCharge(stack);
        double drained = state.uplink.drainPower(toFill);
        manipulator.charge(stack, drained, 0, true, false);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int p_77663_4_, boolean p_77663_5_) {
        if (worldIn.func_82737_E() % 100L == 0L) {
            MMState state = ItemMatterManipulator.getState(stack);
            this.refillPower(stack, state);
        }
    }

    public void func_150895_a(Item item, CreativeTabs creativeTab, List<ItemStack> subItems) {
        ItemStack stack = new ItemStack((Item)this, 1);
        stack.func_77982_d(new MMState().save());
        subItems.add(stack.func_77946_l());
        this.charge(stack, this.tier.maxCharge, this.tier.voltageTier, true, false);
        subItems.add(stack);
    }

    public EnumRarity func_77613_e(ItemStack p_77613_1_) {
        EnumRarity enumRarity;
        switch (this.tier) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case Tier0: {
                enumRarity = EnumRarity.common;
                break;
            }
            case Tier1: {
                enumRarity = EnumRarity.uncommon;
                break;
            }
            case Tier2: {
                enumRarity = EnumRarity.rare;
                break;
            }
            case Tier3: {
                enumRarity = EnumRarity.epic;
            }
        }
        return enumRarity;
    }

    public static MMState getState(ItemStack itemStack) {
        MMState state = MMState.load(ItemMatterManipulator.getOrCreateNbtData(itemStack));
        state.manipulator = (ItemMatterManipulator)itemStack.func_77973_b();
        return state;
    }

    public static void setState(ItemStack itemStack, MMState state) {
        itemStack.func_77982_d(state.save());
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void stopClientClearUsing(TickEvent.PlayerTickEvent event) {
        boolean isCurrentItemValid;
        boolean isHandValid = event.player.func_71011_bu() != null && event.player.func_71011_bu().func_77973_b() == this;
        boolean bl = isCurrentItemValid = event.player.field_71071_by.func_70448_g() != null && event.player.field_71071_by.func_70448_g().func_77973_b() == this;
        if (isHandValid && isCurrentItemValid) {
            NBTTagCompound inInventory = event.player.field_71071_by.func_70448_g().func_77978_p();
            NBTTagCompound using = (NBTTagCompound)event.player.func_71011_bu().func_77978_p().func_74737_b();
            using.func_74780_a("charge", inInventory.func_74769_h("charge"));
            if (inInventory.equals((Object)using)) {
                event.player.func_71008_a(event.player.field_71071_by.func_70448_g(), event.player.func_71052_bv());
            }
        }
    }

    public static NBTTagCompound getOrCreateNbtData(ItemStack itemStack) {
        NBTTagCompound ret = itemStack.func_77978_p();
        if (ret == null) {
            ret = new NBTTagCompound();
            itemStack.func_77982_d(ret);
        }
        return ret;
    }

    public static void onTooltipResponse(int state) {
        ttAEWorks = (state & 1) != 0;
        ttUplinkWorks = (state & 2) != 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List<String> desc, boolean advancedItemTooltips) {
        MMState state = ItemMatterManipulator.getState(itemStack);
        if (!GuiScreen.func_146272_n()) {
            desc.add("Hold shift for more information.");
        } else {
            long time;
            if ((state.hasCap(CONNECTS_TO_AE) || state.hasCap(CONNECTS_TO_UPLINK)) && (time = System.currentTimeMillis()) - this.lastTooltipQueryMS > 1000L) {
                this.lastTooltipQueryMS = time;
                int slot = -1;
                Container c = player.field_71070_bA;
                for (int i = 0; i < c.field_75151_b.size(); ++i) {
                    if (c.func_75139_a(i).func_75211_c() != itemStack) continue;
                    slot = i;
                    break;
                }
                if (slot != -1) {
                    Messages.TooltipQuery.sendToServer(slot);
                }
            }
            if (state.hasCap(CONNECTS_TO_AE)) {
                if (state.encKey != null) {
                    if (ttAEWorks) {
                        desc.add("Has an ME connection. (Can interact currently)");
                    } else {
                        desc.add("Has an ME connection. (Cannot interact currently)");
                    }
                } else {
                    desc.add("Does not have an ME connection.");
                }
            }
            if (state.hasCap(CONNECTS_TO_UPLINK)) {
                if (state.uplinkAddress != null) {
                    if (ttUplinkWorks) {
                        desc.add("Has an Uplink connection. (Can interact currently)");
                    } else {
                        desc.add("Has an Uplink connection. (Cannot interact currently)");
                    }
                    this.addInfoLine(desc, "Uplink address: %s", state.uplinkAddress, Long::toHexString);
                } else {
                    desc.add("Does not have an Uplink connection.");
                }
            }
            if (state.config.action != null) {
                String string;
                switch (state.config.action) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case MOVING_COORDS: {
                        string = "Moving coordinates";
                        break;
                    }
                    case GEOM_SELECTING_BLOCK: {
                        string = "Selecting blocks to place";
                        break;
                    }
                    case MARK_COPY_A: {
                        string = "Marking first copy corner";
                        break;
                    }
                    case MARK_COPY_B: {
                        string = "Marking second copy corner";
                        break;
                    }
                    case MARK_CUT_A: {
                        string = "Marking first cut corner";
                        break;
                    }
                    case MARK_CUT_B: {
                        string = "Marking second cut corner";
                        break;
                    }
                    case MARK_PASTE: {
                        string = "Marking paste location";
                        break;
                    }
                    case EXCH_ADD_REPLACE: {
                        string = "Adding block to replace whitelist";
                        break;
                    }
                    case EXCH_SET_REPLACE: {
                        string = "Setting block in replace whitelist";
                        break;
                    }
                    case EXCH_SET_TARGET: {
                        string = "Setting block to replace with";
                        break;
                    }
                    case PICK_CABLE: {
                        string = "Picking cable";
                        break;
                    }
                    case MARK_ARRAY: {
                        string = "Marking array bounds";
                    }
                }
                this.addInfoLine(desc, "Pending Action: %s", string);
            }
            if (Integer.bitCount(this.tier.capabilities & ALL_MODES) > 1) {
                String string;
                switch (state.config.placeMode) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case GEOMETRY: {
                        string = "Geometry";
                        break;
                    }
                    case MOVING: {
                        string = "Moving";
                        break;
                    }
                    case COPYING: {
                        string = "Copying";
                        break;
                    }
                    case EXCHANGING: {
                        string = "Exchanging";
                        break;
                    }
                    case CABLES: {
                        string = "Cables";
                    }
                }
                this.addInfoLine(desc, "Mode: %s", string);
            }
            if (state.hasCap(ALLOW_REMOVING)) {
                String string;
                switch (state.config.removeMode) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case ALL: {
                        string = "All blocks";
                        break;
                    }
                    case REPLACEABLE: {
                        string = "Replaceable blocks";
                        break;
                    }
                    case NONE: {
                        string = "No blocks";
                    }
                }
                this.addInfoLine(desc, "Removing: %s", string);
            }
            if (state.config.placeMode == MMState.PlaceMode.GEOMETRY) {
                String string;
                switch (state.config.shape) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case LINE: {
                        string = "Line";
                        break;
                    }
                    case CUBE: {
                        string = "Cube";
                        break;
                    }
                    case SPHERE: {
                        string = "Sphere";
                        break;
                    }
                    case CYLINDER: {
                        string = "Cylinder";
                    }
                }
                this.addInfoLine(desc, "Shape: %s", string);
                this.addInfoLine(desc, "Coordinate A: %s", state.config.coordA);
                this.addInfoLine(desc, "Coordinate B: %s", state.config.coordB);
                this.addInfoLine(desc, "Corner block: %s", state.config.corners);
                this.addInfoLine(desc, "Edge block: %s", state.config.edges);
                this.addInfoLine(desc, "Face block: %s", state.config.faces);
                this.addInfoLine(desc, "Volume block: %s", state.config.volumes);
            }
            if (state.config.placeMode == MMState.PlaceMode.COPYING) {
                this.addInfoLine(desc, "Copy Coordinate A: %s", state.config.coordA);
                this.addInfoLine(desc, "Copy Coordinate B: %s", state.config.coordB);
                this.addInfoLine(desc, "Paste Coordinate: %s", state.config.coordC);
                this.addInfoLine(desc, "Stack: %s", state.config.arraySpan, span -> String.format("X: %dx, Y: %dx, Z: %dx", span.x + (span.x < 0 ? -1 : 1), span.y + (span.y < 0 ? -1 : 1), span.z + (span.z < 0 ? -1 : 1)));
            }
            if (state.config.placeMode == MMState.PlaceMode.MOVING) {
                this.addInfoLine(desc, "Cut Coordinate A: %s", state.config.coordA);
                this.addInfoLine(desc, "Cut Coordinate B: %s", state.config.coordB);
                this.addInfoLine(desc, "Paste Coordinate: %s", state.config.coordC);
            }
            if (state.config.placeMode == MMState.PlaceMode.EXCHANGING) {
                this.addInfoLine(desc, "Removable blocks: %s", state.config.replaceWhitelist);
                this.addInfoLine(desc, "Replacing blocks with: %s", state.config.replaceWith);
            }
            if (state.config.placeMode == MMState.PlaceMode.CABLES) {
                this.addInfoLine(desc, "Coordinate A: %s", state.config.coordA);
                this.addInfoLine(desc, "Coordinate B: %s", state.config.coordB);
                this.addInfoLine(desc, "Cable: %s", state.config.cables);
            }
            ArrayList<MMUpgrades> upgrades = new ArrayList<MMUpgrades>(state.getInstalledUpgrades());
            upgrades.sort(Comparator.comparingInt(Enum::ordinal));
            if (!upgrades.isEmpty()) {
                desc.add(StatCollector.func_74838_a((String)"mm.tooltip.installed_upgrades"));
                for (MMUpgrades upgrade : upgrades) {
                    desc.add("- " + upgrade.getStack().func_82833_r());
                }
            }
        }
        desc.add(EnumChatFormatting.AQUA + I18n.func_135052_a((String)"mm.tooltip.voltage", (Object[])new Object[]{MMUtils.formatNumbers(MMUtils.clamp(Math.round(state.charge), 0L, this.tier.maxCharge)), MMUtils.formatNumbers(this.tier.maxCharge), MMUtils.formatNumbers(MMValues.V[this.tier.voltageTier])}) + EnumChatFormatting.GRAY);
    }

    private <T> void addInfoLine(List<String> desc, String format, T value) {
        this.addInfoLine(desc, format, value, Object::toString);
    }

    private <T> void addInfoLine(List<String> desc, String format, T value, Function<T, String> toString) {
        if (value != null) {
            desc.add(String.format(format, EnumChatFormatting.BLUE.toString() + toString.apply(value) + EnumChatFormatting.RESET.toString()));
        } else {
            desc.add(String.format(format, EnumChatFormatting.GRAY.toString() + "None" + EnumChatFormatting.RESET.toString()));
        }
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        MovingObjectPosition hit;
        if (player.func_71039_bw()) {
            return stack;
        }
        MMState state = ItemMatterManipulator.getState(stack);
        if (state.config.action != null && this.handleAction(stack, world, player, state, hit = MMUtils.getHitResult(player, true))) {
            ItemMatterManipulator.setState(stack, state);
            return stack;
        }
        hit = MMUtils.getHitResult(player, false);
        if (hit != null) {
            Location location = new Location(world, hit.field_72311_b, hit.field_72312_c, hit.field_72309_d);
            if (!player.func_70093_af()) {
                location.offset(ForgeDirection.getOrientation((int)hit.field_72310_e));
            }
            if (state.config.placeMode == MMState.PlaceMode.GEOMETRY || state.config.placeMode == MMState.PlaceMode.EXCHANGING || state.config.placeMode == MMState.PlaceMode.CABLES) {
                state.config.coordA = location;
                state.config.coordB = null;
                state.config.coordC = null;
                state.config.coordBOffset = new Vector3i();
                state.config.action = MMState.PendingAction.MOVING_COORDS;
            }
            ItemMatterManipulator.setState(stack, state);
            return stack;
        }
        if (player.func_70093_af()) {
            player.func_71008_a(stack, Integer.MAX_VALUE);
        } else if (world.field_72995_K) {
            UIInfos.openClientUI((EntityPlayer)player, this::createWindow);
        }
        return stack;
    }

    public boolean handleAction(ItemStack itemStack, World world, EntityPlayer player, MMState state, MovingObjectPosition hit) {
        switch (state.config.action) {
            case MOVING_COORDS: {
                Vector3i lookingAt = MMUtils.getLookingAtLocation(player);
                if (state.config.placeMode == MMState.PlaceMode.GEOMETRY && state.config.coordAOffset == null && state.config.coordBOffset != null && state.config.coordCOffset == null && state.config.shape.requiresC()) {
                    state.config.coordA = state.config.getCoordA(world, lookingAt);
                    state.config.coordB = state.config.getCoordB(world, lookingAt);
                    state.config.coordC = null;
                    state.config.coordAOffset = null;
                    state.config.coordBOffset = null;
                    state.config.coordCOffset = new Vector3i();
                } else {
                    state.config.coordA = state.config.getCoordA(world, lookingAt);
                    state.config.coordB = state.config.getCoordB(world, lookingAt);
                    state.config.coordC = state.config.getCoordC(world, lookingAt);
                    state.config.coordAOffset = null;
                    state.config.coordBOffset = null;
                    state.config.coordCOffset = null;
                    state.config.action = null;
                }
                return true;
            }
            case GEOM_SELECTING_BLOCK: {
                state.config.action = null;
                this.onPickBlock(world, player, itemStack, state, hit);
                return true;
            }
            case MARK_COPY_A: {
                state.config.coordA = new Location(world, MMUtils.getLookingAtLocation(player));
                state.config.action = MMState.PendingAction.MARK_COPY_B;
                return true;
            }
            case MARK_COPY_B: {
                state.config.coordB = new Location(world, MMUtils.getLookingAtLocation(player));
                state.config.action = null;
                return true;
            }
            case MARK_CUT_A: {
                state.config.coordA = new Location(world, MMUtils.getLookingAtLocation(player));
                state.config.action = MMState.PendingAction.MARK_CUT_B;
                return true;
            }
            case MARK_CUT_B: {
                state.config.coordB = new Location(world, MMUtils.getLookingAtLocation(player));
                state.config.action = null;
                return true;
            }
            case MARK_PASTE: {
                state.config.coordC = new Location(world, MMUtils.getLookingAtLocation(player));
                state.config.action = null;
                return true;
            }
            case EXCH_SET_TARGET: {
                this.onExchangeSetTarget(world, player, itemStack, state, hit);
                state.config.action = null;
                return true;
            }
            case EXCH_ADD_REPLACE: {
                this.onExchangeAddWhitelist(world, player, itemStack, state, hit);
                state.config.action = null;
                return true;
            }
            case EXCH_SET_REPLACE: {
                this.onExchangeSetWhitelist(world, player, itemStack, state, hit);
                state.config.action = null;
                return true;
            }
            case PICK_CABLE: {
                this.onPickCable(world, player, itemStack, state, hit);
                state.config.action = null;
                return true;
            }
            case MARK_ARRAY: {
                this.onMarkArray(world, player, itemStack, state);
                state.config.action = null;
                return true;
            }
        }
        return false;
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onMouseEvent(MouseEvent event) {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null || player.field_70128_L) {
            return;
        }
        ItemStack heldItem = player.func_70694_bm();
        if (heldItem == null) {
            return;
        }
        if (event.button == 2 && event.buttonstate && heldItem.func_77973_b() == this) {
            event.setCanceled(true);
            MMState state = ItemMatterManipulator.getState(heldItem);
            this.onMMBPressed((EntityPlayer)player, heldItem, state);
            ItemMatterManipulator.setState(heldItem, state);
            Messages.MMBPressed.sendToServer();
        }
    }

    public void onMMBPressed(EntityPlayer player, ItemStack stack, MMState state) {
        if (state.config.placeMode == MMState.PlaceMode.GEOMETRY) {
            this.onPickBlock(player.func_130014_f_(), player, stack, state, MMUtils.getHitResult(player, true));
        }
        if (state.config.placeMode == MMState.PlaceMode.EXCHANGING) {
            if (player.func_70093_af()) {
                this.onExchangeSetWhitelist(player.field_70170_p, player, stack, state, MMUtils.getHitResult(player, true));
            } else {
                this.onExchangeSetTarget(player.field_70170_p, player, stack, state, MMUtils.getHitResult(player, true));
            }
        }
        if (state.config.placeMode == MMState.PlaceMode.CABLES) {
            this.onPickCable(player.func_130014_f_(), player, stack, state, MMUtils.getHitResult(player, true));
        }
    }

    private void onPickBlock(World world, EntityPlayer player, ItemStack stack, MMState state, MovingObjectPosition hit) {
        BlockSpec block = BlockSpec.fromPickBlock(world, player, hit);
        String what = null;
        boolean add = player.func_70093_af();
        switch (state.config.blockSelectMode) {
            case CORNERS: {
                if (state.config.corners == null || !add) {
                    state.config.corners = new WeightedSpecList(new BlockSpec[0]);
                }
                state.config.corners.add(block);
                what = "corners";
                break;
            }
            case EDGES: {
                if (state.config.edges == null || !add) {
                    state.config.edges = new WeightedSpecList(new BlockSpec[0]);
                }
                state.config.edges.add(block);
                what = "edges";
                break;
            }
            case FACES: {
                if (state.config.faces == null || !add) {
                    state.config.faces = new WeightedSpecList(new BlockSpec[0]);
                }
                state.config.faces.add(block);
                what = "faces";
                break;
            }
            case VOLUMES: {
                if (state.config.volumes == null || !add) {
                    state.config.volumes = new WeightedSpecList(new BlockSpec[0]);
                }
                state.config.volumes.add(block);
                what = "volumes";
                break;
            }
            case ALL: {
                if (state.config.corners == null || !add) {
                    state.config.corners = new WeightedSpecList(new BlockSpec[0]);
                }
                if (state.config.edges == null || !add) {
                    state.config.edges = new WeightedSpecList(new BlockSpec[0]);
                }
                if (state.config.faces == null || !add) {
                    state.config.faces = new WeightedSpecList(new BlockSpec[0]);
                }
                if (state.config.volumes == null || !add) {
                    state.config.volumes = new WeightedSpecList(new BlockSpec[0]);
                }
                state.config.corners.add(block);
                state.config.edges.add(block);
                state.config.faces.add(block);
                state.config.volumes.add(block);
                what = "all blocks";
            }
        }
        if (add) {
            MMUtils.sendInfoToPlayer(player, StatCollector.func_74837_a((String)"mm.info.added", (Object[])new Object[]{block.getDisplayName(), what}));
        } else {
            MMUtils.sendInfoToPlayer(player, StatCollector.func_74837_a((String)"mm.info.set", (Object[])new Object[]{what, block.getDisplayName()}));
        }
    }

    private void onExchangeSetTarget(World world, EntityPlayer player, ItemStack stack, MMState state, MovingObjectPosition hit) {
        BlockSpec block = BlockSpec.fromPickBlock(player.field_70170_p, player, hit);
        if (hit != null) {
            this.checkForAECables(state, block, world, hit.field_72311_b, hit.field_72312_c, hit.field_72309_d);
        }
        state.config.replaceWith = new WeightedSpecList(new BlockSpec[0]);
        state.config.replaceWith.add(block);
        MMUtils.sendInfoToPlayer(player, StatCollector.func_74837_a((String)"mm.info.set_block_to_replace_with", (Object[])new Object[]{block.getDisplayName()}));
    }

    private void onExchangeAddWhitelist(World world, EntityPlayer player, ItemStack stack, MMState state, MovingObjectPosition hit) {
        BlockSpec block = BlockSpec.fromPickBlock(player.field_70170_p, player, hit);
        if (hit != null) {
            this.checkForAECables(state, block, world, hit.field_72311_b, hit.field_72312_c, hit.field_72309_d);
        }
        if (state.config.replaceWhitelist == null) {
            state.config.replaceWhitelist = new WeightedSpecList(new BlockSpec[0]);
        }
        state.config.replaceWhitelist.add(block);
        MMUtils.sendInfoToPlayer(player, StatCollector.func_74837_a((String)"mm.info.added_block_to_exchange_whitelist", (Object[])new Object[]{block.getDisplayName()}));
    }

    private void onExchangeSetWhitelist(World world, EntityPlayer player, ItemStack stack, MMState state, MovingObjectPosition hit) {
        BlockSpec block = BlockSpec.fromPickBlock(player.field_70170_p, player, hit);
        if (hit != null) {
            this.checkForAECables(state, block, world, hit.field_72311_b, hit.field_72312_c, hit.field_72309_d);
        }
        state.config.replaceWhitelist = new WeightedSpecList(new BlockSpec[0]);
        state.config.replaceWhitelist.add(block);
        MMUtils.sendInfoToPlayer(player, StatCollector.func_74837_a((String)"mm.info.set_exchange_whitelist_to_only_contain", (Object[])new Object[]{block.getDisplayName()}));
    }

    private void onPickCable(World world, EntityPlayer player, ItemStack stack, MMState state, MovingObjectPosition hit) {
        BlockSpec cable = new BlockSpec();
        if (hit != null) {
            if (Mods.GregTech.isModLoaded()) {
                MMUtils.getGTCable(cable, world, hit.field_72311_b, hit.field_72312_c, hit.field_72309_d);
            }
            if (cable.isAir() && Mods.AppliedEnergistics2.isModLoaded()) {
                MMUtils.getAECable(cable, world, hit.field_72311_b, hit.field_72312_c, hit.field_72309_d);
            }
        }
        state.config.cables = cable.isAir() ? null : cable;
        MMUtils.sendInfoToPlayer(player, StatCollector.func_74837_a((String)"mm.info.set_cable", (Object[])new Object[]{cable.getDisplayName()}));
    }

    private void checkForAECables(MMState state, BlockSpec spec, World world, int x, int y, int z) {
        if (state.hasCap(ALLOW_CABLES) && Mods.AppliedEnergistics2.isModLoaded() && InteropConstants.AE_BLOCK_CABLE.matches(spec)) {
            MMUtils.getAECable(spec, world, x, y, z);
        }
    }

    private void onMarkArray(World world, EntityPlayer player, ItemStack stack, MMState state) {
        Vector3i lookingAt = MMUtils.getLookingAtLocation(player);
        if (!Location.areCompatible(state.config.coordA, state.config.coordB)) {
            MMUtils.sendErrorToPlayer(player, StatCollector.func_74838_a((String)"mm.info.error.cannot_mark_copy"));
            state.config.arraySpan = null;
            return;
        }
        if (state.config.coordC == null || !state.config.coordC.isInWorld(world)) {
            MMUtils.sendErrorToPlayer(player, StatCollector.func_74838_a((String)"mm.info.error.cannot_mark_paste"));
            state.config.arraySpan = null;
            return;
        }
        state.config.arraySpan = state.config.getArrayMult(world, state.config.coordA, state.config.coordB, state.config.coordC, lookingAt);
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.bow;
    }

    public int func_77626_a(ItemStack p_77626_1_) {
        return Integer.MAX_VALUE;
    }

    private void stopBuildable(EntityPlayer player) {
        IBuildable buildable;
        if (!player.field_70170_p.field_72995_K && (buildable = PENDING_BUILDS.remove(player)) != null) {
            buildable.onStopped();
        }
    }

    public void func_77615_a(ItemStack stack, World world, EntityPlayer player, int itemUseCount) {
        this.stopBuildable(player);
    }

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        this.stopBuildable(event.player);
    }

    @SubscribeEvent
    public void onPlayerKilled(LivingDeathEvent event) {
        Entity entity = event.entity;
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            this.stopBuildable(player);
        }
    }

    public void onUsingTick(ItemStack stack, EntityPlayer player, int count) {
        if (!player.field_70170_p.field_72995_K) {
            int ticksUsed = Integer.MAX_VALUE - count;
            MMState state = ItemMatterManipulator.getState(stack);
            if (ticksUsed == 1) {
                switch (state.config.placeMode) {
                    case GEOMETRY: 
                    case COPYING: 
                    case EXCHANGING: 
                    case CABLES: {
                        PENDING_BUILDS.put(player, this.getPendingBuild(player, stack, state));
                        break;
                    }
                    case MOVING: {
                        PENDING_BUILDS.put(player, this.getPendingMove(player, stack, state));
                    }
                }
            }
            int placeTicks = this.tier.placeTicks;
            if (state.hasUpgrade(MMUpgrades.Speed)) {
                placeTicks /= 2;
            }
            if (ticksUsed >= 10 && ticksUsed % placeTicks == 0) {
                try {
                    IBuildable buildable = PENDING_BUILDS.get(player);
                    if (buildable != null) {
                        buildable.tryPlaceBlocks(stack, player);
                    }
                }
                catch (Throwable t) {
                    MMMod.LOG.error("Could not place blocks", t);
                    MMUtils.sendErrorToPlayer(player, "Could not place blocks due to a crash. Check the logs for more info.");
                }
            }
        }
    }

    private IBuildable getPendingBuild(EntityPlayer player, ItemStack stack, MMState state) {
        List<PendingBlock> blocks = state.getPendingBlocks(this.tier, player.func_130014_f_());
        if (this.tier.maxRange != -1) {
            int maxRange2 = this.tier.maxRange * this.tier.maxRange;
            Location playerLocation = new Location(player.func_130014_f_(), MathHelper.func_76128_c((double)player.field_70165_t), MathHelper.func_76128_c((double)player.field_70163_u), MathHelper.func_76128_c((double)player.field_70161_v));
            blocks.removeIf(block -> block.distanceTo2(playerLocation) > maxRange2);
        }
        blocks.sort(PendingBlock.getComparator());
        return new PendingBuild(player, state, this.tier, blocks);
    }

    private IBuildable getPendingMove(EntityPlayer player, ItemStack stack, MMState state) {
        return new PendingMove(player, state, this.tier);
    }

    public String getEncryptionKey(ItemStack item) {
        MMState state = ItemMatterManipulator.getState(item);
        if (state.hasCap(CONNECTS_TO_AE)) {
            return state.encKey != null ? Long.toHexString(state.encKey) : null;
        }
        return null;
    }

    public void setEncryptionKey(ItemStack item, String encKey, String name) {
        MMState state = ItemMatterManipulator.getState(item);
        if (state.hasCap(CONNECTS_TO_AE)) {
            try {
                state.encKey = Long.parseLong(encKey);
            }
            catch (NumberFormatException e) {
                state.encKey = null;
            }
        } else {
            state.encKey = null;
        }
        ItemMatterManipulator.setState(item, state);
    }

    public void setUplinkAddress(ItemStack stack, Long address) {
        MMState state = ItemMatterManipulator.getState(stack);
        if (state.hasCap(CONNECTS_TO_UPLINK)) {
            state.uplinkAddress = address;
            ItemMatterManipulator.setState(stack, state);
        }
    }

    public ModularWindow createWindow(UIBuildContext buildContext) {
        buildContext.setShowNEI(false);
        ModularWindow.Builder builder = ModularWindow.builder((Size)new Size(176, 272));
        builder.widget((Widget)this.getMenuOptions(buildContext).build());
        return builder.build();
    }

    private RadialMenuBuilder getMenuOptions(UIBuildContext buildContext) {
        ItemStack heldStack = buildContext.getPlayer().func_70694_bm();
        MMState initialState = ItemMatterManipulator.getState(heldStack);
        return new RadialMenuBuilder(buildContext).innerIcon(new ItemStack((Item)this)).pipe(builder -> this.addCommonOptions((RadialMenuBuilder)builder, initialState)).pipe(builder -> {
            switch (initialState.config.placeMode) {
                case GEOMETRY: {
                    this.addGeometryOptions((RadialMenuBuilder)builder, buildContext, heldStack, initialState);
                    break;
                }
                case COPYING: {
                    this.addCopyingOptions((RadialMenuBuilder)builder, buildContext, heldStack, initialState);
                    break;
                }
                case MOVING: {
                    this.addMovingOptions((RadialMenuBuilder)builder, buildContext, heldStack);
                    break;
                }
                case EXCHANGING: {
                    this.addExchangingOptions((RadialMenuBuilder)builder, buildContext, heldStack);
                    break;
                }
                case CABLES: {
                    this.addCableOptions((RadialMenuBuilder)builder, buildContext, heldStack);
                }
            }
        });
    }

    private void addCommonOptions(RadialMenuBuilder builder, MMState state) {
        ((RadialMenuBuilder.RadialMenuOptionBuilderBranch)((RadialMenuBuilder.RadialMenuOptionBuilderBranch)((RadialMenuBuilder.RadialMenuOptionBuilderBranch)((RadialMenuBuilder)((RadialMenuBuilder.RadialMenuOptionBuilderBranch)((RadialMenuBuilder.RadialMenuOptionBuilderBranch)((RadialMenuBuilder.RadialMenuOptionBuilderBranch)((RadialMenuBuilder.RadialMenuOptionBuilderBranch)((RadialMenuBuilder.RadialMenuOptionBuilderBranch)((RadialMenuBuilder.RadialMenuOptionBuilderBranch)((RadialMenuBuilder.RadialMenuOptionBuilderBranch)((RadialMenuBuilder.RadialMenuOptionBuilderBranch)((RadialMenuBuilder.RadialMenuOptionBuilderBranch)builder.branch().label(StatCollector.func_74838_a((String)"mm.gui.set_mode")).hidden(this.tier == ManipulatorTier.Tier0).branch().label(StatCollector.func_74838_a((String)"mm.gui.set_remove_mode")).hidden(!state.hasCap(ALLOW_REMOVING)).option().label(StatCollector.func_74838_a((String)"mm.gui.remove_none")).onClicked(() -> Messages.SetRemoveMode.sendToServer((Object)MMState.BlockRemoveMode.NONE)).done()).option().label(StatCollector.func_74838_a((String)"mm.gui.remove_replaceable")).onClicked(() -> Messages.SetRemoveMode.sendToServer((Object)MMState.BlockRemoveMode.REPLACEABLE)).done()).option().label(StatCollector.func_74838_a((String)"mm.gui.remove_all")).onClicked(() -> Messages.SetRemoveMode.sendToServer((Object)MMState.BlockRemoveMode.ALL)).done()).done()).option().label(StatCollector.func_74838_a((String)"mm.gui.geometry")).onClicked(() -> Messages.SetPlaceMode.sendToServer((Object)MMState.PlaceMode.GEOMETRY)).done()).option().label(StatCollector.func_74838_a((String)"mm.gui.moving")).hidden(!state.hasCap(ALLOW_MOVING)).onClicked(() -> Messages.SetPlaceMode.sendToServer((Object)MMState.PlaceMode.MOVING)).done()).option().label(StatCollector.func_74838_a((String)"mm.gui.copying")).hidden(!state.hasCap(ALLOW_COPYING)).onClicked(() -> Messages.SetPlaceMode.sendToServer((Object)MMState.PlaceMode.COPYING)).done()).option().label(StatCollector.func_74838_a((String)"mm.gui.exchanging")).hidden(!state.hasCap(ALLOW_EXCHANGING)).onClicked(() -> Messages.SetPlaceMode.sendToServer((Object)MMState.PlaceMode.EXCHANGING)).done()).option().label(StatCollector.func_74838_a((String)"mm.gui.cables")).hidden(!state.hasCap(ALLOW_CABLES)).onClicked(() -> Messages.SetPlaceMode.sendToServer((Object)MMState.PlaceMode.CABLES)).done()).done()).branch().label(StatCollector.func_74838_a((String)"mm.gui.set_remove_mode")).hidden(this.tier != ManipulatorTier.Tier0 || !state.hasCap(ALLOW_REMOVING)).option().label(StatCollector.func_74838_a((String)"mm.gui.remove_none")).onClicked(() -> Messages.SetRemoveMode.sendToServer((Object)MMState.BlockRemoveMode.NONE)).done()).option().label(StatCollector.func_74838_a((String)"mm.gui.remove_replaceable")).onClicked(() -> Messages.SetRemoveMode.sendToServer((Object)MMState.BlockRemoveMode.REPLACEABLE)).done()).option().label(StatCollector.func_74838_a((String)"mm.gui.remove_all")).onClicked(() -> Messages.SetRemoveMode.sendToServer((Object)MMState.BlockRemoveMode.ALL)).done()).done();
    }

    private void addGeometryOptions(RadialMenuBuilder builder, UIBuildContext buildContext, ItemStack heldStack, MMState state) {
        ((RadialMenuBuilder.RadialMenuOptionBuilderBranch)((RadialMenuBuilder.RadialMenuOptionBuilderBranch)((RadialMenuBuilder.RadialMenuOptionBuilderBranch)((RadialMenuBuilder.RadialMenuOptionBuilderBranch)((RadialMenuBuilder)((RadialMenuBuilder.RadialMenuOptionBuilderBranch)((RadialMenuBuilder.RadialMenuOptionBuilderBranch)((RadialMenuBuilder.RadialMenuOptionBuilderBranch)((RadialMenuBuilder.RadialMenuOptionBuilderBranch)((RadialMenuBuilder)((RadialMenuBuilder.RadialMenuOptionBuilderBranch)((RadialMenuBuilder.RadialMenuOptionBuilderBranch)((RadialMenuBuilder.RadialMenuOptionBuilderBranch)((RadialMenuBuilder.RadialMenuOptionBuilderBranch)((RadialMenuBuilder.RadialMenuOptionBuilderBranch)((RadialMenuBuilder.RadialMenuOptionBuilderBranch)builder.branch().label(StatCollector.func_74838_a((String)"mm.gui.select_blocks")).option().label(StatCollector.func_74838_a((String)"mm.gui.set_corners")).onClicked(() -> {
            Messages.SetBlockSelectMode.sendToServer((Object)MMState.BlockSelectMode.CORNERS);
            Messages.SetPendingAction.sendToServer((Object)MMState.PendingAction.GEOM_SELECTING_BLOCK);
        }).done()).option().label(StatCollector.func_74838_a((String)"mm.gui.set_edges")).onClicked(() -> {
            Messages.SetBlockSelectMode.sendToServer((Object)MMState.BlockSelectMode.EDGES);
            Messages.SetPendingAction.sendToServer((Object)MMState.PendingAction.GEOM_SELECTING_BLOCK);
        }).done()).option().label(StatCollector.func_74838_a((String)"mm.gui.set_faces")).onClicked(() -> {
            Messages.SetBlockSelectMode.sendToServer((Object)MMState.BlockSelectMode.FACES);
            Messages.SetPendingAction.sendToServer((Object)MMState.PendingAction.GEOM_SELECTING_BLOCK);
        }).done()).option().label(StatCollector.func_74838_a((String)"mm.gui.set_volumes")).onClicked(() -> {
            Messages.SetBlockSelectMode.sendToServer((Object)MMState.BlockSelectMode.VOLUMES);
            Messages.SetPendingAction.sendToServer((Object)MMState.PendingAction.GEOM_SELECTING_BLOCK);
        }).done()).option().label(StatCollector.func_74838_a((String)"mm.gui.set_all")).onClicked(() -> {
            Messages.SetBlockSelectMode.sendToServer((Object)MMState.BlockSelectMode.ALL);
            Messages.SetPendingAction.sendToServer((Object)MMState.PendingAction.GEOM_SELECTING_BLOCK);
        }).done()).option().label(StatCollector.func_74838_a((String)"mm.gui.clear_all")).onClicked(() -> Messages.ClearBlocks.sendToServer()).done()).done()).branch().label(StatCollector.func_74838_a((String)"mm.gui.set_shape")).option().label(StatCollector.func_74838_a((String)"mm.gui.line")).onClicked(() -> Messages.SetShape.sendToServer((Object)MMState.Shape.LINE)).done()).option().label(StatCollector.func_74838_a((String)"mm.gui.cube")).onClicked(() -> Messages.SetShape.sendToServer((Object)MMState.Shape.CUBE)).done()).option().label(StatCollector.func_74838_a((String)"mm.gui.sphere")).onClicked(() -> Messages.SetShape.sendToServer((Object)MMState.Shape.SPHERE)).done()).option().label(StatCollector.func_74838_a((String)"mm.gui.cylinder")).onClicked(() -> Messages.SetShape.sendToServer((Object)MMState.Shape.CYLINDER)).done()).done()).branch().label(StatCollector.func_74838_a((String)"mm.gui.move_coords")).option().label(StatCollector.func_74838_a((String)"mm.gui.move_coord_a")).onClicked(() -> Messages.MoveA.sendToServer()).done()).option().label(StatCollector.func_74838_a((String)"mm.gui.move_all")).onClicked(() -> Messages.MoveAll.sendToServer()).done()).option().label(StatCollector.func_74838_a((String)"mm.gui.move_coord_b")).onClicked(() -> Messages.MoveB.sendToServer()).done()).option().label(StatCollector.func_74838_a((String)"mm.gui.move_here")).onClicked(() -> Messages.MoveHere.sendToServer()).done()).done();
    }

    private void addCopyingOptions(RadialMenuBuilder builder, UIBuildContext buildContext, ItemStack heldStack, MMState initialState) {
        ((RadialMenuBuilder)((RadialMenuBuilder)((RadialMenuBuilder.RadialMenuOptionBuilderBranch)((RadialMenuBuilder.RadialMenuOptionBuilderBranch)((RadialMenuBuilder.RadialMenuOptionBuilderBranch)((RadialMenuBuilder.RadialMenuOptionBuilderBranch)((RadialMenuBuilder.RadialMenuOptionBuilderBranch)((RadialMenuBuilder.RadialMenuOptionBuilderBranch)((RadialMenuBuilder)((RadialMenuBuilder.RadialMenuOptionBuilderBranch)((RadialMenuBuilder.RadialMenuOptionBuilderBranch)((RadialMenuBuilder)builder.option().label(StatCollector.func_74838_a((String)"mm.gui.mark_copy")).onClicked(() -> Messages.MarkCopy.sendToServer()).done()).branch().label(StatCollector.func_74838_a((String)"mm.gui.edit_stack")).option().label(StatCollector.func_74838_a((String)"mm.gui.reset")).onClicked(() -> Messages.ResetArray.sendToServer()).done()).option().label(StatCollector.func_74838_a((String)"mm.gui.mark")).onClicked(() -> Messages.SetPendingAction.sendToServer((Object)MMState.PendingAction.MARK_ARRAY)).done()).done()).branch().label(StatCollector.func_74838_a((String)"mm.gui.planning")).option().label(StatCollector.func_74838_a((String)"mm.gui.cancel_auto_plans")).onClicked(() -> Messages.CancelAutoPlans.sendToServer()).done()).option().label(StatCollector.func_74838_a((String)"mm.gui.plan_all_auto")).onClicked(() -> Messages.GetRequiredItems.sendToServer(3)).done()).option().label(StatCollector.func_74838_a((String)"mm.gui.plan_all_manual")).onClicked(() -> Messages.GetRequiredItems.sendToServer(2)).done()).option().label(StatCollector.func_74838_a((String)"mm.gui.clear_manual_plans")).onClicked(() -> Messages.ClearManualPlans.sendToServer()).done()).option().label(StatCollector.func_74838_a((String)"mm.gui.plan_missing_manual")).onClicked(() -> Messages.GetRequiredItems.sendToServer(0)).done()).option().label(StatCollector.func_74838_a((String)"mm.gui.plan_missing_auto")).onClicked(() -> Messages.GetRequiredItems.sendToServer(1)).done()).done()).option().label(StatCollector.func_74838_a((String)"mm.gui.edit_transform")).onClicked((menu, option, mouseButton, doubleClicked) -> {
            UIBuildContext buildContext2 = new UIBuildContext(buildContext.getPlayer());
            ModularWindow window = this.createTransformWindow(buildContext2, heldStack, initialState);
            TransparentModularGui screen = new TransparentModularGui(new ModularUIContainer(new ModularUIContext(buildContext2, null, true), window));
            FMLCommonHandler.instance().showGuiScreen((Object)screen);
        }).done()).option().label(StatCollector.func_74838_a((String)"mm.gui.mark_paste")).onClicked(() -> Messages.MarkPaste.sendToServer()).done();
    }

    private void addMovingOptions(RadialMenuBuilder builder, UIBuildContext buildContext, ItemStack heldStack) {
        ((RadialMenuBuilder)builder.option().label(StatCollector.func_74838_a((String)"mm.gui.mark_cut")).onClicked(() -> Messages.MarkCut.sendToServer()).done()).option().label(StatCollector.func_74838_a((String)"mm.gui.mark_paste")).onClicked(() -> Messages.MarkPaste.sendToServer()).done();
    }

    private void addExchangingOptions(RadialMenuBuilder builder, UIBuildContext buildContext, ItemStack heldStack) {
        ((RadialMenuBuilder.RadialMenuOptionBuilderBranch)((RadialMenuBuilder.RadialMenuOptionBuilderBranch)((RadialMenuBuilder.RadialMenuOptionBuilderBranch)((RadialMenuBuilder.RadialMenuOptionBuilderBranch)((RadialMenuBuilder)((RadialMenuBuilder)((RadialMenuBuilder.RadialMenuOptionBuilderBranch)((RadialMenuBuilder.RadialMenuOptionBuilderBranch)((RadialMenuBuilder.RadialMenuOptionBuilderBranch)builder.branch().label(StatCollector.func_74838_a((String)"mm.gui.edit_replace_whitelist")).option().label(StatCollector.func_74838_a((String)"mm.gui.clear")).onClicked(() -> Messages.ClearWhitelist.sendToServer()).done()).option().label(StatCollector.func_74838_a((String)"mm.gui.add_block")).onClicked(() -> Messages.SetPendingAction.sendToServer((Object)MMState.PendingAction.EXCH_ADD_REPLACE)).done()).option().label(StatCollector.func_74838_a((String)"mm.gui.set_block")).onClicked(() -> Messages.SetPendingAction.sendToServer((Object)MMState.PendingAction.EXCH_SET_REPLACE)).done()).done()).option().label(StatCollector.func_74838_a((String)"mm.gui.set_block_to_replace_with")).onClicked(() -> Messages.SetPendingAction.sendToServer((Object)MMState.PendingAction.EXCH_SET_TARGET)).done()).branch().label(StatCollector.func_74838_a((String)"mm.gui.move_coords")).option().label(StatCollector.func_74838_a((String)"mm.gui.move_coord_a")).onClicked(() -> Messages.MoveA.sendToServer()).done()).option().label(StatCollector.func_74838_a((String)"mm.gui.move_all")).onClicked(() -> Messages.MoveAll.sendToServer()).done()).option().label(StatCollector.func_74838_a((String)"mm.gui.move_coord_b")).onClicked(() -> Messages.MoveB.sendToServer()).done()).option().label(StatCollector.func_74838_a((String)"mm.gui.move_here")).onClicked(() -> Messages.MoveHere.sendToServer()).done()).done();
    }

    private void addCableOptions(RadialMenuBuilder builder, UIBuildContext buildContext, ItemStack heldStack) {
        ((RadialMenuBuilder.RadialMenuOptionBuilderBranch)((RadialMenuBuilder.RadialMenuOptionBuilderBranch)((RadialMenuBuilder.RadialMenuOptionBuilderBranch)((RadialMenuBuilder.RadialMenuOptionBuilderBranch)((RadialMenuBuilder)builder.option().label(StatCollector.func_74838_a((String)"mm.gui.set_cable")).onClicked(() -> Messages.SetPendingAction.sendToServer((Object)MMState.PendingAction.PICK_CABLE)).done()).branch().label(StatCollector.func_74838_a((String)"mm.gui.move_coords")).option().label(StatCollector.func_74838_a((String)"mm.gui.move_coord_a")).onClicked(() -> Messages.MoveA.sendToServer()).done()).option().label(StatCollector.func_74838_a((String)"mm.gui.move_all")).onClicked(() -> Messages.MoveAll.sendToServer()).done()).option().label(StatCollector.func_74838_a((String)"mm.gui.move_coord_b")).onClicked(() -> Messages.MoveB.sendToServer()).done()).option().label(StatCollector.func_74838_a((String)"mm.gui.move_here")).onClicked(() -> Messages.MoveHere.sendToServer()).done()).done();
    }

    private static Widget padding(int width, int height) {
        return new Row().setSize(width, height);
    }

    public ModularWindow createTransformWindow(UIBuildContext buildContext, ItemStack heldStack, MMState initialState) {
        buildContext.setShowNEI(false);
        ModularWindow.Builder builder = ModularWindow.builderFullScreen();
        builder.bindPlayerInventory(buildContext.getPlayer(), 0, -9001);
        if (NetworkUtils.isClient()) {
            DynamicTextWidget rotationInfo = DynamicTextWidget.dynamicString(() -> {
                MMState currState = ItemMatterManipulator.getState(buildContext.getPlayer().func_70694_bm());
                Transform t = currState.getTransform();
                ArrayList<String> flips = new ArrayList<String>();
                if (t.flipX) {
                    flips.add("X");
                }
                if (t.flipY) {
                    flips.add("Y");
                }
                if (t.flipZ) {
                    flips.add("Z");
                }
                return StatCollector.func_74837_a((String)"mm.transform.info", (Object[])new Object[]{flips.isEmpty() ? "None" : String.join((CharSequence)", ", flips), MMUtils.getDirectionDisplayName(t.up), MMUtils.getDirectionDisplayName(t.forward)}).replace("\\n", "\n");
            });
            Widget[] left = new Widget[]{(Widget)new Row().widgets(new Widget[]{new VanillaButtonWidget().setDisplayString(StatCollector.func_74838_a((String)"mm.transform.button.rotate_x-")).setOnClick((t, u) -> Transform.sendRotate(ForgeDirection.EAST, false)).setSynced(false, false).setSize(62, 18), ItemMatterManipulator.padding(6, 6), new VanillaButtonWidget().setDisplayString(StatCollector.func_74838_a((String)"mm.transform.button.rotate_x+")).setOnClick((t, u) -> Transform.sendRotate(ForgeDirection.EAST, true)).setSynced(false, false).setSize(62, 18)}), ItemMatterManipulator.padding(10, 10), (Widget)new Row().widgets(new Widget[]{new VanillaButtonWidget().setDisplayString(StatCollector.func_74838_a((String)"mm.transform.button.rotate_y-")).setOnClick((t, u) -> Transform.sendRotate(ForgeDirection.UP, false)).setSynced(false, false).setSize(62, 18), ItemMatterManipulator.padding(6, 6), new VanillaButtonWidget().setDisplayString(StatCollector.func_74838_a((String)"mm.transform.button.rotate_y+")).setOnClick((t, u) -> Transform.sendRotate(ForgeDirection.UP, true)).setSynced(false, false).setSize(62, 18)}), ItemMatterManipulator.padding(10, 10), (Widget)new Row().widgets(new Widget[]{new VanillaButtonWidget().setDisplayString(StatCollector.func_74838_a((String)"mm.transform.button.rotate_z-")).setOnClick((t, u) -> Transform.sendRotate(ForgeDirection.SOUTH, false)).setSynced(false, false).setSize(62, 18), ItemMatterManipulator.padding(6, 6), new VanillaButtonWidget().setDisplayString(StatCollector.func_74838_a((String)"mm.transform.button.rotate_z+")).setOnClick((t, u) -> Transform.sendRotate(ForgeDirection.SOUTH, true)).setSynced(false, false).setSize(62, 18)}), ItemMatterManipulator.padding(10, 10), (Widget)new Row().widgets(new Widget[]{new VanillaButtonWidget().setDisplayString(StatCollector.func_74838_a((String)"mm.transform.button.flip_x")).setOnClick((t, u) -> Messages.ToggleTransformFlip.sendToServer(1)).setSynced(false, false).setSize(40, 18), ItemMatterManipulator.padding(5, 5), new VanillaButtonWidget().setDisplayString(StatCollector.func_74838_a((String)"mm.transform.button.flip_y")).setOnClick((t, u) -> Messages.ToggleTransformFlip.sendToServer(2)).setSynced(false, false).setSize(40, 18), ItemMatterManipulator.padding(5, 5), new VanillaButtonWidget().setDisplayString(StatCollector.func_74838_a((String)"mm.transform.button.flip_z")).setOnClick((t, u) -> Messages.ToggleTransformFlip.sendToServer(4)).setSynced(false, false).setSize(40, 18)}), ItemMatterManipulator.padding(10, 10), (Widget)new Row().widgets(new Widget[]{new MultiChildWidget().addChild(rotationInfo.setSynced(false).setTextAlignment(Alignment.CenterLeft).setDefaultColor(Color.WHITE.dark(1)).setSize(80, 36).setPos(3, 0)).addChild(new DirectionDrawable().asWidget().setSize(30, 30).setPos(3, 36)).addChild(new TextWidget(MMUtils.RED + "X+ " + MMUtils.GREEN + "Y+ " + MMUtils.BLUE + "Z+").setSize(50, 20).setPos(34, 39)).setBackground(BACKGROUND).setSize(88, 66), ItemMatterManipulator.padding(2, 2), ((Column)new Column().setAlignment(MainAxisAlignment.CENTER, CrossAxisAlignment.END).widget(new VanillaButtonWidget().setDisplayString(StatCollector.func_74838_a((String)"mm.transform.button.reset")).setOnClick((t, u) -> Messages.ResetTransform.sendToServer()).setSynced(false, false).setSize(40, 18))).setSize(40, 66)})};
            Widget[] right = new Widget[]{ItemMatterManipulator.makeHeader(StatCollector.func_74838_a((String)"mm.transform.header.copy")), ItemMatterManipulator.padding(2, 2), this.makeCoordinateEditor(buildContext.getPlayer(), -1, 0), ItemMatterManipulator.padding(2, 2), this.makeCoordinateEditor(buildContext.getPlayer(), -1, 1), ItemMatterManipulator.padding(2, 2), this.makeCoordinateEditor(buildContext.getPlayer(), -1, 2), ItemMatterManipulator.padding(2, 2), ItemMatterManipulator.makeHeader(StatCollector.func_74838_a((String)"mm.transform.header.copy_a")), ItemMatterManipulator.padding(2, 2), this.makeCoordinateEditor(buildContext.getPlayer(), 0, 0), ItemMatterManipulator.padding(2, 2), this.makeCoordinateEditor(buildContext.getPlayer(), 0, 1), ItemMatterManipulator.padding(2, 2), this.makeCoordinateEditor(buildContext.getPlayer(), 0, 2), ItemMatterManipulator.padding(10, 2), ItemMatterManipulator.makeHeader(StatCollector.func_74838_a((String)"mm.transform.header.copy_b")), ItemMatterManipulator.padding(2, 2), this.makeCoordinateEditor(buildContext.getPlayer(), 1, 0), ItemMatterManipulator.padding(2, 2), this.makeCoordinateEditor(buildContext.getPlayer(), 1, 1), ItemMatterManipulator.padding(2, 2), this.makeCoordinateEditor(buildContext.getPlayer(), 1, 2), ItemMatterManipulator.padding(10, 2), ItemMatterManipulator.makeHeader(StatCollector.func_74838_a((String)"mm.transform.header.paste")), ItemMatterManipulator.padding(2, 2), this.makeCoordinateEditor(buildContext.getPlayer(), 2, 0), ItemMatterManipulator.padding(2, 2), this.makeCoordinateEditor(buildContext.getPlayer(), 2, 1), ItemMatterManipulator.padding(2, 2), this.makeCoordinateEditor(buildContext.getPlayer(), 2, 2), ItemMatterManipulator.padding(10, 2), ItemMatterManipulator.makeHeader(StatCollector.func_74838_a((String)"mm.transform.header.stacking")), ItemMatterManipulator.padding(2, 2), this.makeCoordinateEditor(buildContext.getPlayer(), 3, 0), ItemMatterManipulator.padding(2, 2), this.makeCoordinateEditor(buildContext.getPlayer(), 3, 1), ItemMatterManipulator.padding(2, 2), this.makeCoordinateEditor(buildContext.getPlayer(), 3, 2), ItemMatterManipulator.padding(10, 2)};
            builder.widget(((Row)new Row().widgets(new Widget[]{ItemMatterManipulator.padding(10, 10), (Widget)new Column().setAlignment(MainAxisAlignment.CENTER, CrossAxisAlignment.START).widgets(left)})).fillParent());
            Column cr = new Column();
            builder.widget(((Column)cr.setAlignment(MainAxisAlignment.CENTER, CrossAxisAlignment.END).widgets(right)).setPosProvider((screenSize, window, parent) -> new Pos2d(screenSize.width - cr.getSize().width - 10, 0)));
        }
        return builder.build();
    }

    private static Widget makeHeader(String text) {
        return new MultiChildWidget().addChild(new MultiChildWidget().addChild(new TextWidget(text).setTextAlignment(Alignment.BottomCenter).setDefaultColor(Color.WHITE.dark(1)).setSize(60, 13)).setBackground(BACKGROUND).setSize(60, 18).setPos(35, 0)).setSize(130, 18);
    }

    private static Vector3i getDefaultLocation(EntityPlayer player) {
        return MMUtils.getLookingAtLocation(player);
    }

    @SideOnly(value=Side.CLIENT)
    private Row makeCoordinateEditor(final EntityPlayer player, final int coord, final int component) {
        String string;
        IntSupplier getter = () -> {
            int n;
            Vector3i vector3i;
            MMState currState = ItemMatterManipulator.getState(player.func_70694_bm());
            switch (coord) {
                case -1: {
                    vector3i = new Vector3i(0);
                    break;
                }
                case 0: {
                    if (currState.config.coordA == null) {
                        vector3i = null;
                        break;
                    }
                    vector3i = currState.config.coordA.toVec();
                    break;
                }
                case 1: {
                    if (currState.config.coordB == null) {
                        vector3i = null;
                        break;
                    }
                    vector3i = currState.config.coordB.toVec();
                    break;
                }
                case 2: {
                    if (currState.config.coordC == null) {
                        vector3i = null;
                        break;
                    }
                    vector3i = currState.config.coordC.toVec();
                    break;
                }
                case 3: {
                    vector3i = currState.config.arraySpan;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("coord");
                }
            }
            Vector3i l = vector3i;
            if (l == null) {
                l = coord == 3 ? new Vector3i(0) : ItemMatterManipulator.getDefaultLocation(player);
            }
            switch (component) {
                case 0: {
                    n = l.x;
                    break;
                }
                case 1: {
                    n = l.y;
                    break;
                }
                case 2: {
                    n = l.z;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("component");
                }
            }
            return n;
        };
        IntSupplier getterVisual = () -> {
            int k = getter.getAsInt();
            if (coord == 3 && k >= 0) {
                ++k;
            }
            return k;
        };
        IntConsumer setter = i -> {
            Vector3i vector3i;
            MMState currState = ItemMatterManipulator.getState(player.func_70694_bm());
            switch (coord) {
                case -1: {
                    vector3i = new Vector3i(0);
                    break;
                }
                case 0: {
                    if (currState.config.coordA == null) {
                        vector3i = null;
                        break;
                    }
                    vector3i = currState.config.coordA.toVec();
                    break;
                }
                case 1: {
                    if (currState.config.coordB == null) {
                        vector3i = null;
                        break;
                    }
                    vector3i = currState.config.coordB.toVec();
                    break;
                }
                case 2: {
                    if (currState.config.coordC == null) {
                        vector3i = null;
                        break;
                    }
                    vector3i = currState.config.coordC.toVec();
                    break;
                }
                case 3: {
                    vector3i = currState.config.arraySpan;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("coord");
                }
            }
            Vector3i l = vector3i;
            if (l == null) {
                l = coord == 3 ? new Vector3i(0) : ItemMatterManipulator.getDefaultLocation(player);
            }
            switch (component) {
                case 0: {
                    l.x = i;
                    break;
                }
                case 1: {
                    l.y = i;
                    break;
                }
                case 2: {
                    l.z = i;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("component");
                }
            }
            switch (coord) {
                case -1: {
                    if (currState.config.coordA != null) {
                        currState.config.coordA = new Location(player.field_70170_p, currState.config.coordA.toVec().add((Vector3ic)l));
                    }
                    if (currState.config.coordB == null) break;
                    currState.config.coordB = new Location(player.field_70170_p, currState.config.coordB.toVec().add((Vector3ic)l));
                    break;
                }
                case 0: {
                    currState.config.coordA = new Location(player.field_70170_p, l);
                    break;
                }
                case 1: {
                    currState.config.coordB = new Location(player.field_70170_p, l);
                    break;
                }
                case 2: {
                    currState.config.coordC = new Location(player.field_70170_p, l);
                    break;
                }
                case 3: {
                    currState.config.arraySpan = l;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("coord");
                }
            }
            ItemMatterManipulator.setState(player.func_70694_bm(), currState);
            switch (coord) {
                case -1: {
                    if (currState.config.coordA != null) {
                        Messages.SetA.sendToServer(currState.config.coordA.toVec().add((Vector3ic)l));
                    }
                    if (currState.config.coordB == null) break;
                    Messages.SetB.sendToServer(currState.config.coordB.toVec().add((Vector3ic)l));
                    break;
                }
                case 0: {
                    Messages.SetA.sendToServer(l);
                    break;
                }
                case 1: {
                    Messages.SetB.sendToServer(l);
                    break;
                }
                case 2: {
                    Messages.SetC.sendToServer(l);
                    break;
                }
                case 3: {
                    Messages.SetArray.sendToServer(l);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("coord");
                }
            }
        };
        switch (component) {
            case 0: {
                string = "X";
                break;
            }
            case 1: {
                string = "Y";
                break;
            }
            case 2: {
                string = "Z";
                break;
            }
            default: {
                throw new IllegalArgumentException("component");
            }
        }
        String compName = string;
        class SizeStorage {
            public int x;
            public int y;
            public int z;
            public boolean present = false;

            SizeStorage() {
            }

            public Vector3i get() {
                if (!this.present && GuiScreen.func_146271_m()) {
                    MMState currState = ItemMatterManipulator.getState(player.func_70694_bm());
                    Vector3i size = coord == 2 ? currState.config.getPasteVisualDeltas(null, false).size() : currState.config.getCopyVisualDeltas(null).size();
                    this.x = size.x;
                    this.y = size.y;
                    this.z = size.z;
                    this.present = true;
                }
                if (!GuiScreen.func_146271_m()) {
                    this.present = false;
                }
                return this.present ? new Vector3i(this.x, this.y, this.z) : new Vector3i(1);
            }

            public int getOffset() {
                int offset = 1;
                if (GuiScreen.func_146272_n()) {
                    offset = 10;
                } else if (coord != 3 && GuiScreen.func_146271_m()) {
                    int n;
                    Vector3i size = this.get();
                    switch (component) {
                        case 0: {
                            n = size.x;
                            break;
                        }
                        case 1: {
                            n = size.y;
                            break;
                        }
                        case 2: {
                            n = size.z;
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("component");
                        }
                    }
                    offset = n;
                } else {
                    this.present = false;
                }
                return offset;
            }
        }
        SizeStorage storage = new SizeStorage();
        return (Row)new Row().widgets(new Widget[]{new VanillaButtonWidget().setDisplayString(compName + " - 1").setOnClick((t, u) -> {
            int i = getter.getAsInt();
            setter.accept(i -= storage.getOffset());
        }).setSynced(false, false).setSize(40, 18).setTicker(w -> ((VanillaButtonWidget)w).setDisplayString(compName + " - " + storage.getOffset())), ItemMatterManipulator.padding(5, 5), new MultiChildWidget().addChild(coord != -1 ? new NumericWidget().setSynced(false, false).setIntegerOnly(true).setGetter(() -> getterVisual.getAsInt()).setSetter(i -> setter.accept((int)i)).setBounds(-2.147483648E9, 2.147483647E9).setScrollBar().setTextColor(Color.WHITE.dark(1)).setBackground(new IDrawable[]{DISPLAY.withOffset(-2.0f, -2.0f, 4.0f, 4.0f)}).setSize(36, 14).setPos(2, 2).setTicker(w -> {
            if (!w.isFocused()) {
                ((NumericWidget)w).setValue((double)getterVisual.getAsInt());
            }
        }) : new TextWidget("N/A").setDefaultColor(Color.WHITE.dark(1)).setBackground(BACKGROUND).setSize(40, 18)).setSize(40, 18), ItemMatterManipulator.padding(5, 5), new VanillaButtonWidget().setDisplayString(compName + " + 1").setOnClick((t, u) -> {
            int i = getter.getAsInt();
            setter.accept(i += storage.getOffset());
        }).setSynced(false, false).setSize(40, 18).setTicker(w -> ((VanillaButtonWidget)w).setDisplayString(compName + " + " + storage.getOffset()))});
    }

    static {
        PENDING_BUILDS = new MapMaker().weakKeys().makeMap();
        BACKGROUND = new IDrawable[]{new Rectangle().setColor(-7829368), new OffsetDrawable((IDrawable)new Rectangle().setColor(-15658735), 2.0f, 2.0f, -4.0f, -4.0f)};
        DISPLAY = AdaptableUITexture.of((String)"modularui:gui/background/display", (int)143, (int)75, (int)2);
    }

    public static enum ManipulatorTier {
        Tier0(32, 16, 20, 3, 10000000L, ALLOW_GEOMETRY, (List<MMUpgrades>)ImmutableList.of((Object)((Object)MMUpgrades.Mining), (Object)((Object)MMUpgrades.Speed), (Object)((Object)MMUpgrades.PowerEff)), MMItemList.MK0),
        Tier1(64, 32, 10, 5, 100000000L, ALLOW_GEOMETRY | CONNECTS_TO_AE | ALLOW_REMOVING | ALLOW_EXCHANGING | ALLOW_CONFIGURING | ALLOW_CABLES, (List<MMUpgrades>)ImmutableList.of((Object)((Object)MMUpgrades.Speed), (Object)((Object)MMUpgrades.PowerEff)), MMItemList.MK1),
        Tier2(128, 64, 5, 6, 1000000000L, ALLOW_GEOMETRY | CONNECTS_TO_AE | ALLOW_REMOVING | ALLOW_EXCHANGING | ALLOW_CONFIGURING | ALLOW_CABLES | ALLOW_COPYING | ALLOW_MOVING, (List<MMUpgrades>)ImmutableList.of((Object)((Object)MMUpgrades.Speed), (Object)((Object)MMUpgrades.PowerEff)), MMItemList.MK2),
        Tier3(-1, GlobalMMConfig.BuildingConfig.mk3BlocksPerPlace, 5, 7, 10000000000L, ALLOW_GEOMETRY | CONNECTS_TO_AE | ALLOW_REMOVING | ALLOW_EXCHANGING | ALLOW_CONFIGURING | ALLOW_CABLES | ALLOW_COPYING | ALLOW_MOVING | CONNECTS_TO_UPLINK, (List<MMUpgrades>)ImmutableList.of((Object)((Object)MMUpgrades.PowerEff), (Object)((Object)MMUpgrades.PowerP2P)), MMItemList.MK3);

        public final int tier = this.ordinal();
        public final int maxRange;
        public final int placeSpeed;
        public final int placeTicks;
        public final int voltageTier;
        public final long maxCharge;
        public final int capabilities;
        public final Set<MMUpgrades> allowedUpgrades;
        public final MMItemList container;

        private ManipulatorTier(int maxRange, int placeSpeed, int placeTicks, int voltageTier, long maxCharge, int capabilities, List<MMUpgrades> allowedUpgrades, MMItemList container) {
            this.maxRange = maxRange;
            this.placeSpeed = placeSpeed;
            this.placeTicks = placeTicks;
            this.voltageTier = voltageTier;
            this.maxCharge = maxCharge;
            this.capabilities = capabilities;
            this.allowedUpgrades = Collections.unmodifiableSet(new ObjectOpenHashSet(allowedUpgrades));
            this.container = container;
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static class TransparentModularGui
    extends ModularGui {
        public TransparentModularGui(ModularUIContainer container) {
            super(container);
        }

        public void func_146276_q_() {
        }
    }
}

