/*
 * Decompiled with CFR 0.152.
 */
package com.recursive_pineapple.matter_manipulator.common.compat;

import appeng.util.ReadableNumberConverter;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.recursive_pineapple.matter_manipulator.asm.Optional;
import com.recursive_pineapple.matter_manipulator.common.building.InteropConstants;
import com.recursive_pineapple.matter_manipulator.common.compat.BlockProperty;
import com.recursive_pineapple.matter_manipulator.common.compat.BooleanProperty;
import com.recursive_pineapple.matter_manipulator.common.compat.DirectionBlockProperty;
import com.recursive_pineapple.matter_manipulator.common.compat.FloatProperty;
import com.recursive_pineapple.matter_manipulator.common.compat.IntegerProperty;
import com.recursive_pineapple.matter_manipulator.common.compat.IntrinsicProperty;
import com.recursive_pineapple.matter_manipulator.common.compat.MetaBlockProperty;
import com.recursive_pineapple.matter_manipulator.common.compat.Orientation;
import com.recursive_pineapple.matter_manipulator.common.compat.OrientationBlockProperty;
import com.recursive_pineapple.matter_manipulator.common.utils.ImmutableBlockMeta;
import com.recursive_pineapple.matter_manipulator.common.utils.MMUtils;
import com.recursive_pineapple.matter_manipulator.common.utils.Mods;
import de.keridos.floodlights.tileentity.TileEntityMetaFloodlight;
import de.keridos.floodlights.tileentity.TileEntitySmallFloodlight;
import gcewing.architecture.common.tile.TileArchitecture;
import gregtech.api.GregTechAPI;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.common.blocks.ItemMachines;
import gregtech.common.tileentities.machines.MTEHatchOutputBusME;
import gregtech.common.tileentities.machines.MTEHatchOutputME;
import ic2.api.tile.IWrenchable;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.bdew.ae2stuff.machines.wireless.TileWireless;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAnvil;
import net.minecraft.block.BlockBasePressurePlate;
import net.minecraft.block.BlockButton;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockFurnace;
import net.minecraft.block.BlockHopper;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.BlockPistonExtension;
import net.minecraft.block.BlockPumpkin;
import net.minecraft.block.BlockRedstoneLight;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockPropertyRegistry {
    public static final Map<String, BlockProperty<?>> EMPTY_O2O_MAP = Collections.emptyMap();
    public static final Object2ObjectOpenHashMap<Block, Map<String, BlockProperty<?>>> SPECIFIC_BLOCK_PROPERTIES = new Object2ObjectOpenHashMap();
    public static final Object2ObjectOpenHashMap<Class<?>, Map<String, BlockProperty<?>>> BLOCK_IFACE_PROPERTIES = new Object2ObjectOpenHashMap();
    public static final Object2ObjectOpenHashMap<Class<?>, Map<String, BlockProperty<?>>> TILE_IFACE_PROPERTIES = new Object2ObjectOpenHashMap();
    public static final Object2ObjectOpenHashMap<Class<? extends Block>, Map<String, BlockProperty<?>>> CACHED_BLOCK_PROPS = new Object2ObjectOpenHashMap();
    public static final Object2ObjectOpenHashMap<Class<? extends TileEntity>, Map<String, BlockProperty<?>>> CACHED_TILE_PROPS = new Object2ObjectOpenHashMap();
    public static final Map<Block, List<IntrinsicProperty>> INTRINSIC_PROPERTIES = new Reference2ObjectArrayMap();

    private BlockPropertyRegistry() {
    }

    public static void registerProperty(Block block, BlockProperty<?> property) {
        ((Map)SPECIFIC_BLOCK_PROPERTIES.computeIfAbsent((Object)block, x -> new Object2ObjectArrayMap())).put(property.getName(), property);
    }

    public static void registerProperty(Collection<Block> blocks, BlockProperty<?> property) {
        for (Block block : blocks) {
            BlockPropertyRegistry.registerProperty(block, property);
        }
    }

    public static void registerBlockInterfaceProperty(Class<?> iface, BlockProperty<?> property) {
        ((Map)BLOCK_IFACE_PROPERTIES.computeIfAbsent(iface, x -> new Object2ObjectArrayMap())).put(property.getName(), property);
    }

    public static void registerTileEntityInterfaceProperty(Class<?> iface, BlockProperty<?> property) {
        ((Map)TILE_IFACE_PROPERTIES.computeIfAbsent(iface, x -> new Object2ObjectArrayMap())).put(property.getName(), property);
    }

    private static Map<String, BlockProperty<?>> getUnfilteredBlockProperties(Class<? extends Block> clazz) {
        Map props = (Map)CACHED_BLOCK_PROPS.get(clazz);
        if (props != null) {
            return props;
        }
        Object cache = new Object2ObjectArrayMap();
        for (Object2ObjectMap.Entry e : BLOCK_IFACE_PROPERTIES.object2ObjectEntrySet()) {
            if (!((Class)e.getKey()).isAssignableFrom(clazz)) continue;
            cache.putAll((Map)e.getValue());
        }
        cache = cache.isEmpty() ? EMPTY_O2O_MAP : Collections.unmodifiableMap(cache);
        CACHED_BLOCK_PROPS.put(clazz, cache);
        return cache;
    }

    private static Map<String, BlockProperty<?>> getUnfilteredTileProperties(Class<? extends TileEntity> clazz) {
        Map props = (Map)CACHED_TILE_PROPS.get(clazz);
        if (props != null) {
            return props;
        }
        Object cache = new Object2ObjectArrayMap();
        for (Object2ObjectMap.Entry e : TILE_IFACE_PROPERTIES.object2ObjectEntrySet()) {
            if (!((Class)e.getKey()).isAssignableFrom(clazz)) continue;
            cache.putAll((Map)e.getValue());
        }
        cache = cache.isEmpty() ? EMPTY_O2O_MAP : Collections.unmodifiableMap(cache);
        CACHED_TILE_PROPS.put(clazz, cache);
        return cache;
    }

    public static void getProperties(World world, int x, int y, int z, Map<String, BlockProperty<?>> properties) {
        TileEntity tile;
        properties.clear();
        Block block = world.func_147439_a(x, y, z);
        Map props = (Map)SPECIFIC_BLOCK_PROPERTIES.get((Object)block);
        if (props != null) {
            properties.putAll(props);
        }
        BlockPropertyRegistry.addPropertiesFiltered(properties, BlockPropertyRegistry.getUnfilteredBlockProperties(block.getClass()), block);
        if (block.hasTileEntity(world.func_72805_g(x, y, z)) && (tile = world.func_147438_o(x, y, z)) != null) {
            BlockPropertyRegistry.addPropertiesFiltered(properties, BlockPropertyRegistry.getUnfilteredTileProperties(tile.getClass()), tile);
        }
    }

    private static void addPropertiesFiltered(Map<String, BlockProperty<?>> dest, Map<String, BlockProperty<?>> src, Object filter) {
        if (src == null) {
            return;
        }
        for (Map.Entry<String, BlockProperty<?>> e : src.entrySet()) {
            if (filter != null && !e.getValue().appliesTo(filter)) continue;
            dest.put(e.getKey(), e.getValue());
        }
    }

    public static void registerIntrinsicProperty(Block block, IntrinsicProperty property) {
        List m = INTRINSIC_PROPERTIES.computeIfAbsent(block, x -> new ObjectArrayList());
        m.add(property);
    }

    public static void getIntrinsicProperties(IBlockAccess world, int x, int y, int z, Collection<IntrinsicProperty> props) {
        props.clear();
        List<IntrinsicProperty> unfiltered = INTRINSIC_PROPERTIES.get(world.func_147439_a(x, y, z));
        if (unfiltered != null) {
            for (IntrinsicProperty prop : unfiltered) {
                if (!prop.hasValue(world, x, y, z)) continue;
                props.add(prop);
            }
        }
    }

    public static void getIntrinsicProperties(IBlockAccess world, int x, int y, int z, Map<String, IntrinsicProperty> props) {
        props.clear();
        List<IntrinsicProperty> unfiltered = INTRINSIC_PROPERTIES.get(world.func_147439_a(x, y, z));
        if (unfiltered != null) {
            for (IntrinsicProperty prop : unfiltered) {
                if (!prop.hasValue(world, x, y, z)) continue;
                props.put(prop.getName(), prop);
            }
        }
    }

    public static void getIntrinsicProperties(ItemStack stack, Collection<IntrinsicProperty> props) {
        props.clear();
        if (stack == null) {
            return;
        }
        Block block = MMUtils.getBlockFromItem(stack.func_77973_b(), stack.field_77991_e);
        if (block == null) {
            return;
        }
        List<IntrinsicProperty> unfiltered = INTRINSIC_PROPERTIES.get(block);
        if (unfiltered != null) {
            for (IntrinsicProperty prop : unfiltered) {
                if (!prop.hasValue(stack)) continue;
                props.add(prop);
            }
        }
    }

    public static void getIntrinsicProperties(ItemStack stack, Map<String, IntrinsicProperty> props) {
        props.clear();
        if (stack == null) {
            return;
        }
        Block block = MMUtils.getBlockFromItem(stack.func_77973_b(), stack.field_77991_e);
        if (block == null) {
            return;
        }
        List<IntrinsicProperty> unfiltered = INTRINSIC_PROPERTIES.get(block);
        if (unfiltered != null) {
            for (IntrinsicProperty prop : unfiltered) {
                if (!prop.hasValue(stack)) continue;
                props.put(prop.getName(), prop);
            }
        }
    }

    public static void init() {
        BlockPropertyRegistry.initVanilla();
        if (Mods.StorageDrawers.isModLoaded()) {
            BlockPropertyRegistry.initStorageDrawers();
        }
        if (Mods.IndustrialCraft2.isModLoaded()) {
            BlockPropertyRegistry.initIC2();
        }
        if (Mods.ArchitectureCraft.isModLoaded()) {
            BlockPropertyRegistry.initArch();
        }
        if (Mods.FloodLights.isModLoaded()) {
            BlockPropertyRegistry.initFloodLights();
        }
        if (Mods.GregTech.isModLoaded()) {
            BlockPropertyRegistry.initGT5u();
        }
        if (Mods.AE2Stuff.isModLoaded()) {
            BlockPropertyRegistry.initAE2Stuff();
        }
    }

    private static void initVanilla() {
        BlockPropertyRegistry.registerBlockInterfaceProperty(BlockLog.class, DirectionBlockProperty.facing(12, dir -> {
            int n;
            switch (dir) {
                case UP: 
                case DOWN: {
                    n = 0;
                    break;
                }
                case NORTH: 
                case SOUTH: {
                    n = 8;
                    break;
                }
                case WEST: 
                case EAST: {
                    n = 4;
                    break;
                }
                default: {
                    n = 0;
                }
            }
            return n;
        }, meta -> {
            ForgeDirection forgeDirection;
            switch (meta) {
                case 4: {
                    forgeDirection = ForgeDirection.EAST;
                    break;
                }
                case 8: {
                    forgeDirection = ForgeDirection.NORTH;
                    break;
                }
                default: {
                    forgeDirection = ForgeDirection.UP;
                }
            }
            return forgeDirection;
        }));
        BlockPropertyRegistry.registerProperty(Blocks.field_150448_aq, new MetaBlockProperty<RailMode>(){

            @Override
            public String getName() {
                return "mode";
            }

            @Override
            public RailMode getValue(int meta) {
                return BlockPropertyRegistry.getRailMode(meta, true);
            }

            @Override
            public int getMeta(RailMode value, int existing) {
                return BlockPropertyRegistry.getRailMeta(value, BlockPropertyRegistry.getRailDirection(existing, true), true, false);
            }

            @Override
            public RailMode parse(String text) throws Exception {
                return RailMode.parse(text);
            }
        });
        BlockPropertyRegistry.registerProperty(Blocks.field_150448_aq, DirectionBlockProperty.facing((dir, existing) -> BlockPropertyRegistry.getRailMeta(BlockPropertyRegistry.getRailMode(existing, true), dir, true, false), meta -> BlockPropertyRegistry.getRailDirection(meta, true)));
        BlockPropertyRegistry.registerProperty(Arrays.asList(Blocks.field_150318_D, Blocks.field_150319_E, Blocks.field_150408_cc), new MetaBlockProperty<RailMode>(){

            @Override
            public String getName() {
                return "mode";
            }

            @Override
            public RailMode getValue(int meta) {
                return BlockPropertyRegistry.getRailMode(meta, false);
            }

            @Override
            public int getMeta(RailMode value, int existing) {
                return BlockPropertyRegistry.getRailMeta(value, BlockPropertyRegistry.getRailDirection(existing, false), false, BlockPropertyRegistry.isRailPowered(existing));
            }

            @Override
            public RailMode parse(String text) throws Exception {
                return RailMode.parse(text);
            }
        });
        BlockPropertyRegistry.registerProperty(Arrays.asList(Blocks.field_150318_D, Blocks.field_150319_E, Blocks.field_150408_cc), DirectionBlockProperty.facing((dir, existing) -> BlockPropertyRegistry.getRailMeta(BlockPropertyRegistry.getRailMode(existing, false), dir, false, BlockPropertyRegistry.isRailPowered(existing)), meta -> BlockPropertyRegistry.getRailDirection(meta, false)));
        BooleanProperty.FlagBooleanProperty powered = BooleanProperty.flag("powered", 8);
        BlockPropertyRegistry.registerProperty(Arrays.asList(Blocks.field_150318_D, Blocks.field_150319_E, Blocks.field_150408_cc), powered);
        BlockPropertyRegistry.registerBlockInterfaceProperty(BlockButton.class, powered);
        BlockPropertyRegistry.registerBlockInterfaceProperty(BlockButton.class, DirectionBlockProperty.facing(7, 3, 4, 1, 2, 0, 5));
        BlockPropertyRegistry.registerBlockInterfaceProperty(BlockTorch.class, DirectionBlockProperty.facing(-1, 3, 4, 1, 2, 0, 5));
        BlockPropertyRegistry.registerProperty(Blocks.field_150429_aA, BooleanProperty.blocks("powered", Blocks.field_150437_az, Blocks.field_150429_aA));
        BlockPropertyRegistry.registerProperty(Blocks.field_150437_az, BooleanProperty.blocks("powered", Blocks.field_150437_az, Blocks.field_150429_aA));
        BlockPropertyRegistry.registerProperty(Blocks.field_150442_at, powered);
        BlockPropertyRegistry.registerProperty(Blocks.field_150442_at, new DirectionBlockProperty(){

            @Override
            public String getName() {
                return "forward";
            }

            @Override
            public ForgeDirection getValue(World world, int x, int y, int z) {
                ForgeDirection forgeDirection;
                int meta = world.func_72805_g(x, y, z) & 7;
                switch (meta) {
                    case 5: {
                        forgeDirection = ForgeDirection.NORTH;
                        break;
                    }
                    case 6: {
                        forgeDirection = ForgeDirection.EAST;
                        break;
                    }
                    case 0: {
                        forgeDirection = ForgeDirection.EAST;
                        break;
                    }
                    case 7: {
                        forgeDirection = ForgeDirection.NORTH;
                        break;
                    }
                    default: {
                        forgeDirection = ForgeDirection.UNKNOWN;
                    }
                }
                return forgeDirection;
            }

            @Override
            public void setValue(World world, int x, int y, int z, ForgeDirection value) {
                int meta = world.func_72805_g(x, y, z);
                int power = meta & 8;
                if ((meta &= 7) == 0 || meta == 7) {
                    int n = meta = value == ForgeDirection.EAST || value == ForgeDirection.WEST ? 0 : 7;
                }
                if (meta == 5 || meta == 6) {
                    meta = value == ForgeDirection.EAST || value == ForgeDirection.WEST ? 6 : 5;
                }
                world.func_72921_c(x, y, z, meta + power, 2);
            }
        });
        BlockPropertyRegistry.registerProperty(Blocks.field_150442_at, DirectionBlockProperty.facing((dir, existing) -> {
            int n;
            switch (dir) {
                case NORTH: {
                    n = 3;
                    break;
                }
                case SOUTH: {
                    n = 4;
                    break;
                }
                case WEST: {
                    n = 1;
                    break;
                }
                case EAST: {
                    n = 2;
                    break;
                }
                case UP: {
                    if (existing % 8 == 7) {
                        n = 7;
                        break;
                    }
                    n = 0;
                    break;
                }
                case DOWN: {
                    if (existing % 8 == 6) {
                        n = 6;
                        break;
                    }
                    n = 5;
                    break;
                }
                default: {
                    n = 0;
                }
            }
            return (existing & 8) + n;
        }, meta -> {
            ForgeDirection forgeDirection;
            switch (meta & 7) {
                case 3: {
                    forgeDirection = ForgeDirection.NORTH;
                    break;
                }
                case 4: {
                    forgeDirection = ForgeDirection.SOUTH;
                    break;
                }
                case 1: {
                    forgeDirection = ForgeDirection.WEST;
                    break;
                }
                case 2: {
                    forgeDirection = ForgeDirection.EAST;
                    break;
                }
                case 0: 
                case 7: {
                    forgeDirection = ForgeDirection.UP;
                    break;
                }
                case 5: 
                case 6: {
                    forgeDirection = ForgeDirection.DOWN;
                    break;
                }
                default: {
                    forgeDirection = ForgeDirection.UNKNOWN;
                }
            }
            return forgeDirection;
        }));
        BlockPropertyRegistry.registerBlockInterfaceProperty(BlockPistonBase.class, powered);
        BlockPropertyRegistry.registerBlockInterfaceProperty(BlockPistonBase.class, DirectionBlockProperty.facing(7, 3, 4, 1, 2, 0, 5));
        BlockPropertyRegistry.registerBlockInterfaceProperty(BlockPistonExtension.class, DirectionBlockProperty.facing(7, 3, 4, 1, 2, 0, 5));
        BlockPropertyRegistry.registerBlockInterfaceProperty(BlockSlab.class, new BooleanProperty.FlagBooleanProperty("top", 8){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public boolean appliesTo(Object obj) {
                if (!(obj instanceof BlockSlab)) return false;
                BlockSlab slab = (BlockSlab)obj;
                if (slab.field_150004_a) return false;
                return true;
            }
        });
        BlockPropertyRegistry.registerBlockInterfaceProperty(BlockStairs.class, DirectionBlockProperty.facing(3, dir -> {
            int n;
            switch (dir) {
                case EAST: {
                    n = 0;
                    break;
                }
                case WEST: {
                    n = 1;
                    break;
                }
                case SOUTH: {
                    n = 2;
                    break;
                }
                case NORTH: {
                    n = 3;
                    break;
                }
                default: {
                    n = 0;
                }
            }
            return n;
        }, meta -> {
            ForgeDirection forgeDirection;
            switch (meta) {
                case 0: {
                    forgeDirection = ForgeDirection.EAST;
                    break;
                }
                case 1: {
                    forgeDirection = ForgeDirection.WEST;
                    break;
                }
                case 2: {
                    forgeDirection = ForgeDirection.SOUTH;
                    break;
                }
                case 3: {
                    forgeDirection = ForgeDirection.NORTH;
                    break;
                }
                default: {
                    forgeDirection = ForgeDirection.NORTH;
                }
            }
            return forgeDirection;
        }));
        BlockPropertyRegistry.registerBlockInterfaceProperty(BlockStairs.class, DirectionBlockProperty.facing(4, dir -> {
            int n;
            switch (dir) {
                case UP: {
                    n = 0;
                    break;
                }
                case DOWN: {
                    n = 4;
                    break;
                }
                default: {
                    n = 0;
                }
            }
            return n;
        }, meta -> {
            ForgeDirection forgeDirection;
            switch (meta) {
                case 0: {
                    forgeDirection = ForgeDirection.UP;
                    break;
                }
                case 4: {
                    forgeDirection = ForgeDirection.DOWN;
                    break;
                }
                default: {
                    forgeDirection = ForgeDirection.UP;
                }
            }
            return forgeDirection;
        }).setName("up"));
        BlockPropertyRegistry.registerBlockInterfaceProperty(BlockChest.class, DirectionBlockProperty.facing(7, 2, 3, 4, 5, -1, -1));
        BlockPropertyRegistry.registerBlockInterfaceProperty(BlockAnvil.class, DirectionBlockProperty.facing(3, dir -> {
            int n;
            switch (dir) {
                case WEST: {
                    n = 0;
                    break;
                }
                case NORTH: {
                    n = 1;
                    break;
                }
                case EAST: {
                    n = 2;
                    break;
                }
                case SOUTH: {
                    n = 3;
                    break;
                }
                default: {
                    n = 0;
                }
            }
            return n;
        }, meta -> {
            ForgeDirection forgeDirection;
            switch (meta) {
                case 0: {
                    forgeDirection = ForgeDirection.WEST;
                    break;
                }
                case 1: {
                    forgeDirection = ForgeDirection.NORTH;
                    break;
                }
                case 2: {
                    forgeDirection = ForgeDirection.EAST;
                    break;
                }
                case 3: {
                    forgeDirection = ForgeDirection.SOUTH;
                    break;
                }
                default: {
                    forgeDirection = ForgeDirection.NORTH;
                }
            }
            return forgeDirection;
        }));
        BlockPropertyRegistry.registerBlockInterfaceProperty(BlockAnvil.class, IntegerProperty.meta("damage", 12, 2).map(Arrays.asList("undamaged", "slightly_damaged", "very_damaged", "broken")));
        BlockPropertyRegistry.registerProperty((Block)Blocks.field_150488_af, IntegerProperty.meta("power", 15, 0));
        BlockPropertyRegistry.registerBlockInterfaceProperty(BlockFurnace.class, DirectionBlockProperty.facing());
        BlockPropertyRegistry.registerBlockInterfaceProperty(BlockFurnace.class, BooleanProperty.blocks("lit", Blocks.field_150460_al, Blocks.field_150470_am));
        BlockPropertyRegistry.registerProperty(Blocks.field_150444_as, DirectionBlockProperty.facing());
        BlockPropertyRegistry.registerProperty(Blocks.field_150472_an, new FloatProperty(){

            @Override
            public String getName() {
                return "rotation";
            }

            @Override
            public float getFloat(World world, int x, int y, int z) {
                return (float)world.func_72805_g(x, y, z) * 360.0f / 16.0f;
            }

            @Override
            public void setFloat(World world, int x, int y, int z, float value) {
                int meta = (Math.round(value * 16.0f / 360.0f) % 16 + 16) % 16;
                world.func_72921_c(x, y, z, meta, 2);
            }
        });
        BlockPropertyRegistry.registerTileEntityInterfaceProperty(TileEntitySign.class, new BlockProperty<String>(){

            @Override
            public String getName() {
                return "text";
            }

            @Override
            public String getValue(World world, int x, int y, int z) {
                TileEntity tileEntity = world.func_147438_o(x, y, z);
                if (!(tileEntity instanceof TileEntitySign)) {
                    return "";
                }
                TileEntitySign sign = (TileEntitySign)tileEntity;
                return String.join((CharSequence)"\n", sign.field_145915_a);
            }

            @Override
            public void setValue(World world, int x, int y, int z, String value) {
                TileEntity tileEntity = world.func_147438_o(x, y, z);
                if (!(tileEntity instanceof TileEntitySign)) {
                    return;
                }
                TileEntitySign sign = (TileEntitySign)tileEntity;
                String[] text = value.split("\n");
                sign.field_145915_a = new String[4];
                for (int i = 0; i < 4; ++i) {
                    String line = MMUtils.getIndexSafe(text, i);
                    if (line == null) {
                        line = "";
                    }
                    if (line.length() > 15) {
                        line = line.substring(0, 15);
                    }
                    sign.field_145915_a[i] = line;
                }
                sign.func_70296_d();
                world.func_147471_g(x, y, z);
            }

            @Override
            public String parse(String text) throws Exception {
                return text;
            }
        });
        BlockPropertyRegistry.registerBlockInterfaceProperty(BlockDoor.class, new DirectionBlockProperty(){

            @Override
            public String getName() {
                return "facing";
            }

            @Override
            public ForgeDirection getValue(World world, int x, int y, int z) {
                ForgeDirection forgeDirection;
                int meta = world.func_72805_g(x, y, z);
                if (meta == 8) {
                    if (!(world.func_147439_a(x, --y, z) instanceof BlockDoor)) {
                        return ForgeDirection.UNKNOWN;
                    }
                    meta = world.func_72805_g(x, y, z);
                }
                switch (meta & 3) {
                    case 0: {
                        forgeDirection = ForgeDirection.WEST;
                        break;
                    }
                    case 1: {
                        forgeDirection = ForgeDirection.NORTH;
                        break;
                    }
                    case 2: {
                        forgeDirection = ForgeDirection.EAST;
                        break;
                    }
                    case 3: {
                        forgeDirection = ForgeDirection.SOUTH;
                        break;
                    }
                    default: {
                        forgeDirection = ForgeDirection.NORTH;
                    }
                }
                return forgeDirection;
            }

            @Override
            public void setValue(World world, int x, int y, int z, ForgeDirection value) {
                int n;
                int meta = world.func_72805_g(x, y, z);
                if (meta == 8) {
                    if (!(world.func_147439_a(x, --y, z) instanceof BlockDoor)) {
                        return;
                    }
                    meta = world.func_72805_g(x, y, z);
                }
                meta &= 0xFFFFFFFC;
                switch (value) {
                    case WEST: {
                        n = 0;
                        break;
                    }
                    case NORTH: {
                        n = 1;
                        break;
                    }
                    case EAST: {
                        n = 2;
                        break;
                    }
                    case SOUTH: {
                        n = 3;
                        break;
                    }
                    default: {
                        n = 1;
                    }
                }
                world.func_72921_c(x, y, z, meta |= n, 2);
            }
        });
        BlockPropertyRegistry.registerBlockInterfaceProperty(BlockDoor.class, new BooleanProperty(){

            @Override
            public String getName() {
                return "open";
            }

            @Override
            public boolean getBoolean(World world, int x, int y, int z) {
                int meta = world.func_72805_g(x, y, z);
                if (meta == 8) {
                    if (!(world.func_147439_a(x, --y, z) instanceof BlockDoor)) {
                        return false;
                    }
                    meta = world.func_72805_g(x, y, z);
                }
                return meta >= 4;
            }

            @Override
            public void setBoolean(World world, int x, int y, int z, boolean value) {
                int meta = world.func_72805_g(x, y, z);
                if (meta == 8) {
                    if (!(world.func_147439_a(x, --y, z) instanceof BlockDoor)) {
                        return;
                    }
                    meta = world.func_72805_g(x, y, z);
                }
                meta &= 0xFFFFFFFB;
                if (value) {
                    meta |= 4;
                }
                world.func_72921_c(x, y, z, meta, 2);
            }
        });
        BlockPropertyRegistry.registerBlockInterfaceProperty(BlockLadder.class, DirectionBlockProperty.facing());
        BlockPropertyRegistry.registerBlockInterfaceProperty(BlockBasePressurePlate.class, BooleanProperty.flag("powered", 1));
        BlockPropertyRegistry.registerBlockInterfaceProperty(BlockPumpkin.class, DirectionBlockProperty.facing(3, 2, 0, 1, 3, -1, -1));
        BlockPropertyRegistry.registerProperty(Arrays.asList(Blocks.field_150413_aR, Blocks.field_150416_aS), BooleanProperty.blocks("powered", (Block)Blocks.field_150413_aR, (Block)Blocks.field_150416_aS));
        BlockPropertyRegistry.registerProperty(Arrays.asList(Blocks.field_150413_aR, Blocks.field_150416_aS), DirectionBlockProperty.facing(3, 0, 2, 3, 1, -1, -1));
        BlockPropertyRegistry.registerProperty(Arrays.asList(Blocks.field_150413_aR, Blocks.field_150416_aS), IntegerProperty.meta("delay", 12, 2));
        BlockPropertyRegistry.registerBlockInterfaceProperty(BlockTrapDoor.class, DirectionBlockProperty.facing(3, 0, 1, 2, 3, -1, -1));
        BlockPropertyRegistry.registerBlockInterfaceProperty(BlockTrapDoor.class, BooleanProperty.flag("open", 4));
        BlockPropertyRegistry.registerBlockInterfaceProperty(BlockTrapDoor.class, DirectionBlockProperty.facing(8, -1, -1, -1, -1, 8, 0).setName("up"));
        BlockPropertyRegistry.registerBlockInterfaceProperty(BlockRedstoneLight.class, BooleanProperty.blocks("powered", Blocks.field_150379_bu, Blocks.field_150374_bv));
        BlockPropertyRegistry.registerProperty((Block)Blocks.field_150479_bC, DirectionBlockProperty.facing(3, 0, 2, 3, 1, -1, -1));
        BlockPropertyRegistry.registerProperty((Block)Blocks.field_150479_bC, powered);
        BlockPropertyRegistry.registerProperty((Block)Blocks.field_150479_bC, BooleanProperty.flag("connected", 4));
        BlockPropertyRegistry.registerTileEntityInterfaceProperty(TileEntitySkull.class, new IntegerProperty(){

            @Override
            public String getName() {
                return "rotation";
            }

            @Override
            public int getInt(World world, int x, int y, int z) {
                TileEntity tileEntity = world.func_147438_o(x, y, z);
                if (!(tileEntity instanceof TileEntitySkull)) {
                    return 0;
                }
                TileEntitySkull skull = (TileEntitySkull)tileEntity;
                return skull.field_145910_i * 360 / 16;
            }

            @Override
            public void setInt(World world, int x, int y, int z, int value) {
                TileEntity tileEntity = world.func_147438_o(x, y, z);
                if (!(tileEntity instanceof TileEntitySkull)) {
                    return;
                }
                TileEntitySkull skull = (TileEntitySkull)tileEntity;
                skull.field_145910_i = value * 16 / 360;
                skull.func_70296_d();
                world.func_147471_g(x, y, z);
            }
        });
        BlockPropertyRegistry.registerBlockInterfaceProperty(BlockDispenser.class, DirectionBlockProperty.facing());
        BlockPropertyRegistry.registerProperty(Arrays.asList(Blocks.field_150441_bU, Blocks.field_150455_bV), BooleanProperty.flag("powered", 8));
        BlockPropertyRegistry.registerProperty(Arrays.asList(Blocks.field_150441_bU, Blocks.field_150455_bV), DirectionBlockProperty.facing(3, 0, 2, 3, 1, -1, -1));
        BlockPropertyRegistry.registerProperty(Arrays.asList(Blocks.field_150441_bU, Blocks.field_150455_bV), IntegerProperty.meta("mode", 4, 2).map(Arrays.asList("comparator", "subtractor")));
        BlockPropertyRegistry.registerBlockInterfaceProperty(BlockHopper.class, DirectionBlockProperty.facing());
        BlockPropertyRegistry.registerBlockInterfaceProperty(BlockFenceGate.class, DirectionBlockProperty.facing(3, 2, 0, 1, 3, -1, -1));
        BlockPropertyRegistry.registerBlockInterfaceProperty(BlockFenceGate.class, BooleanProperty.flag("open", 4));
    }

    private static RailMode getRailMode(int meta, boolean canTurn) {
        return canTurn && meta >= 6 ? RailMode.TURNED : (meta >= 2 ? RailMode.ASCENDING : RailMode.NONE);
    }

    private static ForgeDirection getRailDirection(int meta, boolean canTurn) {
        ForgeDirection forgeDirection;
        if (canTurn) {
            ForgeDirection forgeDirection2;
            switch (meta) {
                case 0: 
                case 4: 
                case 6: {
                    forgeDirection2 = ForgeDirection.NORTH;
                    break;
                }
                case 1: 
                case 3: 
                case 9: {
                    forgeDirection2 = ForgeDirection.WEST;
                    break;
                }
                case 2: 
                case 7: {
                    forgeDirection2 = ForgeDirection.EAST;
                    break;
                }
                case 5: 
                case 8: {
                    forgeDirection2 = ForgeDirection.SOUTH;
                    break;
                }
                default: {
                    forgeDirection2 = ForgeDirection.NORTH;
                }
            }
            return forgeDirection2;
        }
        switch (meta) {
            case 0: 
            case 4: {
                forgeDirection = ForgeDirection.NORTH;
                break;
            }
            case 1: 
            case 3: {
                forgeDirection = ForgeDirection.WEST;
                break;
            }
            case 2: {
                forgeDirection = ForgeDirection.EAST;
                break;
            }
            case 5: {
                forgeDirection = ForgeDirection.SOUTH;
                break;
            }
            default: {
                forgeDirection = ForgeDirection.NORTH;
            }
        }
        return forgeDirection;
    }

    private static boolean isRailPowered(int meta) {
        return meta >= 8;
    }

    private static int getRailMeta(RailMode mode, ForgeDirection dir, boolean canTurn, boolean powered) {
        int n;
        if (canTurn && mode == RailMode.TURNED) {
            int n2;
            switch (dir) {
                case NORTH: {
                    n2 = 6;
                    break;
                }
                case WEST: {
                    n2 = 9;
                    break;
                }
                case EAST: {
                    n2 = 7;
                    break;
                }
                case SOUTH: {
                    n2 = 8;
                    break;
                }
                default: {
                    n2 = 0;
                }
            }
            return n2;
        }
        if (mode == RailMode.ASCENDING) {
            int n3;
            switch (dir) {
                case NORTH: {
                    n3 = 4;
                    break;
                }
                case WEST: {
                    n3 = 3;
                    break;
                }
                case EAST: {
                    n3 = 2;
                    break;
                }
                case SOUTH: {
                    n3 = 5;
                    break;
                }
                default: {
                    n3 = 0;
                }
            }
            return n3;
        }
        switch (dir) {
            case NORTH: 
            case SOUTH: {
                n = 0;
                break;
            }
            case WEST: 
            case EAST: {
                n = 1;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    @Optional(value={"StorageDrawers"})
    private static void initStorageDrawers() {
        Class<?> clazz = null;
        try {
            clazz = Class.forName("com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        BlockPropertyRegistry.registerTileEntityInterfaceProperty(clazz, BlockPropertyRegistry.methodIntDirectionTile(clazz, "getDirection", "setDirection"));
    }

    @Optional(value={"IC2"})
    private static void initIC2() {
        BlockPropertyRegistry.registerTileEntityInterfaceProperty(IWrenchable.class, new DirectionBlockProperty.AbstractDirectionBlockProperty("facing"){

            @Override
            public ForgeDirection getValue(World world, int x, int y, int z) {
                TileEntity tileEntity = world.func_147438_o(x, y, z);
                if (!(tileEntity instanceof IWrenchable)) {
                    return ForgeDirection.UNKNOWN;
                }
                IWrenchable wrenchable = (IWrenchable)tileEntity;
                return ForgeDirection.getOrientation((int)wrenchable.getFacing());
            }

            @Override
            public void setValue(World world, int x, int y, int z, ForgeDirection value) {
                TileEntity tileEntity = world.func_147438_o(x, y, z);
                if (!(tileEntity instanceof IWrenchable)) {
                    return;
                }
                IWrenchable wrenchable = (IWrenchable)tileEntity;
                wrenchable.setFacing((short)value.ordinal());
            }
        });
    }

    private static void initArch() {
        final ForgeDirection[][] FORWARDS = new ForgeDirection[][]{{ForgeDirection.SOUTH, ForgeDirection.EAST, ForgeDirection.NORTH, ForgeDirection.WEST}, {ForgeDirection.NORTH, ForgeDirection.EAST, ForgeDirection.SOUTH, ForgeDirection.WEST}, {ForgeDirection.DOWN, ForgeDirection.EAST, ForgeDirection.UP, ForgeDirection.WEST}, {ForgeDirection.DOWN, ForgeDirection.WEST, ForgeDirection.UP, ForgeDirection.EAST}, {ForgeDirection.DOWN, ForgeDirection.NORTH, ForgeDirection.UP, ForgeDirection.SOUTH}, {ForgeDirection.DOWN, ForgeDirection.SOUTH, ForgeDirection.UP, ForgeDirection.NORTH}};
        BlockPropertyRegistry.registerTileEntityInterfaceProperty(TileArchitecture.class, new OrientationBlockProperty(){

            @Override
            public String getName() {
                return "orientation";
            }

            @Override
            public Orientation getValue(World world, int x, int y, int z) {
                TileEntity tileEntity = world.func_147438_o(x, y, z);
                if (!(tileEntity instanceof TileArchitecture)) {
                    return Orientation.NONE;
                }
                TileArchitecture tile = (TileArchitecture)tileEntity;
                return Orientation.getOrientation(ForgeDirection.getOrientation((int)tile.side), MMUtils.getIndexSafe((ForgeDirection[])MMUtils.getIndexSafe(FORWARDS, (int)tile.side), (int)tile.turn));
            }

            @Override
            public void setValue(World world, int x, int y, int z, Orientation value) {
                int index;
                TileEntity tileEntity = world.func_147438_o(x, y, z);
                if (!(tileEntity instanceof TileArchitecture)) {
                    return;
                }
                TileArchitecture tile = (TileArchitecture)tileEntity;
                if (value == null || value == Orientation.NONE || value.a == value.b || value.a.getOpposite() == value.b) {
                    value = Orientation.DOWN_NORTH;
                }
                if ((index = MMUtils.indexOf((ForgeDirection[])MMUtils.getIndexSafe(FORWARDS, value.a.ordinal()), value.b)) != -1) {
                    tile.turn = (byte)index;
                    tile.side = (byte)value.a.ordinal();
                } else {
                    for (int side = 0; side < FORWARDS.length; ++side) {
                        index = MMUtils.indexOf(FORWARDS[side], value);
                        if (index == -1) continue;
                        tile.side = (byte)side;
                        tile.turn = (byte)index;
                        break;
                    }
                }
                tile.func_70296_d();
                world.func_147471_g(x, y, z);
            }
        });
    }

    private static void initFloodLights() {
        BlockPropertyRegistry.registerTileEntityInterfaceProperty(TileEntityMetaFloodlight.class, new DirectionBlockProperty.AbstractDirectionBlockProperty("facing"){

            @Override
            public ForgeDirection getValue(World world, int x, int y, int z) {
                TileEntity tileEntity = world.func_147438_o(x, y, z);
                if (!(tileEntity instanceof TileEntityMetaFloodlight)) {
                    return ForgeDirection.UNKNOWN;
                }
                TileEntityMetaFloodlight floodlight = (TileEntityMetaFloodlight)tileEntity;
                return floodlight.getOrientation();
            }

            @Override
            public void setValue(World world, int x, int y, int z, ForgeDirection forgeDirection) {
                TileEntity tileEntity = world.func_147438_o(x, y, z);
                if (!(tileEntity instanceof TileEntityMetaFloodlight)) {
                    return;
                }
                TileEntityMetaFloodlight floodlight = (TileEntityMetaFloodlight)tileEntity;
                floodlight.setOrientation(forgeDirection);
                if (!(floodlight instanceof TileEntitySmallFloodlight)) {
                    world.func_72921_c(x, y, z, forgeDirection.ordinal(), 2);
                } else {
                    world.func_147471_g(x, y, z);
                }
            }
        });
        BlockPropertyRegistry.registerTileEntityInterfaceProperty(TileEntityMetaFloodlight.class, new BooleanProperty(){

            @Override
            public String getName() {
                return "inverted";
            }

            @Override
            public boolean getBoolean(World world, int x, int y, int z) {
                TileEntity tileEntity = world.func_147438_o(x, y, z);
                if (!(tileEntity instanceof TileEntityMetaFloodlight)) {
                    return false;
                }
                TileEntityMetaFloodlight floodlight = (TileEntityMetaFloodlight)tileEntity;
                return floodlight.getInverted();
            }

            @Override
            public void setBoolean(World world, int x, int y, int z, boolean value) {
                TileEntity tileEntity = world.func_147438_o(x, y, z);
                if (!(tileEntity instanceof TileEntityMetaFloodlight)) {
                    return;
                }
                TileEntityMetaFloodlight floodlight = (TileEntityMetaFloodlight)tileEntity;
                if (floodlight.getInverted() != value) {
                    floodlight.toggleInverted();
                }
            }
        });
        BlockPropertyRegistry.registerTileEntityInterfaceProperty(TileEntityMetaFloodlight.class, new IntegerProperty(){

            @Override
            public String getName() {
                return "mode";
            }

            @Override
            public int getInt(World world, int x, int y, int z) {
                TileEntity tileEntity = world.func_147438_o(x, y, z);
                if (!(tileEntity instanceof TileEntityMetaFloodlight)) {
                    return 0;
                }
                TileEntityMetaFloodlight floodlight = (TileEntityMetaFloodlight)tileEntity;
                return floodlight.getMode();
            }

            @Override
            public void setInt(World world, int x, int y, int z, int value) {
                TileEntity tileEntity = world.func_147438_o(x, y, z);
                if (!(tileEntity instanceof TileEntityMetaFloodlight)) {
                    return;
                }
                TileEntityMetaFloodlight floodlight = (TileEntityMetaFloodlight)tileEntity;
                floodlight.setMode(value);
            }
        });
        BlockPropertyRegistry.registerTileEntityInterfaceProperty(TileEntityMetaFloodlight.class, new IntegerProperty(){

            @Override
            public String getName() {
                return "color";
            }

            @Override
            public int getInt(World world, int x, int y, int z) {
                TileEntity tileEntity = world.func_147438_o(x, y, z);
                if (!(tileEntity instanceof TileEntityMetaFloodlight)) {
                    return 0;
                }
                TileEntityMetaFloodlight floodlight = (TileEntityMetaFloodlight)tileEntity;
                return floodlight.getColor();
            }

            @Override
            public void setInt(World world, int x, int y, int z, int value) {
                TileEntity tileEntity = world.func_147438_o(x, y, z);
                if (!(tileEntity instanceof TileEntityMetaFloodlight)) {
                    return;
                }
                TileEntityMetaFloodlight floodlight = (TileEntityMetaFloodlight)tileEntity;
                floodlight.setColor(value);
            }
        });
        BlockPropertyRegistry.registerTileEntityInterfaceProperty(TileEntitySmallFloodlight.class, new BooleanProperty(){

            @Override
            public String getName() {
                return "rotation_state";
            }

            @Override
            public boolean getBoolean(World world, int x, int y, int z) {
                TileEntity tileEntity = world.func_147438_o(x, y, z);
                if (!(tileEntity instanceof TileEntitySmallFloodlight)) {
                    return false;
                }
                TileEntitySmallFloodlight floodlight = (TileEntitySmallFloodlight)tileEntity;
                return floodlight.getRotationState();
            }

            @Override
            public void setBoolean(World world, int x, int y, int z, boolean value) {
                TileEntity tileEntity = world.func_147438_o(x, y, z);
                if (!(tileEntity instanceof TileEntitySmallFloodlight)) {
                    return;
                }
                TileEntitySmallFloodlight floodlight = (TileEntitySmallFloodlight)tileEntity;
                floodlight.setRotationState(value);
                world.func_147471_g(x, y, z);
            }
        });
    }

    @Optional(value={"gregtech"})
    private static void initGT5u() {
        BlockPropertyRegistry.registerIntrinsicProperty(GregTechAPI.sBlockMachines, new MEHatchCapacityProperty<MTEHatchOutputBusME>(MTEHatchOutputBusME.class));
        BlockPropertyRegistry.registerIntrinsicProperty(GregTechAPI.sBlockMachines, new MEHatchCapacityProperty<MTEHatchOutputME>(MTEHatchOutputME.class));
    }

    @Optional(value={"ae2stuff"})
    private static void initAE2Stuff() {
        BlockPropertyRegistry.registerIntrinsicProperty(((ImmutableBlockMeta)InteropConstants.WIRELESS_CONNECTOR.get()).getBlock(), new WirelessHubProperty());
    }

    public static DirectionBlockProperty methodIntDirectionTile(Class<?> clazz, String getterName, String setterName) {
        Method getter = clazz.getDeclaredMethod(getterName, new Class[0]);
        Method setter = clazz.getDeclaredMethod(setterName, Integer.TYPE);
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        MethodHandle getterHandle = lookup.unreflect(getter);
        MethodHandle setterHandle = lookup.unreflect(setter);
        static interface Getter {
            public int get(Object var1);
        }
        final Getter getterFn = LambdaMetafactory.metafactory(lookup, "get", MethodType.methodType(Getter.class), MethodType.methodType(Integer.TYPE, Object.class), getterHandle, getterHandle.type()).getTarget().invokeExact();
        static interface Setter {
            public void set(Object var1, int var2);
        }
        final Setter setterFn = LambdaMetafactory.metafactory(lookup, "set", MethodType.methodType(Setter.class), MethodType.methodType(Void.TYPE, Object.class, Integer.TYPE), setterHandle, setterHandle.type()).getTarget().invokeExact();
        return new DirectionBlockProperty.AbstractDirectionBlockProperty("facing"){
            {
                static interface Getter {
                    public int get(Object var1);
                }
                static interface Setter {
                    public void set(Object var1, int var2);
                }
                super(name);
            }

            @Override
            public ForgeDirection getValue(World world, int x, int y, int z) {
                TileEntity tile = world.func_147438_o(x, y, z);
                static interface Getter {
                    public int get(Object var1);
                }
                return ForgeDirection.getOrientation((int)getterFn.get(tile));
            }

            @Override
            public void setValue(World world, int x, int y, int z, ForgeDirection value) {
                TileEntity tile = world.func_147438_o(x, y, z);
                static interface Setter {
                    public void set(Object var1, int var2);
                }
                setterFn.set(tile, value.ordinal());
                tile.func_70296_d();
                world.func_147471_g(x, y, z);
            }
        };
    }

    public static enum RailMode {
        NONE,
        ASCENDING,
        TURNED;


        public String toString() {
            String string;
            switch (this) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case NONE: {
                    string = "none";
                    break;
                }
                case ASCENDING: {
                    string = "ascending";
                    break;
                }
                case TURNED: {
                    string = "turned";
                }
            }
            return string;
        }

        public static RailMode parse(String name) throws Exception {
            if ("turned".equals(name)) {
                return TURNED;
            }
            if ("ascending".equals(name)) {
                return ASCENDING;
            }
            if ("none".equals(name)) {
                return NONE;
            }
            throw new Exception("illegal rail mode: '" + name + "'");
        }
    }

    private static class MEHatchCapacityProperty<MTE extends IMetaTileEntity>
    extends IntrinsicMTEProperty<MTE> {
        public static final String KEY = "baseCapacity";
        public static final int BASE_CAPACITY = 1600;

        public MEHatchCapacityProperty(Class<MTE> clazz) {
            super(clazz);
        }

        @Override
        public String getName() {
            return "capacity";
        }

        @Override
        public JsonElement getValue(MTE mte) {
            NBTTagCompound tag = new NBTTagCompound();
            mte.setItemNBT(tag);
            long capacity = tag.func_74764_b(KEY) ? tag.func_74763_f(KEY) : 1600L;
            return new JsonPrimitive((Number)capacity);
        }

        @Override
        public void setValue(MTE mte, JsonElement value) {
            throw new UnsupportedOperationException("bus capacity is fixed and cannot be changed");
        }

        @Override
        public JsonElement getValue(NBTTagCompound itemTag) {
            long capacity = itemTag.func_74764_b(KEY) ? itemTag.func_74763_f(KEY) : 1600L;
            return new JsonPrimitive((Number)capacity);
        }

        @Override
        public void setValue(NBTTagCompound itemTag, JsonElement value) {
            if (value.getAsLong() == 1600L) {
                itemTag.func_82580_o(KEY);
            } else {
                itemTag.func_74772_a(KEY, value.getAsLong());
            }
        }

        @Override
        public void getItemDetails(List<String> details, JsonElement value) {
            ReadableNumberConverter nc = ReadableNumberConverter.INSTANCE;
            details.add(String.format("cache capacity: %s", nc.toWideReadableForm(value.getAsLong())));
        }
    }

    private static class WirelessHubProperty
    implements IntrinsicProperty {
        private WirelessHubProperty() {
        }

        @Override
        public String getName() {
            return "isHub";
        }

        @Override
        public boolean hasValue(ItemStack stack) {
            return InteropConstants.WIRELESS_CONNECTOR.matches(MMUtils.getBlockFromItem(stack.func_77973_b(), stack.field_77991_e), Short.MAX_VALUE);
        }

        @Override
        public boolean hasValue(IBlockAccess world, int x, int y, int z) {
            return world.func_147438_o(x, y, z) instanceof TileWireless;
        }

        @Override
        public JsonElement getValue(ItemStack stack) {
            return new JsonPrimitive(Boolean.valueOf(stack.field_77991_e >= 17));
        }

        @Override
        public JsonElement getValue(IBlockAccess world, int x, int y, int z) {
            TileWireless te = (TileWireless)world.func_147438_o(x, y, z);
            return new JsonPrimitive(Boolean.valueOf(te.isHub()));
        }

        @Override
        public void setValue(ItemStack stack, JsonElement value) {
            stack.field_77991_e = stack.field_77991_e % 17 + (value.getAsBoolean() ? 17 : 0);
        }

        @Override
        public void setValue(IBlockAccess world, int x, int y, int z, JsonElement value) {
            throw new UnsupportedOperationException("hub status is fixed and cannot be changed");
        }
    }

    public static abstract class IntrinsicMTEProperty<MTE extends IMetaTileEntity>
    implements IntrinsicProperty {
        public final Class<MTE> clazz;

        public IntrinsicMTEProperty(Class<MTE> clazz) {
            this.clazz = clazz;
        }

        @Override
        public boolean hasValue(ItemStack stack) {
            if (stack == null) {
                return false;
            }
            Item item = stack.func_77973_b();
            if (!(item instanceof ItemMachines)) {
                return false;
            }
            ItemMachines machines = (ItemMachines)item;
            IMetaTileEntity mte = MMUtils.getIndexSafe(GregTechAPI.METATILEENTITIES, machines.getDamage(stack));
            if (mte == null) {
                return false;
            }
            return this.clazz.isAssignableFrom(mte.getClass());
        }

        @Override
        public boolean hasValue(IBlockAccess world, int x, int y, int z) {
            TileEntity tileEntity = world.func_147438_o(x, y, z);
            if (!(tileEntity instanceof IGregTechTileEntity)) {
                return false;
            }
            IGregTechTileEntity igte = (IGregTechTileEntity)tileEntity;
            IMetaTileEntity mte = igte.getMetaTileEntity();
            if (mte == null || igte.isDead()) {
                return false;
            }
            return this.clazz.isAssignableFrom(mte.getClass());
        }

        @Override
        public JsonElement getValue(IBlockAccess world, int x, int y, int z) {
            TileEntity tileEntity = world.func_147438_o(x, y, z);
            if (!(tileEntity instanceof IGregTechTileEntity)) {
                return null;
            }
            IGregTechTileEntity igte = (IGregTechTileEntity)tileEntity;
            IMetaTileEntity mte = igte.getMetaTileEntity();
            if (mte == null || igte.isDead()) {
                return null;
            }
            if (!this.clazz.isAssignableFrom(mte.getClass())) {
                return null;
            }
            IMetaTileEntity casted = (IMetaTileEntity)this.clazz.cast(mte);
            return this.getValue(casted);
        }

        @Override
        public void setValue(IBlockAccess world, int x, int y, int z, JsonElement value) {
            TileEntity tileEntity = world.func_147438_o(x, y, z);
            if (!(tileEntity instanceof IGregTechTileEntity)) {
                return;
            }
            IGregTechTileEntity igte = (IGregTechTileEntity)tileEntity;
            IMetaTileEntity mte = igte.getMetaTileEntity();
            if (mte == null || igte.isDead()) {
                return;
            }
            if (!this.clazz.isAssignableFrom(mte.getClass())) {
                return;
            }
            IMetaTileEntity casted = (IMetaTileEntity)this.clazz.cast(mte);
            this.setValue(casted, value);
        }

        public abstract JsonElement getValue(MTE var1);

        public abstract void setValue(MTE var1, JsonElement var2);

        @Override
        public JsonElement getValue(ItemStack stack) {
            NBTTagCompound tag = stack.func_77978_p();
            if (tag == null) {
                return null;
            }
            return this.getValue(tag);
        }

        @Override
        public void setValue(ItemStack stack, JsonElement value) {
            NBTTagCompound tag = stack.func_77978_p();
            if (tag == null) {
                tag = new NBTTagCompound();
                stack.func_77982_d(tag);
            }
            this.setValue(tag, value);
        }

        public abstract JsonElement getValue(NBTTagCompound var1);

        public abstract void setValue(NBTTagCompound var1, JsonElement var2);
    }
}

