/*
 * Decompiled with CFR 0.152.
 */
package net.glease.tc4tweak.asm;

import net.glease.tc4tweak.asm.LoadingPlugin;
import net.glease.tc4tweak.asm.TC4Transformer;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

public class TileVisRelayVisitor
extends ClassVisitor {
    private String superName;

    public TileVisRelayVisitor(int api, ClassVisitor cv) {
        super(api, cv);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.superName = superName;
        super.visit(version, access, name, signature, this.superName, interfaces);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (name.equals("drawEffect")) {
            TC4Transformer.log.debug("Visiting {}{}", new Object[]{name, desc});
            return new DrawEffectVisitor(this.api, mv);
        }
        return mv;
    }

    public void visitEnd() {
        TC4Transformer.log.debug("Adding sendUpdate() via overriding setParent()");
        MethodVisitor mv = this.visitMethod(1, "setParent", "(Ljava/lang/ref/WeakReference;)V", "(Ljava/lang/ref/WeakReference<Lthaumcraft/api/visnet/TileVisNode;>;)V", null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(183, this.superName, "setParent", "(Ljava/lang/ref/WeakReference;)V", false);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(184, "net/glease/tc4tweak/asm/ASMCallhookServer", "sendUpdate", "(Lnet/minecraft/tileentity/TileEntity;)V", false);
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        super.visitEnd();
    }

    private static class DrawEffectVisitor
    extends MethodVisitor {
        public DrawEffectVisitor(int api, MethodVisitor mv) {
            super(api, mv);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            super.visitMethodInsn(opcode, owner, name, desc, itf);
            if (opcode == 182 && name.equals(LoadingPlugin.dev ? "getWorldObj" : "func_145831_w")) {
                TC4Transformer.log.trace("Injecting blockExists() check");
                Label l = new Label();
                this.mv.visitVarInsn(25, 0);
                this.mv.visitFieldInsn(180, "thaumcraft/common/tiles/TileVisRelay", LoadingPlugin.dev ? "xCoord" : "field_145851_c", "I");
                this.mv.visitVarInsn(25, 0);
                this.mv.visitFieldInsn(180, "thaumcraft/common/tiles/TileVisRelay", "px", "I");
                this.mv.visitInsn(100);
                this.mv.visitVarInsn(25, 0);
                this.mv.visitFieldInsn(180, "thaumcraft/common/tiles/TileVisRelay", LoadingPlugin.dev ? "yCoord" : "field_145848_d", "I");
                this.mv.visitVarInsn(25, 0);
                this.mv.visitFieldInsn(180, "thaumcraft/common/tiles/TileVisRelay", "py", "I");
                this.mv.visitInsn(100);
                this.mv.visitVarInsn(25, 0);
                this.mv.visitFieldInsn(180, "thaumcraft/common/tiles/TileVisRelay", LoadingPlugin.dev ? "zCoord" : "field_145849_e", "I");
                this.mv.visitVarInsn(25, 0);
                this.mv.visitFieldInsn(180, "thaumcraft/common/tiles/TileVisRelay", "pz", "I");
                this.mv.visitInsn(100);
                this.mv.visitMethodInsn(184, "net/glease/tc4tweak/asm/ASMCallhookServer", "checkVisRelayParentLoaded", "(Lnet/minecraft/world/World;III)Z", false);
                this.mv.visitJumpInsn(154, l);
                this.mv.visitInsn(177);
                this.mv.visitLabel(l);
                this.mv.visitFrame(3, 0, null, 0, null);
                this.mv.visitVarInsn(25, 0);
                this.mv.visitMethodInsn(opcode, owner, name, desc, itf);
            }
        }
    }
}

