/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.compat;

import codechicken.nei.api.API;
import codechicken.nei.api.IConfigureNEI;
import codechicken.nei.recipe.GuiCraftingRecipe;
import codechicken.nei.recipe.GuiUsageRecipe;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;
import ganymedes01.etfuturum.ModBlocks;
import ganymedes01.etfuturum.compat.nei.BannerPatternHandler;
import ganymedes01.etfuturum.compat.nei.BlastFurnaceRecipeHandler;
import ganymedes01.etfuturum.compat.nei.ComposterHandler;
import ganymedes01.etfuturum.compat.nei.SmokerRecipeHandler;
import ganymedes01.etfuturum.configuration.configs.ConfigWorld;
import net.minecraft.block.BlockSlab;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class NEIEtFuturumConfig
implements IConfigureNEI {
    private static final BlastFurnaceRecipeHandler BLAST_FURNACE_HANDLER = new BlastFurnaceRecipeHandler();
    private static final SmokerRecipeHandler SMOKER_HANDLER = new SmokerRecipeHandler();

    public void loadConfig() {
        Object handler;
        if (ConfigWorld.tileReplacementMode != -1) {
            if (ModBlocks.BREWING_STAND.isEnabled()) {
                API.hideItem((ItemStack)ModBlocks.BREWING_STAND.newItemStack());
            }
            if (ModBlocks.BEACON.isEnabled()) {
                API.hideItem((ItemStack)ModBlocks.BEACON.newItemStack());
            }
            if (ModBlocks.ANVIL.isEnabled()) {
                API.hideItem((ItemStack)ModBlocks.ANVIL.newItemStack());
                API.hideItem((ItemStack)ModBlocks.ANVIL.newItemStack(1, 1));
                API.hideItem((ItemStack)ModBlocks.ANVIL.newItemStack(1, 2));
            }
            if (ModBlocks.ENCHANTMENT_TABLE.isEnabled()) {
                API.hideItem((ItemStack)ModBlocks.ENCHANTMENT_TABLE.newItemStack());
            }
        }
        API.hideItem((ItemStack)new ItemStack(Items.field_151152_bP));
        for (byte i = 1; i <= 3; i = (byte)(i + 1)) {
            ItemStack firework = new ItemStack(Items.field_151152_bP);
            NBTTagCompound nbt = new NBTTagCompound();
            NBTTagCompound nbt2 = new NBTTagCompound();
            nbt2.func_74774_a("Flight", i);
            nbt.func_74782_a("Fireworks", (NBTBase)nbt2);
            firework.func_77982_d(nbt);
            API.addItemListEntry((ItemStack)firework);
        }
        for (ModBlocks mb : ModBlocks.VALUES) {
            if (!mb.isEnabled() || !(mb.get() instanceof BlockSlab) || !mb.name().toLowerCase().contains("double")) continue;
            API.hideItem((ItemStack)mb.newItemStack(1, Short.MAX_VALUE));
        }
        if (ModBlocks.BANNER.isEnabled()) {
            API.registerRecipeHandler((ICraftingHandler)new BannerPatternHandler());
            API.registerUsageHandler((IUsageHandler)new BannerPatternHandler());
        }
        if (ModBlocks.SMOKER.isEnabled()) {
            handler = SMOKER_HANDLER;
            GuiCraftingRecipe.craftinghandlers.add(handler);
            GuiUsageRecipe.usagehandlers.add(handler);
        }
        if (ModBlocks.BLAST_FURNACE.isEnabled()) {
            handler = BLAST_FURNACE_HANDLER;
            GuiCraftingRecipe.craftinghandlers.add(handler);
            GuiUsageRecipe.usagehandlers.add(handler);
        }
        if (ModBlocks.COMPOSTER.isEnabled()) {
            handler = new ComposterHandler();
            GuiCraftingRecipe.craftinghandlers.add(handler);
            GuiUsageRecipe.usagehandlers.add(handler);
        }
    }

    public static void clearCaches() {
        BLAST_FURNACE_HANDLER.clearCache();
        SMOKER_HANDLER.clearCache();
    }

    public String getName() {
        return "Et Futurum Requiem";
    }

    public String getVersion() {
        return "2.6.2.18-GTNH-daily";
    }
}

