/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.world;

import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import mantle.pulsar.pulse.Handler;
import mantle.pulsar.pulse.Pulse;
import mantle.utils.RecipeRemover;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.potion.Potion;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import tconstruct.TConstruct;
import tconstruct.armor.TinkerArmor;
import tconstruct.blocks.SlabBase;
import tconstruct.blocks.slime.SlimeFluid;
import tconstruct.blocks.slime.SlimeGel;
import tconstruct.blocks.slime.SlimeGrass;
import tconstruct.blocks.slime.SlimeLeaves;
import tconstruct.blocks.slime.SlimeSapling;
import tconstruct.blocks.slime.SlimeTallGrass;
import tconstruct.blocks.traps.BarricadeBlock;
import tconstruct.blocks.traps.Punji;
import tconstruct.client.StepSoundSlime;
import tconstruct.common.itemblocks.MetadataItemBlock;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.crafting.FluidType;
import tconstruct.smeltery.blocks.MetalOre;
import tconstruct.smeltery.itemblocks.MetalItemBlock;
import tconstruct.tools.TinkerTools;
import tconstruct.tools.blocks.MultiBrick;
import tconstruct.tools.blocks.MultiBrickFancy;
import tconstruct.tools.blocks.MultiBrickMetal;
import tconstruct.tools.entity.ArrowEntity;
import tconstruct.tools.entity.DaggerEntity;
import tconstruct.tools.entity.FancyEntityItem;
import tconstruct.tools.entity.LaunchedPotion;
import tconstruct.tools.itemblocks.MultiBrickFancyItem;
import tconstruct.tools.itemblocks.MultiBrickItem;
import tconstruct.tools.itemblocks.MultiBrickMetalItem;
import tconstruct.util.config.PHConstruct;
import tconstruct.world.TinkerWorldEvents;
import tconstruct.world.TinkerWorldProxyCommon;
import tconstruct.world.blocks.ConveyorBase;
import tconstruct.world.blocks.GravelOre;
import tconstruct.world.blocks.MeatBlock;
import tconstruct.world.blocks.OreberryBush;
import tconstruct.world.blocks.OreberryBushEssence;
import tconstruct.world.blocks.SlimeExplosive;
import tconstruct.world.blocks.SlimePad;
import tconstruct.world.blocks.StoneLadder;
import tconstruct.world.blocks.StoneTorch;
import tconstruct.world.blocks.TMetalBlock;
import tconstruct.world.blocks.WoodRail;
import tconstruct.world.entity.BlueSlime;
import tconstruct.world.entity.Crystal;
import tconstruct.world.entity.KingBlueSlime;
import tconstruct.world.gen.TBaseWorldGenerator;
import tconstruct.world.gen.TerrainGenEventHandler;
import tconstruct.world.itemblocks.BarricadeItem;
import tconstruct.world.itemblocks.GravelOreItem;
import tconstruct.world.itemblocks.HamboneItemBlock;
import tconstruct.world.itemblocks.MetalOreItemBlock;
import tconstruct.world.itemblocks.OreberryBushItem;
import tconstruct.world.itemblocks.OreberryBushSecondItem;
import tconstruct.world.itemblocks.SlimeGelItemBlock;
import tconstruct.world.itemblocks.SlimeGrassItemBlock;
import tconstruct.world.itemblocks.SlimeLeavesItemBlock;
import tconstruct.world.itemblocks.SlimeSaplingItemBlock;
import tconstruct.world.itemblocks.SlimeTallGrassItem;
import tconstruct.world.itemblocks.WoolSlab1Item;
import tconstruct.world.itemblocks.WoolSlab2Item;
import tconstruct.world.items.GoldenHead;
import tconstruct.world.items.OreBerries;
import tconstruct.world.items.StrangeFood;

@GameRegistry.ObjectHolder(value="TConstruct")
@Pulse(id="Tinkers' World", description="Ores, slime islands, essence berries, and the like.", forced=true)
public class TinkerWorld {
    @Mod.Instance(value="TinkerWorld")
    public static TinkerWorld instance;
    @SidedProxy(clientSide="tconstruct.world.TinkerWorldProxyClient", serverSide="tconstruct.world.TinkerWorldProxyCommon")
    public static TinkerWorldProxyCommon proxy;
    public static Item strangeFood;
    public static Block stoneTorch;
    public static Block stoneLadder;
    public static Block meatBlock;
    public static Block woolSlab1;
    public static Block woolSlab2;
    public static Block barricadeOak;
    public static Block barricadeSpruce;
    public static Block barricadeBirch;
    public static Block barricadeJungle;
    public static Block slimeExplosive;
    public static Fluid blueSlimeFluid;
    public static Block.SoundType slimeStep;
    public static Block slimePool;
    public static Block slimeGel;
    public static Block slimeGrass;
    public static Block slimeTallGrass;
    public static SlimeLeaves slimeLeaves;
    public static SlimeSapling slimeSapling;
    public static Block slimeChannel;
    public static Block slimePad;
    public static Block bloodChannel;
    public static Block oreSlag;
    public static Block oreGravel;
    public static OreberryBush oreBerry;
    public static OreberryBush oreBerrySecond;
    public static Item oreBerries;
    public static Block woodenRail;
    public static ChestGenHooks tinkerHouseChest;
    public static ChestGenHooks tinkerHousePatterns;
    public static Block punji;
    public static Block metalBlock;
    public static Item goldHead;

    @Handler
    public void preInit(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new TinkerWorldEvents());
        meatBlock = new MeatBlock().func_149663_c("tconstruct.meatblock");
        woolSlab1 = new SlabBase(Material.field_151580_n, Blocks.field_150325_L, 0, 8).func_149663_c("cloth");
        woolSlab1.func_149672_a(Block.field_149775_l).func_149647_a(CreativeTabs.field_78031_c);
        woolSlab2 = new SlabBase(Material.field_151580_n, Blocks.field_150325_L, 8, 8).func_149663_c("cloth");
        woolSlab2.func_149672_a(Block.field_149775_l).func_149647_a(CreativeTabs.field_78031_c);
        punji = new Punji().func_149663_c("trap.punji");
        barricadeOak = new BarricadeBlock(Blocks.field_150364_r, 0).func_149663_c("trap.barricade.oak");
        barricadeSpruce = new BarricadeBlock(Blocks.field_150364_r, 1).func_149663_c("trap.barricade.spruce");
        barricadeBirch = new BarricadeBlock(Blocks.field_150364_r, 2).func_149663_c("trap.barricade.birch");
        barricadeJungle = new BarricadeBlock(Blocks.field_150364_r, 3).func_149663_c("trap.barricade.jungle");
        slimeExplosive = new SlimeExplosive().func_149711_c(0.0f).func_149672_a(Block.field_149779_h).func_149663_c("explosive.slime");
        slimeStep = new StepSoundSlime("mob.slime", 1.0f, 1.0f);
        blueSlimeFluid = new Fluid("slime.blue");
        if (!FluidRegistry.registerFluid((Fluid)blueSlimeFluid)) {
            blueSlimeFluid = FluidRegistry.getFluid((String)"slime.blue");
        }
        slimePool = new SlimeFluid(blueSlimeFluid, Material.field_151586_h).func_149647_a(TConstructRegistry.blockTab).func_149672_a(slimeStep).func_149663_c("liquid.slime");
        GameRegistry.registerBlock((Block)slimePool, (String)"liquid.slime");
        blueSlimeFluid.setBlock(slimePool);
        slimeGel = new SlimeGel().func_149672_a(slimeStep).func_149713_g(0).func_149663_c("slime.gel");
        slimeGel.setHarvestLevel("axe", 0, 1);
        slimeGrass = new SlimeGrass().func_149672_a(Block.field_149779_h).func_149713_g(0).func_149663_c("slime.grass");
        slimeTallGrass = new SlimeTallGrass().func_149672_a(Block.field_149779_h).func_149663_c("slime.grass.tall");
        slimeLeaves = (SlimeLeaves)new SlimeLeaves().func_149672_a(slimeStep).func_149663_c("slime.leaves");
        slimeSapling = (SlimeSapling)new SlimeSapling().func_149672_a(slimeStep).func_149663_c("slime.sapling");
        slimeChannel = new ConveyorBase(Material.field_151586_h, "greencurrent").func_149711_c(0.3f).func_149672_a(slimeStep).func_149663_c("slime.channel");
        bloodChannel = new ConveyorBase(Material.field_151586_h, "liquid_cow").func_149711_c(0.3f).func_149672_a(slimeStep).func_149663_c("blood.channel");
        slimePad = new SlimePad(Material.field_151580_n).func_149672_a(slimeStep).func_149711_c(0.3f).func_149663_c("slime.pad");
        stoneTorch = new StoneTorch().func_149663_c("decoration.stonetorch");
        stoneLadder = new StoneLadder().func_149663_c("decoration.stoneladder");
        TinkerTools.multiBrick = new MultiBrick().func_149663_c("Decoration.Brick");
        TinkerTools.multiBrickFancy = new MultiBrickFancy().func_149663_c("Decoration.BrickFancy");
        TinkerTools.multiBrickMetal = new MultiBrickMetal().func_149663_c("Decoration.BrickMetal");
        if (Loader.isModLoaded((String)"IguanaTweaksTConstruct")) {
            TinkerTools.multiBrick.setHarvestLevel("pickaxe", 5, 0);
            TinkerTools.multiBrickFancy.setHarvestLevel("pickaxe", 5, 0);
        }
        String[] berryOres = new String[]{"berry_iron", "berry_gold", "berry_copper", "berry_tin", "berry_iron_ripe", "berry_gold_ripe", "berry_copper_ripe", "berry_tin_ripe"};
        oreBerry = (OreberryBush)new OreberryBush(berryOres, 0, 4, new String[]{"oreIron", "oreGold", "oreCopper", "oreTin"}).func_149663_c("ore.berries.one");
        String[] berryOresTwo = new String[]{"berry_aluminum", "berry_essence", "", "", "berry_aluminum_ripe", "berry_essence_ripe", "", ""};
        oreBerrySecond = (OreberryBush)new OreberryBushEssence(berryOresTwo, 4, 2, new String[]{"oreAluminum", "oreSilver"}).func_149663_c("ore.berries.two");
        String[] oreTypes = new String[]{"nether_slag", "nether_cobalt", "nether_ardite", "ore_copper", "ore_tin", "ore_aluminum", "ore_slag"};
        oreSlag = new MetalOre(Material.field_151576_e, 10.0f, oreTypes).func_149663_c("tconstruct.stoneore");
        oreSlag.setHarvestLevel("pickaxe", 4, 1);
        oreSlag.setHarvestLevel("pickaxe", 4, 2);
        oreSlag.setHarvestLevel("pickaxe", 1, 3);
        oreSlag.setHarvestLevel("pickaxe", 1, 4);
        oreSlag.setHarvestLevel("pickaxe", 1, 5);
        oreGravel = new GravelOre().func_149663_c("GravelOre").func_149663_c("tconstruct.gravelore");
        oreGravel.setHarvestLevel("shovel", 1, 0);
        oreGravel.setHarvestLevel("shovel", 2, 1);
        oreGravel.setHarvestLevel("shovel", 1, 2);
        oreGravel.setHarvestLevel("shovel", 1, 3);
        oreGravel.setHarvestLevel("shovel", 1, 4);
        oreGravel.setHarvestLevel("shovel", 4, 5);
        if (!Loader.isModLoaded((String)"dreamcraft")) {
            woodenRail = new WoodRail().func_149672_a(Block.field_149766_f).func_149647_a((CreativeTabs)TConstructRegistry.blockTab).func_149663_c("rail.wood");
        }
        GameRegistry.registerBlock((Block)meatBlock, HamboneItemBlock.class, (String)"MeatBlock");
        OreDictionary.registerOre((String)"hambone", (ItemStack)new ItemStack(meatBlock));
        GameRegistry.registerBlock((Block)woolSlab1, WoolSlab1Item.class, (String)"WoolSlab1");
        GameRegistry.registerBlock((Block)woolSlab2, WoolSlab2Item.class, (String)"WoolSlab2");
        GameRegistry.registerBlock((Block)punji, (String)"trap.punji");
        GameRegistry.registerBlock((Block)barricadeOak, BarricadeItem.class, (String)"trap.barricade.oak");
        GameRegistry.registerBlock((Block)barricadeSpruce, BarricadeItem.class, (String)"trap.barricade.spruce");
        GameRegistry.registerBlock((Block)barricadeBirch, BarricadeItem.class, (String)"trap.barricade.birch");
        GameRegistry.registerBlock((Block)barricadeJungle, BarricadeItem.class, (String)"trap.barricade.jungle");
        GameRegistry.registerBlock((Block)slimeExplosive, MetadataItemBlock.class, (String)"explosive.slime");
        GameRegistry.registerBlock((Block)slimeGel, SlimeGelItemBlock.class, (String)"slime.gel");
        GameRegistry.registerBlock((Block)slimeGrass, SlimeGrassItemBlock.class, (String)"slime.grass");
        GameRegistry.registerBlock((Block)slimeTallGrass, SlimeTallGrassItem.class, (String)"slime.grass.tall");
        GameRegistry.registerBlock((Block)slimeLeaves, SlimeLeavesItemBlock.class, (String)"slime.leaves");
        GameRegistry.registerBlock((Block)slimeSapling, SlimeSaplingItemBlock.class, (String)"slime.sapling");
        GameRegistry.registerBlock((Block)slimeChannel, (String)"slime.channel");
        GameRegistry.registerBlock((Block)bloodChannel, (String)"blood.channel");
        GameRegistry.registerBlock((Block)slimePad, (String)"slime.pad");
        GameRegistry.registerBlock((Block)stoneTorch, (String)"decoration.stonetorch");
        GameRegistry.registerBlock((Block)stoneLadder, (String)"decoration.stoneladder");
        GameRegistry.registerBlock((Block)TinkerTools.multiBrick, MultiBrickItem.class, (String)"decoration.multibrick");
        GameRegistry.registerBlock((Block)TinkerTools.multiBrickFancy, MultiBrickFancyItem.class, (String)"decoration.multibrickfancy");
        GameRegistry.registerBlock((Block)TinkerTools.multiBrickMetal, MultiBrickMetalItem.class, (String)"decoration.multibrickmetal");
        GameRegistry.registerBlock((Block)oreBerry, OreberryBushItem.class, (String)"ore.berries.one");
        GameRegistry.registerBlock((Block)oreBerrySecond, OreberryBushSecondItem.class, (String)"ore.berries.two");
        GameRegistry.registerBlock((Block)oreSlag, MetalOreItemBlock.class, (String)"SearedBrick");
        GameRegistry.registerBlock((Block)oreGravel, GravelOreItem.class, (String)"GravelOre");
        if (woodenRail != null) {
            GameRegistry.registerBlock((Block)woodenRail, (String)"rail.wood");
        }
        goldHead = new GoldenHead(4, 1.2f, false).func_77848_i().func_77844_a(Potion.field_76428_l.field_76415_H, 10, 0, 1.0f).func_77655_b("goldenhead");
        GameRegistry.registerItem((Item)goldHead, (String)"goldHead");
        strangeFood = new StrangeFood().func_77655_b("tconstruct.strangefood");
        oreBerries = new OreBerries().func_77655_b("oreberry");
        GameRegistry.registerItem((Item)strangeFood, (String)"strangeFood");
        GameRegistry.registerItem((Item)oreBerries, (String)"oreBerries");
        String[] oreberries = new String[]{"Iron", "Gold", "Copper", "Tin", "Aluminum", "Essence"};
        for (int i = 0; i < oreberries.length; ++i) {
            TConstructRegistry.addItemStackToDirectory("oreberry" + oreberries[i], new ItemStack(oreBerries, 1, i));
        }
        TConstructRegistry.addItemStackToDirectory("blueSlimeFood", new ItemStack(strangeFood, 1, 0));
        Items.field_151135_aq.func_77625_d(16);
        Items.field_151139_aw.func_77625_d(16);
        Items.field_151124_az.func_77625_d(16);
        Items.field_151143_au.func_77625_d(3);
        Items.field_151105_aU.func_77625_d(16);
        metalBlock = new TMetalBlock(Material.field_151573_f, 10.0f).func_149663_c("tconstruct.metalblock");
        TinkerWorld.metalBlock.field_149762_H = Block.field_149777_j;
        GameRegistry.registerBlock((Block)metalBlock, MetalItemBlock.class, (String)"MetalBlock");
        FluidType.registerFluidType("Slime", slimeGel, 0, 250, blueSlimeFluid, false);
        this.oreRegistry();
    }

    @Handler
    public void init(FMLInitializationEvent event) {
        if (!PHConstruct.disableAllRecipes) {
            this.craftingTableRecipes();
            this.addRecipesForFurnace();
        }
        this.addLoot();
        this.createEntities();
        proxy.initialize();
        GameRegistry.registerWorldGenerator((IWorldGenerator)new TBaseWorldGenerator(), (int)0);
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)new TerrainGenEventHandler());
    }

    @Handler
    public void postInit(FMLPostInitializationEvent evt) {
    }

    public void createEntities() {
        EntityRegistry.registerModEntity(FancyEntityItem.class, (String)"Fancy Item", (int)0, (Object)TConstruct.instance, (int)32, (int)5, (boolean)true);
        EntityRegistry.registerModEntity(DaggerEntity.class, (String)"Dagger", (int)1, (Object)TConstruct.instance, (int)32, (int)5, (boolean)true);
        EntityRegistry.registerModEntity(Crystal.class, (String)"Crystal", (int)2, (Object)TConstruct.instance, (int)32, (int)3, (boolean)true);
        EntityRegistry.registerModEntity(LaunchedPotion.class, (String)"Launched Potion", (int)3, (Object)TConstruct.instance, (int)32, (int)3, (boolean)true);
        EntityRegistry.registerModEntity(ArrowEntity.class, (String)"Arrow", (int)4, (Object)TConstruct.instance, (int)32, (int)5, (boolean)true);
        EntityRegistry.registerModEntity(BlueSlime.class, (String)"EdibleSlime", (int)12, (Object)TConstruct.instance, (int)64, (int)5, (boolean)true);
        EntityRegistry.registerModEntity(KingBlueSlime.class, (String)"KingSlime", (int)14, (Object)TConstruct.instance, (int)64, (int)5, (boolean)true);
        if (PHConstruct.naturalSlimeSpawn > 0) {
            EntityRegistry.addSpawn(BlueSlime.class, (int)PHConstruct.naturalSlimeSpawn, (int)4, (int)20, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.FOREST));
            EntityRegistry.addSpawn(BlueSlime.class, (int)PHConstruct.naturalSlimeSpawn, (int)4, (int)20, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.PLAINS));
            EntityRegistry.addSpawn(BlueSlime.class, (int)PHConstruct.naturalSlimeSpawn, (int)4, (int)20, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN));
            EntityRegistry.addSpawn(BlueSlime.class, (int)PHConstruct.naturalSlimeSpawn, (int)4, (int)20, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.HILLS));
            EntityRegistry.addSpawn(BlueSlime.class, (int)PHConstruct.naturalSlimeSpawn, (int)4, (int)20, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.SWAMP));
            EntityRegistry.addSpawn(BlueSlime.class, (int)PHConstruct.naturalSlimeSpawn, (int)4, (int)20, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE));
            EntityRegistry.addSpawn(BlueSlime.class, (int)PHConstruct.naturalSlimeSpawn, (int)4, (int)20, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.WASTELAND));
        }
    }

    private void craftingTableRecipes() {
        String[] patBlock = new String[]{"###", "###", "###"};
        String[] patSurround = new String[]{"###", "#m#", "###"};
        GameRegistry.addRecipe((ItemStack)new ItemStack(metalBlock, 1, 3), (Object[])new Object[]{patBlock, Character.valueOf('#'), new ItemStack(TinkerTools.materials, 1, 9)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(metalBlock, 1, 5), (Object[])new Object[]{patBlock, Character.valueOf('#'), new ItemStack(TinkerTools.materials, 1, 10)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(metalBlock, 1, 6), (Object[])new Object[]{patBlock, Character.valueOf('#'), new ItemStack(TinkerTools.materials, 1, 11)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(metalBlock, 1, 4), (Object[])new Object[]{patBlock, Character.valueOf('#'), new ItemStack(TinkerTools.materials, 1, 13)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(metalBlock, 1, 7), (Object[])new Object[]{patBlock, Character.valueOf('#'), new ItemStack(TinkerTools.materials, 1, 14)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(metalBlock, 1, 0), (Object[])new Object[]{patBlock, Character.valueOf('#'), new ItemStack(TinkerTools.materials, 1, 3)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(metalBlock, 1, 1), (Object[])new Object[]{patBlock, Character.valueOf('#'), new ItemStack(TinkerTools.materials, 1, 4)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(metalBlock, 1, 2), (Object[])new Object[]{patBlock, Character.valueOf('#'), new ItemStack(TinkerTools.materials, 1, 5)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(metalBlock, 1, 8), (Object[])new Object[]{patBlock, Character.valueOf('#'), new ItemStack(TinkerTools.materials, 1, 15)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(metalBlock, 1, 9), (Object[])new Object[]{patBlock, Character.valueOf('#'), new ItemStack(TinkerTools.materials, 1, 16)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(TinkerTools.materials, 1, 11), (Object[])new Object[]{"#", Character.valueOf('#'), new ItemStack(TinkerTools.materials, 1, 12)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(TinkerTools.materials, 9, 9), (Object[])new Object[]{"m", Character.valueOf('m'), new ItemStack(metalBlock, 1, 3)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(TinkerTools.materials, 9, 10), (Object[])new Object[]{"m", Character.valueOf('m'), new ItemStack(metalBlock, 1, 5)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(TinkerTools.materials, 9, 11), (Object[])new Object[]{"m", Character.valueOf('m'), new ItemStack(metalBlock, 1, 6)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(TinkerTools.materials, 9, 13), (Object[])new Object[]{"m", Character.valueOf('m'), new ItemStack(metalBlock, 1, 4)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(TinkerTools.materials, 9, 14), (Object[])new Object[]{"m", Character.valueOf('m'), new ItemStack(metalBlock, 1, 7)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(TinkerTools.materials, 9, 3), (Object[])new Object[]{"m", Character.valueOf('m'), new ItemStack(metalBlock, 1, 0)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(TinkerTools.materials, 9, 4), (Object[])new Object[]{"m", Character.valueOf('m'), new ItemStack(metalBlock, 1, 1)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(TinkerTools.materials, 9, 5), (Object[])new Object[]{"m", Character.valueOf('m'), new ItemStack(metalBlock, 1, 2)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(TinkerTools.materials, 9, 15), (Object[])new Object[]{"m", Character.valueOf('m'), new ItemStack(metalBlock, 1, 8)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(TinkerTools.materials, 9, 16), (Object[])new Object[]{"m", Character.valueOf('m'), new ItemStack(metalBlock, 1, 9)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(Items.field_151042_j), (Object[])new Object[]{patBlock, Character.valueOf('#'), new ItemStack(TinkerTools.materials, 1, 19)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(TinkerTools.materials, 1, 9), (Object[])new Object[]{patBlock, Character.valueOf('#'), new ItemStack(TinkerTools.materials, 1, 20)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(TinkerTools.materials, 1, 10), (Object[])new Object[]{patBlock, Character.valueOf('#'), new ItemStack(TinkerTools.materials, 1, 21)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(TinkerTools.materials, 1, 11), (Object[])new Object[]{patBlock, Character.valueOf('#'), new ItemStack(TinkerTools.materials, 1, 22)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(TinkerTools.materials, 1, 14), (Object[])new Object[]{patBlock, Character.valueOf('#'), new ItemStack(TinkerTools.materials, 1, 24)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(TinkerTools.materials, 1, 18), (Object[])new Object[]{patBlock, Character.valueOf('#'), new ItemStack(TinkerTools.materials, 1, 27)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(TinkerTools.materials, 1, 3), (Object[])new Object[]{patBlock, Character.valueOf('#'), new ItemStack(TinkerTools.materials, 1, 28)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(TinkerTools.materials, 1, 4), (Object[])new Object[]{patBlock, Character.valueOf('#'), new ItemStack(TinkerTools.materials, 1, 29)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(TinkerTools.materials, 1, 5), (Object[])new Object[]{patBlock, Character.valueOf('#'), new ItemStack(TinkerTools.materials, 1, 30)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(TinkerTools.materials, 1, 13), (Object[])new Object[]{patBlock, Character.valueOf('#'), new ItemStack(TinkerTools.materials, 1, 31)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(TinkerTools.materials, 1, 15), (Object[])new Object[]{patBlock, Character.valueOf('#'), new ItemStack(TinkerTools.materials, 1, 32)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(TinkerTools.materials, 1, 16), (Object[])new Object[]{patBlock, Character.valueOf('#'), new ItemStack(TinkerTools.materials, 1, 33)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(TinkerTools.materials, 9, 19), (Object[])new Object[]{"m", Character.valueOf('m'), new ItemStack(Items.field_151042_j)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(TinkerTools.materials, 9, 20), (Object[])new Object[]{"m", Character.valueOf('m'), new ItemStack(TinkerTools.materials, 1, 9)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(TinkerTools.materials, 9, 21), (Object[])new Object[]{"m", Character.valueOf('m'), new ItemStack(TinkerTools.materials, 1, 10)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(TinkerTools.materials, 9, 22), (Object[])new Object[]{"m", Character.valueOf('m'), new ItemStack(TinkerTools.materials, 1, 11)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(TinkerTools.materials, 9, 24), (Object[])new Object[]{"m", Character.valueOf('m'), new ItemStack(TinkerTools.materials, 1, 14)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(TinkerTools.materials, 9, 27), (Object[])new Object[]{"m", Character.valueOf('m'), new ItemStack(TinkerTools.materials, 1, 18)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(TinkerTools.materials, 9, 28), (Object[])new Object[]{"m", Character.valueOf('m'), new ItemStack(TinkerTools.materials, 1, 3)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(TinkerTools.materials, 9, 29), (Object[])new Object[]{"m", Character.valueOf('m'), new ItemStack(TinkerTools.materials, 1, 4)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(TinkerTools.materials, 9, 30), (Object[])new Object[]{"m", Character.valueOf('m'), new ItemStack(TinkerTools.materials, 1, 5)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(TinkerTools.materials, 9, 31), (Object[])new Object[]{"m", Character.valueOf('m'), new ItemStack(TinkerTools.materials, 1, 13)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(TinkerTools.materials, 9, 32), (Object[])new Object[]{"m", Character.valueOf('m'), new ItemStack(TinkerTools.materials, 1, 15)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(TinkerTools.materials, 9, 33), (Object[])new Object[]{"m", Character.valueOf('m'), new ItemStack(TinkerTools.materials, 1, 16)});
        String[] dyeTypes = new String[]{"dyeBlack", "dyeRed", "dyeGreen", "dyeBrown", "dyeBlue", "dyePurple", "dyeCyan", "dyeLightGray", "dyeGray", "dyePink", "dyeLime", "dyeYellow", "dyeLightBlue", "dyeMagenta", "dyeOrange", "dyeWhite"};
        for (int i = 0; i < 16; ++i) {
            String color = dyeTypes[15 - i];
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Blocks.field_150325_L, 8, i), new Object[]{patSurround, Character.valueOf('m'), color, Character.valueOf('#'), new ItemStack(Blocks.field_150325_L, 1, Short.MAX_VALUE)}));
        }
        GameRegistry.addRecipe((ItemStack)new ItemStack(Blocks.field_150428_aP, 1, 0), (Object[])new Object[]{"p", "s", Character.valueOf('p'), new ItemStack(Blocks.field_150423_aK), Character.valueOf('s'), new ItemStack(stoneTorch)});
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(stoneTorch, 4), new Object[]{"p", "w", Character.valueOf('p'), new ItemStack(Items.field_151044_h, 1, Short.MAX_VALUE), Character.valueOf('w'), "rodStone"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(stoneLadder, 3), new Object[]{"w w", "www", "w w", Character.valueOf('w'), "rodStone"}));
        if (woodenRail != null) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(woodenRail, 4, 0), new Object[]{"b b", "bxb", "b b", Character.valueOf('b'), "plankWood", Character.valueOf('x'), "stickWood"}));
        }
        GameRegistry.addRecipe((ItemStack)new ItemStack(TinkerTools.toolRod, 4, 1), (Object[])new Object[]{"c", "c", Character.valueOf('c'), new ItemStack(Blocks.field_150348_b)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(TinkerTools.toolRod, 2, 1), (Object[])new Object[]{"c", "c", Character.valueOf('c'), new ItemStack(Blocks.field_150347_e)});
        ItemStack aluBrass = new ItemStack(TinkerTools.materials, 1, 14);
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Items.field_151113_aN), new Object[]{" i ", "iri", " i ", Character.valueOf('i'), aluBrass, Character.valueOf('r'), "dustRedstone"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(goldHead), new Object[]{patSurround, Character.valueOf('#'), "ingotGold", Character.valueOf('m'), new ItemStack(Items.field_151144_bL, 1, 3)}));
        for (int sc = 0; sc <= 7; ++sc) {
            GameRegistry.addRecipe((ItemStack)new ItemStack(woolSlab1, 6, sc), (Object[])new Object[]{"www", Character.valueOf('w'), new ItemStack(Blocks.field_150325_L, 1, sc)});
            GameRegistry.addRecipe((ItemStack)new ItemStack(woolSlab2, 6, sc), (Object[])new Object[]{"www", Character.valueOf('w'), new ItemStack(Blocks.field_150325_L, 1, sc + 8)});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Blocks.field_150325_L, 1, sc), (Object[])new Object[]{new ItemStack(woolSlab1, 1, sc), new ItemStack(woolSlab1, 1, sc)});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Blocks.field_150325_L, 1, sc + 8), (Object[])new Object[]{new ItemStack(woolSlab2, 1, sc), new ItemStack(woolSlab2, 1, sc)});
        }
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(Blocks.field_150325_L, 1, 0), new Object[]{"slabCloth", "slabCloth"}));
        GameRegistry.addRecipe((ItemStack)new ItemStack(punji, 5, 0), (Object[])new Object[]{"b b", " b ", "b b", Character.valueOf('b'), new ItemStack(Items.field_151120_aE)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(barricadeSpruce, 1, 0), (Object[])new Object[]{"b", "b", Character.valueOf('b'), new ItemStack(Blocks.field_150364_r, 1, 1)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(barricadeBirch, 1, 0), (Object[])new Object[]{"b", "b", Character.valueOf('b'), new ItemStack(Blocks.field_150364_r, 1, 2)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(barricadeJungle, 1, 0), (Object[])new Object[]{"b", "b", Character.valueOf('b'), new ItemStack(Blocks.field_150364_r, 1, 3)});
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(barricadeOak, 1, 0), new Object[]{"b", "b", Character.valueOf('b'), "logWood"}));
        GameRegistry.addRecipe((ItemStack)new ItemStack(slimeGel, 1, 0), (Object[])new Object[]{"##", "##", Character.valueOf('#'), strangeFood});
        GameRegistry.addRecipe((ItemStack)new ItemStack(strangeFood, 4, 0), (Object[])new Object[]{"#", Character.valueOf('#'), new ItemStack(slimeGel, 1, 0)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(slimeGel, 1, 1), (Object[])new Object[]{"##", "##", Character.valueOf('#'), Items.field_151123_aH});
        GameRegistry.addRecipe((ItemStack)new ItemStack(Items.field_151123_aH, 4, 0), (Object[])new Object[]{"#", Character.valueOf('#'), new ItemStack(slimeGel, 1, 1)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(slimeExplosive, 1, 0), (Object[])new Object[]{Items.field_151123_aH, Blocks.field_150335_W});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(slimeExplosive, 1, 2), (Object[])new Object[]{strangeFood, Blocks.field_150335_W});
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(slimeExplosive, 1, 0), new Object[]{"slimeball", Blocks.field_150335_W}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(slimeChannel, 1, 0), new Object[]{new ItemStack(slimeGel, 1, Short.MAX_VALUE), "dustRedstone"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(bloodChannel, 1, 0), new Object[]{new ItemStack(strangeFood, 1, 1), new ItemStack(strangeFood, 1, 1), new ItemStack(strangeFood, 1, 1), new ItemStack(strangeFood, 1, 1), "dustRedstone"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(slimeChannel, 1, 0), new Object[]{"slimeball", "slimeball", "slimeball", "slimeball", "dustRedstone"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(slimePad, 1, 0), new Object[]{slimeChannel, "slimeball"}));
        GameRegistry.addRecipe((ItemStack)new ItemStack(meatBlock), (Object[])new Object[]{"mmm", "mbm", "mmm", Character.valueOf('b'), new ItemStack(Items.field_151103_aS), Character.valueOf('m'), new ItemStack(Items.field_151147_al)});
    }

    private void addRecipesForFurnace() {
        FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack(TinkerTools.craftedSoil, 1, 3), new ItemStack(TinkerTools.craftedSoil, 1, 4), 0.2f);
        FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack(TinkerTools.craftedSoil, 1, 0), new ItemStack(TinkerTools.materials, 1, 1), 2.0f);
        FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack(TinkerTools.craftedSoil, 1, 1), new ItemStack(TinkerTools.materials, 1, 2), 2.0f);
        FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack(TinkerTools.craftedSoil, 1, 2), new ItemStack(TinkerTools.materials, 1, 17), 2.0f);
        FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack(TinkerTools.craftedSoil, 1, 6), new ItemStack(TinkerTools.materials, 1, 37), 2.0f);
        FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack(oreSlag, 1, 3), new ItemStack(TinkerTools.materials, 1, 9), 0.5f);
        FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack(oreSlag, 1, 4), new ItemStack(TinkerTools.materials, 1, 10), 0.5f);
        FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack(oreSlag, 1, 5), new ItemStack(TinkerTools.materials, 1, 11), 0.5f);
        FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack(oreBerries, 1, 0), new ItemStack(TinkerTools.materials, 1, 19), 0.2f);
        FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack(oreBerries, 1, 1), new ItemStack(Items.field_151074_bl), 0.2f);
        FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack(oreBerries, 1, 2), new ItemStack(TinkerTools.materials, 1, 20), 0.2f);
        FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack(oreBerries, 1, 3), new ItemStack(TinkerTools.materials, 1, 21), 0.2f);
        FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack(oreBerries, 1, 4), new ItemStack(TinkerTools.materials, 1, 22), 0.2f);
        FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack(oreGravel, 1, 0), new ItemStack(Items.field_151042_j), 0.2f);
        FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack(oreGravel, 1, 1), new ItemStack(Items.field_151043_k), 0.2f);
        FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack(oreGravel, 1, 2), new ItemStack(TinkerTools.materials, 1, 9), 0.2f);
        FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack(oreGravel, 1, 3), new ItemStack(TinkerTools.materials, 1, 10), 0.2f);
        FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack(oreGravel, 1, 4), new ItemStack(TinkerTools.materials, 1, 11), 0.2f);
        FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack(TinkerTools.materials, 1, 38), new ItemStack(TinkerTools.materials, 1, 4), 0.2f);
        FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack(TinkerTools.materials, 1, 39), new ItemStack(TinkerTools.materials, 1, 3), 0.2f);
        FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack(TinkerTools.materials, 1, 40), new ItemStack(TinkerTools.materials, 1, 11), 0.2f);
        FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack(TinkerTools.materials, 1, 41), new ItemStack(TinkerTools.materials, 1, 5), 0.2f);
        FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack(TinkerTools.materials, 1, 42), new ItemStack(TinkerTools.materials, 1, 14), 0.2f);
    }

    public void oreRegistry() {
        OreDictionary.registerOre((String)"oreCobalt", (ItemStack)new ItemStack(oreSlag, 1, 1));
        OreDictionary.registerOre((String)"oreArdite", (ItemStack)new ItemStack(oreSlag, 1, 2));
        OreDictionary.registerOre((String)"oreCopper", (ItemStack)new ItemStack(oreSlag, 1, 3));
        OreDictionary.registerOre((String)"oreTin", (ItemStack)new ItemStack(oreSlag, 1, 4));
        OreDictionary.registerOre((String)"oreAluminum", (ItemStack)new ItemStack(oreSlag, 1, 5));
        OreDictionary.registerOre((String)"oreAluminium", (ItemStack)new ItemStack(oreSlag, 1, 5));
        OreDictionary.registerOre((String)"oreIron", (ItemStack)new ItemStack(oreGravel, 1, 0));
        OreDictionary.registerOre((String)"oreGold", (ItemStack)new ItemStack(oreGravel, 1, 1));
        OreDictionary.registerOre((String)"oreCobalt", (ItemStack)new ItemStack(oreGravel, 1, 5));
        OreDictionary.registerOre((String)"oreCopper", (ItemStack)new ItemStack(oreGravel, 1, 2));
        OreDictionary.registerOre((String)"oreTin", (ItemStack)new ItemStack(oreGravel, 1, 3));
        OreDictionary.registerOre((String)"oreAluminum", (ItemStack)new ItemStack(oreGravel, 1, 4));
        OreDictionary.registerOre((String)"oreAluminium", (ItemStack)new ItemStack(oreGravel, 1, 4));
        OreDictionary.registerOre((String)"blockCobalt", (ItemStack)new ItemStack(metalBlock, 1, 0));
        OreDictionary.registerOre((String)"blockArdite", (ItemStack)new ItemStack(metalBlock, 1, 1));
        OreDictionary.registerOre((String)"blockManyullyn", (ItemStack)new ItemStack(metalBlock, 1, 2));
        OreDictionary.registerOre((String)"blockCopper", (ItemStack)new ItemStack(metalBlock, 1, 3));
        OreDictionary.registerOre((String)"blockBronze", (ItemStack)new ItemStack(metalBlock, 1, 4));
        OreDictionary.registerOre((String)"blockTin", (ItemStack)new ItemStack(metalBlock, 1, 5));
        OreDictionary.registerOre((String)"blockAluminum", (ItemStack)new ItemStack(metalBlock, 1, 6));
        OreDictionary.registerOre((String)"blockAluminium", (ItemStack)new ItemStack(metalBlock, 1, 6));
        OreDictionary.registerOre((String)"blockAluminumBrass", (ItemStack)new ItemStack(metalBlock, 1, 7));
        OreDictionary.registerOre((String)"blockAluminiumBrass", (ItemStack)new ItemStack(metalBlock, 1, 7));
        OreDictionary.registerOre((String)"blockAlumite", (ItemStack)new ItemStack(metalBlock, 1, 8));
        OreDictionary.registerOre((String)"blockSteel", (ItemStack)new ItemStack(metalBlock, 1, 9));
        OreDictionary.registerOre((String)"blockEnder", (ItemStack)new ItemStack(metalBlock, 1, 10));
        OreDictionary.registerOre((String)"nuggetIron", (ItemStack)new ItemStack(oreBerries, 1, 0));
        OreDictionary.registerOre((String)"nuggetCopper", (ItemStack)new ItemStack(oreBerries, 1, 2));
        OreDictionary.registerOre((String)"nuggetTin", (ItemStack)new ItemStack(oreBerries, 1, 3));
        OreDictionary.registerOre((String)"nuggetAluminum", (ItemStack)new ItemStack(oreBerries, 1, 4));
        OreDictionary.registerOre((String)"nuggetAluminium", (ItemStack)new ItemStack(oreBerries, 1, 4));
        OreDictionary.registerOre((String)"nuggetGold", (ItemStack)new ItemStack(oreBerries, 1, 1));
        OreDictionary.registerOre((String)"oreberryIron", (ItemStack)new ItemStack(oreBerries, 1, 0));
        OreDictionary.registerOre((String)"oreberryCopper", (ItemStack)new ItemStack(oreBerries, 1, 2));
        OreDictionary.registerOre((String)"oreberryTin", (ItemStack)new ItemStack(oreBerries, 1, 3));
        OreDictionary.registerOre((String)"oreberryAluminum", (ItemStack)new ItemStack(oreBerries, 1, 4));
        OreDictionary.registerOre((String)"oreberryAluminium", (ItemStack)new ItemStack(oreBerries, 1, 4));
        OreDictionary.registerOre((String)"oreberryGold", (ItemStack)new ItemStack(oreBerries, 1, 1));
        OreDictionary.registerOre((String)"oreberryEssence", (ItemStack)new ItemStack(oreBerries, 1, 5));
        OreDictionary.registerOre((String)"orebushIron", (ItemStack)new ItemStack((Block)oreBerry, 1, 0));
        OreDictionary.registerOre((String)"orebushGold", (ItemStack)new ItemStack((Block)oreBerry, 1, 1));
        OreDictionary.registerOre((String)"orebushCopper", (ItemStack)new ItemStack((Block)oreBerry, 1, 2));
        OreDictionary.registerOre((String)"orebushTin", (ItemStack)new ItemStack((Block)oreBerry, 1, 3));
        OreDictionary.registerOre((String)"orebushAluminum", (ItemStack)new ItemStack((Block)oreBerrySecond, 1, 4));
        OreDictionary.registerOre((String)"orebushAluminium", (ItemStack)new ItemStack((Block)oreBerrySecond, 1, 4));
        OreDictionary.registerOre((String)"orebushEssence", (ItemStack)new ItemStack((Block)oreBerrySecond, 1, 5));
        OreDictionary.registerOre((String)"slabCloth", (ItemStack)new ItemStack(woolSlab1, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"slabCloth", (ItemStack)new ItemStack(woolSlab2, 1, Short.MAX_VALUE));
        TinkerWorld.ensureOreIsRegistered("stoneMossy", new ItemStack(Blocks.field_150417_aV, 1, 1));
        TinkerWorld.ensureOreIsRegistered("stoneMossy", new ItemStack(Blocks.field_150341_Y));
        OreDictionary.registerOre((String)"crafterWood", (ItemStack)new ItemStack(Blocks.field_150462_ai, 1));
        OreDictionary.registerOre((String)"craftingTableWood", (ItemStack)new ItemStack(Blocks.field_150462_ai, 1));
        OreDictionary.registerOre((String)"torchStone", (ItemStack)new ItemStack(stoneTorch));
        OreDictionary.registerOre((String)"slimeball", (ItemStack)new ItemStack(Items.field_151123_aH));
        OreDictionary.registerOre((String)"slimeball", (ItemStack)new ItemStack(strangeFood, 1, 0));
        OreDictionary.registerOre((String)"slimeball", (ItemStack)new ItemStack(strangeFood, 1, 1));
        OreDictionary.registerOre((String)"blockGlass", (ItemStack)new ItemStack(Blocks.field_150359_w));
        RecipeRemover.removeShapedRecipe((ItemStack)new ItemStack((Block)Blocks.field_150320_F));
        RecipeRemover.removeShapedRecipe((ItemStack)new ItemStack(Items.field_151064_bs));
        RecipeRemover.removeShapedRecipe((ItemStack)new ItemStack(Items.field_151058_ca));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack((Block)Blocks.field_150320_F), new Object[]{"slimeball", Blocks.field_150331_J}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(Items.field_151064_bs), new Object[]{"slimeball", Items.field_151065_br}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Items.field_151058_ca, 2), new Object[]{"ss ", "sS ", "  s", Character.valueOf('s'), Items.field_151007_F, Character.valueOf('S'), "slimeball"}));
    }

    public static void ensureOreIsRegistered(String oreName, ItemStack is) {
        int oreId = OreDictionary.getOreID((ItemStack)is);
        if (oreId == -1) {
            OreDictionary.registerOre((String)oreName, (ItemStack)is);
        }
    }

    public void addLoot() {
        Item[] partTypes;
        ChestGenHooks.getInfo((String)"dungeonChest").addItem(new WeightedRandomChestContent(new ItemStack(TinkerArmor.heartCanister, 1, 1), 1, 1, 5));
        ChestGenHooks.getInfo((String)"pyramidDesertyChest").addItem(new WeightedRandomChestContent(new ItemStack(TinkerArmor.heartCanister, 1, 1), 1, 1, 10));
        ChestGenHooks.getInfo((String)"pyramidJungleChest").addItem(new WeightedRandomChestContent(new ItemStack(TinkerArmor.heartCanister, 1, 1), 1, 1, 10));
        tinkerHouseChest = new ChestGenHooks("TinkerHouse", new WeightedRandomChestContent[0], 3, 27);
        tinkerHouseChest.addItem(new WeightedRandomChestContent(new ItemStack(TinkerArmor.heartCanister, 1, 1), 1, 1, 1));
        int[] validTypes = new int[]{0, 1, 2, 3, 4, 5, 6, 8, 9, 13, 14, 17};
        for (Item partType : partTypes = new Item[]{TinkerTools.pickaxeHead, TinkerTools.shovelHead, TinkerTools.hatchetHead, TinkerTools.binding, TinkerTools.swordBlade, TinkerTools.wideGuard, TinkerTools.handGuard, TinkerTools.crossbar, TinkerTools.knifeBlade, TinkerTools.frypanHead, TinkerTools.signHead, TinkerTools.chiselHead}) {
            for (int validType : validTypes) {
                tinkerHouseChest.addItem(new WeightedRandomChestContent(new ItemStack(partType, 1, validType), 1, 1, 15));
            }
        }
        tinkerHousePatterns = new ChestGenHooks("TinkerPatterns", new WeightedRandomChestContent[0], 5, 30);
        for (int i = 0; i < 13; ++i) {
            tinkerHousePatterns.addItem(new WeightedRandomChestContent(new ItemStack(TinkerTools.woodPattern, 1, i + 1), 1, 3, 20));
        }
        tinkerHousePatterns.addItem(new WeightedRandomChestContent(new ItemStack(TinkerTools.woodPattern, 1, 22), 1, 3, 40));
    }
}

