/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.client.renderer;

import java.util.List;
import mods.battlegear2.api.heraldry.IFlagHolder;
import mods.battlegear2.client.utils.ImageCache;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import org.lwjgl.opengl.GL11;

public class FlagPoleTileRenderer
extends TileEntitySpecialRenderer {
    public static int period = 250;
    public static int flag_sections = 16;

    public static double getZLevel(float x, float size, long time) {
        return Math.pow(x, 0.5 / (double)(size / 5.0f)) * Math.sin(Math.PI * (double)(-x / size * 3.0f + (float)(time % (long)period) / (0.5f * (float)period))) / 4.0;
    }

    public void func_147500_a(TileEntity tileentity, double d0, double d1, double d2, float f) {
        if (tileentity instanceof IFlagHolder) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
            int type = tileentity.func_145832_p();
            int side = ((IFlagHolder)tileentity).getOrientation(type);
            GL11.glPushMatrix();
            GL11.glTranslated((double)d0, (double)d1, (double)d2);
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            Block banner = tileentity.func_145838_q();
            if (banner instanceof BlockAir) {
                GL11.glPopMatrix();
                return;
            }
            float[] dims = new float[5];
            for (int i = 0; i < 5; ++i) {
                dims[i] = ((IFlagHolder)tileentity).getTextureDimensions(type, i);
            }
            switch (side) {
                case 0: {
                    this.renderYFlagPole(banner, f, type, dims);
                    this.renderYFlag((IFlagHolder)tileentity, d0, d1, d2, f, type);
                    break;
                }
                case 1: {
                    this.renderZFlagPole(banner, f, type, dims);
                    this.renderZFlag((IFlagHolder)tileentity, d0, d1, d2, f, type);
                    break;
                }
                case 2: {
                    GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glTranslatef((float)-1.0f, (float)0.0f, (float)0.0f);
                    this.renderZFlagPole(banner, f, type, dims);
                    this.renderZFlag((IFlagHolder)tileentity, d0, d1, d2, f, type);
                }
            }
            GL11.glPopMatrix();
        }
    }

    private void renderZFlag(IFlagHolder tileentity, double d0, double d1, double d2, float f, int type) {
        List<ItemStack> flags = tileentity.getFlags();
        if (flags.size() > 0) {
            Tessellator tess = Tessellator.field_78398_a;
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glDisable((int)2896);
            GL11.glMatrixMode((int)5890);
            GL11.glPushMatrix();
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            for (int flagIndex = 0; flagIndex < flags.size(); ++flagIndex) {
                ItemStack flag = flags.get(flagIndex);
                ImageCache.setTexture(flag);
                if (flag_sections == 0) {
                    tess.func_78382_b();
                    tess.func_78374_a(0.5, (double)((float)(-flagIndex + 1) - 0.125f), 0.0, 0.0, 0.001);
                    tess.func_78374_a(0.5, (double)((float)(-flagIndex) - 0.125f), 0.0, 1.0, 0.001);
                    tess.func_78374_a(0.5, (double)((float)(-flagIndex) - 0.125f), 1.0, 1.0, 0.999);
                    tess.func_78374_a(0.5, (double)((float)(-flagIndex + 1) - 0.125f), 1.0, 0.0, 0.999);
                    tess.func_78374_a(0.5, (double)((float)(-flagIndex + 1) - 0.125f), 1.0, 0.0, 0.999);
                    tess.func_78374_a(0.5, (double)((float)(-flagIndex) - 0.125f), 1.0, 1.0, 0.999);
                    tess.func_78374_a(0.5, (double)((float)(-flagIndex) - 0.125f), 0.0, 1.0, 0.001);
                    tess.func_78374_a(0.5, (double)((float)(-flagIndex + 1) - 0.125f), 0.0, 0.0, 0.001);
                    tess.func_78381_a();
                    continue;
                }
                long time = System.currentTimeMillis();
                for (int i = 0; i < flag_sections; ++i) {
                    tess.func_78382_b();
                    double z1 = FlagPoleTileRenderer.getZLevel((float)(flag_sections - i) / (float)flag_sections + (float)flagIndex, 5.0f, time) / 5.0;
                    double z2 = FlagPoleTileRenderer.getZLevel((float)(flag_sections - i + 1) / (float)flag_sections + (float)flagIndex, 5.0f, time) / 5.0;
                    tess.func_78374_a(0.5 + z1, (double)((float)(-flagIndex) + (float)(i + 1) / (float)flag_sections - 0.125f), 0.0, (double)((float)(i + 1) / (float)flag_sections), 0.999);
                    tess.func_78374_a(0.5 + z2, (double)((float)(-flagIndex) + (float)i / (float)flag_sections - 0.125f), 0.0, (double)((float)i / (float)flag_sections), 0.999);
                    tess.func_78374_a(0.5 + z2, (double)((float)(-flagIndex) + (float)i / (float)flag_sections - 0.125f), 1.0, (double)((float)i / (float)flag_sections), 0.001);
                    tess.func_78374_a(0.5 + z1, (double)((float)(-flagIndex) + (float)(i + 1) / (float)flag_sections - 0.125f), 1.0, (double)((float)(i + 1) / (float)flag_sections), 0.001);
                    tess.func_78374_a(0.5 + z1, (double)((float)(-flagIndex) + (float)(i + 1) / (float)flag_sections - 0.125f), 1.0, (double)((float)(i + 1) / (float)flag_sections), 0.001);
                    tess.func_78374_a(0.5 + z2, (double)((float)(-flagIndex) + (float)i / (float)flag_sections - 0.125f), 1.0, (double)((float)i / (float)flag_sections), 0.001);
                    tess.func_78374_a(0.5 + z2, (double)((float)(-flagIndex) + (float)i / (float)flag_sections - 0.125f), 0.0, (double)((float)i / (float)flag_sections), 0.999);
                    tess.func_78374_a(0.5 + z1, (double)((float)(-flagIndex) + (float)(i + 1) / (float)flag_sections - 0.125f), 0.0, (double)((float)(i + 1) / (float)flag_sections), 0.999);
                    tess.func_78381_a();
                }
            }
            GL11.glPopMatrix();
            GL11.glMatrixMode((int)5888);
            GL11.glEnable((int)2896);
            GL11.glDisable((int)3042);
        }
    }

    private void renderZFlagPole(Block banner, float f, int type, float[] dims) {
        IIcon icon = banner.func_149691_a(2, type);
        Tessellator tess = Tessellator.field_78398_a;
        tess.func_78382_b();
        tess.func_78374_a(0.5625, 0.875, 0.0, (double)icon.func_94214_a((double)dims[0]), (double)icon.func_94207_b((double)dims[0]));
        tess.func_78374_a(0.5625, 1.0, 0.0, (double)icon.func_94214_a((double)dims[1]), (double)icon.func_94207_b((double)dims[0]));
        tess.func_78374_a(0.5625, 1.0, 1.0, (double)icon.func_94214_a((double)dims[1]), (double)icon.func_94207_b((double)dims[4]));
        tess.func_78374_a(0.5625, 0.875, 1.0, (double)icon.func_94214_a((double)dims[0]), (double)icon.func_94207_b((double)dims[4]));
        tess.func_78381_a();
        tess.func_78382_b();
        tess.func_78374_a(0.4375, 0.875, 0.0, (double)icon.func_94214_a((double)dims[2]), (double)icon.func_94207_b((double)dims[0]));
        tess.func_78374_a(0.5625, 0.875, 0.0, (double)icon.func_94214_a((double)dims[1]), (double)icon.func_94207_b((double)dims[0]));
        tess.func_78374_a(0.5625, 0.875, 1.0, (double)icon.func_94214_a((double)dims[1]), (double)icon.func_94207_b((double)dims[4]));
        tess.func_78374_a(0.4375, 0.875, 1.0, (double)icon.func_94214_a((double)dims[2]), (double)icon.func_94207_b((double)dims[4]));
        tess.func_78381_a();
        tess.func_78382_b();
        tess.func_78374_a(0.4375, 0.875, 1.0, (double)icon.func_94214_a((double)dims[2]), (double)icon.func_94207_b((double)dims[4]));
        tess.func_78374_a(0.4375, 1.0, 1.0, (double)icon.func_94214_a((double)dims[3]), (double)icon.func_94207_b((double)dims[4]));
        tess.func_78374_a(0.4375, 1.0, 0.0, (double)icon.func_94214_a((double)dims[3]), (double)icon.func_94207_b((double)dims[0]));
        tess.func_78374_a(0.4375, 0.875, 0.0, (double)icon.func_94214_a((double)dims[2]), (double)icon.func_94207_b((double)dims[0]));
        tess.func_78381_a();
        tess.func_78382_b();
        tess.func_78374_a(0.4375, 1.0, 1.0, (double)icon.func_94214_a((double)dims[2]), (double)icon.func_94207_b((double)dims[4]));
        tess.func_78374_a(0.5625, 1.0, 1.0, (double)icon.func_94214_a((double)dims[1]), (double)icon.func_94207_b((double)dims[4]));
        tess.func_78374_a(0.5625, 1.0, 0.0, (double)icon.func_94214_a((double)dims[1]), (double)icon.func_94207_b((double)dims[0]));
        tess.func_78374_a(0.4375, 1.0, 0.0, (double)icon.func_94214_a((double)dims[2]), (double)icon.func_94207_b((double)dims[0]));
        tess.func_78381_a();
        icon = banner.func_149691_a(0, type);
        tess.func_78382_b();
        tess.func_78374_a(0.4375, 1.0, 0.0, (double)icon.func_94214_a(10.0), (double)icon.func_94207_b(10.0));
        tess.func_78374_a(0.5625, 1.0, 0.0, (double)icon.func_94214_a(6.0), (double)icon.func_94207_b(10.0));
        tess.func_78374_a(0.5625, 0.875, 0.0, (double)icon.func_94214_a(6.0), (double)icon.func_94207_b(6.0));
        tess.func_78374_a(0.4375, 0.875, 0.0, (double)icon.func_94214_a(10.0), (double)icon.func_94207_b(6.0));
        tess.func_78381_a();
        tess.func_78382_b();
        tess.func_78374_a(0.4375, 0.875, 1.0, (double)icon.func_94214_a(10.0), (double)icon.func_94207_b(6.0));
        tess.func_78374_a(0.5625, 0.875, 1.0, (double)icon.func_94214_a(6.0), (double)icon.func_94207_b(6.0));
        tess.func_78374_a(0.5625, 1.0, 1.0, (double)icon.func_94214_a(6.0), (double)icon.func_94207_b(10.0));
        tess.func_78374_a(0.4375, 1.0, 1.0, (double)icon.func_94214_a(10.0), (double)icon.func_94207_b(10.0));
        tess.func_78381_a();
    }

    private void renderYFlag(IFlagHolder tileentity, double d0, double d1, double d2, float f, int type) {
        List<ItemStack> flags = tileentity.getFlags();
        if (flags.size() > 0) {
            Tessellator tess = Tessellator.field_78398_a;
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glDisable((int)2896);
            for (int flagIndex = 0; flagIndex < flags.size(); ++flagIndex) {
                ItemStack flag = flags.get(flagIndex);
                ImageCache.setTexture(flag);
                if (flag_sections == 0) {
                    tess.func_78382_b();
                    tess.func_78374_a((double)(0.4375f - (float)flagIndex), 0.0, 0.5, 0.0, 0.999);
                    tess.func_78374_a((double)(0.4375f - (float)flagIndex - 1.0f), 0.0, 0.5, 1.0025, 0.999);
                    tess.func_78374_a((double)(0.4375f - (float)flagIndex - 1.0f), 1.0, 0.5, 1.0025, 0.001);
                    tess.func_78374_a((double)(0.4375f - (float)flagIndex), 1.0, 0.5, 0.0, 0.001);
                    tess.func_78374_a((double)(0.4375f - (float)flagIndex), 1.0, 0.5, 0.0, 0.001);
                    tess.func_78374_a((double)(0.4375f - (float)flagIndex - 1.0f), 1.0, 0.5, 1.0025, 0.001);
                    tess.func_78374_a((double)(0.4375f - (float)flagIndex - 1.0f), 0.0, 0.5, 1.0025, 0.999);
                    tess.func_78374_a((double)(0.4375f - (float)flagIndex), 0.0, 0.5, 0.0, 0.999);
                    tess.func_78381_a();
                    continue;
                }
                long time = System.currentTimeMillis();
                for (int i = 0; i < flag_sections; ++i) {
                    tess.func_78382_b();
                    double z1 = FlagPoleTileRenderer.getZLevel((float)i / (float)flag_sections + (float)flagIndex, 3.0f, time);
                    double z2 = FlagPoleTileRenderer.getZLevel((float)(i + 1) / (float)flag_sections + (float)flagIndex, 3.0f, time);
                    tess.func_78374_a((double)(0.4375f - (float)i / (float)flag_sections - (float)flagIndex), 0.0, 0.5 + z1, (double)((float)i / (float)flag_sections), 0.999);
                    tess.func_78374_a((double)(0.4375f - (float)(i + 1) / (float)flag_sections - (float)flagIndex), 0.0, 0.5 + z2, (double)((float)(i + 1) / (float)flag_sections), 0.999);
                    tess.func_78374_a((double)(0.4375f - (float)(i + 1) / (float)flag_sections - (float)flagIndex), 1.0025, 0.5 + z2, (double)((float)(i + 1) / (float)flag_sections), 0.001);
                    tess.func_78374_a((double)(0.4375f - (float)i / (float)flag_sections - (float)flagIndex), 1.0025, 0.5 + z1, (double)((float)i / (float)flag_sections), 0.001);
                    tess.func_78374_a((double)(0.4375f - (float)i / (float)flag_sections - (float)flagIndex), 1.0025, 0.5 + z1, (double)((float)i / (float)flag_sections), 0.001);
                    tess.func_78374_a((double)(0.4375f - (float)(i + 1) / (float)flag_sections - (float)flagIndex), 1.0025, 0.5 + z2, (double)((float)(i + 1) / (float)flag_sections), 0.001);
                    tess.func_78374_a((double)(0.4375f - (float)(i + 1) / (float)flag_sections - (float)flagIndex), 0.0, 0.5 + z2, (double)((float)(i + 1) / (float)flag_sections), 0.999);
                    tess.func_78374_a((double)(0.4375f - (float)i / (float)flag_sections - (float)flagIndex), 0.0, 0.5 + z1, (double)((float)i / (float)flag_sections), 0.999);
                    tess.func_78381_a();
                }
            }
            GL11.glEnable((int)2896);
            GL11.glDisable((int)3042);
        }
    }

    private void renderYFlagPole(Block banner, float f, int type, float[] dims) {
        IIcon icon = banner.func_149691_a(2, type);
        Tessellator tess = Tessellator.field_78398_a;
        tess.func_78382_b();
        tess.func_78374_a(0.4375, 0.0, 0.5625, (double)icon.func_94214_a((double)dims[0]), (double)icon.func_94207_b((double)dims[0]));
        tess.func_78374_a(0.5625, 0.0, 0.5625, (double)icon.func_94214_a((double)dims[1]), (double)icon.func_94207_b((double)dims[0]));
        tess.func_78374_a(0.5625, 1.0, 0.5625, (double)icon.func_94214_a((double)dims[1]), (double)icon.func_94207_b((double)dims[4]));
        tess.func_78374_a(0.4375, 1.0, 0.5625, (double)icon.func_94214_a((double)dims[0]), (double)icon.func_94207_b((double)dims[4]));
        tess.func_78381_a();
        tess.func_78382_b();
        tess.func_78374_a(0.5625, 0.0, 0.5625, (double)icon.func_94214_a((double)dims[1]), (double)icon.func_94207_b((double)dims[0]));
        tess.func_78374_a(0.5625, 0.0, 0.4375, (double)icon.func_94214_a((double)dims[2]), (double)icon.func_94207_b((double)dims[0]));
        tess.func_78374_a(0.5625, 1.0, 0.4375, (double)icon.func_94214_a((double)dims[2]), (double)icon.func_94207_b((double)dims[4]));
        tess.func_78374_a(0.5625, 1.0, 0.5625, (double)icon.func_94214_a((double)dims[1]), (double)icon.func_94207_b((double)dims[4]));
        tess.func_78381_a();
        tess.func_78382_b();
        tess.func_78374_a(0.5625, 0.0, 0.4375, (double)icon.func_94214_a((double)dims[2]), (double)icon.func_94207_b((double)dims[0]));
        tess.func_78374_a(0.4375, 0.0, 0.4375, (double)icon.func_94214_a((double)dims[3]), (double)icon.func_94207_b((double)dims[0]));
        tess.func_78374_a(0.4375, 1.0, 0.4375, (double)icon.func_94214_a((double)dims[3]), (double)icon.func_94207_b((double)dims[4]));
        tess.func_78374_a(0.5625, 1.0, 0.4375, (double)icon.func_94214_a((double)dims[2]), (double)icon.func_94207_b((double)dims[4]));
        tess.func_78381_a();
        tess.func_78382_b();
        tess.func_78374_a(0.4375, 0.0, 0.4375, (double)icon.func_94214_a((double)dims[3]), (double)icon.func_94207_b((double)dims[0]));
        tess.func_78374_a(0.4375, 0.0, 0.5625, (double)icon.func_94214_a((double)dims[4]), (double)icon.func_94207_b((double)dims[0]));
        tess.func_78374_a(0.4375, 1.0, 0.5625, (double)icon.func_94214_a((double)dims[4]), (double)icon.func_94207_b((double)dims[4]));
        tess.func_78374_a(0.4375, 1.0, 0.4375, (double)icon.func_94214_a((double)dims[3]), (double)icon.func_94207_b((double)dims[4]));
        tess.func_78381_a();
        icon = banner.func_149691_a(0, type);
        tess.func_78382_b();
        tess.func_78374_a(0.4375, 0.0, 0.4375, (double)icon.func_94214_a(6.0), (double)icon.func_94207_b(6.0));
        tess.func_78374_a(0.5625, 0.0, 0.4375, (double)icon.func_94214_a(10.0), (double)icon.func_94207_b(6.0));
        tess.func_78374_a(0.5625, 0.0, 0.5625, (double)icon.func_94214_a(10.0), (double)icon.func_94207_b(10.0));
        tess.func_78374_a(0.4375, 0.0, 0.5625, (double)icon.func_94214_a(6.0), (double)icon.func_94207_b(10.0));
        tess.func_78381_a();
        tess.func_78382_b();
        tess.func_78374_a(0.5625, 1.0, 0.4375, (double)icon.func_94214_a(6.0), (double)icon.func_94207_b(6.0));
        tess.func_78374_a(0.4375, 1.0, 0.4375, (double)icon.func_94214_a(10.0), (double)icon.func_94207_b(6.0));
        tess.func_78374_a(0.4375, 1.0, 0.5625, (double)icon.func_94214_a(10.0), (double)icon.func_94207_b(10.0));
        tess.func_78374_a(0.5625, 1.0, 0.5625, (double)icon.func_94214_a(6.0), (double)icon.func_94207_b(10.0));
        tess.func_78381_a();
    }
}

