/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.api.quiver;

import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import mods.battlegear2.api.ISensible;
import mods.battlegear2.api.quiver.IArrowFireHandler;
import mods.battlegear2.api.quiver.IQuiverSelection;
import mods.battlegear2.api.quiver.ISpecialBow;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import xonin.backhand.api.core.BackhandUtils;

public class QuiverArrowRegistry {
    private static Map<Item, Class<? extends EntityArrow>> itemToClasses = new HashMap<Item, Class<? extends EntityArrow>>();
    private static Map<ItemStack, Class<? extends EntityArrow>> stackToClasses = new TreeMap<ItemStack, Class<? extends EntityArrow>>(new StackComparator());
    private static Map<Class<? extends EntityArrow>, ItemStack> classToStacks = new HashMap<Class<? extends EntityArrow>, ItemStack>();
    private static List<IQuiverSelection> quiverSelectors = new ArrayList<IQuiverSelection>();
    private static List<IArrowFireHandler> fireHandlers = new ArrayList<IArrowFireHandler>();

    public static void addArrowToRegistry(Item itemId, Class<? extends EntityArrow> entityArrow) {
        itemToClasses.put(itemId, entityArrow);
        if (entityArrow != null) {
            classToStacks.put(entityArrow, new ItemStack(itemId));
        }
    }

    public static void addArrowToRegistry(Item itemId, int itemMetadata, Class<? extends EntityArrow> entityArrow) {
        ItemStack stack = new ItemStack(itemId, 1, itemMetadata);
        QuiverArrowRegistry.addArrowToRegistry(stack, entityArrow);
    }

    public static void addArrowToRegistry(ItemStack stack) {
        QuiverArrowRegistry.addArrowToRegistry(stack, null);
    }

    public static void addArrowToRegistry(ItemStack stack, Class<? extends EntityArrow> entityArrow) {
        ItemStack st = stack.func_77946_l();
        st.field_77994_a = 1;
        stackToClasses.put(st, entityArrow);
        if (entityArrow != null) {
            classToStacks.put(entityArrow, st);
        }
    }

    public static boolean addQuiverSelection(IQuiverSelection handler) {
        if (handler == null) {
            return false;
        }
        quiverSelectors.add(handler);
        return true;
    }

    public static boolean addArrowFireHandler(IArrowFireHandler handler) {
        if (handler == null) {
            return false;
        }
        fireHandlers.add(handler);
        return true;
    }

    public static ItemStack getArrowContainer(EntityPlayer entityPlayer) {
        ItemStack temp;
        ItemStack bow = entityPlayer.func_71045_bC();
        if (bow != null && (temp = QuiverArrowRegistry.getArrowContainer(bow, entityPlayer)) != null) {
            return temp;
        }
        bow = BackhandUtils.getOffhandItem((EntityPlayer)entityPlayer);
        return bow != null ? QuiverArrowRegistry.getArrowContainer(bow, entityPlayer) : null;
    }

    public static ItemStack getArrowContainer(ItemStack bow, EntityPlayer entityPlayer) {
        for (IQuiverSelection handler : quiverSelectors) {
            ItemStack temp = handler.getQuiverFor(bow, entityPlayer);
            if (temp == null) continue;
            return temp;
        }
        return null;
    }

    public static EntityArrow getArrowType(ItemStack arrow, World world, EntityPlayer player, float charge) {
        List<IArrowFireHandler> handlers = QuiverArrowRegistry.getFireHandlers(QuiverArrowRegistry.getSpecialBow(player), arrow, player);
        for (IArrowFireHandler handler : handlers) {
            EntityArrow result;
            if (!handler.canFireArrow(arrow, world, player, charge) || (result = handler.getFiredArrow(arrow, world, player, charge)) == null) continue;
            return result;
        }
        return null;
    }

    private static ItemStack getSpecialBow(EntityPlayer player) {
        ItemStack bow = player.func_70694_bm();
        if (bow != null && bow.func_77973_b() instanceof ISpecialBow) {
            return bow;
        }
        return BackhandUtils.getOffhandItem((EntityPlayer)player);
    }

    public static List<IArrowFireHandler> getFireHandlers(ItemStack bow, ItemStack arrow, EntityPlayer player) {
        List<IArrowFireHandler> handlers;
        if (bow != null && bow.func_77973_b() instanceof ISpecialBow && (handlers = ((ISpecialBow)bow.func_77973_b()).getFireHandlers(arrow, bow, player)) != null) {
            return handlers;
        }
        return fireHandlers;
    }

    public static Class<? extends EntityArrow> getArrowClass(ItemStack stack) {
        Class<? extends EntityArrow> clazz = stackToClasses.get(stack);
        if (clazz != null) {
            return clazz;
        }
        return itemToClasses.get(stack.func_77973_b());
    }

    public static ItemStack getItem(Class<? extends EntityArrow> clazz) {
        ItemStack temp = classToStacks.get(clazz);
        if (temp == null) {
            return new ItemStack(Items.field_151032_g);
        }
        return temp.func_77946_l();
    }

    public static boolean isKnownArrow(ItemStack test) {
        return QuiverArrowRegistry.isKnownArrow(test, true) || QuiverArrowRegistry.isKnownArrow(test, false);
    }

    public static boolean isKnownArrow(ItemStack test, boolean compareFullStack) {
        return test != null && (compareFullStack ? stackToClasses.containsKey(test) : itemToClasses.containsKey(test.func_77973_b()));
    }

    public static boolean isKnownArrow(ItemStack test, Iterable<ISensible<ItemStack>> senses) {
        ISensible.Filter<ItemStack> predicate = new ISensible.Filter<ItemStack>(test, senses);
        return Iterators.any(stackToClasses.keySet().iterator(), predicate);
    }

    static {
        fireHandlers.add(new DefaultArrowFire());
    }

    static class StackComparator
    implements Comparator<ItemStack> {
        StackComparator() {
        }

        @Override
        public int compare(ItemStack stack, ItemStack stack2) {
            if (stack == stack2) {
                return 0;
            }
            int idDiff = stack.func_77960_j() - stack2.func_77960_j();
            if (idDiff != 0) {
                return idDiff;
            }
            idDiff = Item.func_150891_b((Item)stack.func_77973_b()) - Item.func_150891_b((Item)stack2.func_77973_b());
            if (idDiff != 0) {
                return idDiff;
            }
            int tag = 0;
            if (stack.func_77942_o()) {
                tag = stack.func_77978_p().hashCode();
            }
            int tag2 = 0;
            if (stack2.func_77942_o()) {
                tag2 = stack2.func_77978_p().hashCode();
            }
            return tag - tag2;
        }
    }

    public static class DefaultArrowFire
    implements IArrowFireHandler {
        @Override
        public boolean canFireArrow(ItemStack arrow, World world, EntityPlayer player, float charge) {
            return QuiverArrowRegistry.isKnownArrow(arrow);
        }

        @Override
        public EntityArrow getFiredArrow(ItemStack arrow, World world, EntityPlayer player, float charge) {
            Class<? extends EntityArrow> clazz = QuiverArrowRegistry.getArrowClass(arrow);
            if (clazz != null) {
                try {
                    return clazz.getConstructor(World.class, EntityLivingBase.class, Float.TYPE).newInstance(player.field_70170_p, player, Float.valueOf(charge));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }
    }
}

