/*
 * Decompiled with CFR 0.152.
 */
package tectech.mechanics.enderStorage;

import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import tectech.TecTech;

public class EnderFluidContainer
implements IFluidHandler,
Serializable {
    private static final long serialVersionUID = 2L;
    private static final int SERIALIZE_TYPE_WITH_NBT = 0;
    private static final int SERIALIZE_TYPE_WITHOUT_NBT = 1;
    private static final int SERIALIZE_TYPE_NULL = 2;
    private static final int CAPACITY = 64000;
    private transient FluidStack fluidStack;

    private FluidStack getFluidStack() {
        return this.fluidStack;
    }

    private void setFluidStack(FluidStack fluidStack) {
        this.fluidStack = fluidStack;
    }

    public int fill(ForgeDirection side, FluidStack fluidStackIn, boolean doFill) {
        int filledFluid = 0;
        FluidStack fluidStackStored = this.getFluidStack();
        if (fluidStackIn != null) {
            if (fluidStackStored == null) {
                fluidStackStored = fluidStackIn.copy();
                fluidStackStored.amount = 0;
            }
            if (fluidStackStored.amount < 64000 && fluidStackIn.isFluidEqual(fluidStackStored)) {
                filledFluid = Math.min(64000 - fluidStackStored.amount, fluidStackIn.amount);
                if (doFill) {
                    fluidStackStored.amount += filledFluid;
                    this.setFluidStack(fluidStackStored);
                }
            }
        }
        return filledFluid;
    }

    public FluidStack drain(ForgeDirection side, FluidStack fluidStack, boolean doDrain) {
        FluidStack fluidStackOutput = null;
        if (fluidStack != null && fluidStack.isFluidEqual(this.getFluidStack())) {
            fluidStackOutput = this.drain(side, fluidStack.amount, doDrain);
        }
        return fluidStackOutput;
    }

    public FluidStack drain(ForgeDirection side, int amount, boolean doDrain) {
        FluidStack fluidStackOutput = null;
        FluidStack fluidStackStored = this.getFluidStack();
        if (fluidStackStored != null && fluidStackStored.amount > 0) {
            int drainedFluid = Math.min(fluidStackStored.amount, amount);
            fluidStackOutput = fluidStackStored.copy();
            fluidStackOutput.amount = drainedFluid;
            if (doDrain) {
                fluidStackStored.amount -= drainedFluid;
                if (fluidStackStored.amount == 0) {
                    fluidStackStored = null;
                }
                this.setFluidStack(fluidStackStored);
            }
        }
        return fluidStackOutput;
    }

    public boolean canFill(ForgeDirection forgeDirection, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection forgeDirection, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection forgeDirection) {
        return new FluidTankInfo[]{new FluidTankInfo(this.getFluidStack(), 64000)};
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.fluidStack != null) {
            out.writeByte(this.fluidStack.tag != null ? 0 : 1);
            if (this.fluidStack.tag != null) {
                CompressedStreamTools.func_74800_a((NBTTagCompound)this.fluidStack.tag, (DataOutput)out);
            }
            out.writeUTF(this.fluidStack.getFluid().getName());
            out.writeInt(this.fluidStack.amount);
        } else {
            out.writeByte(2);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        byte type = in.readByte();
        NBTTagCompound tag = null;
        switch (type) {
            case 0: {
                tag = CompressedStreamTools.func_74794_a((DataInputStream)new DataInputStream(in));
            }
            case 1: {
                this.fluidStack = FluidRegistry.getFluidStack((String)in.readUTF(), (int)in.readInt());
                break;
            }
            case 2: {
                this.fluidStack = null;
                break;
            }
            default: {
                TecTech.LOGGER.error((Object)("Something very wrong... got a fluid container with state " + type));
                this.fluidStack = null;
            }
        }
        if (this.fluidStack != null) {
            this.fluidStack.tag = tag;
        }
    }

    public NBTTagCompound save() {
        NBTTagCompound data = new NBTTagCompound();
        if (this.fluidStack != null) {
            this.fluidStack.writeToNBT(data);
        }
        return data;
    }

    public static EnderFluidContainer load(NBTTagCompound data) {
        EnderFluidContainer container = new EnderFluidContainer();
        container.fluidStack = !"".equals(data.func_74779_i("FluidName")) ? FluidStack.loadFluidStackFromNBT((NBTTagCompound)data) : null;
        return container;
    }
}

