/*
 * Decompiled with CFR 0.152.
 */
package gtnhlanth.common.tileentity;

import bartworks.common.loaders.ItemRegistry;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEEnhancedMultiBlockBase;
import gregtech.api.metatileentity.implementations.MTEHatchEnergy;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.extensions.ArrayExt;
import gregtech.common.misc.GTStructureChannels;
import gtnhlanth.api.recipe.LanthanidesRecipeMaps;
import gtnhlanth.common.beamline.BeamInformation;
import gtnhlanth.common.beamline.Particle;
import gtnhlanth.common.hatch.MTEBusInputFocus;
import gtnhlanth.common.hatch.MTEHatchInputBeamline;
import gtnhlanth.common.register.LanthItemList;
import gtnhlanth.common.tileentity.recipe.beamline.TargetChamberMetadata;
import gtnhlanth.util.DescTextLocalization;
import java.util.ArrayList;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;

public class MTETargetChamber
extends MTEEnhancedMultiBlockBase<MTETargetChamber>
implements ISurvivalConstructable {
    private static final IStructureDefinition<MTETargetChamber> STRUCTURE_DEFINITION;
    private final ArrayList<MTEHatchInputBeamline> mInputBeamline = new ArrayList();
    private final ArrayList<MTEBusInputFocus> mInputFocus = new ArrayList();
    private static final int CASING_INDEX_FRONT;
    private static final int CASING_INDEX_CENTRE = 1662;
    private GTRecipe lastRecipe;

    private boolean addGlass(Block block, int meta) {
        return block == ItemRegistry.bw_glasses[0];
    }

    private boolean addBeamLineInputHatch(IGregTechTileEntity te, int casingIndex) {
        if (te == null) {
            return false;
        }
        IMetaTileEntity mte = te.getMetaTileEntity();
        if (mte == null) {
            return false;
        }
        if (mte instanceof MTEHatchInputBeamline) {
            return this.mInputBeamline.add((MTEHatchInputBeamline)mte);
        }
        return false;
    }

    private boolean addFocusInputHatch(IGregTechTileEntity te, int casingIndex) {
        if (te == null) {
            return false;
        }
        IMetaTileEntity mte = te.getMetaTileEntity();
        if (mte == null) {
            return false;
        }
        if (mte instanceof MTEBusInputFocus) {
            return this.mInputFocus.add((MTEBusInputFocus)mte);
        }
        return false;
    }

    public MTETargetChamber(int id, String name, String nameRegional) {
        super(id, name, nameRegional);
    }

    public MTETargetChamber(String name) {
        super(name);
    }

    @Override
    public boolean supportsPowerPanel() {
        return false;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity te) {
        return new MTETargetChamber(this.mName);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean active, boolean redstoneLevel) {
        if (side == facing) {
            if (active) {
                return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][47], TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_OIL_CRACKER_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_OIL_CRACKER_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][47], TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_OIL_CRACKER).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_OIL_CRACKER_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][47]};
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Collision Chamber").addInfo("Hitting things with other things").addInfo(DescTextLocalization.BEAMLINE_SCANNER_INFO).beginStructureBlock(5, 5, 6, true).addController("Front bottom").addCasingInfoExactly("Grate Machine Casing", 29, false).addCasingInfoExactly("Shielded Accelerator Casing", 28, false).addCasingInfoExactly("Any Tiered Glass", 16, false).addCasingInfoExactly(LanthItemList.SHIELDED_ACCELERATOR_GLASS.func_149732_F(), 34, false).addCasingInfoExactly(LanthItemList.TARGET_RECEPTACLE_CASING.func_149732_F(), 4, false).addCasingInfoExactly(LanthItemList.FOCUS_MANIPULATION_CASING.func_149732_F(), 4, false).addCasingInfoExactly(LanthItemList.FOCUS_HOLDER.func_149732_F(), 1, false).addCasingInfoExactly(LanthItemList.TARGET_HOLDER.func_149732_F(), 1, false).addOtherStructurePart("Focus Input Bus", DescTextLocalization.addDotText(1)).addMaintenanceHatch(DescTextLocalization.addDotText(2)).addEnergyHatch(DescTextLocalization.addDotText(2)).addInputBus(DescTextLocalization.addDotText(3)).addOutputBus(DescTextLocalization.addDotText(4)).addOtherStructurePart("Beamline Input Hatch", DescTextLocalization.addDotText(5)).addSubChannelUsage(GTStructureChannels.BOROGLASS).toolTipFinisher(new String[0]);
        return tt;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece("base", stackSize, hintsOnly, 2, 4, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivalBuildPiece("base", stackSize, 2, 4, 0, elementBudget, env, false, true);
    }

    @Override
    public IStructureDefinition<MTETargetChamber> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return LanthanidesRecipeMaps.targetChamberRecipes;
    }

    @Override
    @NotNull
    public CheckRecipeResult checkProcessing() {
        ItemStack[] itemOutputArray;
        ArrayList<ItemStack> tItems = this.getStoredInputs();
        ArrayList<ItemStack> tFocusItemArray = this.getFocusItemStack();
        ArrayList<ItemStack> tItemsWithFocusItem = new ArrayList<ItemStack>();
        if (tFocusItemArray != null) {
            ItemStack tFocusItemZeroDamage = tFocusItemArray.get(0).func_77946_l();
            tFocusItemZeroDamage.func_77964_b(0);
            tItemsWithFocusItem.add(tFocusItemZeroDamage);
        }
        tItemsWithFocusItem.addAll(tItems);
        ItemStack[] tItemsWithFocusItemArray = tItemsWithFocusItem.toArray(new ItemStack[0]);
        long tVoltageActual = GTValues.VP[(int)this.getInputVoltageTier()];
        GTRecipe tRecipe = LanthanidesRecipeMaps.targetChamberRecipes.findRecipeQuery().items(tItemsWithFocusItemArray).voltage(tVoltageActual).filter(recipe -> {
            TargetChamberMetadata metadata = recipe.getMetadata(LanthanidesRecipeMaps.TARGET_CHAMBER_METADATA);
            if (metadata == null) {
                return false;
            }
            BeamInformation recipeInInfo = this.getInputInformation();
            int particle = metadata.particleID;
            if (recipeInInfo != null) {
                return particle == recipeInInfo.getParticleId() && !(recipeInInfo.getEnergy() < metadata.minEnergy) && !(recipeInInfo.getEnergy() > metadata.maxEnergy);
            }
            return false;
        }).cachedRecipe(this.lastRecipe).find();
        if (tRecipe == null) {
            return CheckRecipeResultRegistry.NO_RECIPE;
        }
        TargetChamberMetadata metadata = tRecipe.getMetadata(LanthanidesRecipeMaps.TARGET_CHAMBER_METADATA);
        if (metadata == null) {
            return CheckRecipeResultRegistry.NO_RECIPE;
        }
        BeamInformation inputInfo = this.getInputInformation();
        if (inputInfo == null) {
            return CheckRecipeResultRegistry.NO_RECIPE;
        }
        float inputEnergy = inputInfo.getEnergy();
        float inputRate = inputInfo.getRate();
        int inputParticle = inputInfo.getParticleId();
        float inputFocus = inputInfo.getFocus();
        if (inputEnergy < metadata.minEnergy || inputEnergy > metadata.maxEnergy) {
            return CheckRecipeResultRegistry.NO_RECIPE;
        }
        if (inputFocus < metadata.minFocus) {
            return CheckRecipeResultRegistry.NO_RECIPE;
        }
        if (inputParticle != metadata.particleID) {
            return CheckRecipeResultRegistry.NO_RECIPE;
        }
        if (metadata.focusItem != null && tFocusItemArray != null && tFocusItemArray.get(0) != null && metadata.focusItem.func_77973_b() != tFocusItemArray.get(0).func_77973_b()) {
            return CheckRecipeResultRegistry.NO_RECIPE;
        }
        float progressTime = (float)metadata.amount / inputRate * 5.0f * 20.0f;
        int batchAmount = 1;
        if (progressTime < 1.0f) {
            batchAmount = (int)Math.round(1.0 / (double)progressTime);
            if (metadata.focusItem != null) {
                int maskLimit = 0;
                if (tFocusItemArray != null) {
                    for (ItemStack focus : tFocusItemArray) {
                        maskLimit += focus.func_77958_k() - focus.func_77960_j() + 1;
                    }
                }
                if (batchAmount > maskLimit) {
                    batchAmount = maskLimit;
                }
                progressTime = 1.0f;
                if (batchAmount < maskLimit) {
                    int ratio = Math.min(maskLimit / batchAmount, 128);
                    batchAmount *= ratio;
                    progressTime = ratio;
                }
            }
        }
        this.mMaxProgresstime = (int)progressTime;
        if (this.mMaxProgresstime == 0x7FFFFFFE && this.mEUt == 0x7FFFFFFE) {
            return CheckRecipeResultRegistry.NO_RECIPE;
        }
        double maxParallel = tRecipe.maxParallelCalculatedByInputs(batchAmount, GTValues.emptyFluidStackArray, tItemsWithFocusItemArray);
        if ((double)batchAmount > maxParallel) {
            batchAmount = (int)maxParallel;
        }
        if (!tRecipe.equals(this.lastRecipe)) {
            this.lastRecipe = tRecipe;
        }
        tRecipe.consumeInput(batchAmount, GTValues.emptyFluidStackArray, tItemsWithFocusItemArray);
        for (ItemStack stack : itemOutputArray = ArrayExt.copyItemsIfNonEmpty(tRecipe.mOutputs)) {
            stack.field_77994_a *= batchAmount;
        }
        this.mOutputItems = itemOutputArray;
        this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
        this.mEfficiencyIncrease = 10000;
        this.mEUt = (int)(-tVoltageActual);
        if (this.mEUt > 0) {
            this.mEUt = -this.mEUt;
        }
        int focusDurabilityDepletion = batchAmount;
        if (tFocusItemArray != null) {
            for (ItemStack stack : tFocusItemArray) {
                if (focusDurabilityDepletion + stack.func_77960_j() >= stack.func_77958_k() + 1) {
                    focusDurabilityDepletion -= stack.func_77958_k() + 1 - stack.func_77960_j();
                    --stack.field_77994_a;
                    continue;
                }
                stack.func_77964_b(stack.func_77960_j() + focusDurabilityDepletion);
                break;
            }
        }
        this.updateSlots();
        return CheckRecipeResultRegistry.SUCCESSFUL;
    }

    @Nullable
    private BeamInformation getInputInformation() {
        Iterator<MTEHatchInputBeamline> iterator = this.mInputBeamline.iterator();
        if (iterator.hasNext()) {
            MTEHatchInputBeamline in = iterator.next();
            if (in.dataPacket == null) {
                return new BeamInformation(0.0f, 0, 0, 0.0f);
            }
            return (BeamInformation)in.dataPacket.getContent();
        }
        return null;
    }

    @Nullable
    private ArrayList<ItemStack> getFocusItemStack() {
        if (this.mInputFocus.isEmpty()) {
            return null;
        }
        if (this.mInputFocus.get(0).getContentUsageSlots().isEmpty()) {
            return null;
        }
        return this.mInputFocus.get(0).getContentUsageSlots();
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity arg0, ItemStack arg1) {
        this.mInputBeamline.clear();
        this.mInputFocus.clear();
        this.lastRecipe = null;
        if (!this.checkPiece("base", 2, 4, 0)) {
            return false;
        }
        return this.mInputBeamline.size() == 1 && this.mMaintenanceHatches.size() == 1 && this.mInputBusses.size() == 1 && this.mOutputBusses.size() == 1 && this.mInputFocus.size() == 1;
    }

    @Override
    public String[] getStructureDescription(ItemStack arg0) {
        return DescTextLocalization.addText("TargetChamber.hint", 13);
    }

    @Override
    public String[] getInfoData() {
        long storedEnergy = 0L;
        long maxEnergy = 0L;
        for (MTEHatchEnergy tHatch : this.mEnergyHatches) {
            if (!tHatch.isValid()) continue;
            storedEnergy += tHatch.getBaseMetaTileEntity().getStoredEU();
            maxEnergy += tHatch.getBaseMetaTileEntity().getEUCapacity();
        }
        BeamInformation information = this.getInputInformation();
        if (information == null) {
            information = new BeamInformation(0.0f, 0, 0, 0.0f);
        }
        return new String[]{StatCollector.func_74838_a((String)"GT5U.multiblock.Progress") + ": " + EnumChatFormatting.GREEN + GTUtility.formatNumbers(this.mProgresstime / 20) + EnumChatFormatting.RESET + " s / " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers(this.mMaxProgresstime / 20) + EnumChatFormatting.RESET + " s", StatCollector.func_74838_a((String)"GT5U.multiblock.energy") + ": " + EnumChatFormatting.GREEN + GTUtility.formatNumbers(storedEnergy) + EnumChatFormatting.RESET + " EU / " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers(maxEnergy) + EnumChatFormatting.RESET + " EU", StatCollector.func_74838_a((String)"GT5U.multiblock.usage") + ": " + EnumChatFormatting.RED + GTUtility.formatNumbers(this.getActualEnergyUsage()) + EnumChatFormatting.RESET + " EU/t", StatCollector.func_74838_a((String)"GT5U.multiblock.mei") + ": " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers(this.getMaxInputVoltage()) + EnumChatFormatting.RESET + " EU/t(*2A) " + StatCollector.func_74838_a((String)"GT5U.machines.tier") + ": " + EnumChatFormatting.YELLOW + GTValues.VN[GTUtility.getTier(this.getMaxInputVoltage())] + EnumChatFormatting.RESET, StatCollector.func_74838_a((String)"GT5U.multiblock.problems") + ": " + EnumChatFormatting.RED + (this.getIdealStatus() - this.getRepairStatus()) + EnumChatFormatting.RESET + " " + StatCollector.func_74838_a((String)"GT5U.multiblock.efficiency") + ": " + EnumChatFormatting.YELLOW + (float)this.mEfficiency / 100.0f + EnumChatFormatting.RESET + " %", EnumChatFormatting.BOLD + StatCollector.func_74838_a((String)"beamline.in_pre") + ": " + EnumChatFormatting.RESET, StatCollector.func_74838_a((String)"beamline.particle") + ": " + EnumChatFormatting.GOLD + Particle.getParticleFromId(information.getParticleId()).getLocalisedName() + " " + EnumChatFormatting.RESET, StatCollector.func_74838_a((String)"beamline.energy") + ": " + EnumChatFormatting.DARK_RED + information.getEnergy() * 1000.0f + EnumChatFormatting.RESET + " eV", StatCollector.func_74838_a((String)"beamline.focus") + ": " + EnumChatFormatting.BLUE + information.getFocus() + " " + EnumChatFormatting.RESET, StatCollector.func_74838_a((String)"beamline.amount") + ": " + EnumChatFormatting.LIGHT_PURPLE + information.getRate()};
    }

    static {
        CASING_INDEX_FRONT = GTUtility.getCasingTextureIndex(GregTechAPI.sBlockCasings3, 10);
        STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("base", (String[][])new String[][]{{"ggggg", "gjjjg", "gjbjg", "gjjjg", "ff~ff"}, {"cslsc", "s-r-s", "srhrs", "s-r-s", "ccccc"}, {"csssc", "s---s", "s---s", "s---s", "ccccc"}, {"csssc", "s---s", "s---s", "s---s", "ccccc"}, {"cstsc", "s-u-s", "suius", "s-u-s", "ccccc"}, {"ggggg", "gjjjg", "gjojg", "gjjjg", "ggggg"}}).addElement('g', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings3, (int)10)).addElement('f', GTStructureUtility.buildHatchAdder(MTETargetChamber.class).atLeast(HatchElement.Maintenance, HatchElement.Energy).casingIndex(CASING_INDEX_FRONT).dot(2).buildAndChain(StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings3, (int)10))).addElement('j', StructureUtility.ofBlockAdder(MTETargetChamber::addGlass, (Block)ItemRegistry.bw_glasses[0], (int)1)).addElement('b', GTStructureUtility.buildHatchAdder(MTETargetChamber.class).hatchClass(MTEHatchInputBeamline.class).casingIndex(1662).dot(5).adder(MTETargetChamber::addBeamLineInputHatch).build()).addElement('c', StructureUtility.ofBlock((Block)LanthItemList.SHIELDED_ACCELERATOR_CASING, (int)0)).addElement('l', GTStructureUtility.buildHatchAdder(MTETargetChamber.class).hatchClass(MTEBusInputFocus.class).casingIndex(1662).dot(1).adder(MTETargetChamber::addFocusInputHatch).build()).addElement('t', GTStructureUtility.buildHatchAdder(MTETargetChamber.class).atLeast(HatchElement.InputBus).casingIndex(1662).dot(3).build()).addElement('s', StructureUtility.ofBlock((Block)LanthItemList.SHIELDED_ACCELERATOR_GLASS, (int)0)).addElement('r', StructureUtility.ofBlock((Block)LanthItemList.FOCUS_MANIPULATION_CASING, (int)0)).addElement('h', StructureUtility.ofBlock((Block)LanthItemList.FOCUS_HOLDER, (int)0)).addElement('u', StructureUtility.ofBlock((Block)LanthItemList.TARGET_RECEPTACLE_CASING, (int)0)).addElement('i', StructureUtility.ofBlock((Block)LanthItemList.TARGET_HOLDER, (int)0)).addElement('o', GTStructureUtility.buildHatchAdder(MTETargetChamber.class).atLeast(HatchElement.OutputBus).casingIndex(1662).dot(4).build()).build();
    }
}

