/*
 * Decompiled with CFR 0.152.
 */
package gtneioreplugin.util;

import gregtech.api.GregTechAPI;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.SmallOres;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.world.GTWorldgen;
import gregtech.common.SmallOreBuilder;
import gregtech.common.WorldgenGTOreSmallPieces;
import gtneioreplugin.util.DimensionHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;

public class GT5OreSmallHelper {
    private static final int SMALL_ORE_BASE_META = 16000;
    public static boolean restrictBiomeSupport = false;
    public static final List<ItemStack> oreSmallList = new ArrayList<ItemStack>();
    public static final HashMap<String, OreSmallWrapper> mapOreSmallWrapper = new HashMap();
    public static final HashMap<String, Short> mapOreDropUnlocalizedNameToOreMeta = new HashMap();
    public static final HashMap<Short, List<ItemStack>> mapOreMetaToOreDrops = new HashMap();
    public static final HashMap<OreSmallWrapper, Map<String, Boolean>> bufferedDims = new HashMap();
    public static final HashMap<String, SmallOreDimensionWrapper> dimToSmallOreWrapper = new HashMap();

    public static void init() {
        HashMap<String, SmallOreBuilder> smallOreDefMap = new HashMap<String, SmallOreBuilder>();
        for (SmallOres ore : SmallOres.values()) {
            smallOreDefMap.put(ore.smallOreBuilder.smallOreName, ore.smallOreBuilder);
        }
        for (GTWorldgen worldGen : GregTechAPI.sWorldgenList) {
            if (!worldGen.mWorldGenName.startsWith("ore.small.") || !(worldGen instanceof WorldgenGTOreSmallPieces)) continue;
            WorldgenGTOreSmallPieces worldGenSmallPieces = (WorldgenGTOreSmallPieces)worldGen;
            short meta = worldGenSmallPieces.mMeta;
            if (meta < 0) break;
            Materials material = GregTechAPI.sGeneratedMaterials[meta];
            mapOreSmallWrapper.put(worldGen.mWorldGenName, new OreSmallWrapper((SmallOreBuilder)smallOreDefMap.get(worldGenSmallPieces.mWorldGenName)));
            if (mapOreMetaToOreDrops.containsKey(meta)) continue;
            ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
            ItemStack stack = GTOreDictUnificator.get(OrePrefixes.gemExquisite, (Object)material, GTOreDictUnificator.get(OrePrefixes.gem, material, 1L), 1L);
            if (stack != null && !mapOreDropUnlocalizedNameToOreMeta.containsKey(stack.func_77977_a())) {
                mapOreDropUnlocalizedNameToOreMeta.put(stack.func_77977_a(), meta);
                stackList.add(stack);
            }
            if ((stack = GTOreDictUnificator.get(OrePrefixes.gemFlawless, (Object)material, GTOreDictUnificator.get(OrePrefixes.gem, material, 1L), 1L)) != null && !mapOreDropUnlocalizedNameToOreMeta.containsKey(stack.func_77977_a())) {
                mapOreDropUnlocalizedNameToOreMeta.put(stack.func_77977_a(), meta);
                stackList.add(stack);
            }
            if ((stack = GTOreDictUnificator.get(OrePrefixes.gem, material, 1L)) != null && !mapOreDropUnlocalizedNameToOreMeta.containsKey(stack.func_77977_a())) {
                mapOreDropUnlocalizedNameToOreMeta.put(stack.func_77977_a(), meta);
                stackList.add(stack);
            }
            if ((stack = GTOreDictUnificator.get(OrePrefixes.gemFlawed, (Object)material, GTOreDictUnificator.get(OrePrefixes.crushed, material, 1L), 1L)) != null && !mapOreDropUnlocalizedNameToOreMeta.containsKey(stack.func_77977_a())) {
                mapOreDropUnlocalizedNameToOreMeta.put(stack.func_77977_a(), meta);
                stackList.add(stack);
            }
            if ((stack = GTOreDictUnificator.get(OrePrefixes.crushed, material, 1L)) != null && !mapOreDropUnlocalizedNameToOreMeta.containsKey(stack.func_77977_a())) {
                mapOreDropUnlocalizedNameToOreMeta.put(stack.func_77977_a(), meta);
                stackList.add(stack);
            }
            if ((stack = GTOreDictUnificator.get(OrePrefixes.gemChipped, (Object)material, GTOreDictUnificator.get(OrePrefixes.dustImpure, material, 1L), 1L)) != null && !mapOreDropUnlocalizedNameToOreMeta.containsKey(stack.func_77977_a())) {
                mapOreDropUnlocalizedNameToOreMeta.put(stack.func_77977_a(), meta);
                stackList.add(stack);
            }
            if ((stack = GTOreDictUnificator.get(OrePrefixes.dustImpure, material, 1L)) != null && !mapOreDropUnlocalizedNameToOreMeta.containsKey(stack.func_77977_a())) {
                mapOreDropUnlocalizedNameToOreMeta.put(stack.func_77977_a(), meta);
                stackList.add(stack);
            }
            oreSmallList.add(new ItemStack(GregTechAPI.sBlockOres1, 1, meta + 16000));
            mapOreMetaToOreDrops.put(meta, stackList);
        }
        for (OreSmallWrapper oreSmallWrapper : mapOreSmallWrapper.values()) {
            bufferedDims.put(oreSmallWrapper, DimensionHelper.getDims(oreSmallWrapper));
        }
        bufferedDims.forEach((veinInfo, dims) -> {
            for (String dim : dims.keySet()) {
                SmallOreDimensionWrapper dimensionSmallOres = dimToSmallOreWrapper.getOrDefault(dim, new SmallOreDimensionWrapper());
                dimensionSmallOres.internalDimOreList.add((OreSmallWrapper)veinInfo);
                dimToSmallOreWrapper.put(dim, dimensionSmallOres);
            }
            for (String dim : dimToSmallOreWrapper.keySet()) {
                GT5OreSmallHelper.dimToSmallOreWrapper.get(dim).calculateWeights();
            }
        });
    }

    public static Materials[] getDroppedDusts() {
        return new Materials[]{Materials.Stone, Materials.Netherrack, Materials.Endstone, Materials.GraniteBlack, Materials.GraniteRed, Materials.Marble, Materials.Basalt, Materials.Stone};
    }

    public static class OreSmallWrapper {
        public final String oreGenName;
        public final short oreMeta;
        public final String worldGenHeightRange;
        public final short amountPerChunk;
        public final Map<String, Boolean> allowedDimWithOrigNames;
        private final Materials oreMaterial;

        public Materials getOreMaterial() {
            return this.oreMaterial;
        }

        public OreSmallWrapper(SmallOreBuilder ore) {
            this.oreGenName = ore.smallOreName;
            this.oreMeta = (short)ore.ore.mMetaItemSubID;
            this.worldGenHeightRange = ore.minY + "-" + ore.maxY;
            this.amountPerChunk = (short)ore.amount;
            this.oreMaterial = ore.ore;
            this.allowedDimWithOrigNames = ore.dimsEnabled;
        }

        public List<ItemStack> getMaterialDrops(int maximumIndex) {
            ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
            for (int i = 0; i < maximumIndex; ++i) {
                stackList.add(new ItemStack(GregTechAPI.sBlockOres1, 1, this.oreMeta + 16000 + i * 1000));
            }
            return stackList;
        }
    }

    public static class SmallOreDimensionWrapper {
        public final ArrayList<OreSmallWrapper> internalDimOreList = new ArrayList();
        public final HashMap<OreSmallWrapper, Double> oreVeinToProbabilityInDimension = new HashMap();

        private void calculateWeights() {
            int totalWeight = 0;
            for (OreSmallWrapper oreVein : this.internalDimOreList) {
                totalWeight += oreVein.amountPerChunk;
            }
            for (OreSmallWrapper oreVein : this.internalDimOreList) {
                this.oreVeinToProbabilityInDimension.put(oreVein, (double)oreVein.amountPerChunk / (double)totalWeight);
            }
        }
    }
}

