/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production.turbines;

import com.gtnewhorizon.structurelib.alignment.IAlignmentLimits;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.items.MetaGeneratedTool;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.metatileentity.implementations.MTEHatchDynamo;
import gregtech.api.metatileentity.implementations.MTEHatchInputBus;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.TurbineStatCalculator;
import gregtech.api.util.shutdown.ShutDownReason;
import gregtech.api.util.shutdown.ShutDownReasonRegistry;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.objects.minecraft.BlockPos;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.MTEHatchTurbine;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GTPPMultiBlockBase;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public abstract class MTELargerTurbineBase
extends GTPPMultiBlockBase<MTELargerTurbineBase>
implements ISurvivalConstructable {
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final ClassValue<IStructureDefinition<MTELargerTurbineBase>> STRUCTURE_DEFINITION = new ClassValue<IStructureDefinition<MTELargerTurbineBase>>(){

        @Override
        protected IStructureDefinition<MTELargerTurbineBase> computeValue(Class<?> type) {
            return StructureDefinition.builder().addShape(MTELargerTurbineBase.STRUCTURE_PIECE_MAIN, (String[][])new String[][]{{"ccchccc", "ccccccc", "ccmcmcc", "ccc~ccc", "ccmcmcc", "ccccccc", "ccchccc"}, {"ctchctc", "cscccsc", "cscccsc", "cscccsc", "cscccsc", "cscccsc", "ctchctc"}, {"ccchccc", "ccccccc", "ccccccc", "ccccccc", "ccccccc", "ccccccc", "ccchccc"}, {"ccchccc", "ccccccc", "ccccccc", "ccccccc", "ccccccc", "ccccccc", "ccchccc"}, {"ctchctc", "cscccsc", "cscccsc", "cscccsc", "cscccsc", "cscccsc", "ctchctc"}, {"ccchccc", "ccccccc", "ccccccc", "ccccccc", "ccccccc", "ccccccc", "ccchccc"}, {"ccchccc", "ccccccc", "ccccccc", "ccccccc", "ccccccc", "ccccccc", "ccchccc"}, {"ctchctc", "cscccsc", "cscccsc", "cscccsc", "cscccsc", "cscccsc", "ctchctc"}, {"ccchccc", "ccccccc", "ccccccc", "ccccccc", "ccccccc", "ccccccc", "ccchccc"}}).addElement('c', (IStructureElement)StructureUtility.lazy(t -> StructureUtility.ofBlock((Block)t.getCasingBlock(), (int)t.getCasingMeta()))).addElement('s', (IStructureElement)StructureUtility.lazy(t -> StructureUtility.ofBlock((Block)t.getShaftBlock(), (int)t.getTurbineShaftMeta()))).addElement('t', (IStructureElement)StructureUtility.lazy(t -> GTStructureUtility.buildHatchAdder(MTELargerTurbineBase.class).adder(MTELargerTurbineBase::addTurbineHatch).hatchClass(MTEHatchTurbine.class).casingIndex(t.getCasingTextureIndex()).dot(1).build())).addElement('h', (IStructureElement)StructureUtility.lazy(t -> GTStructureUtility.buildHatchAdder(MTELargerTurbineBase.class).atLeast(HatchElement.InputBus, HatchElement.InputHatch, HatchElement.OutputHatch, HatchElement.Dynamo.or(GTPPMultiBlockBase.GTPPHatchElement.TTDynamo), HatchElement.Maintenance).casingIndex(t.getCasingTextureIndex()).dot(4).buildAndChain(t.getCasingBlock(), t.getCasingMeta()))).addElement('m', (IStructureElement)StructureUtility.lazy(t -> ((MTELargerTurbineBase)t).requiresMufflers() ? HatchElement.Muffler.newAny(t.getCasingTextureIndex(), 7) : StructureUtility.ofBlock((Block)t.getCasingBlock(), (int)t.getCasingMeta()))).build();
        }
    };
    protected int baseEff = 0;
    protected long optFlow = 0L;
    protected long euPerTurbine = 0L;
    protected double realOptFlow = 0.0;
    protected int storedFluid = 0;
    protected int counter = 0;
    protected boolean looseFit = false;
    protected float[] flowMultipliers = new float[]{1.0f, 1.0f, 1.0f};
    public ArrayList<MTEHatchTurbine> mTurbineRotorHatches = new ArrayList();
    private Long mLastHatchUpdate;

    public MTELargerTurbineBase(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTELargerTurbineBase(String aName) {
        super(aName);
    }

    protected abstract String getTurbineType();

    protected abstract String getCasingName();

    protected abstract boolean isDenseSteam();

    protected abstract boolean requiresOutputHatch();

    @Override
    public boolean supportsPowerPanel() {
        return false;
    }

    @Override
    protected final MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType(this.getMachineType()).addInfo("Runs as fast as 16 Large Turbines of the same type, takes the space of 12").addInfo("Right-click with screwdriver to enable loose fit").addInfo("Optimal flow will increase or decrease depending on fitting").addInfo("Loose fit increases flow in exchange for efficiency");
        if (this.getTurbineType().equals("Plasma")) {
            tt.addInfo("Plasma fuel efficiency is lower for high tier turbines when using low-grade plasmas").addInfo("Efficiency = ((FuelValue / 200,000)^2) / (EU per Turbine)");
        } else if (this.getTurbineType().contains("Steam")) {
            tt.addInfo("Dense types of steam are so energy packed, they only require 1/1000th of the original flow");
        }
        tt.addTecTechHatchInfo();
        tt.addPollutionAmount(this.getPollutionPerSecond(null)).beginStructureBlock(7, 9, 7, false).addController("Top Middle").addCasingInfoMin(this.getCasingName(), 360, false).addCasingInfoMin("Turbine Shaft", 30, false).addOtherStructurePart(StatCollector.func_74838_a((String)"GTPP.tooltip.structure.rotor_assembly"), "Any 1 dot hint", 1).addInputBus("Any 4 dot hint (min 1)", 4).addInputHatch("Any 4 dot hint(min 1)", 4);
        if (this.requiresOutputHatch()) {
            tt.addOutputHatch("Any 4 dot hint(min 1)", 4);
        }
        tt.addDynamoHatch("Any 4 dot hint(min 1)", 4).addMaintenanceHatch("Any 4 dot hint(min 1)", 4);
        if (this.requiresMufflers()) {
            tt.addMufflerHatch("Any 7 dot hint (x4)", 7);
        }
        tt.toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    public IStructureDefinition<MTELargerTurbineBase> getStructureDefinition() {
        return STRUCTURE_DEFINITION.get(this.getClass());
    }

    private boolean requiresMufflers() {
        return this.getPollutionPerSecond(null) > 0;
    }

    @Override
    public void clearHatches() {
        super.clearHatches();
        this.mTurbineRotorHatches.clear();
    }

    @Override
    public boolean checkStructure(boolean aForceReset, IGregTechTileEntity aBaseMetaTileEntity) {
        boolean f = super.checkStructure(aForceReset, aBaseMetaTileEntity);
        if (f) {
            for (MTEHatchTurbine tHatch : this.mTurbineRotorHatches) {
                tHatch.sendUpdate();
            }
        }
        return f;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        boolean aStructure = this.checkPiece(STRUCTURE_PIECE_MAIN, 3, 3, 0);
        this.log("Structure Check: " + aStructure);
        if (this.mTurbineRotorHatches.size() != 12 || this.mMaintenanceHatches.size() != 1 || this.mDynamoHatches.isEmpty() && this.mTecTechDynamoHatches.isEmpty() || this.requiresMufflers() && this.mMufflerHatches.size() != 4 || this.mInputBusses.isEmpty() || this.mInputHatches.isEmpty() || this.requiresOutputHatch() && this.mOutputHatches.isEmpty()) {
            this.log("Bad Hatches - Turbine Housings: " + this.mTurbineRotorHatches.size() + ", Maint: " + this.mMaintenanceHatches.size() + ", Dynamo: " + this.mDynamoHatches.size() + ", Muffler: " + this.mMufflerHatches.size() + ", Input Buses: " + this.mInputBusses.size() + ", Input Hatches: " + this.mInputHatches.size() + ", Output Hatches: " + this.mOutputHatches.size());
            return false;
        }
        return aStructure;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 3, 3, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        int realBudget = elementBudget >= 200 ? elementBudget : Math.min(200, elementBudget * 2);
        return this.survivalBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 3, 3, 0, realBudget, env, false, true);
    }

    public boolean addTurbineHatch(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof MTEHatchTurbine) {
            MTEHatchTurbine aTurbineHatch = (MTEHatchTurbine)aMetaTileEntity;
            this.log("Found MTEHatchTurbine");
            this.updateTexture(aTileEntity, aBaseCasingIndex);
            IGregTechTileEntity g = this.getBaseMetaTileEntity();
            if (aTurbineHatch.setController(new BlockPos(g.getXCoord(), (int)g.getYCoord(), g.getZCoord(), g.getWorld()))) {
                boolean aDidAdd = this.mTurbineRotorHatches.add(aTurbineHatch);
                Logger.INFO("Injected Controller into Turbine Assembly. Found: " + this.mTurbineRotorHatches.size());
                return aDidAdd;
            }
            Logger.INFO("Failed to inject controller into Turbine Assembly Hatch.");
        }
        this.log("Bad Turbine Housing");
        return false;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return this.getMaxEfficiency(aStack) > 0;
    }

    public Block getCasingBlock() {
        return ModBlocks.blockSpecialMultiCasings;
    }

    public final Block getShaftBlock() {
        return ModBlocks.blockSpecialMultiCasings;
    }

    public abstract int getCasingMeta();

    public byte getTurbineShaftMeta() {
        return 0;
    }

    public abstract int getCasingTextureIndex();

    public abstract int getFuelValue(FluidStack var1);

    public static boolean isValidTurbine(ItemStack aTurbine) {
        return aTurbine != null && aTurbine.func_77973_b() instanceof MetaGeneratedTool && aTurbine.func_77960_j() >= 170 && aTurbine.func_77960_j() <= 176;
    }

    protected ArrayList<ItemStack> getAllBufferedTurbines() {
        this.startRecipeProcessing();
        ArrayList<ItemStack> aTurbinesInStorage = new ArrayList<ItemStack>();
        for (ItemStack aStack : this.getStoredInputs()) {
            int tmpStackSize;
            if (!MTELargerTurbineBase.isValidTurbine(aStack)) continue;
            for (int stackSize = aStack.field_77994_a; stackSize > 0; stackSize -= tmpStackSize) {
                tmpStackSize = Math.min(stackSize, aStack.func_77976_d());
                ItemStack copy = aStack.func_77946_l();
                copy.field_77994_a = tmpStackSize;
                aTurbinesInStorage.add(copy);
            }
        }
        this.endRecipeProcessing();
        return aTurbinesInStorage;
    }

    public boolean areAllTurbinesTheSame() {
        ArrayList<MTEHatchTurbine> aTurbineAssemblies = this.getFullTurbineAssemblies();
        if (aTurbineAssemblies.size() < 12) {
            this.log("Found " + aTurbineAssemblies.size() + ", expected 12.");
            return false;
        }
        ArrayList<Materials> aTurbineMats = new ArrayList<Materials>();
        ArrayList<Integer> aTurbineSizes = new ArrayList<Integer>();
        for (MTEHatchTurbine aHatch : aTurbineAssemblies) {
            aTurbineMats.add(MetaGeneratedTool.getPrimaryMaterial(aHatch.getTurbine()));
            aTurbineSizes.add(MTELargerTurbineBase.getTurbineSize(aHatch.getTurbine()));
        }
        Materials aBaseMat = (Materials)aTurbineMats.get(0);
        int aBaseSize = (Integer)aTurbineSizes.get(0);
        Iterator iterator = aTurbineSizes.iterator();
        while (iterator.hasNext()) {
            int aSize = (Integer)iterator.next();
            if (aBaseSize == aSize) continue;
            return false;
        }
        for (Materials aMat : aTurbineMats) {
            if (aBaseMat == aMat) continue;
            return false;
        }
        return true;
    }

    public static int getTurbineSize(ItemStack aTurbine) {
        if (MTELargerTurbineBase.isValidTurbine(aTurbine)) {
            if (aTurbine.func_77960_j() >= 170 && aTurbine.func_77960_j() < 172) {
                return 1;
            }
            if (aTurbine.func_77960_j() >= 172 && aTurbine.func_77960_j() < 174) {
                return 2;
            }
            if (aTurbine.func_77960_j() >= 174 && aTurbine.func_77960_j() < 176) {
                return 3;
            }
            if (aTurbine.func_77960_j() >= 176 && aTurbine.func_77960_j() < 178) {
                return 4;
            }
        }
        return 0;
    }

    public static String getTurbineSizeString(int aSize) {
        String string;
        switch (aSize) {
            case 1: {
                string = "Small Turbine";
                break;
            }
            case 2: {
                string = "Turbine";
                break;
            }
            case 3: {
                string = "Large Turbine";
                break;
            }
            case 4: {
                string = "Huge Turbine";
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    protected ArrayList<MTEHatchTurbine> getEmptyTurbineAssemblies() {
        ArrayList<MTEHatchTurbine> aEmptyTurbineRotorHatches = new ArrayList<MTEHatchTurbine>();
        for (MTEHatchTurbine aTurbineHatch : this.mTurbineRotorHatches) {
            if (aTurbineHatch.hasTurbine()) continue;
            aEmptyTurbineRotorHatches.add(aTurbineHatch);
        }
        return aEmptyTurbineRotorHatches;
    }

    protected ArrayList<MTEHatchTurbine> getFullTurbineAssemblies() {
        ArrayList<MTEHatchTurbine> aTurbineRotorHatches = new ArrayList<MTEHatchTurbine>();
        for (MTEHatchTurbine aTurbineHatch : this.mTurbineRotorHatches) {
            if (!aTurbineHatch.hasTurbine()) continue;
            aTurbineRotorHatches.add(aTurbineHatch);
        }
        return aTurbineRotorHatches;
    }

    protected void depleteTurbineFromStock(ItemStack aTurbine) {
        if (aTurbine == null) {
            return;
        }
        this.startRecipeProcessing();
        for (MTEHatchInputBus aInputBus : this.mInputBusses) {
            for (int slot = aInputBus.func_70302_i_() - 1; slot >= 0; --slot) {
                ItemStack aStack = aInputBus.func_70301_a(slot);
                if (!GTUtility.areStacksEqual(aStack, aTurbine)) continue;
                aStack.field_77994_a -= aTurbine.field_77994_a;
                this.updateSlots();
                this.endRecipeProcessing();
                return;
            }
        }
        this.endRecipeProcessing();
    }

    @Override
    @NotNull
    public CheckRecipeResult checkProcessing() {
        try {
            ArrayList<MTEHatchTurbine> aEmptyTurbineRotorHatches = this.getEmptyTurbineAssemblies();
            if (!aEmptyTurbineRotorHatches.isEmpty()) {
                block2: for (MTEHatchTurbine aHatch : aEmptyTurbineRotorHatches) {
                    ArrayList<ItemStack> aTurbines = this.getAllBufferedTurbines();
                    for (ItemStack aTurbineItem : aTurbines) {
                        if (aTurbineItem == null || !aHatch.insertTurbine(aTurbineItem.func_77946_l())) continue;
                        this.depleteTurbineFromStock(aTurbineItem);
                        continue block2;
                    }
                }
            }
            if (!this.getEmptyTurbineAssemblies().isEmpty() || !this.areAllTurbinesTheSame()) {
                this.stopMachine(ShutDownReasonRegistry.NO_TURBINE);
                return CheckRecipeResultRegistry.NO_TURBINE_FOUND;
            }
            ArrayList<FluidStack> tFluids = this.getStoredFluids();
            ItemStack aStack = this.getFullTurbineAssemblies().get(0).getTurbine();
            TurbineStatCalculator turbine = new TurbineStatCalculator((MetaGeneratedTool)aStack.func_77973_b(), aStack);
            if (!tFluids.isEmpty()) {
                if (this.baseEff == 0 || this.optFlow == 0L || this.counter >= 512 || this.getBaseMetaTileEntity().hasWorkJustBeenEnabled() || this.getBaseMetaTileEntity().hasInventoryBeenModified()) {
                    this.counter = 0;
                    float aTotalBaseEff = 0.0f;
                    float aTotalOptimalFlow = 0.0f;
                    this.baseEff = MathUtils.roundToClosestInt(aTotalBaseEff += turbine.getBaseEfficiency() * 100.0f);
                    this.optFlow = MathUtils.roundToClosestInt(aTotalOptimalFlow += (float)GTUtility.safeInt((long)Math.max(Float.MIN_NORMAL, (float)this.getSpeedMultiplier() * turbine.getOptimalFlow())));
                    if (aTotalOptimalFlow < 0.0f) {
                        aTotalOptimalFlow = 100.0f;
                    }
                    if (this.optFlow <= 0L || this.baseEff <= 0) {
                        this.stopMachine(ShutDownReasonRegistry.NONE);
                        return CheckRecipeResultRegistry.NO_FUEL_FOUND;
                    }
                } else {
                    ++this.counter;
                }
            }
            long newPower = this.fluidIntoPower(tFluids, turbine);
            long difference = newPower - this.lEUt;
            int maxChangeAllowed = Math.max(10, GTUtility.safeInt(Math.abs(difference) / 100L));
            if (Math.abs(difference) > (long)maxChangeAllowed) {
                int change = maxChangeAllowed * (difference > 0L ? 1 : -1);
                this.lEUt += (long)change;
            } else {
                this.lEUt = newPower;
            }
            if (this.lEUt <= 0L) {
                this.lEUt = 0L;
                this.mEfficiency = 0;
                return CheckRecipeResultRegistry.NO_FUEL_FOUND;
            }
            this.mMaxProgresstime = 1;
            this.mEfficiencyIncrease = 10;
            this.enableAllTurbineHatches();
            return CheckRecipeResultRegistry.GENERATING;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return CheckRecipeResultRegistry.NO_FUEL_FOUND;
        }
    }

    @Override
    public boolean doRandomMaintenanceDamage() {
        if (this.getMaxParallelRecipes() == 0) {
            this.stopMachine(ShutDownReasonRegistry.NO_TURBINE);
            return false;
        }
        if (this.mRuntime++ > 1000) {
            this.mRuntime = 0;
            if (this.getBaseMetaTileEntity().getRandomNumber(6000) < this.getMaintenanceThreshold()) {
                this.causeMaintenanceIssue();
            }
            for (MTEHatchTurbine aHatch : this.getFullTurbineAssemblies()) {
                for (int i = 0; i < this.getTurbineDamageMultiplier(); ++i) {
                    aHatch.damageTurbine(this.lEUt / 5L, this.damageFactorLow, this.damageFactorHigh);
                }
            }
        }
        return true;
    }

    @Override
    public int getMaxParallelRecipes() {
        return this.getFullTurbineAssemblies().size();
    }

    abstract long fluidIntoPower(ArrayList<FluidStack> var1, TurbineStatCalculator var2);

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 1;
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return this.getMaxParallelRecipes() == 12 ? 10000 : 0;
    }

    public boolean isLooseMode() {
        return this.looseFit;
    }

    @Override
    public String[] getExtraInfoData() {
        String tRunning = this.mMaxProgresstime > 0 ? EnumChatFormatting.GREEN + StatCollector.func_74838_a((String)"GT5U.turbine.running.true") + EnumChatFormatting.RESET : EnumChatFormatting.RED + StatCollector.func_74838_a((String)"GT5U.turbine.running.false") + EnumChatFormatting.RESET;
        String tMaintenance = this.getIdealStatus() == this.getRepairStatus() ? EnumChatFormatting.GREEN + StatCollector.func_74838_a((String)"GT5U.turbine.maintenance.false") + EnumChatFormatting.RESET : EnumChatFormatting.RED + StatCollector.func_74838_a((String)"GT5U.turbine.maintenance.true") + EnumChatFormatting.RESET;
        StringBuilder aTurbineDamage = new StringBuilder();
        for (MTEHatchTurbine aHatch : this.getFullTurbineAssemblies()) {
            ItemStack aTurbine = aHatch.getTurbine();
            int tDura = MathUtils.safeInt((long)(100.0f / (float)MetaGeneratedTool.getToolMaxDamage(aTurbine) * (float)MetaGeneratedTool.getToolDamage(aTurbine) + 1.0f));
            aTurbineDamage.append(EnumChatFormatting.RED).append(GTUtility.formatNumbers(tDura)).append(EnumChatFormatting.RESET).append("% | ");
        }
        long storedEnergy = 0L;
        long maxEnergy = 0L;
        for (MTEHatchDynamo tHatch : GTUtility.validMTEList(this.mDynamoHatches)) {
            storedEnergy += tHatch.getBaseMetaTileEntity().getStoredEU();
            maxEnergy += tHatch.getBaseMetaTileEntity().getEUCapacity();
        }
        boolean aIsSteam = this.getClass().getName().toLowerCase().contains("steam");
        return new String[]{tRunning + ": " + EnumChatFormatting.RED + GTUtility.formatNumbers(this.lEUt * (long)this.mEfficiency / 10000L) + EnumChatFormatting.RESET + " EU/t", tMaintenance, StatCollector.func_74838_a((String)"GT5U.turbine.efficiency") + ": " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers((float)this.mEfficiency / 100.0f) + EnumChatFormatting.RESET + "%", StatCollector.func_74838_a((String)"GT5U.multiblock.energy") + ": " + EnumChatFormatting.GREEN + GTUtility.formatNumbers(storedEnergy) + EnumChatFormatting.RESET + " EU / " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers(maxEnergy) + EnumChatFormatting.RESET + " EU", StatCollector.func_74838_a((String)"GT5U.turbine.flow") + ": " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers(MathUtils.safeInt((long)this.realOptFlow) / (this.isDenseSteam() ? 1000 : 1)) + EnumChatFormatting.RESET + " L/" + (this.getTurbineType().equals("Plasma") ? (char)'s' : 't') + EnumChatFormatting.YELLOW + " (" + (this.isLooseMode() ? StatCollector.func_74838_a((String)"GT5U.turbine.loose") : StatCollector.func_74838_a((String)"GT5U.turbine.tight")) + ")", StatCollector.func_74838_a((String)"GT5U.turbine.fuel") + ": " + EnumChatFormatting.GOLD + GTUtility.formatNumbers(this.storedFluid) + EnumChatFormatting.RESET + "L", StatCollector.func_74838_a((String)"GT5U.turbine.dmg") + ": " + aTurbineDamage, StatCollector.func_74838_a((String)"GT5U.multiblock.pollution") + ": " + EnumChatFormatting.GREEN + this.getAveragePollutionPercentage() + EnumChatFormatting.RESET + " %"};
    }

    @Override
    public long maxAmperesOut() {
        return 16L;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74757_a("turbineFitting", this.looseFit);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.looseFit = aNBT.func_74767_n("turbineFitting");
    }

    @Override
    public void onModeChangeByScrewdriver(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (side == this.getBaseMetaTileEntity().getFrontFacing()) {
            this.looseFit = !this.looseFit;
            this.clearRecipeMapForAllInputHatches();
            GTUtility.sendChatToPlayer(aPlayer, this.looseFit ? "Fitting: Loose - More Flow" : "Fitting: Tight - More Efficiency");
        }
    }

    @Override
    public final ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int aColorIndex, boolean aActive, boolean aRedstone) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[1][aColorIndex + 1], facing == side ? this.getFrontFacingTurbineTexture(aActive) : Textures.BlockIcons.getCasingTextureForId(this.getCasingTextureIndex())};
    }

    protected ITexture getFrontFacingTurbineTexture(boolean isActive) {
        if (isActive) {
            return TextureFactory.builder().addIcon(TexturesGtBlock.Overlay_Machine_Controller_Advanced_Active).extFacing().build();
        }
        return TextureFactory.builder().addIcon(TexturesGtBlock.Overlay_Machine_Controller_Advanced).extFacing().build();
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isServerSide()) {
            if (this.maxProgresstime() > 0 || this.getBaseMetaTileEntity().hasWorkJustBeenEnabled()) {
                this.enableAllTurbineHatches();
            }
            if (this.maxProgresstime() <= 0) {
                this.stopMachine(ShutDownReasonRegistry.NONE);
            }
        }
    }

    @Override
    public void stopMachine(@NotNull ShutDownReason reason) {
        this.baseEff = 0;
        this.optFlow = 0L;
        this.disableAllTurbineHatches();
        super.stopMachine(reason);
    }

    @Override
    public void onRemoval() {
        super.onRemoval();
        for (MTEHatchTurbine h : this.mTurbineRotorHatches) {
            h.clearController();
        }
        this.disableAllTurbineHatches();
        this.mTurbineRotorHatches.clear();
    }

    public void enableAllTurbineHatches() {
        this.updateTurbineHatches(this.isMachineRunning());
    }

    public void disableAllTurbineHatches() {
        this.updateTurbineHatches(false);
    }

    public void updateTurbineHatches(boolean aState) {
        if (this.mLastHatchUpdate == null) {
            this.mLastHatchUpdate = System.currentTimeMillis() / 1000L;
        }
        if (this.mTurbineRotorHatches.isEmpty() || System.currentTimeMillis() / 1000L - this.mLastHatchUpdate <= 2L) {
            return;
        }
        for (MTEHatchTurbine h : GTUtility.validMTEList(this.mTurbineRotorHatches)) {
            h.setActive(aState);
        }
        this.mLastHatchUpdate = System.currentTimeMillis() / 1000L;
    }

    @Override
    protected IAlignmentLimits getInitialAlignmentLimits() {
        return (d, r, f) -> d == ForgeDirection.UP;
    }

    @Override
    public boolean onRunningTick(ItemStack aStack) {
        if (this.lEUt > 0L) {
            this.addEnergyOutput(this.lEUt * (long)this.mEfficiency / 10000L);
            return true;
        }
        return false;
    }

    @Override
    public boolean addEnergyOutput(long aEU) {
        if (aEU <= 0L) {
            return true;
        }
        if (!this.mAllDynamoHatches.isEmpty()) {
            return this.addEnergyOutputMultipleDynamos(aEU, true);
        }
        return false;
    }

    @Override
    public boolean addEnergyOutputMultipleDynamos(long aEU, boolean aAllowMixedVoltageDynamos) {
        long aVoltage;
        int injected = 0;
        long aFirstVoltageFound = -1L;
        for (MTEHatch aDynamo : GTUtility.validMTEList(this.mAllDynamoHatches)) {
            aVoltage = aDynamo.maxEUOutput();
            if (aFirstVoltageFound != -1L) continue;
            aFirstVoltageFound = aVoltage;
        }
        for (MTEHatch aDynamo : GTUtility.validMTEList(this.mAllDynamoHatches)) {
            long leftToInject = aEU - (long)injected;
            aVoltage = aDynamo.maxEUOutput();
            int aAmpsToInject = (int)(leftToInject / aVoltage);
            int aRemainder = (int)(leftToInject - (long)aAmpsToInject * aVoltage);
            int ampsOnCurrentHatch = (int)Math.min(aDynamo.maxAmperesOut(), (long)aAmpsToInject);
            aDynamo.getBaseMetaTileEntity().increaseStoredEnergyUnits(aVoltage * (long)ampsOnCurrentHatch, false);
            injected = (int)((long)injected + aVoltage * (long)ampsOnCurrentHatch);
            if (aRemainder <= 0 || (long)ampsOnCurrentHatch >= aDynamo.maxAmperesOut()) continue;
            aDynamo.getBaseMetaTileEntity().increaseStoredEnergyUnits(aRemainder, false);
            injected += aRemainder;
        }
        return injected > 0;
    }

    public int getSpeedMultiplier() {
        return 16;
    }

    public int getMaintenanceThreshold() {
        return 1;
    }

    public int getTurbineDamageMultiplier() {
        return 1;
    }

    @Override
    public boolean supportsBatchMode() {
        return false;
    }

    @Override
    public boolean showRecipeTextInGUI() {
        return false;
    }
}

