/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.api.metatileentity.implementations;

import com.gtnewhorizon.structurelib.alignment.enumerable.ExtendedFacing;
import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.Materials;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.items.MetaGeneratedTool;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.objects.GTItemStack;
import gregtech.api.render.RenderOverlay;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTUtility;
import gregtech.api.util.GTUtilityClient;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.objects.minecraft.BlockPos;
import gtPlusPlus.core.handler.PacketHandler;
import gtPlusPlus.core.lib.GTPPCore;
import gtPlusPlus.core.network.packet.PacketTurbineHatchUpdate;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production.turbines.MTELargerTurbineBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.ArrayUtils;

public class MTEHatchTurbine
extends MTEHatch {
    public boolean mHasController = false;
    public boolean mUsingAnimation = true;
    private BlockPos mControllerLocation;
    public int mEUt = 0;
    protected final List<RenderOverlay.OverlayTicket> overlayTickets = new ArrayList<RenderOverlay.OverlayTicket>();
    private boolean mFormed;
    private boolean mHasTurbine;

    public MTEHatchTurbine(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 16, "Turbine Rotor holder for XL Turbines", new ITexture[0]);
    }

    public MTEHatchTurbine(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 1, aDescription, aTextures);
    }

    @Override
    public String[] getDescription() {
        return (String[])ArrayUtils.addAll((Object[])this.mDescriptionArray, (Object[])new String[]{"Right Click with a soldering iron to reset controller link", "Right Click with a wrench to remove turbine", "Right Click with a screwdriver for technical information", "Sneak + Right Click with a wrench to rotate", "Sneak + Right Click with a screwdriver to disable animations", GTPPCore.GT_Tooltip.get()});
    }

    @Override
    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of(Textures.BlockIcons.LARGETURBINE_NEW_ACTIVE5)};
    }

    @Override
    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        if (this.hasTurbine()) {
            return new ITexture[]{aBaseTexture, TextureFactory.of(Textures.BlockIcons.LARGETURBINE_NEW_EMPTY5)};
        }
        return new ITexture[]{aBaseTexture, TextureFactory.of(Textures.BlockIcons.LARGETURBINE_NEW5)};
    }

    public int getEU() {
        return this.mEUt;
    }

    public void setEU(int aEU) {
        this.mEUt = aEU;
    }

    @Override
    public boolean isFacingValid(ForgeDirection facing) {
        return facing.offsetY == 0;
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return false;
    }

    public boolean hasTurbine() {
        if (this.getBaseMetaTileEntity().isServerSide()) {
            ItemStack aStack = this.mInventory[0];
            return MTELargerTurbineBase.isValidTurbine(aStack);
        }
        return this.mHasTurbine;
    }

    public ItemStack getTurbine() {
        if (this.hasTurbine()) {
            return this.mInventory[0];
        }
        return null;
    }

    public boolean canWork() {
        return this.hasTurbine();
    }

    public boolean insertTurbine(ItemStack aTurbine) {
        if (MTELargerTurbineBase.isValidTurbine(aTurbine)) {
            this.mInventory[0] = aTurbine;
            this.sendUpdate();
            return true;
        }
        return false;
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEHatchTurbine(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        this.openGui(aPlayer);
        return true;
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    public void damageTurbine(int aEUt, int damageFactorLow, float damageFactorHigh) {
        this.damageTurbine((long)aEUt, damageFactorLow, damageFactorHigh);
    }

    public void damageTurbine(long aEUt, int damageFactorLow, float damageFactorHigh) {
        if (this.hasTurbine() && MathUtils.randInt(0, 1) == 0) {
            ItemStack aTurbine = this.getTurbine();
            ((MetaGeneratedTool)aTurbine.func_77973_b()).doDamage(aTurbine, (long)this.getDamageToComponent(aTurbine) * (long)Math.min((double)((float)aEUt / (float)damageFactorLow), Math.pow(aEUt, damageFactorHigh)));
        }
    }

    private int getDamageToComponent(ItemStack aStack) {
        return 1;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74757_a("mHasController", this.mHasController);
        aNBT.func_74757_a("mUsingAnimation", this.mUsingAnimation);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.mHasController = aNBT.func_74767_n("mHasController");
        this.mUsingAnimation = aNBT.func_74767_n("mUsingAnimation");
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (this.mHasController) {
            if (aTick % 20L == 0L) {
                boolean oActive = this.getBaseMetaTileEntity().isActive();
                boolean active = this.isControllerActive();
                this.getBaseMetaTileEntity().setActive(active);
                if (active != oActive) {
                    this.getBaseMetaTileEntity().issueClientUpdate();
                }
            }
        } else if (this.mControllerLocation == null || this.setController(this.mControllerLocation)) {
            // empty if block
        }
        if (this.mInventory[0] != null && this.mInventory[0].field_77994_a <= 0) {
            this.mInventory[0] = null;
        }
    }

    public boolean isControllerActive() {
        MTELargerTurbineBase x = this.getController();
        if (x != null) {
            return x.lEUt > 0L;
        }
        return false;
    }

    public MTELargerTurbineBase getController() {
        if (this.mHasController && this.mControllerLocation != null) {
            BlockPos p = this.mControllerLocation;
            IGregTechTileEntity tTileEntity = this.getBaseMetaTileEntity().getIGregTechTileEntity(p.xPos, p.yPos, p.zPos);
            if (tTileEntity != null && tTileEntity.getMetaTileEntity() instanceof MTELargerTurbineBase) {
                return (MTELargerTurbineBase)tTileEntity.getMetaTileEntity();
            }
            if (tTileEntity == null) {
                Logger.INFO("Controller MTE is null, somehow?");
            } else {
                Logger.INFO("Controller is a different MTE to expected");
            }
        }
        return null;
    }

    public boolean canSetNewController() {
        return this.mControllerLocation == null && !this.mHasController;
    }

    public boolean setController(BlockPos aPos) {
        this.clearController();
        if (this.canSetNewController()) {
            this.mControllerLocation = aPos;
            this.mHasController = true;
            Logger.INFO("Successfully injected controller into this Turbine Assembly Hatch.");
        }
        return this.mHasController;
    }

    public void clearController() {
        this.mControllerLocation = null;
        this.mHasController = false;
    }

    public IIconContainer[] getTurbineTextureActive() {
        return Textures.BlockIcons.TURBINE_NEW_ACTIVE;
    }

    public IIconContainer[] getTurbineTextureFull() {
        return Textures.BlockIcons.TURBINE_NEW;
    }

    public IIconContainer[] getTurbineTextureEmpty() {
        return Textures.BlockIcons.TURBINE_NEW_EMPTY;
    }

    @Override
    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        super.onFirstTick(aBaseMetaTileEntity);
        this.setTurbineOverlay();
    }

    protected void setTurbineOverlay() {
        IGregTechTileEntity tile = this.getBaseMetaTileEntity();
        if (tile.isServerSide()) {
            return;
        }
        IIconContainer[] tTextures = tile.isActive() ? this.getTurbineTextureActive() : (this.hasTurbine() ? this.getTurbineTextureFull() : this.getTurbineTextureEmpty());
        GTUtilityClient.setTurbineOverlay(tile.getWorld(), tile.getXCoord(), tile.getYCoord(), tile.getZCoord(), ExtendedFacing.of((ForgeDirection)this.getBaseMetaTileEntity().getFrontFacing()), tTextures, this.overlayTickets);
    }

    @Override
    public void onTextureUpdate() {
        this.setTurbineOverlay();
    }

    public boolean usingAnimations() {
        return this.mUsingAnimation;
    }

    @Override
    public long getMinimumStoredEU() {
        return 0L;
    }

    @Override
    public boolean func_94041_b(int aIndex, ItemStack aStack) {
        return false;
    }

    @Override
    public int[] func_94128_d(int ordinalSide) {
        return GTValues.emptyIntArray;
    }

    @Override
    public boolean func_102007_a(int aIndex, ItemStack aStack, int ordinalSide) {
        return false;
    }

    public void setActive(boolean b) {
        this.getBaseMetaTileEntity().setActive(b);
    }

    @Override
    public void func_70299_a(int aIndex, ItemStack aStack) {
        super.func_70299_a(aIndex, aStack);
        this.sendUpdate();
    }

    @Override
    public boolean allowCoverOnSide(ForgeDirection side, ItemStack coverItem) {
        return false;
    }

    @Override
    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aTool) {
        if (!aPlayer.func_70093_af()) {
            GTUtility.sendChatToPlayer(aPlayer, "Using Animations? " + this.usingAnimations());
            GTUtility.sendChatToPlayer(aPlayer, "Has Controller? " + this.mHasController);
            if (this.mHasController) {
                GTUtility.sendChatToPlayer(aPlayer, "Controller Location: " + this.mControllerLocation.getLocationString());
                GTUtility.sendChatToPlayer(aPlayer, "Controller Active? " + this.isControllerActive());
            }
            GTUtility.sendChatToPlayer(aPlayer, "Active? " + this.getBaseMetaTileEntity().isActive());
            GTUtility.sendChatToPlayer(aPlayer, "Has Turbine inserted? " + this.hasTurbine());
            if (this.hasTurbine()) {
                Materials aMat = MetaGeneratedTool.getPrimaryMaterial(this.getTurbine());
                String aSize = MTELargerTurbineBase.getTurbineSizeString(MTELargerTurbineBase.getTurbineSize(this.getTurbine()));
                GTUtility.sendChatToPlayer(aPlayer, "Using: " + aMat.mLocalizedName + " " + aSize);
            }
        } else {
            boolean bl = this.mUsingAnimation = !this.mUsingAnimation;
            if (this.mUsingAnimation) {
                GTUtility.sendChatToPlayer(aPlayer, "Using Animated Turbine Texture.");
            } else {
                GTUtility.sendChatToPlayer(aPlayer, "Using Static Turbine Texture.");
            }
        }
    }

    @Override
    public boolean onWrenchRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aTool) {
        if (this.getBaseMetaTileEntity().isServerSide() && !aPlayer.func_70093_af() && aTool != null && aTool.func_77973_b() instanceof MetaGeneratedTool) {
            return this.onToolClick(aTool, aPlayer, wrenchingSide);
        }
        return super.onWrenchRightClick(side, wrenchingSide, aPlayer, aX, aY, aZ, aTool);
    }

    @Override
    public boolean onSolderingToolRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aTool) {
        if (this.getBaseMetaTileEntity().isServerSide() && aTool != null && aTool.func_77973_b() instanceof MetaGeneratedTool) {
            return this.onToolClick(aTool, aPlayer, wrenchingSide);
        }
        return super.onSolderingToolRightClick(side, wrenchingSide, aPlayer, aX, aY, aZ, aTool);
    }

    public boolean onToolClick(ItemStack tCurrentItem, EntityPlayer aPlayer, ForgeDirection side) {
        if (GTUtility.isStackInList(tCurrentItem, (Collection<GTItemStack>)GregTechAPI.sWrenchList)) {
            boolean aHasTurbine = this.hasTurbine();
            if (aPlayer.field_71071_by.func_70447_i() >= 0 && aHasTurbine) {
                if (aPlayer.field_71075_bZ.field_75098_d || GTModHandler.damageOrDechargeItem(tCurrentItem, 1, 1000, (EntityLivingBase)aPlayer)) {
                    aPlayer.field_71071_by.func_70441_a(this.getTurbine());
                    this.mInventory[0] = null;
                    GTUtility.sendChatToPlayer(aPlayer, "Removed turbine with wrench.");
                    this.sendUpdate();
                    return true;
                }
            } else {
                GTUtility.sendChatToPlayer(aPlayer, aHasTurbine ? "Cannot remove turbine, no free inventory space." : "No turbine to remove.");
            }
        } else if (GTUtility.isStackInList(tCurrentItem, (Collection<GTItemStack>)GregTechAPI.sSolderingToolList) && this.mControllerLocation != null && this.setController(this.mControllerLocation) && (aPlayer.field_71075_bZ.field_75098_d || GTModHandler.damageOrDechargeItem(tCurrentItem, 1, 1000, (EntityLivingBase)aPlayer))) {
            String tChat = "Trying to Reset linked Controller";
            IGregTechTileEntity g = this.getBaseMetaTileEntity();
            GTUtility.sendChatToPlayer(aPlayer, tChat);
            GTUtility.sendSoundToPlayers(g.getWorld(), SoundResource.IC2_TOOLS_RUBBER_TRAMPOLINE, 1.0f, -1.0f, g.getXCoord(), (int)g.getYCoord(), g.getZCoord());
            return true;
        }
        return false;
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        SlotWidget slot = new SlotWidget((IItemHandlerModifiable)this.inventoryHandler, 0).setFilter(MTELargerTurbineBase::isValidTurbine);
        if (this.getBaseMetaTileEntity().isServerSide()) {
            slot.setChangeListener(this::sendUpdate);
        }
        builder.widget(slot.setAccess(false, true).setPos(79, 34));
    }

    public void receiveUpdate(PacketTurbineHatchUpdate message) {
        this.mHasTurbine = message.isHasTurbine();
        this.mFormed = message.isFormed();
        if (message.getController() != null) {
            this.clearController();
        } else {
            this.setController(message.getController());
        }
        this.getBaseMetaTileEntity().issueTextureUpdate();
        this.setTurbineOverlay();
    }

    public void sendUpdate() {
        PacketTurbineHatchUpdate message = new PacketTurbineHatchUpdate();
        message.setX(this.getBaseMetaTileEntity().getXCoord());
        message.setY(this.getBaseMetaTileEntity().getYCoord());
        message.setZ(this.getBaseMetaTileEntity().getZCoord());
        message.setFormed(this.mHasController && this.getController().mMachine);
        message.setHasTurbine(this.hasTurbine());
        message.setController(this.mControllerLocation);
        PacketHandler.sendToAllAround(message, this.getBaseMetaTileEntity().getWorld().field_73011_w.field_76574_g, this.getBaseMetaTileEntity().getXCoord(), this.getBaseMetaTileEntity().getYCoord(), this.getBaseMetaTileEntity().getZCoord(), 64.0);
    }

    @Override
    public void onRemoval() {
        super.onRemoval();
        if (this.getBaseMetaTileEntity().isClientSide()) {
            GTUtilityClient.clearTurbineOverlay(this.overlayTickets);
        }
    }
}

