/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.forestry;

import binnie.extratrees.genetics.ExtraTreeSpecies;
import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.EnumWoodType;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.TreeManager;
import forestry.api.genetics.IIndividual;
import forestry.arboriculture.genetics.TreeDefinition;
import forestry.plugins.PluginArboriculture;
import gtPlusPlus.core.util.reflect.ReflectionUtils;
import gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production.MTETreeFarm;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ForestryTreeHandler {
    public static void generateForestryTrees() {
        for (TreeDefinition tree : TreeDefinition.values()) {
            ItemStack[] produceList;
            String speciesUID = tree.getUID();
            ItemStack sapling = tree.getMemberStack(EnumGermlingType.SAPLING);
            EnumWoodType woodType = (EnumWoodType)ReflectionUtils.getField(tree, "woodType");
            ItemStack log = woodType != null ? TreeManager.woodItemAccess.getLog(woodType, false) : (ItemStack)ReflectionUtils.getField(tree, "vanillaWood");
            ItemStack leaves = new ItemStack((Block)PluginArboriculture.blocks.leaves, 1, 0);
            if (speciesUID != null) {
                NBTTagCompound nbtTagCompound = new NBTTagCompound();
                nbtTagCompound.func_74778_a("species", speciesUID);
                leaves.func_77982_d(nbtTagCompound);
            }
            ItemStack fruit = null;
            ITree individual = tree.getIndividual();
            if (individual.canBearFruit() && (produceList = individual.getProduceList()) != null && produceList.length > 0) {
                fruit = individual.getProduceList()[0];
            }
            MTETreeFarm.registerForestryTree(speciesUID, sapling == null ? null : sapling.func_77946_l(), log == null ? null : log.func_77946_l(), leaves.func_77946_l(), fruit == null ? null : fruit.func_77946_l());
        }
    }

    public static void generateExtraTreesTrees() {
        for (ExtraTreeSpecies species : ExtraTreeSpecies.values()) {
            ItemStack[] produceList;
            String speciesUID = species.getUID();
            ITree individual = TreeManager.treeRoot.templateAsIndividual(species.getTemplate());
            ItemStack sapling = TreeManager.treeRoot.getMemberStack((IIndividual)individual, 0);
            ItemStack log = null;
            if (species.getLog() != null) {
                log = species.getLog().getItemStack();
            }
            ItemStack leaves = new ItemStack((Block)PluginArboriculture.blocks.leaves, 1, 0);
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            nbtTagCompound.func_74778_a("species", speciesUID);
            leaves.func_77982_d(nbtTagCompound);
            ItemStack fruit = null;
            if (individual.canBearFruit() && (produceList = individual.getProduceList()) != null && produceList.length > 0) {
                fruit = individual.getProduceList()[0];
            }
            MTETreeFarm.registerForestryTree(speciesUID, sapling == null ? null : sapling.func_77946_l(), log == null ? null : log.func_77946_l(), leaves.func_77946_l(), fruit == null ? null : fruit.func_77946_l());
        }
    }
}

