/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.util.reflect;

import com.gtnewhorizon.gtnhlib.reflect.Fields;
import gtPlusPlus.api.objects.Logger;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;

public class ReflectionUtils {
    public static Map<String, CachedField> mCachedFields = new HashMap<String, CachedField>();
    public static Map<Field, Fields.ClassFields.Field> mCachedFieldAccessors = new HashMap<Field, Fields.ClassFields.Field>();

    private static Fields.ClassFields.Field cacheAccessor(Field f) {
        return mCachedFieldAccessors.computeIfAbsent(f, field -> Fields.ofClass(field.getDeclaringClass()).getUntypedField(Fields.LookupType.DECLARED_IN_HIERARCHY, field.getName()));
    }

    private static boolean cacheField(Class<?> aClass, Field aField) {
        if (aField == null) {
            return false;
        }
        boolean isStatic = Modifier.isStatic(aField.getModifiers());
        CachedField y = mCachedFields.get(aClass.getName() + "." + aField.getName());
        if (y == null) {
            mCachedFields.put(aClass.getName() + "." + aField.getName(), new CachedField(aField, isStatic));
            return true;
        }
        return false;
    }

    public static Field getField(Class<?> aClass, String aFieldName) {
        if (aClass == null || aFieldName == null || aFieldName.length() == 0) {
            return null;
        }
        CachedField y = mCachedFields.get(aClass.getName() + "." + aFieldName);
        if (y == null) {
            try {
                Field u = ReflectionUtils.getField_Internal(aClass, aFieldName);
                if (u != null) {
                    Logger.REFLECTION("Caching Field '" + aFieldName + "' from " + aClass.getName());
                    ReflectionUtils.cacheField(aClass, u);
                    return u;
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
            return null;
        }
        return y.get();
    }

    public static <T> T getField(Object aInstance, String aFieldName) {
        try {
            return (T)ReflectionUtils.getField(aInstance.getClass(), aFieldName).get(aInstance);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            return null;
        }
    }

    public static void makeFieldAccessible(Field field) {
        if (!Modifier.isPublic(field.getModifiers()) || !Modifier.isPublic(field.getDeclaringClass().getModifiers())) {
            field.setAccessible(true);
        }
    }

    public static boolean setField(Object object, Field field, Object fieldValue) {
        if (field == null) {
            return false;
        }
        Class<?> clazz = object instanceof Class ? (Class<?>)object : object.getClass();
        try {
            Field field2 = ReflectionUtils.getField(clazz, field.getName());
            if (field2 != null) {
                ReflectionUtils.setFieldValue_Internal(object, field, fieldValue);
                return true;
            }
        }
        catch (Exception e) {
            Logger.REFLECTION("setField(" + object + ", " + field.getName() + ") failed.");
            throw new IllegalStateException(e);
        }
        return false;
    }

    private static Field getField_Internal(Class<?> clazz, String fieldName) throws NoSuchFieldException {
        try {
            Logger.REFLECTION("Field: Internal Lookup: " + fieldName);
            Field k = clazz.getDeclaredField(fieldName);
            ReflectionUtils.makeFieldAccessible(k);
            return k;
        }
        catch (NoSuchFieldException e) {
            Logger.REFLECTION("Field: Internal Lookup Failed: " + fieldName);
            Class<?> superClass = clazz.getSuperclass();
            if (superClass == null) {
                Logger.REFLECTION("Unable to find field '" + fieldName + "'");
                throw e;
            }
            Logger.REFLECTION("Method: Recursion Lookup: " + fieldName + " - Checking in " + superClass.getName());
            return ReflectionUtils.getField_Internal(superClass, fieldName);
        }
    }

    private static void setFieldValue_Internal(Object owner, Field field, Object value) {
        ReflectionUtils.cacheAccessor(field).setValue(owner, value);
    }

    public static <T> T getFieldValue(Field field, Object instance) {
        try {
            return (T)field.get(instance);
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            return null;
        }
    }

    private static class CachedField {
        private final Field FIELD;

        public CachedField(Field aField, boolean isStatic) {
            this.FIELD = aField;
        }

        public Field get() {
            return this.FIELD;
        }
    }
}

