/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.proxy;

import codechicken.nei.api.API;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLLoadCompleteEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import gregtech.common.handlers.PowerGogglesHudHandler;
import gregtech.common.handlers.PowerGogglesKeybindHandler;
import gregtech.common.items.gui.PowerGogglesGuiOverlay;
import gtPlusPlus.GTplusplus;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.client.renderer.CustomItemBlockRenderer;
import gtPlusPlus.core.client.renderer.CustomOreBlockRenderer;
import gtPlusPlus.core.client.renderer.RenderDecayChest;
import gtPlusPlus.core.client.renderer.RenderMiningExplosivesPrimed;
import gtPlusPlus.core.client.renderer.RenderSickBlaze;
import gtPlusPlus.core.client.renderer.RenderStaballoyConstruct;
import gtPlusPlus.core.client.renderer.RenderToxinball;
import gtPlusPlus.core.common.CommonProxy;
import gtPlusPlus.core.config.Configuration;
import gtPlusPlus.core.entity.EntityPrimedMiningExplosive;
import gtPlusPlus.core.entity.monster.EntitySickBlaze;
import gtPlusPlus.core.entity.monster.EntityStaballoyConstruct;
import gtPlusPlus.core.entity.projectile.EntityLightningAttack;
import gtPlusPlus.core.entity.projectile.EntityToxinballSmall;
import gtPlusPlus.core.tileentities.general.TileEntityDecayablesChest;
import gtPlusPlus.nei.NEIGTPPConfig;
import gtPlusPlus.xmod.gregtech.common.render.FlaskRenderer;
import gtPlusPlus.xmod.gregtech.common.render.MachineBlockRenderer;
import ic2.core.item.ItemFluidCell;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderFireball;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class ClientProxy
extends CommonProxy {
    @Override
    public void preInit(FMLPreInitializationEvent e) {
        super.preInit(e);
        GTplusplus.loadTextures();
        PowerGogglesGuiOverlay.init();
    }

    @Override
    public void init(FMLInitializationEvent e) {
        new CustomOreBlockRenderer();
        new CustomItemBlockRenderer();
        new MachineBlockRenderer();
        new FlaskRenderer();
        MinecraftForge.EVENT_BUS.register((Object)new NEIGTPPConfig());
        MinecraftForge.EVENT_BUS.register((Object)new PowerGogglesHudHandler());
        PowerGogglesKeybindHandler.init();
        super.init(e);
    }

    @Override
    public void postInit(FMLPostInitializationEvent e) {
        super.postInit(e);
    }

    @Override
    public void registerRenderThings() {
        RenderingRegistry.registerEntityRenderingHandler(EntityPrimedMiningExplosive.class, (Render)new RenderMiningExplosivesPrimed());
        RenderingRegistry.registerEntityRenderingHandler(EntitySickBlaze.class, (Render)new RenderSickBlaze());
        RenderingRegistry.registerEntityRenderingHandler(EntityStaballoyConstruct.class, (Render)new RenderStaballoyConstruct());
        RenderingRegistry.registerEntityRenderingHandler(EntityToxinballSmall.class, (Render)new RenderToxinball(1.0f));
        RenderingRegistry.registerEntityRenderingHandler(EntityLightningAttack.class, (Render)new RenderFireball(1.0f));
        Logger.INFO("Registering Custom Renderer for the Lead Lined Chest.");
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityDecayablesChest.class, (TileEntitySpecialRenderer)new RenderDecayChest());
    }

    @Override
    public int addArmor(String armor) {
        return RenderingRegistry.addNewArmourRendererPrefix((String)armor);
    }

    @Override
    public void serverStarting(FMLServerStartingEvent e) {
    }

    @Override
    public void onLoadComplete(FMLLoadCompleteEvent event) {
        if (Configuration.features.hideUniversalCells) {
            this.hideUniversalCells();
        }
        super.onLoadComplete(event);
    }

    private void hideUniversalCells() {
        ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
        for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
            if (fluid == null) continue;
            itemList.add(ItemFluidCell.getUniversalFluidCell((FluidStack)new FluidStack(fluid, Integer.MAX_VALUE)));
        }
        for (ItemStack aCell : itemList) {
            API.hideItem((ItemStack)aCell);
        }
    }

    @Override
    public World getClientWorld() {
        return FMLClientHandler.instance().getClient().field_71441_e;
    }

    @Override
    public EntityPlayer getPlayerEntity(MessageContext ctx) {
        return ctx.side.isClient() ? Minecraft.func_71410_x().field_71439_g : super.getPlayerEntity(ctx);
    }
}

