/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.item.chemistry;

import gregtech.api.enums.Mods;
import gtPlusPlus.core.item.base.misc.BaseItemParticle;
import gtPlusPlus.core.material.Particle;
import gtPlusPlus.core.util.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;

public class StandardBaseParticles
extends BaseItemParticle {
    public static HashMap<String, Integer> NameToMetaMap = new HashMap();
    public static HashMap<Integer, String> MetaToNameMap = new HashMap();
    private static final String[] aTypes = new String[]{"Graviton", "Up", "Down", "Charm", "Strange", "Top", "Bottom", "Electron", "Electron Neutrino", "Muon", "Muon Neutrino", "Tau", "Tau Neutrino", "Gluon", "Photon", "Z Boson", "W Boson", "Higgs Boson", "Proton", "Neutron", "Lambda", "Omega", "Pion", "ETA Meson", "Unknown"};
    public IIcon[] icons = new IIcon[aTypes.length];

    public StandardBaseParticles() {
        super("Base", aTypes.length, EnumRarity.rare);
    }

    @Override
    public String[] getAffixes() {
        return new String[]{"", ""};
    }

    public String func_77658_a() {
        return "";
    }

    public String func_77667_c(ItemStack itemStack) {
        return "item.particle.base." + aTypes[itemStack.func_77960_j()];
    }

    public static Particle getParticle(ItemStack aStack) {
        ArrayList<Particle> g = Particle.aMap;
        for (Particle p : g) {
            String expectedPart;
            String aPartName = Utils.sanitizeString(p.mParticleName.toLowerCase());
            if (!aPartName.equals(expectedPart = Utils.sanitizeString(aTypes[aStack.func_77960_j()].toLowerCase()))) continue;
            return p;
        }
        return Particle.UNKNOWN;
    }

    @Override
    public int func_82790_a(ItemStack stack, int HEX_OxFFFFFF) {
        return super.getColorFromParentClass(stack, HEX_OxFFFFFF);
    }

    @Override
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean bool) {
        Particle aCharge = StandardBaseParticles.getParticle(stack);
        EnumChatFormatting aColour = EnumChatFormatting.GRAY;
        if (aCharge != null) {
            String aGroup = aCharge.mParticleType.name().toLowerCase();
            if (aGroup.toLowerCase().contains("quark")) {
                aColour = EnumChatFormatting.LIGHT_PURPLE;
            } else if (aGroup.toLowerCase().contains("lepton")) {
                aColour = EnumChatFormatting.GREEN;
            } else if (aCharge == Particle.HIGGS_BOSON) {
                aColour = EnumChatFormatting.YELLOW;
            } else if (aGroup.toLowerCase().contains("boson")) {
                aColour = EnumChatFormatting.RED;
            } else if (aGroup.toLowerCase().contains("baryon")) {
                aColour = EnumChatFormatting.BLUE;
            } else if (aGroup.toLowerCase().contains("meson")) {
                aColour = EnumChatFormatting.WHITE;
            }
            String aGroupKey = "gtpp.tooltip.base_particles.type." + aGroup;
            String aState = aColour + StatCollector.func_74838_a((String)aGroupKey) + EnumChatFormatting.RESET;
            list.add(EnumChatFormatting.GRAY + StatCollector.func_74837_a((String)"gtpp.tooltip.base_particles.type", (Object[])new Object[]{aState}));
        }
        super.func_77624_a(stack, player, list, bool);
    }

    public void func_94581_a(IIconRegister reg) {
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = reg.func_94245_a(Mods.GTPlusPlus.ID + ":particle/" + i);
        }
    }

    public IIcon func_77617_a(int meta) {
        return this.icons[meta];
    }

    static {
        int key = 0;
        for (String s : aTypes) {
            NameToMetaMap.put(Utils.sanitizeString(s.toLowerCase()), key);
            MetaToNameMap.put(key, Utils.sanitizeString(s.toLowerCase()));
            for (Particle o : Particle.aMap) {
                int aColour = 0;
                if (!o.mParticleName.equalsIgnoreCase(s)) continue;
                if (o.mParticleType == Particle.ElementaryGroup.BARYON) {
                    aColour = Utils.rgbtoHexValue(174, 226, 156);
                    aColourMap.put(key++, aColour);
                    continue;
                }
                if (o.mParticleType == Particle.ElementaryGroup.BOSON) {
                    if (o == Particle.HIGGS_BOSON) {
                        aColour = Utils.rgbtoHexValue(226, 196, 104);
                        aColourMap.put(key++, aColour);
                        continue;
                    }
                    aColour = Utils.rgbtoHexValue(226, 52, 66);
                    aColourMap.put(key++, aColour);
                    continue;
                }
                if (o.mParticleType == Particle.ElementaryGroup.LEPTON) {
                    aColour = Utils.rgbtoHexValue(126, 226, 95);
                    aColourMap.put(key++, aColour);
                    continue;
                }
                if (o.mParticleType == Particle.ElementaryGroup.MESON) {
                    aColour = Utils.rgbtoHexValue(90, 154, 226);
                    aColourMap.put(key++, aColour);
                    continue;
                }
                aColour = Utils.rgbtoHexValue(188, 61, 226);
                aColourMap.put(key++, aColour);
            }
        }
    }
}

