/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.item.base.misc;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.Mods;
import gregtech.api.util.GTLanguageManager;
import gregtech.api.util.GTOreDictUnificator;
import gtPlusPlus.core.creative.AddToCreativeTab;
import gtPlusPlus.core.util.Utils;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class BaseItemMisc
extends Item {
    public final String displayName;
    public final String unlocalName;
    public final MiscTypes miscType;
    public final Object componentColour;
    @SideOnly(value=Side.CLIENT)
    private IIcon secondIcon;

    public BaseItemMisc(String displayName, short[] RGB, int maxStackSize, MiscTypes miscType, String[] description) {
        this.displayName = displayName;
        String unlocalName = Utils.sanitizeString(displayName);
        this.unlocalName = "item" + miscType.TYPE + unlocalName;
        this.miscType = miscType;
        this.func_77637_a(AddToCreativeTab.tabMisc);
        this.func_77655_b(this.unlocalName);
        this.func_77625_d(maxStackSize);
        this.componentColour = RGB != null ? Integer.valueOf(Utils.rgbtoHexValue(RGB[0], RGB[1], RGB[2])) : null;
        if (description != null) {
            for (int i = 0; i < description.length; ++i) {
                GTLanguageManager.addStringLocalization("gtplusplus." + this.func_77658_a() + ".tooltip." + i, description[i]);
            }
        }
        GameRegistry.registerItem((Item)this, (String)this.unlocalName);
        GTOreDictUnificator.registerOre(miscType.getOreDictPrefix() + unlocalName, new ItemStack((Item)this));
    }

    private String getCorrectTextures() {
        return Mods.GTPlusPlus.ID + ":item" + this.miscType.TYPE;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return this.miscType == MiscTypes.DROP;
    }

    public int getRenderPasses(int meta) {
        return this.miscType == MiscTypes.DROP ? 2 : 1;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
        if (this.miscType == MiscTypes.DROP && Mods.Forestry.isModLoaded()) {
            this.field_77791_bV = par1IconRegister.func_94245_a("forestry:honeyDrop.0");
            this.secondIcon = par1IconRegister.func_94245_a("forestry:honeyDrop.1");
        } else {
            this.field_77791_bV = par1IconRegister.func_94245_a(this.getCorrectTextures());
        }
    }

    public IIcon getIcon(ItemStack stack, int pass) {
        return pass == 0 ? this.field_77791_bV : this.secondIcon;
    }

    public final void func_77624_a(ItemStack stack, EntityPlayer aPlayer, List list, boolean bool) {
        int i = 0;
        while (true) {
            String tooltip = GTLanguageManager.getTranslation("gtplusplus." + this.func_77658_a() + ".tooltip." + i);
            if (("gtplusplus." + this.func_77658_a() + ".tooltip." + i).equals(tooltip)) break;
            list.add(tooltip);
            ++i;
        }
    }

    public int func_82790_a(ItemStack stack, int HEX_OxFFFFFF) {
        if (this.componentColour == null) {
            return 0xFFFFFF;
        }
        return (Integer)this.componentColour;
    }

    public void func_77663_a(ItemStack iStack, World world, Entity entityHolding, int p_77663_4_, boolean p_77663_5_) {
    }

    public static enum MiscTypes {
        POTION("Potion", " Potion", "potion"),
        KEY("Key", " Key", "key"),
        BIGKEY("KeyBig", " Big Key", "bosskey"),
        BOTTLE("Bottle", " Bottle", "bottle"),
        GEM("Gem", " Gemstone", "gem"),
        DROP("Droplet", " Droplet", "droplet"),
        MUSHROOM("Mushroom", " Mushroom", "mushroom");

        private final String TYPE;
        private final String DISPLAY_NAME_SUFFIX;
        private final String OREDICT_PREFIX;

        private MiscTypes(String LocalName, String DisplayNameSuffix, String OreDictPrefix) {
            this.TYPE = LocalName;
            this.DISPLAY_NAME_SUFFIX = DisplayNameSuffix;
            this.OREDICT_PREFIX = OreDictPrefix;
        }

        public String getType() {
            return this.TYPE;
        }

        public String getName() {
            return this.DISPLAY_NAME_SUFFIX;
        }

        public String getOreDictPrefix() {
            return this.OREDICT_PREFIX;
        }
    }
}

