/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.handler.events;

import com.kuba6000.mobsinfo.api.IMobExtraInfoProvider;
import com.kuba6000.mobsinfo.api.MobDrop;
import com.kuba6000.mobsinfo.api.MobRecipe;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import gregtech.api.util.GTUtility;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.item.ModItems;
import gtPlusPlus.core.util.math.MathUtils;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.NotNull;

@Optional.Interface(iface="com.kuba6000.mobsinfo.api.IMobExtraInfoProvider", modid="mobsinfo")
public class EntityDeathHandler
implements IMobExtraInfoProvider {
    private static final HashMap<Class<?>, ArrayList<Triple<ItemStack, Integer, Integer>>> mMobDropMap = new HashMap();
    private static final ArrayList<Class<?>> mInternalClassKeyCache = new ArrayList();

    public static void registerDropsForMob(Class aMobClass, ItemStack aStack, int aMaxAmount, int aChance) {
        Triple aData = Triple.of((Object)aStack, (Object)aMaxAmount, (Object)aChance);
        ArrayList<Object> aDataMap = mMobDropMap.get(aMobClass);
        if (aDataMap == null) {
            aDataMap = new ArrayList();
        }
        aDataMap.add((Triple<ItemStack, Integer, Integer>)aData);
        mMobDropMap.put(aMobClass, aDataMap);
        Logger.INFO("[Loot] Registered " + aStack.func_82833_r() + " (1-" + aMaxAmount + ") as a valid drop for " + aMobClass.getCanonicalName());
        mInternalClassKeyCache.add(aMobClass);
    }

    private static ItemStack processItemDropTriplet(Triple<ItemStack, Integer, Integer> aData) {
        ItemStack aLoot = (ItemStack)aData.getLeft();
        int aMaxDrop = (Integer)aData.getMiddle();
        int aChanceOutOf10000 = (Integer)aData.getRight();
        if (MathUtils.randInt(0, 10000) <= aChanceOutOf10000 && (aLoot = GTUtility.copyAmount(MathUtils.randInt(1, aMaxDrop), aLoot)) != null) {
            return aLoot;
        }
        return null;
    }

    private static boolean processDropsForMob(EntityLivingBase entityLiving) {
        ArrayList<Triple<ItemStack, Integer, Integer>> aMobData = mMobDropMap.get(entityLiving.getClass());
        boolean aDidDrop = false;
        if (aMobData != null && !aMobData.isEmpty()) {
            for (Triple<ItemStack, Integer, Integer> g : aMobData) {
                ItemStack aPossibleDrop = EntityDeathHandler.processItemDropTriplet(g);
                if (aPossibleDrop == null || entityLiving.func_70099_a(aPossibleDrop, MathUtils.randFloat(0.0f, 1.0f)) == null) continue;
                aDidDrop = true;
            }
        }
        return aDidDrop;
    }

    private static void dropMeatFromPlayer(EntityPlayer aPlayer) {
        int aBigMeatStackSize1 = MathUtils.randInt(4, 8);
        aPlayer.func_70099_a(new ItemStack((Item)ModItems.itemMetaFood, aBigMeatStackSize1), (float)MathUtils.randInt(0, 1));
        if (MathUtils.randInt(0, 10) < 7) {
            int aBigMeatStackSize2 = MathUtils.randInt(4, 8);
            aPlayer.func_70099_a(new ItemStack((Item)ModItems.itemMetaFood, aBigMeatStackSize2), (float)MathUtils.randInt(0, 1));
        }
        if (MathUtils.randInt(0, 10) < 4) {
            int aBigMeatStackSize3 = MathUtils.randInt(4, 8);
            aPlayer.func_70099_a(new ItemStack((Item)ModItems.itemMetaFood, aBigMeatStackSize3), (float)MathUtils.randInt(0, 1));
        }
        if (MathUtils.randInt(0, 10) < 2) {
            int aBigMeatStackSize4 = MathUtils.randInt(4, 8);
            aPlayer.func_70099_a(new ItemStack((Item)ModItems.itemMetaFood, aBigMeatStackSize4), (float)MathUtils.randInt(0, 1));
        }
    }

    @SubscribeEvent
    public void onEntityDrop(LivingDropsEvent event) {
        if (event == null || event.entityLiving == null) {
            return;
        }
        if (EntityDeathHandler.isRealPlayer(event.entityLiving)) {
            EntityPlayer aPlayer = (EntityPlayer)event.entityLiving;
            EntityDeathHandler.dropMeatFromPlayer(aPlayer);
        } else {
            for (Class<?> c : mInternalClassKeyCache) {
                if (!c.isInstance(event.entityLiving)) continue;
                EntityDeathHandler.processDropsForMob(event.entityLiving);
            }
        }
    }

    private static boolean isRealPlayer(EntityLivingBase entity) {
        EntityPlayer p;
        return entity instanceof EntityPlayer && !(p = (EntityPlayer)entity).getClass().getName().contains("Fake");
    }

    @Optional.Method(modid="mobsinfo")
    public void provideExtraDropsInformation(@NotNull String entityString, @NotNull ArrayList<MobDrop> drops, @NotNull MobRecipe recipe) {
        ArrayList<Triple<ItemStack, Integer, Integer>> dropEntry = mMobDropMap.get(recipe.entity.getClass());
        if (dropEntry != null && !dropEntry.isEmpty()) {
            for (Triple<ItemStack, Integer, Integer> data : dropEntry) {
                ItemStack loot = (ItemStack)data.getLeft();
                int maxDrop = (Integer)data.getMiddle();
                int chance = (Integer)data.getRight();
                if (loot == null) continue;
                loot = loot.func_77946_l();
                loot.field_77994_a = 1;
                MobDrop drop = new MobDrop(loot, MobDrop.DropType.Normal, (int)(MobDrop.getChanceBasedOnFromTo((int)1, (int)maxDrop) * 10000.0 * ((double)chance / 10000.0)), null, null, false, false);
                drop.clampChance();
                drops.add(drop);
            }
        }
    }
}

