/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.block.base;

import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.GTMod;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTOreDictUnificator;
import gtPlusPlus.api.interfaces.ITexturedBlock;
import gtPlusPlus.core.block.base.BasicBlock;
import gtPlusPlus.core.client.renderer.CustomOreBlockRenderer;
import gtPlusPlus.core.item.base.itemblock.ItemBlockOre;
import gtPlusPlus.core.util.Utils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockBaseOre
extends BasicBlock
implements ITexturedBlock {
    private final gtPlusPlus.core.material.Material blockMaterial;
    protected static boolean shouldFortune = false;
    protected static boolean shouldSilkTouch = false;

    public BlockBaseOre(gtPlusPlus.core.material.Material material, BasicBlock.BlockTypes blockType) {
        super(blockType, Utils.sanitizeString(material.getUnlocalizedName()), Material.field_151576_e, Math.min(Math.max(material.vTier, 1), 6));
        int aMaterialTierForMining = Math.min(Math.max(material.vTier, 1), 6);
        this.blockMaterial = material;
        this.func_149711_c(1.0f * (float)aMaterialTierForMining);
        this.func_149752_b(6.0f);
        this.func_149715_a(0.0f);
        this.setHarvestLevel("pickaxe", aMaterialTierForMining);
        this.func_149672_a(field_149769_e);
        this.func_149663_c("Ore" + Utils.sanitizeString(Utils.sanitizeString(material.getUnlocalizedName())));
        this.func_149658_d("stone");
        try {
            GameRegistry.registerBlock((Block)this, ItemBlockOre.class, (String)Utils.sanitizeString("ore" + Utils.sanitizeString(this.blockMaterial.getLocalizedName())));
            GTOreDictUnificator.registerOre("ore" + Utils.sanitizeString(this.blockMaterial.getLocalizedName()), new ItemStack((Block)this));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public gtPlusPlus.core.material.Material getMaterialEx() {
        return this.blockMaterial;
    }

    public int func_149645_b() {
        try {
            if (CustomOreBlockRenderer.INSTANCE != null) {
                return CustomOreBlockRenderer.INSTANCE.mRenderID;
            }
            return super.func_149645_b();
        }
        catch (NullPointerException n) {
            return 0;
        }
    }

    public IIcon func_149673_e(IBlockAccess aIBlockAccess, int aX, int aY, int aZ, int ordinalSide) {
        return Blocks.field_150348_b.func_149691_a(0, 0);
    }

    public IIcon func_149691_a(int ordinalSide, int aMeta) {
        return Blocks.field_150348_b.func_149691_a(0, 0);
    }

    @Override
    public ITexture[] getTexture(ForgeDirection side) {
        return this.getTexture(null, side);
    }

    @Override
    public ITexture[] getTexture(Block block, ForgeDirection side) {
        if (this.blockMaterial != null) {
            ITexture texture = TextureFactory.builder().addIcon(this.blockMaterial.getTextureSet().mTextures[OrePrefixes.ore.mTextureIndex]).setRGBA(this.blockMaterial.getRGBA()).stdOrient().build();
            return new ITexture[]{TextureFactory.of(Blocks.field_150348_b, 0), texture};
        }
        return new ITexture[]{TextureFactory.builder().addIcon(Textures.BlockIcons.STONES[0]).setRGBA(new short[]{240, 240, 240, 0}).stdOrient().build()};
    }

    public void func_149651_a(IIconRegister p_149651_1_) {
    }

    public void func_149636_a(World worldIn, EntityPlayer player, int x, int y, int z, int meta) {
        if (EnchantmentHelper.func_77502_d((EntityLivingBase)player)) {
            shouldSilkTouch = true;
            super.func_149636_a(worldIn, player, x, y, z, meta);
            if (shouldSilkTouch) {
                shouldSilkTouch = false;
            }
            return;
        }
        if (!(player instanceof FakePlayer)) {
            shouldFortune = true;
        }
        super.func_149636_a(worldIn, player, x, y, z, meta);
        if (shouldFortune) {
            shouldFortune = false;
        }
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        if (shouldSilkTouch) {
            drops.add(new ItemStack((Block)this, 1, metadata));
        } else {
            switch (GTMod.proxy.oreDropSystem) {
                case Item: {
                    drops.add(ItemUtils.getItemStackOfAmountFromOreDictNoBroken("oreRaw" + this.blockMaterial.getLocalizedName(), 1));
                    break;
                }
                case FortuneItem: {
                    if (shouldFortune && fortune > 0) {
                        int aMinAmount = 1;
                        if (fortune > 3) {
                            fortune = 3;
                        }
                        long amount = (long)new Random().nextInt(fortune) + (long)aMinAmount;
                        int i = 0;
                        while ((long)i < amount) {
                            drops.add(ItemUtils.getItemStackOfAmountFromOreDictNoBroken("oreRaw" + this.blockMaterial.getLocalizedName(), 1));
                            ++i;
                        }
                        break;
                    }
                    drops.add(ItemUtils.getItemStackOfAmountFromOreDictNoBroken("oreRaw" + this.blockMaterial.getLocalizedName(), 1));
                    break;
                }
                case UnifiedBlock: 
                case PerDimBlock: 
                case Block: {
                    drops.add(new ItemStack((Block)this, 1, metadata));
                }
            }
        }
        return drops;
    }
}

