/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.storage;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import com.gtnewhorizons.modularui.api.NumberFormatMUI;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.modularui.IAddUIWidgets;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTETieredMachineBlock;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTLanguageManager;
import gregtech.api.util.GTUtility;
import gregtech.common.tileentities.storage.MTEQuantumChest;
import gregtech.crossmod.ae2.IMEAwareItemInventory;
import gregtech.crossmod.ae2.MEItemInventoryHandler;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class MTEDigitalChestBase
extends MTETieredMachineBlock
implements IMEMonitor<IAEItemStack>,
IMEAwareItemInventory,
IAddUIWidgets {
    protected boolean mVoidOverflow = false;
    protected boolean mDisableFilter;
    private final MEItemInventoryHandler<?> meInventoryHandler = new MEItemInventoryHandler<MTEDigitalChestBase>(this);
    protected static final NumberFormatMUI numberFormat = new NumberFormatMUI();
    protected int clientItemCount;

    public MTEDigitalChestBase(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 3, new String[]{"Stores " + GTUtility.formatNumbers(MTEDigitalChestBase.commonSizeCompute(aTier)) + " items", "Use a screwdriver to enable", "voiding items on overflow", "Will keep its contents when harvested"}, new ITexture[0]);
    }

    protected static int commonSizeCompute(int tier) {
        int n;
        switch (tier) {
            case 1: {
                n = 4000000;
                break;
            }
            case 2: {
                n = 8000000;
                break;
            }
            case 3: {
                n = 16000000;
                break;
            }
            case 4: {
                n = 32000000;
                break;
            }
            case 5: {
                n = 64000000;
                break;
            }
            case 6: {
                n = 128000000;
                break;
            }
            case 7: {
                n = 256000000;
                break;
            }
            case 8: {
                n = 512000000;
                break;
            }
            case 9: {
                n = 1024000000;
                break;
            }
            case 10: {
                n = 0x7FFFFFF8;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    public MTEDigitalChestBase(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 3, aDescription, aTextures);
    }

    @Override
    public void addAdditionalTooltipInformation(ItemStack stack, List<String> tooltip) {
        if (stack.func_77942_o() && stack.field_77990_d.func_74764_b("mItemStack")) {
            ItemStack tContents = ItemStack.func_77949_a((NBTTagCompound)stack.field_77990_d.func_74775_l("mItemStack"));
            int tSize = stack.field_77990_d.func_74762_e("mItemCount");
            if (tContents != null && tSize > 0) {
                tooltip.add(GTLanguageManager.addStringLocalization("TileEntity_CHEST_INFO", "Contains Item: ") + EnumChatFormatting.YELLOW + tContents.func_82833_r() + EnumChatFormatting.GRAY);
                tooltip.add(GTLanguageManager.addStringLocalization("TileEntity_CHEST_AMOUNT", "Item Amount: ") + EnumChatFormatting.GREEN + GTUtility.formatNumbers(tSize) + EnumChatFormatting.GRAY);
            }
        }
    }

    public void addListener(IMEMonitorHandlerReceiver<IAEItemStack> imeMonitorHandlerReceiver, Object o) {
        this.meInventoryHandler.addListener(imeMonitorHandlerReceiver, o);
    }

    public void removeListener(IMEMonitorHandlerReceiver<IAEItemStack> imeMonitorHandlerReceiver) {
        this.meInventoryHandler.removeListener(imeMonitorHandlerReceiver);
    }

    public AccessRestriction getAccess() {
        return this.meInventoryHandler.getAccess();
    }

    public boolean isPrioritized(IAEItemStack iaeItemStack) {
        return this.meInventoryHandler.isPrioritized(iaeItemStack);
    }

    public boolean canAccept(IAEItemStack iaeItemStack) {
        return this.meInventoryHandler.canAccept(iaeItemStack);
    }

    public int getPriority() {
        return this.meInventoryHandler.getPriority();
    }

    public int getSlot() {
        return this.meInventoryHandler.getSlot();
    }

    public boolean validForPass(int i) {
        return this.meInventoryHandler.validForPass(i);
    }

    @Override
    public abstract ItemStack getItemStack();

    @Override
    public abstract void setItemStack(ItemStack var1);

    public IItemList<IAEItemStack> getAvailableItems(IItemList<IAEItemStack> out, int iteration) {
        return this.meInventoryHandler.getAvailableItems(out, iteration);
    }

    public IItemList<IAEItemStack> getStorageList() {
        return this.meInventoryHandler.getStorageList();
    }

    @Override
    public abstract int getItemCount();

    @Override
    public abstract void setItemCount(int var1);

    @Override
    public int getMaxItemCount() {
        return MTEDigitalChestBase.commonSizeCompute(this.mTier);
    }

    @Override
    public int getItemCapacity() {
        return this.getMaxItemCount();
    }

    @Override
    public ItemStack getExtraItemStack() {
        return this.mInventory[1];
    }

    @Override
    public void setExtraItemStack(ItemStack stack) {
        this.mInventory[1] = stack;
    }

    @Override
    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        return new ITexture[0][0][0];
    }

    public IAEItemStack injectItems(IAEItemStack input, Actionable mode, BaseActionSource src) {
        IAEItemStack returnStack = this.meInventoryHandler.injectItems(input, mode, src);
        if (this.mVoidOverflow) {
            return null;
        }
        return returnStack;
    }

    public IAEItemStack extractItems(IAEItemStack request, Actionable mode, BaseActionSource src) {
        return this.meInventoryHandler.extractItems(request, mode, src);
    }

    public StorageChannel getChannel() {
        return this.meInventoryHandler.getChannel();
    }

    @Override
    public final void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aTool) {
        this.mVoidOverflow = !this.mVoidOverflow;
        GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)(this.mVoidOverflow ? "GT5U.machines.digitalchest.voidoverflow.enabled" : "GT5U.machines.digitalchest.voidoverflow.disabled")));
    }

    @Override
    public boolean onSolderingToolRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aTool) {
        this.mDisableFilter = !this.mDisableFilter;
        GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)(this.mDisableFilter ? "GT5U.machines.digitalchest.inputfilter.disabled" : "GT5U.machines.digitalchest.inputfilter.enabled")));
        return true;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTimer) {
        if (this.getBaseMetaTileEntity().isServerSide()) {
            int availableSpace;
            if (this.getItemCount() <= 0) {
                this.setItemStack(null);
                this.setItemCount(0);
            }
            if (this.getItemStack() == null && this.mInventory[0] != null) {
                this.setItemStack(this.mInventory[0].func_77946_l());
            }
            int count = this.getItemCount();
            ItemStack stack = this.getItemStack();
            int savedCount = count;
            int n = availableSpace = this.mVoidOverflow ? this.getMaxItemCount() : this.getMaxItemCount() - savedCount;
            if (this.mInventory[0] != null && availableSpace > 0 && GTUtility.areStacksEqual(this.mInventory[0], stack)) {
                int stackToMove = Math.min(this.mInventory[0].field_77994_a, availableSpace);
                count = (int)Math.min((long)count + (long)stackToMove, (long)this.getMaxItemCount());
                this.mInventory[0].field_77994_a -= stackToMove;
                if (this.mInventory[0].field_77994_a <= 0) {
                    this.mInventory[0] = null;
                }
            }
            if (this.mInventory[1] == null && stack != null) {
                this.mInventory[1] = stack.func_77946_l();
                this.mInventory[1].field_77994_a = Math.min(stack.func_77976_d(), count);
                count -= this.mInventory[1].field_77994_a;
            } else if (count > 0 && GTUtility.areStacksEqual(this.mInventory[1], stack) && this.mInventory[1].func_77976_d() > this.mInventory[1].field_77994_a) {
                int tmp = Math.min(count, this.mInventory[1].func_77976_d() - this.mInventory[1].field_77994_a);
                this.mInventory[1].field_77994_a += tmp;
                count -= tmp;
            }
            this.setItemCount(count);
            if (stack != null) {
                this.mInventory[2] = stack.func_77946_l();
                this.mInventory[2].field_77994_a = Math.min(stack.func_77976_d(), count);
            } else {
                this.mInventory[2] = null;
            }
            this.meInventoryHandler.notifyListeners(count - savedCount, stack);
            if (count != savedCount) {
                this.getBaseMetaTileEntity().func_70296_d();
            }
        }
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        this.openGui(aPlayer);
        return true;
    }

    @Override
    public boolean isFacingValid(ForgeDirection facing) {
        return true;
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return aIndex != 2;
    }

    @Override
    public int getProgresstime() {
        return this.getItemCount() + (this.mInventory[0] == null ? 0 : this.mInventory[0].field_77994_a) + (this.mInventory[1] == null ? 0 : this.mInventory[1].field_77994_a);
    }

    @Override
    public int maxProgresstime() {
        return this.getMaxItemCount();
    }

    @Override
    public boolean isGivingInformation() {
        return true;
    }

    @Override
    public String[] getInfoData() {
        if (this.getItemStack() == null) {
            return new String[]{EnumChatFormatting.BLUE + this.localizedChestName() + EnumChatFormatting.RESET, StatCollector.func_74838_a((String)"GT5U.infodata.digital_chest.stored_items"), EnumChatFormatting.GOLD + StatCollector.func_74838_a((String)"GT5U.infodata.digital_chest.stored_items.empty") + EnumChatFormatting.RESET, EnumChatFormatting.GREEN + "0" + EnumChatFormatting.RESET + " " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers(this.getMaxItemCount()) + EnumChatFormatting.RESET};
        }
        return new String[]{EnumChatFormatting.BLUE + this.localizedChestName() + EnumChatFormatting.RESET, StatCollector.func_74838_a((String)"GT5U.infodata.digital_chest.stored_items"), EnumChatFormatting.GOLD + this.getItemStack().func_82833_r() + EnumChatFormatting.RESET, EnumChatFormatting.GREEN + GTUtility.formatNumbers(this.getItemCount()) + EnumChatFormatting.RESET + " " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers(this.getMaxItemCount()) + EnumChatFormatting.RESET};
    }

    @Override
    public ItemStack[] getStoredItemData() {
        return this.mInventory;
    }

    protected abstract String localizedChestName();

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74768_a("mItemCount", this.getItemCount());
        if (this.getItemStack() != null) {
            aNBT.func_74782_a("mItemStack", (NBTBase)this.getItemStack().func_77955_b(new NBTTagCompound()));
        }
        aNBT.func_74757_a("mVoidOverflow", this.mVoidOverflow);
        aNBT.func_74757_a("mDisableFilter", this.mDisableFilter);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        if (aNBT.func_74764_b("mItemCount")) {
            this.setItemCount(aNBT.func_74762_e("mItemCount"));
        }
        if (aNBT.func_74764_b("mItemStack")) {
            this.setItemStack(ItemStack.func_77949_a((NBTTagCompound)((NBTTagCompound)aNBT.func_74781_a("mItemStack"))));
        }
        this.mVoidOverflow = aNBT.func_74767_n("mVoidOverflow");
        this.mDisableFilter = aNBT.func_74767_n("mDisableFilter");
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        if (GTValues.disableDigitalChestsExternalAccess && this.meInventoryHandler.hasActiveMEConnection()) {
            return false;
        }
        return aIndex == 1;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        if (GTValues.disableDigitalChestsExternalAccess && this.meInventoryHandler.hasActiveMEConnection()) {
            return false;
        }
        if (aIndex != 0) {
            return false;
        }
        if (this.mInventory[0] != null && !GTUtility.areStacksEqual(this.mInventory[0], aStack)) {
            return false;
        }
        if (this.mDisableFilter) {
            return true;
        }
        if (this.getItemStack() == null) {
            return this.mInventory[1] == null || GTUtility.areStacksEqual(this.mInventory[1], aStack);
        }
        return GTUtility.areStacksEqual(this.getItemStack(), aStack);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection aFacing, int colorIndex, boolean aActive, boolean redstoneLevel) {
        if (side != aFacing) {
            return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][colorIndex + 1]};
        }
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][colorIndex + 1], TextureFactory.of(Textures.BlockIcons.OVERLAY_SCHEST), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_SCHEST_GLOW).glow().build()};
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currenttip, accessor, config);
        NBTTagCompound tag = accessor.getNBTData();
        if (tag.func_150297_b("itemType", 10)) {
            currenttip.add("Item Count: " + GTUtility.formatNumbers(tag.func_74763_f("itemCount")));
            currenttip.add("Item Type: " + ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("itemType")).func_82833_r());
        } else {
            currenttip.add("Chest Empty");
        }
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        ItemStack is = this.getItemStack();
        if (GTUtility.isStackInvalid(is)) {
            return;
        }
        long realItemCount = this.getItemCount();
        if (GTUtility.isStackValid(this.mInventory[1]) && GTUtility.areStacksEqual(this.mInventory[1], is)) {
            realItemCount += (long)this.mInventory[1].field_77994_a;
        }
        tag.func_74772_a("itemCount", realItemCount);
        tag.func_74782_a("itemType", (NBTBase)is.func_77955_b(new NBTTagCompound()));
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new DrawableWidget().setDrawable((IDrawable)GTUITextures.PICTURE_SCREEN_BLACK).setPos(7, 16).setSize(71, 45))).widget(new SlotWidget((IItemHandlerModifiable)this.inventoryHandler, 0).setBackground(new IDrawable[]{this.getGUITextureSet().getItemSlot(), GTUITextures.OVERLAY_SLOT_IN}).setPos(79, 16))).widget(new SlotWidget((IItemHandlerModifiable)this.inventoryHandler, 1).setAccess(true, false).setBackground(new IDrawable[]{this.getGUITextureSet().getItemSlot(), GTUITextures.OVERLAY_SLOT_OUT}).setPos(79, 52))).widget(SlotWidget.phantom((IItemHandlerModifiable)this.inventoryHandler, (int)2).disableInteraction().setBackground(new IDrawable[]{GTUITextures.TRANSPARENT}).setPos(59, 42))).widget(new TextWidget(StatCollector.func_74838_a((String)"GT5U.gui.text.item_amount")).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(10, 20))).widget(new TextWidget().setStringSupplier(() -> numberFormat.format((long)this.clientItemCount)).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(10, 30))).widget((Widget)new FakeSyncWidget.IntegerSyncer(() -> this instanceof MTEQuantumChest ? ((MTEQuantumChest)this).mItemCount : 0, value -> {
            this.clientItemCount = value;
        }));
    }
}

