/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi.purification;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.enums.TierEU;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatchInput;
import gregtech.api.metatileentity.implementations.MTEHatchInputBus;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.shutdown.ShutDownReasonRegistry;
import gregtech.common.items.IDMetaItem03;
import gregtech.common.items.MetaGeneratedItem03;
import gregtech.common.tileentities.machines.MTEHatchInputBusME;
import gregtech.common.tileentities.machines.multi.purification.MTEPurificationUnitBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class MTEPurificationUnitBaryonicPerfection
extends MTEPurificationUnitBase<MTEPurificationUnitBaryonicPerfection>
implements ISurvivalConstructable {
    public static long BARYONIC_MATTER_OUTPUT = 2000L;
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final int STRUCTURE_X_OFFSET = 8;
    private static final int STRUCTURE_Y_OFFSET = 8;
    private static final int STRUCTURE_Z_OFFSET = 0;
    static final String[][] structure = new String[][]{{"                 ", "                 ", "                 ", "                 ", "                 ", "                 ", "      AAAAA      ", "      AAAAA      ", "      AA~AA      ", "      AAAAA      ", "      AAAAA      ", "                 ", "                 ", "                 ", "                 ", "                 ", "                 "}, {"                 ", "        E        ", "        E        ", "        E        ", "        E        ", "        E        ", "      AAAAA      ", "      AAAAA      ", " EEEEEAAAAAEEEEE ", "      AAAAA      ", "      AAAAA      ", "        E        ", "        E        ", "        E        ", "        E        ", "        E        ", "                 "}, {"                 ", "        E        ", "                 ", "                 ", "                 ", "                 ", "      CCCCC      ", "      CDDDC      ", " E    CDBDC    E ", "      CDDDC      ", "      CCCCC      ", "                 ", "                 ", "                 ", "                 ", "        E        ", "                 "}, {"                 ", "        E        ", "                 ", "                 ", "                 ", "                 ", "                 ", "       DDD       ", " E     DBD     E ", "       DDD       ", "                 ", "                 ", "                 ", "                 ", "                 ", "        E        ", "                 "}, {"                 ", "        E        ", "                 ", "                 ", "                 ", "                 ", "                 ", "       DDD       ", " E     DBD     E ", "       DDD       ", "                 ", "                 ", "                 ", "                 ", "                 ", "        E        ", "                 "}, {"                 ", "        E        ", "                 ", "                 ", "                 ", "                 ", "                 ", "       DDD       ", " E     DBD     E ", "       DDD       ", "                 ", "                 ", "                 ", "                 ", "                 ", "        E        ", "                 "}, {"      AAAAA      ", "      AAAAA      ", "      CCCCC      ", "                 ", "                 ", "                 ", "AAC   AAAAA   CAA", "AAC   ADDDA   CAA", "AAC   ADBDA   CAA", "AAC   ADDDA   CAA", "AAC   AAAAA   CAA", "                 ", "                 ", "                 ", "      CCCCC      ", "      AAAAA      ", "      AAAAA      "}, {"      AAAAA      ", "      AAAAA      ", "      CDDDC      ", "       DDD       ", "       DDD       ", "       DDD       ", "AAC   ADDDA   CAA", "AADDDDD   DDDDDAA", "AADDDDD B DDDDDAA", "AADDDDD   DDDDDAA", "AAC   ADDDA   CAA", "       DDD       ", "       DDD       ", "       DDD       ", "      CDDDC      ", "      AAAAA      ", "      AAAAA      "}, {"      AAAAA      ", " EEEEEAAAAAEEEEE ", " E    CDBDC    E ", " E     DBD     E ", " E     DBD     E ", " E     DBD     E ", "AAC   ADBDA   CAA", "AADDDDD B DDDDDAA", "AABBBBBBBBBBBBBAA", "AADDDDD B DDDDDAA", "AAC   ADBDA   CAA", " E     DBD     E ", " E     DBD     E ", " E     DBD     E ", " E    CDBDC    E ", " EEEEEAAAAAEEEEE ", "      AAAAA      "}, {"      AAAAA      ", "      AAAAA      ", "      CDDDC      ", "       DDD       ", "       DDD       ", "       DDD       ", "AAC   ADDDA   CAA", "AADDDDD   DDDDDAA", "AADDDDD B DDDDDAA", "AADDDDD   DDDDDAA", "AAC   ADDDA   CAA", "       DDD       ", "       DDD       ", "       DDD       ", "      CDDDC      ", "      AAAAA      ", "      AAAAA      "}, {"      AAAAA      ", "      AAAAA      ", "      CCCCC      ", "                 ", "                 ", "                 ", "AAC   AAAAA   CAA", "AAC   ADDDA   CAA", "AAC   ADBDA   CAA", "AAC   ADDDA   CAA", "AAC   AAAAA   CAA", "                 ", "                 ", "                 ", "      CCCCC      ", "      AAAAA      ", "      AAAAA      "}, {"                 ", "        E        ", "                 ", "                 ", "                 ", "                 ", "                 ", "       DDD       ", " E     DBD     E ", "       DDD       ", "                 ", "                 ", "                 ", "                 ", "                 ", "        E        ", "                 "}, {"                 ", "        E        ", "                 ", "                 ", "                 ", "                 ", "                 ", "       DDD       ", " E     DBD     E ", "       DDD       ", "                 ", "                 ", "                 ", "                 ", "                 ", "        E        ", "                 "}, {"                 ", "        E        ", "                 ", "                 ", "                 ", "                 ", "                 ", "       DDD       ", " E     DBD     E ", "       DDD       ", "                 ", "                 ", "                 ", "                 ", "                 ", "        E        ", "                 "}, {"                 ", "        E        ", "                 ", "                 ", "                 ", "                 ", "      CCCCC      ", "      CDDDC      ", " E    CDBDC    E ", "      CDDDC      ", "      CCCCC      ", "                 ", "                 ", "                 ", "                 ", "        E        ", "                 "}, {"                 ", "        E        ", "        E        ", "        E        ", "        E        ", "        E        ", "      AAAAA      ", "      AAAAA      ", " EEEEEAAAAAEEEEE ", "      AAAAA      ", "      AAAAA      ", "        E        ", "        E        ", "        E        ", "        E        ", "        E        ", "                 "}, {"                 ", "                 ", "                 ", "                 ", "                 ", "                 ", "      AAAAA      ", "      AAAAA      ", "      AAAAA      ", "      AAAAA      ", "      AAAAA      ", "                 ", "                 ", "                 ", "                 ", "                 ", "                 "}};
    private static final int CASING_INDEX_MAIN = MTEPurificationUnitBaryonicPerfection.getTextureIndex(GregTechAPI.sBlockCasings10, 2);
    private static final IStructureDefinition<MTEPurificationUnitBaryonicPerfection> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", structure).addElement('A', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{StructureUtility.lazy(t -> GTStructureUtility.buildHatchAdder().atLeastList(Arrays.asList(HatchElement.InputBus, HatchElement.OutputBus, HatchElement.InputHatch, HatchElement.OutputHatch)).dot(1).casingIndex(CASING_INDEX_MAIN).build()), StructureUtility.onElementPass(t -> ++t.numCasings, (IStructureElement)StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings10, (int)2))})).addElement('B', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings9, (int)14)).addElement('C', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings9, (int)15)).addElement('D', StructureUtility.ofBlock((Block)GregTechAPI.sBlockGlass1, (int)3)).addElement('E', GTStructureUtility.ofFrame(Materials.Bedrockium)).build();
    private CatalystCombination currentCombination = null;
    private ArrayList<ItemStack> insertedCatalysts = new ArrayList();
    private static final long CATALYST_BASE_COST = 144L;
    private int correctStartIndex = -1;
    private int numCasings = 0;
    private static final int MIN_CASINGS = 300;

    private static CatalystCombination generateNewCombination() {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        int firstIndex = random.nextInt(0, CatalystCombination.CATALYST_ITEMS.length);
        int secondIndex = random.nextInt(0, CatalystCombination.CATALYST_ITEMS.length);
        while (secondIndex == firstIndex) {
            secondIndex = random.nextInt(0, CatalystCombination.CATALYST_ITEMS.length);
        }
        return new CatalystCombination(CatalystCombination.CATALYST_ITEMS[firstIndex].get(1L, new Object[0]), CatalystCombination.CATALYST_ITEMS[secondIndex].get(1L, new Object[0]));
    }

    public MTEPurificationUnitBaryonicPerfection(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTEPurificationUnitBaryonicPerfection(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEPurificationUnitBaryonicPerfection(this.mName);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean active, boolean redstoneLevel) {
        if (side == facing) {
            if (active) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(CASING_INDEX_MAIN), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_WATER_T8_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_WATER_T8_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(CASING_INDEX_MAIN), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_WATER_T8).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_WATER_T8_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(CASING_INDEX_MAIN)};
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 8, 8, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        return this.survivalBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 8, 8, 0, elementBudget, env, true);
    }

    @Override
    public IStructureDefinition<MTEPurificationUnitBaryonicPerfection> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.numCasings = 0;
        if (!this.checkPiece(STRUCTURE_PIECE_MAIN, 8, 8, 0)) {
            return false;
        }
        if (this.numCasings < 300) {
            return false;
        }
        for (MTEHatchInputBus bus : GTUtility.validMTEList(this.mInputBusses)) {
            if (!(bus instanceof MTEHatchInputBusME)) continue;
            return false;
        }
        return super.checkMachine(aBaseMetaTileEntity, aStack);
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Purification Unit").addInfo(EnumChatFormatting.AQUA + "" + EnumChatFormatting.BOLD + "Water Tier: " + EnumChatFormatting.WHITE + GTUtility.formatNumbers(this.getWaterTier()) + EnumChatFormatting.RESET).addInfo("Must be linked to a Purification Plant using a data stick to work.").addSeparator().addInfo("Insert " + EnumChatFormatting.WHITE + "Quark Releasing Catalysts " + EnumChatFormatting.GRAY + "into the input bus while running.").addInfo("Every recipe cycle, a different combination of " + EnumChatFormatting.RED + "2" + EnumChatFormatting.GRAY + " different " + EnumChatFormatting.WHITE + "Quark Releasing Catalysts").addInfo("will correctly identify the lone quark and succeed the recipe.").addInfo("The order of catalysts in the combination does not matter, so " + EnumChatFormatting.BLUE + "Up" + EnumChatFormatting.GRAY + "/" + EnumChatFormatting.LIGHT_PURPLE + "Down" + EnumChatFormatting.GRAY + " can be identified by inserting " + EnumChatFormatting.LIGHT_PURPLE + "Down" + EnumChatFormatting.GRAY + "/" + EnumChatFormatting.BLUE + "Up" + EnumChatFormatting.GRAY + ".").addSeparator().addInfo("Every " + EnumChatFormatting.RED + "20" + EnumChatFormatting.GRAY + " ticks, consumes ALL catalysts in the input bus.").addInfo("The base cost of inserting a catalyst is " + EnumChatFormatting.RED + 144L + "L" + EnumChatFormatting.WHITE + " Molten Infinity" + EnumChatFormatting.GRAY + ".").addInfo("For every duplicate occurrence of an inserted catalyst in the sequence, this cost is doubled.").addSeparator().addInfo("Keeps track of the entire sequence of catalysts inserted this recipe.").addInfo("If the correct catalyst combination is in the sequence of inserted catalysts, immediately outputs " + EnumChatFormatting.RED + BARYONIC_MATTER_OUTPUT + "L " + EnumChatFormatting.WHITE + "Stabilised Baryonic Matter" + EnumChatFormatting.GRAY + ".").addInfo("At the end of a successful recipe, outputs additional " + EnumChatFormatting.RED + 500 + "L " + EnumChatFormatting.WHITE + "Stabilised Baryonic Matter" + EnumChatFormatting.GRAY + " per parallel.").addInfo("At the end of the recipe, returns all incorrectly inserted catalysts in the output bus.").addSeparator().addInfo(EnumChatFormatting.AQUA + "" + EnumChatFormatting.ITALIC + "The final stage of water purification goes beyond subatomic particles and identifies the smallest").addInfo(EnumChatFormatting.AQUA + "" + EnumChatFormatting.ITALIC + "possible imperfections within the baryons themselves. By correctly identifying which pairs of quark").addInfo(EnumChatFormatting.AQUA + "" + EnumChatFormatting.ITALIC + "flavors are required, the unit will activate the catalysts, stabilizing the errant particles.").addInfo(EnumChatFormatting.AQUA + "" + EnumChatFormatting.ITALIC + "This ultimately creates both Stabilised Baryonic Matter and, most importantly, absolutely perfectly purified water.").beginStructureBlock(17, 17, 17, false).addController("Front center").addCasingInfoMinColored("Quark Exclusion Casing", EnumChatFormatting.GRAY, 300, EnumChatFormatting.GOLD, false).addCasingInfoExactlyColored("Femtometer-Calibrated Particle Beam Casing", EnumChatFormatting.GRAY, 96, EnumChatFormatting.GOLD, false).addCasingInfoExactlyColored("Particle Beam Guidance Pipe Casing", EnumChatFormatting.GRAY, 37, EnumChatFormatting.GOLD, false).addCasingInfoExactlyColored("Non-Photonic Matter Exclusion Glass", EnumChatFormatting.GRAY, 240, EnumChatFormatting.GOLD, false).addCasingInfoExactlyColored("Bedrockium Frame Box", EnumChatFormatting.GRAY, 108, EnumChatFormatting.GOLD, false).addInputBus("Any Quark Exclusion Casing. Stocking bus is blacklisted.", 1).addInputHatch("Any Quark Exclusion Casing", 1).addOutputBus("Any Quark Exclusion Casing", 1).addOutputHatch("Any Quark Exclusion Casing", 1).toolTipFinisher(GTValues.AuthorNotAPenguin);
        return tt;
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return RecipeMaps.purificationParticleExtractionRecipes;
    }

    @Override
    public void startCycle(int cycleTime, int progressTime) {
        super.startCycle(cycleTime, progressTime);
        this.insertedCatalysts.clear();
        this.currentCombination = MTEPurificationUnitBaryonicPerfection.generateNewCombination();
        this.correctStartIndex = -1;
    }

    private boolean isCatalyst(ItemStack stack) {
        if (stack.func_77973_b() instanceof MetaGeneratedItem03) {
            int meta = stack.func_77960_j() - 32000;
            return meta >= IDMetaItem03.Quark_Creation_Catalyst_Up.ID && meta <= IDMetaItem03.Quark_Creation_Catalyst_Top.ID;
        }
        return false;
    }

    @Override
    public void endCycle() {
        super.endCycle();
        for (int i = 0; i < this.insertedCatalysts.size(); ++i) {
            if (this.correctStartIndex != -1 && (i == this.correctStartIndex || i == this.correctStartIndex + 1)) continue;
            this.addOutput(this.insertedCatalysts.get(i));
        }
    }

    @Override
    public float calculateFinalSuccessChance() {
        if (this.correctStartIndex != -1) {
            return 100.0f;
        }
        return 0.0f;
    }

    private int calculateCatalystCost(ItemStack newCatalyst) {
        int count = 0;
        for (ItemStack cat : this.insertedCatalysts) {
            if (cat.func_77960_j() != newCatalyst.func_77960_j()) continue;
            ++count;
        }
        return (int)(GTUtility.powInt(2.0, count) * 144.0);
    }

    public int checkSequence() {
        for (int i = 0; i < this.insertedCatalysts.size() - 1; ++i) {
            ItemStack second;
            ItemStack first = this.insertedCatalysts.get(i);
            if (!this.currentCombination.matches(first, second = this.insertedCatalysts.get(i + 1))) continue;
            return i;
        }
        return -1;
    }

    @Override
    protected void runMachine(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.runMachine(aBaseMetaTileEntity, aTick);
        if (this.mMaxProgresstime > 0 && aTick % 20L == 0L) {
            this.startRecipeProcessing();
            ArrayList<ItemStack> storedInputs = this.getStoredInputs();
            for (ItemStack stack : storedInputs) {
                if (!this.isCatalyst(stack)) continue;
                int cost = this.calculateCatalystCost(stack);
                FluidStack inputCost = Materials.Infinity.getMolten(cost);
                boolean drained = false;
                for (MTEHatchInput hatch : this.mInputHatches) {
                    FluidStack drainedStack = hatch.drain(ForgeDirection.UNKNOWN, inputCost, true);
                    if (drainedStack == null || drainedStack.amount != inputCost.amount) continue;
                    drained = true;
                    break;
                }
                if (!drained) {
                    this.stopMachine(ShutDownReasonRegistry.outOfFluid(inputCost));
                    this.endRecipeProcessing();
                    return;
                }
                for (int i = 0; i < stack.field_77994_a; ++i) {
                    ItemStack singleStack = new ItemStack(stack.func_77973_b(), 1, stack.func_77960_j());
                    this.insertedCatalysts.add(singleStack);
                }
                this.depleteInput(stack);
            }
            this.endRecipeProcessing();
            if (this.correctStartIndex != -1) {
                return;
            }
            this.correctStartIndex = this.checkSequence();
            if (this.correctStartIndex != -1) {
                this.addOutput(Materials.StableBaryonicMatter.getFluid(BARYONIC_MATTER_OUTPUT));
            }
        }
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        NBTTagCompound insertedNBT = new NBTTagCompound();
        for (int i = 0; i < this.insertedCatalysts.size(); ++i) {
            ItemStack inserted = this.insertedCatalysts.get(i);
            NBTTagCompound itemNBT = new NBTTagCompound();
            inserted.func_77955_b(itemNBT);
            insertedNBT.func_74782_a(Integer.toString(i), (NBTBase)itemNBT);
        }
        aNBT.func_74782_a("insertedItems", (NBTBase)insertedNBT);
        aNBT.func_74768_a("correctStartIndex", this.correctStartIndex);
        super.saveNBTData(aNBT);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        this.currentCombination = MTEPurificationUnitBaryonicPerfection.generateNewCombination();
        if (aNBT.func_74764_b("insertedItems")) {
            NBTTagCompound insertedList = aNBT.func_74775_l("insertedItems");
            this.insertedCatalysts = new ArrayList<Object>(Collections.nCopies(insertedList.func_150296_c().size(), null));
            for (String key : insertedList.func_150296_c()) {
                NBTTagCompound itemCompound = insertedList.func_74775_l(key);
                int index = Integer.parseInt(key);
                this.insertedCatalysts.set(index, ItemStack.func_77949_a((NBTTagCompound)itemCompound));
            }
        }
        if (aNBT.func_74764_b("correctStartIndex")) {
            this.correctStartIndex = aNBT.func_74762_e("correctStartIndex");
        }
        super.loadNBTData(aNBT);
    }

    private String getCorrectlyDecodedString() {
        if (this.correctStartIndex != -1) {
            return EnumChatFormatting.GREEN + "Yes";
        }
        return EnumChatFormatting.RED + "No";
    }

    public EnumChatFormatting getQuarkColor(ItemStack stack) {
        int meta = stack.func_77960_j() - 32000;
        if (meta == IDMetaItem03.Quark_Creation_Catalyst_Up.ID) {
            return EnumChatFormatting.BLUE;
        }
        if (meta == IDMetaItem03.Quark_Creation_Catalyst_Down.ID) {
            return EnumChatFormatting.LIGHT_PURPLE;
        }
        if (meta == IDMetaItem03.Quark_Creation_Catalyst_Strange.ID) {
            return EnumChatFormatting.YELLOW;
        }
        if (meta == IDMetaItem03.Quark_Creation_Catalyst_Charm.ID) {
            return EnumChatFormatting.GREEN;
        }
        if (meta == IDMetaItem03.Quark_Creation_Catalyst_Bottom.ID) {
            return EnumChatFormatting.AQUA;
        }
        if (meta == IDMetaItem03.Quark_Creation_Catalyst_Top.ID) {
            return EnumChatFormatting.RED;
        }
        return EnumChatFormatting.GRAY;
    }

    @Override
    public String[] getInfoData() {
        ArrayList<String> info = new ArrayList<String>(Arrays.asList(super.getInfoData()));
        info.add(StatCollector.func_74838_a((String)"GT5U.infodata.pubp.catalyst_history"));
        for (int i = 0; i < this.insertedCatalysts.size(); ++i) {
            ItemStack stack = this.insertedCatalysts.get(i);
            String name = stack.func_82833_r();
            String[] split = name.split("-");
            info.add(EnumChatFormatting.YELLOW + "" + (i + 1) + ": " + this.getQuarkColor(stack) + split[0] + EnumChatFormatting.GRAY + "-" + split[1]);
        }
        info.add(StatCollector.func_74837_a((String)"GT5U.infodata.pubp.quark_combination", (Object[])new Object[]{this.getCorrectlyDecodedString()}));
        return info.toArray(new String[0]);
    }

    @Override
    public int getWaterTier() {
        return 8;
    }

    @Override
    public long getBasePowerUsage() {
        return TierEU.RECIPE_UEV;
    }

    private static class CatalystCombination {
        public ItemStack firstCatalyst;
        public ItemStack secondCatalyst;
        public static ItemList[] CATALYST_ITEMS = new ItemList[]{ItemList.Quark_Creation_Catalyst_Up, ItemList.Quark_Creation_Catalyst_Down, ItemList.Quark_Creation_Catalyst_Bottom, ItemList.Quark_Creation_Catalyst_Top, ItemList.Quark_Creation_Catalyst_Strange, ItemList.Quark_Creation_Catalyst_Charm};

        public CatalystCombination(ItemStack first, ItemStack second) {
            this.firstCatalyst = first;
            this.secondCatalyst = second;
        }

        public boolean matches(ItemStack a, ItemStack b) {
            return a.func_77969_a(this.firstCatalyst) && b.func_77969_a(this.secondCatalyst) || b.func_77969_a(this.firstCatalyst) && a.func_77969_a(this.secondCatalyst);
        }

        public NBTTagCompound saveToNBT() {
            NBTTagCompound nbt = new NBTTagCompound();
            NBTTagCompound first = new NBTTagCompound();
            NBTTagCompound second = new NBTTagCompound();
            this.firstCatalyst.func_77955_b(first);
            this.secondCatalyst.func_77955_b(second);
            nbt.func_74782_a("first", (NBTBase)first);
            nbt.func_74782_a("second", (NBTBase)second);
            return nbt;
        }

        public static CatalystCombination readFromNBT(NBTTagCompound nbt) {
            NBTTagCompound first = nbt.func_74775_l("first");
            NBTTagCompound second = nbt.func_74775_l("second");
            return new CatalystCombination(ItemStack.func_77949_a((NBTTagCompound)first), ItemStack.func_77949_a((NBTTagCompound)second));
        }
    }
}

