/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.GTMod;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.HeatingCoilLevel;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.metatileentity.implementations.MTEHatchEnergy;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.OverclockCalculator;
import gregtech.common.tileentities.machines.MTEHatchOutputBusME;
import gregtech.common.tileentities.machines.multi.MTEAbstractMultiFurnace;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;

public class MTEMultiFurnace
extends MTEAbstractMultiFurnace<MTEMultiFurnace>
implements ISurvivalConstructable {
    private int mLevel = 0;
    private static final long RECIPE_EUT = 4L;
    private static final int RECIPE_DURATION = 128;
    private static final int CASING_INDEX = 11;
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final IStructureDefinition<MTEMultiFurnace> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", StructureUtility.transpose((String[][])new String[][]{{"ccc", "cmc", "ccc"}, {"CCC", "C-C", "CCC"}, {"b~b", "bbb", "bbb"}})).addElement('c', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings1, (int)11)).addElement('m', HatchElement.Muffler.newAny(11, 2)).addElement('C', GTStructureUtility.activeCoils(GTStructureUtility.ofCoil(MTEAbstractMultiFurnace::setCoilLevel, MTEAbstractMultiFurnace::getCoilLevel))).addElement('b', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GTStructureUtility.buildHatchAdder(MTEMultiFurnace.class).atLeast(HatchElement.Maintenance, HatchElement.InputBus, HatchElement.OutputBus, HatchElement.Energy).casingIndex(11).dot(1).build(), StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings1, (int)11)})).build();

    public MTEMultiFurnace(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTEMultiFurnace(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEMultiFurnace(this.mName);
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Furnace").addInfo("Smelts 4 * 2^(Coil Tier) items in parallel").addPollutionAmount(this.getPollutionPerSecond(null)).beginStructureBlock(3, 3, 3, true).addController("Front bottom").addCasingInfoRange("Heat Proof Machine Casing", 8, 14, false).addOtherStructurePart("Heating Coils", "Middle layer").addEnergyHatch("Any bottom casing", 1).addMaintenanceHatch("Any bottom casing", 1).addMufflerHatch("Top Middle", 2).addInputBus("Any bottom casing", 1).addOutputBus("Any bottom casing", 1).toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection sideDirection, ForgeDirection facingDirection, int colorIndex, boolean active, boolean redstoneLevel) {
        if (sideDirection != facingDirection) {
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][11]};
        }
        if (active) {
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][11], TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_MULTI_SMELTER_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_MULTI_SMELTER_ACTIVE_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][11], TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_MULTI_SMELTER).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_MULTI_SMELTER_GLOW).extFacing().glow().build()};
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return RecipeMaps.furnaceRecipes;
    }

    @Override
    public int getPollutionPerSecond(ItemStack aStack) {
        return GTMod.proxy.mPollutionMultiSmelterPerSecond;
    }

    @Override
    public boolean supportsPowerPanel() {
        return false;
    }

    @Override
    @NotNull
    public CheckRecipeResult checkProcessing() {
        ArrayList<ItemStack> tInput = this.getAllStoredInputs();
        long availableEUt = GTUtility.roundUpVoltage(this.getMaxInputVoltage());
        if (availableEUt < 4L) {
            return CheckRecipeResultRegistry.insufficientPower(4L);
        }
        if (tInput.isEmpty()) {
            return CheckRecipeResultRegistry.NO_RECIPE;
        }
        int maxParallel = this.mLevel;
        int originalMaxParallel = this.mLevel;
        OverclockCalculator calculator = new OverclockCalculator().setEUt(availableEUt).setRecipeEUt(4L).setDuration(128).setParallel(originalMaxParallel);
        int maxParallelBeforeBatchMode = maxParallel = GTUtility.safeInt((long)((double)maxParallel * calculator.calculateMultiplierUnderOneTick()), 0);
        if (this.isBatchModeEnabled()) {
            maxParallel = GTUtility.safeInt((long)maxParallel * (long)this.getMaxBatchSize(), 0);
        }
        int currentParallel = (int)Math.min((long)maxParallel, availableEUt / 4L);
        int itemParallel = 0;
        for (ItemStack item : tInput) {
            ItemStack smeltedOutput = GTModHandler.getSmeltingOutput(item, false, null);
            if (smeltedOutput == null) continue;
            int parallelsLeft = currentParallel - itemParallel;
            if (parallelsLeft <= 0) break;
            itemParallel += Math.min(item.field_77994_a, parallelsLeft);
        }
        if ((currentParallel = itemParallel) <= 0) {
            return CheckRecipeResultRegistry.NO_RECIPE;
        }
        int currentParallelBeforeBatchMode = Math.min(currentParallel, maxParallelBeforeBatchMode);
        calculator.setCurrentParallel(currentParallelBeforeBatchMode).calculate();
        double batchMultiplierMax = 1.0;
        if (currentParallel > maxParallelBeforeBatchMode && calculator.getDuration() < this.getMaxBatchSize()) {
            batchMultiplierMax = (double)this.getMaxBatchSize() / (double)calculator.getDuration();
            batchMultiplierMax = Math.min(batchMultiplierMax, (double)currentParallel / (double)maxParallelBeforeBatchMode);
        }
        int finalParallel = (int)(batchMultiplierMax * (double)currentParallelBeforeBatchMode);
        ArrayList<ItemStack> outputSlots = new ArrayList<ItemStack>();
        for (ItemStack itemStack : this.getItemOutputSlots(null)) {
            if (itemStack != null) {
                outputSlots.add(itemStack.func_77946_l());
                continue;
            }
            outputSlots.add(null);
        }
        boolean hasMEOutputBus = false;
        for (MTEHatch bus : GTUtility.validMTEList(this.mOutputBusses)) {
            MTEHatchOutputBusME meBus;
            if (!(bus instanceof MTEHatchOutputBusME) || (meBus = (MTEHatchOutputBusME)bus).isLocked() || !meBus.canAcceptItem()) continue;
            hasMEOutputBus = true;
            break;
        }
        ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
        int toSmelt = finalParallel;
        for (ItemStack item : tInput) {
            int toProcess;
            ItemStack smeltedOutput = GTModHandler.getSmeltingOutput(item, false, null);
            if (smeltedOutput == null) continue;
            int maxOutput = 0;
            int remainingToSmelt = Math.min(toSmelt, item.field_77994_a);
            if (hasMEOutputBus) {
                maxOutput = remainingToSmelt;
            } else {
                int needed = remainingToSmelt;
                ItemStack outputType = smeltedOutput.func_77946_l();
                outputType.field_77994_a = 1;
                for (int i = 0; i < outputSlots.size(); ++i) {
                    int canFit;
                    ItemStack slot = (ItemStack)outputSlots.get(i);
                    if (slot == null) {
                        canFit = Math.min(needed, outputType.func_77976_d());
                        ItemStack newStack = outputType.func_77946_l();
                        newStack.field_77994_a = canFit;
                        outputSlots.set(i, newStack);
                        maxOutput += canFit;
                        needed -= canFit;
                    } else if (slot.func_77969_a(outputType)) {
                        if (slot.field_77994_a == 65) {
                            canFit = needed;
                        } else {
                            int space = outputType.func_77976_d() - slot.field_77994_a;
                            canFit = Math.min(needed, space);
                        }
                        slot.field_77994_a += canFit;
                        maxOutput += canFit;
                        needed -= canFit;
                    }
                    if (needed <= 0) break;
                }
            }
            if ((toProcess = this.protectsExcessItem() ? maxOutput : remainingToSmelt) <= 0) continue;
            ItemStack outputStack = smeltedOutput.func_77946_l();
            outputStack.field_77994_a *= toProcess;
            arrayList.add(outputStack);
            item.field_77994_a -= toProcess;
            if ((toSmelt -= toProcess) > 0) continue;
            break;
        }
        if (arrayList.isEmpty()) {
            return CheckRecipeResultRegistry.NO_RECIPE;
        }
        this.mOutputItems = arrayList.toArray(new ItemStack[0]);
        this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
        this.mEfficiencyIncrease = 10000;
        this.mMaxProgresstime = (int)((double)calculator.getDuration() * batchMultiplierMax);
        this.lEUt = calculator.getConsumption();
        if (this.lEUt > 0L) {
            this.lEUt = -this.lEUt;
        }
        this.updateSlots();
        return CheckRecipeResultRegistry.SUCCESSFUL;
    }

    @Override
    public boolean supportsVoidProtection() {
        return true;
    }

    @Override
    public IStructureDefinition<MTEMultiFurnace> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mLevel = 0;
        this.setCoilLevel(HeatingCoilLevel.None);
        if (!this.checkPiece(STRUCTURE_PIECE_MAIN, 1, 2, 0)) {
            return false;
        }
        if (this.getCoilLevel() == HeatingCoilLevel.None) {
            return false;
        }
        if (this.mMaintenanceHatches.size() != 1) {
            return false;
        }
        this.mLevel = 4 << this.getCoilLevel().ordinal() - 1;
        return true;
    }

    @Override
    public String[] getInfoData() {
        long storedEnergy = 0L;
        long maxEnergy = 0L;
        for (MTEHatchEnergy tHatch : GTUtility.validMTEList(this.mEnergyHatches)) {
            storedEnergy += tHatch.getBaseMetaTileEntity().getStoredEU();
            maxEnergy += tHatch.getBaseMetaTileEntity().getEUCapacity();
        }
        return new String[]{StatCollector.func_74838_a((String)"GT5U.multiblock.Progress") + ": " + EnumChatFormatting.GREEN + GTUtility.formatNumbers(this.mProgresstime / 20) + EnumChatFormatting.RESET + " s / " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers(this.mMaxProgresstime / 20) + EnumChatFormatting.RESET + " s", StatCollector.func_74838_a((String)"GT5U.multiblock.energy") + ": " + EnumChatFormatting.GREEN + GTUtility.formatNumbers(storedEnergy) + EnumChatFormatting.RESET + " EU / " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers(maxEnergy) + EnumChatFormatting.RESET + " EU", StatCollector.func_74838_a((String)"GT5U.multiblock.usage") + ": " + EnumChatFormatting.RED + GTUtility.formatNumbers(-this.lEUt) + EnumChatFormatting.RESET + " EU/t", StatCollector.func_74838_a((String)"GT5U.multiblock.mei") + ": " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers(this.getMaxInputVoltage()) + EnumChatFormatting.RESET + " EU/t(*2A) " + StatCollector.func_74838_a((String)"GT5U.machines.tier") + ": " + EnumChatFormatting.YELLOW + GTValues.VN[GTUtility.getTier(this.getMaxInputVoltage())] + EnumChatFormatting.RESET, StatCollector.func_74838_a((String)"GT5U.multiblock.problems") + ": " + EnumChatFormatting.RED + (this.getIdealStatus() - this.getRepairStatus()) + EnumChatFormatting.RESET + " " + StatCollector.func_74838_a((String)"GT5U.multiblock.efficiency") + ": " + EnumChatFormatting.YELLOW + (float)this.mEfficiency / 100.0f + EnumChatFormatting.RESET + " %", StatCollector.func_74838_a((String)"GT5U.MS.multismelting") + ": " + EnumChatFormatting.GREEN + this.mLevel + EnumChatFormatting.RESET, StatCollector.func_74838_a((String)"GT5U.multiblock.pollution") + ": " + EnumChatFormatting.GREEN + this.getAveragePollutionPercentage() + EnumChatFormatting.RESET + " %"};
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 1, 2, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivalBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 1, 2, 0, elementBudget, env, false, true);
    }

    @Override
    public boolean supportsBatchMode() {
        return true;
    }

    @Override
    public boolean onWireCutterRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aTool) {
        if (aPlayer.func_70093_af()) {
            boolean bl = this.batchMode = !this.batchMode;
            if (this.batchMode) {
                GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"misc.BatchModeTextOn"));
            } else {
                GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"misc.BatchModeTextOff"));
            }
            return true;
        }
        return false;
    }
}

