/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.DynamicPositionedColumn;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.HeatingCoilLevel;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.implementations.MTEExtendedPowerMultiBlockBase;
import gregtech.api.metatileentity.implementations.MTEHatchEnergy;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.common.misc.GTStructureChannels;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;

public class MTELargeFluidExtractor
extends MTEExtendedPowerMultiBlockBase<MTELargeFluidExtractor>
implements ISurvivalConstructable {
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final int CASING_INDEX = 48;
    private static final int BASE_CASING_COUNT = 57;
    private static final int MAX_HATCHES_ALLOWED = 16;
    private static final double BASE_SPEED_BONUS = 1.5;
    private static final double BASE_EU_MULTIPLIER = 0.8;
    private static final double SPEED_PER_COIL = 0.1;
    private static final int PARALLELS_PER_SOLENOID = 8;
    private static final double HEATING_COIL_EU_MULTIPLIER = 0.9;
    private static final IStructureDefinition<MTELargeFluidExtractor> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", StructureUtility.transpose((String[][])new String[][]{{"     ", " ccc ", " ccc ", " ccc ", "     "}, {"     ", " f f ", "  s  ", " f f ", "     "}, {"     ", " f f ", "  s  ", " f f ", "     "}, {"     ", " f f ", "  s  ", " f f ", "     "}, {"ccccc", "ccccc", "ccscc", "ccccc", "ccccc"}, {"fgggf", "ghhhg", "ghshg", "ghhhg", "fgggf"}, {"fgggf", "ghhhg", "ghshg", "ghhhg", "fgggf"}, {"fgggf", "ghhhg", "ghshg", "ghhhg", "fgggf"}, {"cc~cc", "ccccc", "ccccc", "ccccc", "ccccc"}})).addElement('c', GTStructureUtility.buildHatchAdder(MTELargeFluidExtractor.class).atLeast(HatchElement.InputBus, HatchElement.OutputBus, HatchElement.OutputHatch, HatchElement.Energy, HatchElement.Maintenance).casingIndex(48).dot(1).buildAndChain(StructureUtility.onElementPass(MTELargeFluidExtractor::onCasingAdded, (IStructureElement)StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings4, (int)0)))).addElement('g', GTStructureUtility.chainAllGlasses(-1, (te, t) -> {
        te.glassTier = t;
    }, te -> te.glassTier)).addElement('h', GTStructureChannels.HEATING_COIL.use(GTStructureUtility.activeCoils(GTStructureUtility.ofCoil(MTELargeFluidExtractor::setCoilLevel, MTELargeFluidExtractor::getCoilLevel)))).addElement('s', GTStructureChannels.SOLENOID.use(GTStructureUtility.ofSolenoidCoil(MTELargeFluidExtractor::setSolenoidLevel, MTELargeFluidExtractor::getSolenoidLevel))).addElement('f', GTStructureUtility.ofFrame(Materials.BlackSteel)).build();
    private int glassTier = -1;
    @Nullable
    private HeatingCoilLevel mCoilLevel = null;
    @Nullable
    private Byte mSolenoidLevel = null;
    private int mCasingAmount;
    private boolean mStructureBadGlassTier = false;
    private boolean mStructureBadCasingCount = false;

    public MTELargeFluidExtractor(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTELargeFluidExtractor(String aName) {
        super(aName);
    }

    @Override
    public IStructureDefinition<MTELargeFluidExtractor> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    @Override
    public void clearHatches() {
        super.clearHatches();
        this.mCasingAmount = 0;
        this.mStructureBadGlassTier = false;
        this.mStructureBadCasingCount = false;
        this.glassTier = -1;
        this.mCoilLevel = null;
        this.mSolenoidLevel = null;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        if (!this.checkPiece(STRUCTURE_PIECE_MAIN, 2, 8, 0)) {
            return false;
        }
        if (this.mCasingAmount < 41) {
            this.mStructureBadCasingCount = true;
        }
        for (MTEHatchEnergy energyHatch : this.mEnergyHatches) {
            if (energyHatch.getBaseMetaTileEntity() == null || this.glassTier >= 10 || energyHatch.getTierForStructure() <= this.glassTier) continue;
            this.mStructureBadGlassTier = true;
            break;
        }
        return !this.mStructureBadGlassTier && !this.mStructureBadCasingCount;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 2, 8, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivalBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 2, 8, 0, elementBudget, env, false, true);
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic(){

            @Override
            @NotNull
            public CheckRecipeResult process() {
                this.setEuModifier(MTELargeFluidExtractor.this.getEUMultiplier());
                this.setSpeedBonus(1.0f / MTELargeFluidExtractor.this.getSpeedBonus());
                return super.process();
            }
        }.noRecipeCaching().setMaxParallelSupplier(this::getTrueParallel);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTELargeFluidExtractor(this.mName);
    }

    private void onCasingAdded() {
        ++this.mCasingAmount;
    }

    private HeatingCoilLevel getCoilLevel() {
        return this.mCoilLevel;
    }

    private void setCoilLevel(HeatingCoilLevel level) {
        this.mCoilLevel = level;
    }

    private Byte getSolenoidLevel() {
        return this.mSolenoidLevel;
    }

    private void setSolenoidLevel(byte level) {
        this.mSolenoidLevel = level;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean active, boolean redstoneLevel) {
        if (side == facing) {
            if (active) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(48), TextureFactory.builder().addIcon(TexturesGtBlock.oMCALargeFluidExtractorActive).extFacing().build(), TextureFactory.builder().addIcon(TexturesGtBlock.oMCALargeFluidExtractorActiveGlow).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(48), TextureFactory.builder().addIcon(TexturesGtBlock.oMCALargeFluidExtractor).extFacing().build(), TextureFactory.builder().addIcon(TexturesGtBlock.oMCALargeFluidExtractorGlow).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(48)};
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Fluid Extractor, LFE").addInfo(String.format("%d%% faster than single block machines of the same voltage", (int)Math.round(50.0))).addInfo(String.format("Only uses %d%% of the EU/t normally required", (int)Math.round(80.0))).addInfo(String.format("Every coil tier gives a +%d%% speed bonus and a %d%% EU/t discount (multiplicative)", (int)Math.round(10.0), (int)Math.round(9.999999999999998))).addInfo(String.format("Every solenoid tier gives %s%d * tier%s parallels (MV is tier 2)", EnumChatFormatting.ITALIC, 8, EnumChatFormatting.GRAY)).addInfo(String.format("The EU multiplier is %s%.2f * (%.2f ^ Heating Coil Tier)%s, prior to overclocks", EnumChatFormatting.ITALIC, 0.8, 0.9, EnumChatFormatting.GRAY)).addInfo("The energy hatch tier is limited by the glass tier. UEV glass unlocks all tiers.").beginStructureBlock(5, 9, 5, false).addController("Front Center (Bottom Layer)").addCasingInfoMin("Robust Tungstensteel Machine Casing", 41, false).addCasingInfoExactly("Any Tiered Glass", 36, true).addCasingInfoExactly("Solenoid Superconducting Coil", 7, true).addCasingInfoExactly("Heating Coils", 24, true).addCasingInfoExactly("Black Steel Frame Box", 24, false).addInputBus("Any Robust Tungstensteel Machine Casing", 1).addOutputBus("Any Robust Tungstensteel Machine Casing", 1).addOutputHatch("Any Robust Tungstensteel Machine Casing", 1).addEnergyHatch("Any Robust Tungstensteel Machine Casing", 1).addMaintenanceHatch("Any Robust Tungstensteel Machine Casing", 1).addSubChannelUsage(GTStructureChannels.BOROGLASS).addSubChannelUsage(GTStructureChannels.HEATING_COIL).addSubChannelUsage(GTStructureChannels.SOLENOID).toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    protected void drawTexts(DynamicPositionedColumn screenElements, SlotWidget inventorySlot) {
        super.drawTexts(screenElements, inventorySlot);
        screenElements.widgets(new Widget[]{TextWidget.dynamicString(() -> {
            if (this.mStructureBadCasingCount) {
                return EnumChatFormatting.DARK_RED + StatCollector.func_74837_a((String)"GT5U.gui.text.large_fluid_extractor.not_enough_casings", (Object[])new Object[]{41, this.mCasingAmount}).replace("\\n", "\n") + EnumChatFormatting.RESET;
            }
            if (this.mStructureBadGlassTier) {
                byte hatchTier = 0;
                for (MTEHatchEnergy hatch : this.mEnergyHatches) {
                    if (hatch.mTier <= hatchTier) continue;
                    hatchTier = hatch.mTier;
                }
                return String.format("%sEnergy hatch tier (%s) is too high\nfor the glass tier (%s).%s", EnumChatFormatting.DARK_RED, GTValues.VN[hatchTier], GTValues.VN[this.glassTier], EnumChatFormatting.RESET);
            }
            return "";
        }).setTextAlignment(Alignment.CenterLeft)});
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return RecipeMaps.fluidExtractionRecipes;
    }

    @Override
    public boolean supportsVoidProtection() {
        return true;
    }

    @Override
    public boolean supportsBatchMode() {
        return true;
    }

    @Override
    public boolean supportsSingleRecipeLocking() {
        return true;
    }

    @Override
    public String[] getInfoData() {
        ArrayList<String> data = new ArrayList<String>(Arrays.asList(super.getInfoData()));
        data.add(StatCollector.func_74837_a((String)"Max Parallels: %s%d%s", (Object[])new Object[]{EnumChatFormatting.YELLOW, this.getMaxParallelRecipes(), EnumChatFormatting.RESET}));
        data.add(StatCollector.func_74837_a((String)"Heating Coil Speed Bonus: +%s%.0f%s %%", (Object[])new Object[]{EnumChatFormatting.YELLOW, Float.valueOf(this.getCoilSpeedBonus() * 100.0f), EnumChatFormatting.RESET}));
        data.add(StatCollector.func_74837_a((String)"Total Speed Multiplier: %s%.0f%s %%", (Object[])new Object[]{EnumChatFormatting.YELLOW, Float.valueOf(this.getSpeedBonus() * 100.0f), EnumChatFormatting.RESET}));
        data.add(StatCollector.func_74837_a((String)"Total EU/t Multiplier: %s%.0f%s %%", (Object[])new Object[]{EnumChatFormatting.YELLOW, Float.valueOf(this.getEUMultiplier() * 100.0f), EnumChatFormatting.RESET}));
        return data.toArray(new String[0]);
    }

    @Override
    public int getMaxParallelRecipes() {
        return Math.max(1, this.mSolenoidLevel == null ? 0 : 8 * this.mSolenoidLevel);
    }

    public float getCoilSpeedBonus() {
        return (float)(this.mCoilLevel == null ? 0.0 : 0.1 * (double)this.mCoilLevel.getTier());
    }

    public float getSpeedBonus() {
        return (float)(1.5 + (double)this.getCoilSpeedBonus());
    }

    public float getEUMultiplier() {
        double heatingBonus = this.mCoilLevel == null ? 0.0 : GTUtility.powInt(0.9, this.mCoilLevel.getTier());
        return (float)(0.8 * heatingBonus);
    }

    @Override
    public boolean onWireCutterRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aTool) {
        if (aPlayer.func_70093_af()) {
            boolean bl = this.batchMode = !this.batchMode;
            if (this.batchMode) {
                GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"misc.BatchModeTextOn"));
            } else {
                GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"misc.BatchModeTextOff"));
            }
            return true;
        }
        return false;
    }
}

