/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import com.gtnewhorizon.structurelib.alignment.IAlignmentLimits;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEEnhancedMultiBlockBase;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.metatileentity.implementations.MTEHatchInput;
import gregtech.api.metatileentity.implementations.MTEHatchOutput;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.registries.LHECoolantRegistry;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.common.tileentities.machines.IRecipeProcessingAwareHatch;
import gregtech.common.tileentities.machines.MTEHatchInputME;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class MTEHeatExchanger
extends MTEEnhancedMultiBlockBase<MTEHeatExchanger>
implements ISurvivalConstructable {
    private int dryHeatCounter = 0;
    private static final int dryHeatMaximum = 2000;
    private static final int CASING_INDEX = 50;
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final IStructureDefinition<MTEHeatExchanger> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", StructureUtility.transpose((String[][])new String[][]{{"ccc", "cCc", "ccc"}, {"ccc", "cPc", "ccc"}, {"ccc", "cPc", "ccc"}, {"c~c", "cHc", "ccc"}})).addElement('P', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings2, (int)14)).addElement('C', HatchElement.OutputHatch.withAdder(MTEHeatExchanger::addColdFluidOutputToMachineList).withCount(t -> t.mOutputColdFluidHatch.isValid() ? 1L : 0L).newAny(50, 3)).addElement('H', HatchElement.InputHatch.withAdder(MTEHeatExchanger::addHotFluidInputToMachineList).withCount(t -> t.mInputHotFluidHatch.isValid() ? 1L : 0L).newAny(50, 2)).addElement('c', GTStructureUtility.buildHatchAdder(MTEHeatExchanger.class).atLeast(HatchElement.InputBus, HatchElement.InputHatch, HatchElement.OutputBus, HatchElement.OutputHatch, HatchElement.Maintenance).casingIndex(50).dot(1).buildAndChain(StructureUtility.onElementPass(MTEHeatExchanger::onCasingAdded, (IStructureElement)StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings4, (int)2)))).build();
    public static float penalty_per_config = 0.015f;
    private MTEHatchInput mInputHotFluidHatch;
    private MTEHatchOutput mOutputColdFluidHatch;
    private boolean superheated = false;
    private int superheated_threshold = 0;
    private int steamBudget;
    private int mCasingAmount;

    public MTEHeatExchanger(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTEHeatExchanger(String aName) {
        super(aName);
    }

    @Override
    public boolean supportsPowerPanel() {
        return false;
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Heat Exchanger, LHE").addInfo("More complicated than a Fusion Reactor. Seriously").addInfo("Inputs are Lava, Hot Coolant, or Hot Solar Salt").addInfo("Outputs Pahoehoe Lava, IC2 Coolant, or Cold Solar Salt").addInfo("Converts Distilled Water into Steam/SH Steam in the process").beginStructureBlock(3, 4, 3, false).addController("Front bottom").addCasingInfoRange("Stable Titanium Machine Casing", 20, 28, false).addOtherStructurePart("Titanium Pipe Casing", "Center 2 blocks").addMaintenanceHatch("Any casing", 1).addInputHatch("Hot Fluid, bottom center casing", 2).addInputHatch("Distilled water, any casing", 1).addOutputHatch("Cold Fluid, top center casing", 3).addOutputHatch("Steam/SH Steam, any casing", 1).toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        this.superheated = aNBT.func_74767_n("superheated");
        this.steamBudget = aNBT.func_74762_e("steamBudget");
        super.loadNBTData(aNBT);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74757_a("superheated", this.superheated);
        aNBT.func_74768_a("steamBudget", this.steamBudget);
        super.saveNBTData(aNBT);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection aFacing, int colorIndex, boolean aActive, boolean redstoneLevel) {
        if (side == aFacing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][50], TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_HEAT_EXCHANGER_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_HEAT_EXCHANGER_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][50], TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_HEAT_EXCHANGER).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_HEAT_EXCHANGER_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][50]};
    }

    @Override
    protected IAlignmentLimits getInitialAlignmentLimits() {
        return (d, r, f) -> !r.isUpsideDown() && !f.isVerticallyFliped();
    }

    @Override
    @Nonnull
    public CheckRecipeResult checkProcessing() {
        int circuit_config;
        FluidStack hotFluid = null;
        MTEHatchInput mTEHatchInput = this.mInputHotFluidHatch;
        if (mTEHatchInput instanceof MTEHatchInputME) {
            MTEHatchInputME inputME = (MTEHatchInputME)mTEHatchInput;
            FluidStack[] fluids = inputME.getStoredFluids();
            if (fluids.length > 0) {
                hotFluid = fluids[0];
            }
        } else {
            hotFluid = this.mInputHotFluidHatch.getFluid();
        }
        if (hotFluid == null) {
            return CheckRecipeResultRegistry.NO_RECIPE;
        }
        int fluidAmountToConsume = hotFluid.amount;
        this.superheated_threshold = 4000;
        float efficiency = 1.0f;
        int shs_reduction_per_config = 150;
        float steam_output_multiplier = 20.0f;
        float penalty = 0.0f;
        if (this.mInventory[1] != null && this.mInventory[1].func_77977_a().startsWith("gt.integrated_circuit") && (circuit_config = this.mInventory[1].func_77960_j()) >= 1 && circuit_config <= 25) {
            penalty = (float)(circuit_config - 1) * penalty_per_config;
            this.superheated_threshold -= shs_reduction_per_config * (circuit_config - 1);
        }
        efficiency -= penalty;
        LHECoolantRegistry.LHECoolantInfo coolant = LHECoolantRegistry.getCoolant(hotFluid.getFluid());
        if (coolant == null) {
            this.superheated_threshold = 0;
            return CheckRecipeResultRegistry.NO_RECIPE;
        }
        steam_output_multiplier = (float)((double)steam_output_multiplier * coolant.steamMultiplier);
        this.superheated_threshold = (int)((double)this.superheated_threshold * coolant.superheatedThreshold);
        this.superheated = fluidAmountToConsume >= this.superheated_threshold;
        fluidAmountToConsume = Math.min(fluidAmountToConsume, this.superheated_threshold * 2);
        this.mInputHotFluidHatch.drain(ForgeDirection.UNKNOWN, new FluidStack(hotFluid.getFluid(), fluidAmountToConsume), true);
        this.mOutputColdFluidHatch.fill(coolant.getColdFluid(fluidAmountToConsume), true);
        this.mMaxProgresstime = 20;
        this.mEUt = (int)((float)fluidAmountToConsume * steam_output_multiplier * efficiency);
        this.mEfficiencyIncrease = 80;
        return CheckRecipeResultRegistry.SUCCESSFUL;
    }

    private int useWater(int steam) {
        this.steamBudget -= steam;
        int usage = -Math.min(0, Math.floorDiv(this.steamBudget, 160));
        this.steamBudget += usage * 160;
        return usage;
    }

    @Override
    public boolean onRunningTick(ItemStack aStack) {
        if (this.mEUt > 0) {
            int tGeneratedEU = (int)((long)this.mEUt * 2L * (long)this.mEfficiency / 10000L);
            if (tGeneratedEU > 0) {
                if (this.superheated) {
                    tGeneratedEU /= 2;
                }
                int distilledConsumed = this.useWater(tGeneratedEU);
                FluidStack distilledStack = GTModHandler.getDistilledWater(distilledConsumed);
                this.startRecipeProcessing();
                if (this.depleteInput(distilledStack)) {
                    if (this.superheated) {
                        this.addOutput(FluidRegistry.getFluidStack((String)"ic2superheatedsteam", (int)tGeneratedEU));
                    } else {
                        this.addOutput(Materials.Steam.getGas(tGeneratedEU));
                    }
                    this.dryHeatCounter = 0;
                } else if (this.dryHeatCounter < 2000) {
                    ++this.dryHeatCounter;
                } else {
                    GTLog.exp.println(this.mName + " was too hot and had no more Distilled Water!");
                    this.explodeMultiblock();
                }
                this.endRecipeProcessing();
            }
            return true;
        }
        return true;
    }

    @Override
    public IStructureDefinition<MTEHeatExchanger> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    private void onCasingAdded() {
        ++this.mCasingAmount;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mOutputColdFluidHatch = null;
        this.mInputHotFluidHatch = null;
        this.mCasingAmount = 0;
        return this.checkPiece(STRUCTURE_PIECE_MAIN, 1, 3, 0) && this.mCasingAmount >= 20 && this.mMaintenanceHatches.size() == 1;
    }

    public boolean addColdFluidOutputToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof MTEHatchOutput) {
            ((MTEHatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            this.mOutputColdFluidHatch = (MTEHatchOutput)aMetaTileEntity;
            return true;
        }
        return false;
    }

    public boolean addHotFluidInputToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof MTEHatchInput) {
            ((MTEHatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            ((MTEHatchInput)aMetaTileEntity).mRecipeMap = this.getRecipeMap();
            this.mInputHotFluidHatch = (MTEHatchInput)aMetaTileEntity;
            return true;
        }
        return false;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEHeatExchanger(this.mName);
    }

    @Override
    public String[] getInfoData() {
        return new String[]{StatCollector.func_74838_a((String)"GT5U.multiblock.Progress") + ": " + EnumChatFormatting.GREEN + GTUtility.formatNumbers(this.mProgresstime / 20) + EnumChatFormatting.RESET + " s / " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers(this.mMaxProgresstime / 20) + EnumChatFormatting.RESET + " s", StatCollector.func_74838_a((String)"GT5U.multiblock.usage") + " " + StatCollector.func_74838_a((String)"GT5U.LHE.steam") + ": " + (this.superheated ? EnumChatFormatting.RED : EnumChatFormatting.YELLOW) + GTUtility.formatNumbers(this.superheated ? -2L * (long)this.mEUt : (long)(-this.mEUt)) + EnumChatFormatting.RESET + " EU/t", StatCollector.func_74838_a((String)"GT5U.multiblock.problems") + ": " + EnumChatFormatting.RED + (this.getIdealStatus() - this.getRepairStatus()) + EnumChatFormatting.RESET + " " + StatCollector.func_74838_a((String)"GT5U.multiblock.efficiency") + ": " + EnumChatFormatting.YELLOW + (float)this.mEfficiency / 100.0f + EnumChatFormatting.RESET + " %", StatCollector.func_74838_a((String)"GT5U.LHE.superheated") + ": " + (this.superheated ? EnumChatFormatting.RED : EnumChatFormatting.BLUE) + this.superheated + EnumChatFormatting.RESET, StatCollector.func_74838_a((String)"GT5U.LHE.superheated") + " " + StatCollector.func_74838_a((String)"GT5U.LHE.threshold") + ": " + EnumChatFormatting.GREEN + GTUtility.formatNumbers(this.superheated_threshold) + EnumChatFormatting.RESET};
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 1, 3, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivalBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 1, 3, 0, elementBudget, env, false, true);
    }

    @Override
    public void startRecipeProcessing() {
        super.startRecipeProcessing();
        MTEHatchInput mTEHatchInput = this.mInputHotFluidHatch;
        if (mTEHatchInput instanceof IRecipeProcessingAwareHatch) {
            IRecipeProcessingAwareHatch aware = (IRecipeProcessingAwareHatch)((Object)mTEHatchInput);
            if (this.mInputHotFluidHatch.isValid()) {
                aware.startRecipeProcessing();
            }
        }
    }

    @Override
    public void endRecipeProcessing() {
        super.endRecipeProcessing();
        MTEHatchInput mTEHatchInput = this.mInputHotFluidHatch;
        if (mTEHatchInput instanceof IRecipeProcessingAwareHatch) {
            IRecipeProcessingAwareHatch aware = (IRecipeProcessingAwareHatch)((Object)mTEHatchInput);
            if (this.mInputHotFluidHatch.isValid()) {
                aware.endRecipeProcessing(this);
            }
        }
    }
}

