/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import gregtech.api.GregTechAPI;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.common.tileentities.machines.multi.MTEFusionComputer;
import net.minecraft.block.Block;

public class MTEFusionComputer3
extends MTEFusionComputer {
    private static final ITexture textureOverlay = TextureFactory.of(TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FUSION3).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FUSION3_GLOW).extFacing().glow().build());

    public MTEFusionComputer3(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTEFusionComputer3(String aName) {
        super(aName);
    }

    @Override
    public int tier() {
        return 8;
    }

    @Override
    public long maxEUStore() {
        return 640010000L * (long)Math.min(16, this.mEnergyHatches.size()) / 16L;
    }

    @Override
    public long capableStartupCanonical() {
        return 640000000L;
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEFusionComputer3(this.mName);
    }

    @Override
    public Block getCasing() {
        return GregTechAPI.sBlockCasings4;
    }

    @Override
    public int getCasingMeta() {
        return 8;
    }

    @Override
    public Block getFusionCoil() {
        return GregTechAPI.sBlockCasings4;
    }

    @Override
    public int getFusionCoilMeta() {
        return 7;
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Fusion Reactor").addInfo("A SUN DOWN ON EARTH").addInfo("\u00a7b32,768\u00a77 EU/t and \u00a7b40M\u00a77 EU capacity per Energy Hatch").addInfo("If the recipe has a startup cost greater than the").addInfo("number of energy hatches * cap, you can't do it").beginStructureBlock(15, 3, 15, false).addController("See diagram when placed").addCasingInfoRange("Fusion Machine Casing Mk II", 79, 123, false).addStructureInfo("Cover the coils with casing").addOtherStructurePart("Fusion Coil Block", "Center part of the ring").addEnergyHatch("1-16, Specified casings", 2).addInputHatch("2-16, Specified casings", 1).addOutputHatch("1-16, Specified casings", 3).addStructureInfo("ALL Hatches must be UV or better").toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    public ITexture getTextureOverlay() {
        return textureOverlay;
    }
}

