/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import gregtech.api.casing.Casings;
import gregtech.api.casing.ICasingGroup;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Mods;
import gregtech.api.enums.StructureError;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.implementations.MTEExtendedPowerMultiBlockBase;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.render.TextureFactory;
import gregtech.api.structure.IStructureInstance;
import gregtech.api.structure.IStructureProvider;
import gregtech.api.structure.StructureWrapper;
import gregtech.api.structure.StructureWrapperInstanceInfo;
import gregtech.api.structure.StructureWrapperTooltipBuilder;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.OverclockCalculator;
import gregtech.common.misc.GTStructureChannels;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class MTEEntropicProcessor
extends MTEExtendedPowerMultiBlockBase<MTEEntropicProcessor>
implements ISurvivalConstructable,
IStructureProvider<MTEEntropicProcessor> {
    protected final StructureWrapper<MTEEntropicProcessor> structure;
    protected final StructureWrapperInstanceInfo<MTEEntropicProcessor> structureInstanceInfo;

    public MTEEntropicProcessor(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
        this.structure = new StructureWrapper<MTEEntropicProcessor>(this);
        this.structureInstanceInfo = null;
        this.structure.loadStructure();
    }

    protected MTEEntropicProcessor(MTEEntropicProcessor prototype) {
        super(prototype.mName);
        this.structure = prototype.structure;
        this.structureInstanceInfo = new StructureWrapperInstanceInfo<MTEEntropicProcessor>(this.structure);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity igte) {
        return new MTEEntropicProcessor(this);
    }

    @Override
    public String[][] getDefinition() {
        return new String[][]{{"  BBB  ", "   B   ", "   ~   ", "   B   ", "  BBB  "}, {" BBBBB ", " BA AB ", " BA AB ", " BA AB ", " BBBBB "}, {"BBBBBBB", " A   A ", " A   A ", " A   A ", "BBBBBBB"}, {"BBBBBBB", "B  C  B", "B  C  B", "B  C  B", "BBBBBBB"}, {"BBBBBBB", " A   A ", " A   A ", " A   A ", "BBBBBBB"}, {" BBBBB ", " BA AB ", " BA AB ", " BA AB ", " BBBBB "}, {"  BBB  ", "   B   ", "   B   ", "   B   ", "  BBB  "}};
    }

    @Override
    public IStructureDefinition<MTEEntropicProcessor> compile(String[][] def) {
        if (Mods.Thaumcraft.isModLoaded()) {
            this.structure.addCasing('A', Casings.WardedGlass);
        } else {
            this.structure.addCasing('A', Casings.BorosilicateGlassAny);
        }
        this.structure.addCasing('B', Casings.AlchemicalCasing).withHatches(1, 32, Arrays.asList(HatchElement.InputHatch, HatchElement.OutputHatch, HatchElement.InputBus, HatchElement.OutputBus, HatchElement.Maintenance, HatchElement.Energy)).withChannel(GTStructureChannels.ALCHEMICAL_CASING);
        if (Mods.Thaumcraft.isModLoaded()) {
            this.structure.addCasing('C', Casings.AlchemicalConstructTiered).withChannel(GTStructureChannels.ALCHEMICAL_CONSTRUCT);
        } else {
            this.structure.addCasing('C', Casings.AlchemicalCasing);
        }
        return this.structure.buildStructure(def);
    }

    @Override
    public IStructureInstance<MTEEntropicProcessor> getStructureInstance() {
        return this.structureInstanceInfo;
    }

    @Override
    public IStructureDefinition<MTEEntropicProcessor> getStructureDefinition() {
        return this.structure.structureDefinition;
    }

    @Override
    public void clearHatches() {
        super.clearHatches();
        this.structureInstanceInfo.clearHatches();
    }

    public void construct(ItemStack trigger, boolean hintsOnly) {
        this.structure.construct(this, trigger, hintsOnly);
    }

    public int survivalConstruct(ItemStack trigger, int elementBudget, ISurvivalBuildEnvironment env) {
        return this.structure.survivalConstruct(this, trigger, elementBudget, env);
    }

    @Override
    public boolean checkStructure(boolean aForceReset, IGregTechTileEntity base) {
        boolean successful = super.checkStructure(aForceReset, base);
        base.issueTileUpdate();
        this.structureInstanceInfo.onPostCheck(this);
        return successful;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity base, ItemStack itemStack) {
        return this.structure.checkStructure(this);
    }

    @Override
    protected void validateStructure(Collection<StructureError> errors, NBTTagCompound context) {
        super.validateStructure(errors, context);
        this.structureInstanceInfo.validate(errors, context);
    }

    @Override
    protected void localizeStructureErrors(Collection<StructureError> errors, NBTTagCompound context, List<String> lines) {
        super.localizeStructureErrors(errors, context, lines);
        this.structureInstanceInfo.localizeStructureErrors(errors, context, lines);
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        StructureWrapperTooltipBuilder<MTEEntropicProcessor> tt = new StructureWrapperTooltipBuilder<MTEEntropicProcessor>(this.structure);
        tt.addMachineType("Entropic Processor").addInfo("Processes substances by increasing or decreasing their entropy.").addSeparator().addInfo("Has 8 parallels by default.").addInfo("Using Advanced Alchemical Constructs increases the machine's parallels to 32.").addSeparator().addInfo("Mixes fluids or solids with a magical catalyst.").addInfo("Catalyst is consumed by the recipe, then returned upon completion.").addSeparator().addInfo("Performs one perfect overclock per casing tier (Thaumium = 1 perfect OC).");
        tt.beginStructureBlock(true).addAllCasingInfo();
        tt.addSubChannelUsage(GTStructureChannels.ALCHEMICAL_CASING);
        tt.addSubChannelUsage(GTStructureChannels.ALCHEMICAL_CONSTRUCT);
        tt.toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack itemStack) {
        return true;
    }

    @Override
    public int getMaxEfficiency(ItemStack itemStack) {
        return 10000;
    }

    @Override
    public int getDamageToComponent(ItemStack itemStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack itemStack) {
        return false;
    }

    @Override
    public boolean supportsVoidProtection() {
        return true;
    }

    @Override
    public boolean supportsBatchMode() {
        return true;
    }

    @Override
    public boolean supportsInputSeparation() {
        return true;
    }

    @Override
    public boolean supportsSingleRecipeLocking() {
        return true;
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return RecipeMaps.entropicProcessing;
    }

    private int getCasingTier() {
        if (this.structureInstanceInfo == null) {
            return 0;
        }
        return GTUtility.clamp(this.structureInstanceInfo.getCasingTier(ICasingGroup.ofCasing(Casings.AlchemicalCasing), 0), 0, 2);
    }

    private int getConstructTier() {
        if (this.structureInstanceInfo == null) {
            return 0;
        }
        return GTUtility.clamp(this.structureInstanceInfo.getCasingTier(ICasingGroup.ofCasing(Casings.AlchemicalConstructTiered), 0), 0, 1);
    }

    @Override
    public int getMaxParallelRecipes() {
        return this.getConstructTier() == 1 ? 32 : 8;
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic(){

            @Override
            @Nonnull
            protected OverclockCalculator createOverclockCalculator(@Nonnull GTRecipe recipe) {
                return super.createOverclockCalculator(recipe).setMachineHeat((MTEEntropicProcessor.this.getCasingTier() + 1) * 1800).setRecipeHeat(0).setHeatOC(true).setHeatDiscount(false);
            }
        }.setMaxParallelSupplier(this::getTrueParallel);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74768_a("casingTier", this.getCasingTier());
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.structureInstanceInfo.setCasingTier(ICasingGroup.ofCasing(Casings.AlchemicalCasing), aNBT.func_74762_e("casingTier"));
    }

    @Override
    public NBTTagCompound getDescriptionData() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("casingTier", this.getCasingTier());
        return tag;
    }

    @Override
    public void onDescriptionPacket(NBTTagCompound data) {
        this.structureInstanceInfo.setCasingTier(ICasingGroup.ofCasing(Casings.AlchemicalCasing), data.func_74762_e("casingTier"));
        this.getBaseMetaTileEntity().issueTextureUpdate();
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity igte, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean active, boolean redstoneLevel) {
        ArrayList<ITexture> textures = new ArrayList<ITexture>();
        switch (this.getCasingTier()) {
            case 0: {
                textures.add(TextureFactory.builder().addIcon(Textures.BlockIcons.MACHINE_CASING_THAUMIUM).build());
                break;
            }
            case 1: {
                textures.add(TextureFactory.builder().addIcon(Textures.BlockIcons.MACHINE_CASING_VOID).build());
                break;
            }
            case 2: {
                textures.add(TextureFactory.builder().addIcon(Textures.BlockIcons.MACHINE_CASING_ICHORIUM).build());
            }
        }
        if (side == facing) {
            if (active) {
                textures.add(TextureFactory.builder().addIcon(TexturesGtBlock.Overlay_Machine_Controller_Advanced_Active).extFacing().build());
            } else {
                textures.add(TextureFactory.builder().addIcon(TexturesGtBlock.Overlay_Machine_Controller_Advanced).extFacing().build());
            }
        }
        return textures.toArray(new ITexture[0]);
    }
}

