/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import com.gtnewhorizon.gtnhlib.capability.Capabilities;
import com.gtnewhorizon.structurelib.StructureLibAPI;
import com.gtnewhorizon.structurelib.alignment.constructable.IConstructable;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.Column;
import com.gtnewhorizons.modularui.common.widget.DynamicPositionedColumn;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.Textures;
import gregtech.api.enums.TierEU;
import gregtech.api.interfaces.ICleanroom;
import gregtech.api.interfaces.ICleanroomReceiver;
import gregtech.api.interfaces.ISecondaryDescribable;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEBasicHull;
import gregtech.api.metatileentity.implementations.MTEHatchEnergy;
import gregtech.api.metatileentity.implementations.MTEHatchMaintenance;
import gregtech.api.metatileentity.implementations.MTETooltipMultiBlockBase;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.recipe.check.SimpleCheckRecipeResult;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTUtility;
import gregtech.api.util.GlassTier;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.OverclockCalculator;
import gregtech.common.config.MachineStats;
import ic2.core.block.BlockIC2Door;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class MTECleanroom
extends MTETooltipMultiBlockBase
implements IConstructable,
ISecondaryDescribable,
ICleanroom {
    public static final int MAX_WIDTH = 15;
    public static final int MAX_HEIGHT = 15;
    public static final HashSet<String> ALLOWED_BLOCKS = new HashSet();
    protected static Block CASING_BLOCK;
    protected static final int CASING_META = 2;
    protected static final int CASING_INDEX = 210;
    protected static Block FILTER_BLOCK;
    protected static final int FILTER_META = 11;
    protected static final int MIN_GLASS_TIER = 4;
    private final Set<ICleanroomReceiver> cleanroomReceivers = new HashSet<ICleanroomReceiver>();
    private int mHeight = -1;
    protected int dxMin = 0;
    protected int dxMax = 0;
    protected int dzMin = 0;
    protected int dzMax = 0;
    protected int dyMin = 0;
    protected int casingCount;
    protected int otherCount;
    protected boolean isDoorOpen;
    private static final int MASK_CASING = 1;
    private static final int MASK_FILTER = 2;
    private static final int MASK_GLASS = 4;
    private static final int MASK_OTHER = 8;
    private static final int MASK_DOOR = 16;
    private static final int MASK_HATCH = 32;
    private static final int MASK_CEILING_INTERNAL = 2;
    private static final int MASK_CEILING_EDGE = 45;
    private static final int MASK_WALL_INTERNAL = 61;
    private static final int MASK_WALL_EDGE = 45;
    private static final int MASK_FLOOR_INTERNAL = 45;
    private static final int MASK_FLOOR_EDGE = 45;

    public MTECleanroom(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTECleanroom(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTECleanroom(this.mName);
    }

    @Override
    public int getCleanness() {
        return this.mEfficiency;
    }

    @Override
    public boolean isValidCleanroom() {
        return this.isValid() && this.mMachine;
    }

    @Override
    public void pollute() {
        this.mEfficiency = 0;
        this.mWrench = false;
        this.mScrewdriver = false;
        this.mSoftMallet = false;
        this.mHardHammer = false;
        this.mSolderingTool = false;
        this.mCrowbar = false;
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Cleanroom").addInfo("Consumes 40 EU/t when first turned on, and 4 EU/t once at 100% efficiency.").addInfo("Can accept 2A from an LV energy hatch.").addInfo("Will overclock and gain efficiency faster starting from HV.").addSeparator().addInfo(EnumChatFormatting.RED + "Warning:").addInfo("Below 100% efficiency machines inside have a chance to void outputs!").addInfo("Each maintenance issue reduces maximum efficiency by 10%.").addInfo("Generating any pollution inside causes the cleanroom to shut down.").beginVariableStructureBlock(3, 15, 4, 15, 3, 15, true).addController("Top center.").addStructureInfo("  If width or length is even, it can be in either of the two middle positions.").addOtherStructurePart("Filter Machine Casing", "Top layer, except for edges.").addOtherStructurePart("Plascrete Blocks", "Edges of top layer, all walls and floor. Minimum " + EnumChatFormatting.GOLD + MachineStats.cleanroom.minCasingCount + EnumChatFormatting.GRAY + ".").addEnergyHatch("Any Plascrete Block. Exactly one.").addMaintenanceHatch("Any Plascrete Block. Exactly one.").addStructureInfo("").addStructureInfo("Up to " + EnumChatFormatting.GOLD + MachineStats.cleanroom.maxReplacementPercentage + "%" + EnumChatFormatting.GRAY + " of plascrete blocks can be replaced by other valid blocks.").addStructureInfo("Try some of the following:").addStructureInfo("- Any " + EnumChatFormatting.DARK_GRAY + "EV+" + EnumChatFormatting.GRAY + " tier glass.").addStructureInfo("- Machine hulls or diodes for item and power transfer.").addStructureInfo("- Reinforced Doors (" + EnumChatFormatting.ITALIC + "IC2" + EnumChatFormatting.RESET + EnumChatFormatting.GRAY + "). Keep closed, no gaps allowed or efficiency will drop!").addStructureInfo("- Elevators (" + EnumChatFormatting.ITALIC + "OpenBlocks" + EnumChatFormatting.RESET + EnumChatFormatting.GRAY + ") or Travel Anchors (" + EnumChatFormatting.ITALIC + "EnderIO" + EnumChatFormatting.RESET + EnumChatFormatting.GRAY + ").").addStructureInfo("See " + EnumChatFormatting.DARK_GRAY + "config/GregTech/MachineStats.cfg" + EnumChatFormatting.GRAY + " for more valid blocks.").addStructureInfo(EnumChatFormatting.YELLOW + "All non-plascrete blocks now share the same limit. Feel free to mix and match!").toolTipFinisher(new String[0]);
        return tt;
    }

    public String[] getStructureDescription(ItemStack itemStack) {
        return new String[]{"The base can be rectangular."};
    }

    @Override
    @Nonnull
    public CheckRecipeResult checkProcessing() {
        this.mEfficiencyIncrease = 100;
        long inputVoltage = this.getMaxInputVoltage();
        if (inputVoltage < TierEU.LV) {
            return CheckRecipeResultRegistry.insufficientPower(40L);
        }
        int amperage = inputVoltage == TierEU.LV ? 2 : 1;
        OverclockCalculator calculator = new OverclockCalculator().setRecipeEUt(40L).setEUt(inputVoltage * (long)amperage).setDuration(45 * Math.max(1, this.mHeight - 1)).calculate();
        this.mEUt = (int)calculator.getConsumption();
        this.mMaxProgresstime = calculator.getDuration();
        this.mEUt /= -10;
        return SimpleCheckRecipeResult.ofSuccess("cleanroom_running");
    }

    @Override
    public boolean isFacingValid(ForgeDirection facing) {
        return (facing.flag & (ForgeDirection.UP.flag | ForgeDirection.DOWN.flag)) == 0;
    }

    private CleanroomBlockType getBlockType(IGregTechTileEntity aBaseMetaTileEntity, int dx, int dy, int dz, int allowedMask) {
        IGregTechTileEntity te;
        Integer glassTier;
        Block block = aBaseMetaTileEntity.getBlockOffset(dx, dy, dz);
        int meta = aBaseMetaTileEntity.getMetaIDOffset(dx, dy, dz);
        if ((allowedMask & 1) != 0 && block == CASING_BLOCK && meta == 2) {
            return CleanroomBlockType.CASING;
        }
        if ((allowedMask & 2) != 0 && block == FILTER_BLOCK && meta == 11) {
            return CleanroomBlockType.FILTER;
        }
        if ((allowedMask & 4) != 0 && (glassTier = GlassTier.getGlassBlockTier(block, meta)) != null && glassTier >= 4) {
            return CleanroomBlockType.GLASS;
        }
        if ((allowedMask & 8) != 0 && (ALLOWED_BLOCKS.contains(block.func_149739_a()) || ALLOWED_BLOCKS.contains(block.func_149739_a() + ":" + meta))) {
            return CleanroomBlockType.OTHER;
        }
        if ((allowedMask & 0x10) != 0 && block instanceof BlockIC2Door) {
            if (!this.isDoorOpen) {
                int doorOrientation = this.getDoorOrientation(aBaseMetaTileEntity, dx, dy, dz);
                if (doorOrientation < 0) {
                    if (GTValues.debugCleanroom) {
                        GTLog.out.println("Cleanroom: Invalid block at offset (" + dx + ", " + dy + ", " + dz + ").");
                    }
                    return CleanroomBlockType.INVALID;
                }
                if (doorOrientation % 2 == 0) {
                    if (dx != this.dxMin && dx != this.dxMax) {
                        this.isDoorOpen = true;
                    } else if (dz > this.dzMin && aBaseMetaTileEntity.getBlockOffset(dx, dy, dz - 1) instanceof BlockIC2Door && doorOrientation != this.getDoorOrientation(aBaseMetaTileEntity, dx, dy, dz - 1)) {
                        this.isDoorOpen = true;
                    } else if (dz < this.dzMax && aBaseMetaTileEntity.getBlockOffset(dx, dy, dz + 1) instanceof BlockIC2Door && doorOrientation != this.getDoorOrientation(aBaseMetaTileEntity, dx, dy, dz + 1)) {
                        this.isDoorOpen = true;
                    }
                } else if (dz != this.dzMin && dz != this.dzMax) {
                    this.isDoorOpen = true;
                } else if (dx > this.dxMin && aBaseMetaTileEntity.getBlockOffset(dx - 1, dy, dz) instanceof BlockIC2Door && doorOrientation != this.getDoorOrientation(aBaseMetaTileEntity, dx - 1, dy, dz)) {
                    this.isDoorOpen = true;
                } else if (dx < this.dxMax && aBaseMetaTileEntity.getBlockOffset(dx + 1, dy, dz) instanceof BlockIC2Door && doorOrientation != this.getDoorOrientation(aBaseMetaTileEntity, dx + 1, dy, dz)) {
                    this.isDoorOpen = true;
                }
                if (GTValues.debugCleanroom && this.isDoorOpen) {
                    GTLog.out.println("Cleanroom: Open door at offset (" + dx + ", " + dy + ", " + dz + ").");
                }
            }
            return CleanroomBlockType.DOOR;
        }
        if ((allowedMask & 0x20) != 0 && (te = aBaseMetaTileEntity.getIGregTechTileEntityOffset(dx, dy, dz)) != null) {
            IMetaTileEntity mte = te.getMetaTileEntity();
            if (mte instanceof MTEHatchMaintenance) {
                return CleanroomBlockType.HATCH_MAINTENANCE;
            }
            if (mte instanceof MTEHatchEnergy) {
                return CleanroomBlockType.HATCH_ENERGY;
            }
            if (mte instanceof MTEBasicHull) {
                return CleanroomBlockType.HATCH_DIODE;
            }
            return CleanroomBlockType.INVALID;
        }
        return CleanroomBlockType.INVALID;
    }

    protected boolean addStructureBlock(IGregTechTileEntity aBaseMetaTileEntity, int dx, int dy, int dz, int allowedMask) {
        switch (this.getBlockType(aBaseMetaTileEntity, dx, dy, dz, allowedMask)) {
            case CASING: {
                ++this.casingCount;
                return true;
            }
            case FILTER: {
                return true;
            }
            case GLASS: 
            case OTHER: 
            case DOOR: 
            case HATCH_DIODE: {
                ++this.otherCount;
                return true;
            }
            case HATCH_ENERGY: {
                this.addEnergyInputToMachineList(aBaseMetaTileEntity.getIGregTechTileEntityOffset(dx, dy, dz), 210);
                ++this.otherCount;
                return true;
            }
            case HATCH_MAINTENANCE: {
                this.addMaintenanceToMachineList(aBaseMetaTileEntity.getIGregTechTileEntityOffset(dx, dy, dz), 210);
                ++this.otherCount;
                return true;
            }
            case INVALID: {
                if (GTValues.debugCleanroom) {
                    GTLog.out.println("Cleanroom: Invalid block at offset (" + dx + ", " + dy + ", " + dz + ").");
                }
                return false;
            }
        }
        throw new IllegalArgumentException("Cleanroom error: unknown block type at at offset (" + dx + ", " + dy + ", " + dz + ").");
    }

    protected boolean checkSize(IGregTechTileEntity aBaseMetaTileEntity) {
        this.dxMin = -1;
        while (this.dxMin >= -7 && this.getBlockType(aBaseMetaTileEntity, this.dxMin, 0, 0, 2) != CleanroomBlockType.INVALID) {
            --this.dxMin;
        }
        if (this.dxMin < -7) {
            if (GTValues.debugCleanroom) {
                GTLog.out.println("Cleanroom: Too large (x-axis).");
            }
            return false;
        }
        this.dxMax = 1;
        while (this.dxMax <= 7 && this.getBlockType(aBaseMetaTileEntity, this.dxMax, 0, 0, 2) != CleanroomBlockType.INVALID) {
            ++this.dxMax;
        }
        if (this.dxMax > 7) {
            if (GTValues.debugCleanroom) {
                GTLog.out.println("Cleanroom: Too large (x-axis).");
            }
            return false;
        }
        if (Math.abs(this.dxMin + this.dxMax) > 1) {
            if (GTValues.debugCleanroom) {
                GTLog.out.println("Cleanroom: Controller not centered (x-axis).");
            }
            return false;
        }
        this.dzMin = -1;
        while (this.dzMin >= -7 && this.getBlockType(aBaseMetaTileEntity, 0, 0, this.dzMin, 2) != CleanroomBlockType.INVALID) {
            --this.dzMin;
        }
        if (this.dzMin < -7) {
            if (GTValues.debugCleanroom) {
                GTLog.out.println("Cleanroom: Too large (z-axis).");
            }
            return false;
        }
        this.dzMax = 1;
        while (this.dzMax <= 7 && this.getBlockType(aBaseMetaTileEntity, 0, 0, this.dzMax, 2) != CleanroomBlockType.INVALID) {
            ++this.dzMax;
        }
        if (this.dzMax > 7) {
            if (GTValues.debugCleanroom) {
                GTLog.out.println("Cleanroom: Too large (z-axis).");
            }
            return false;
        }
        if (Math.abs(this.dzMin + this.dzMax) > 1) {
            if (GTValues.debugCleanroom) {
                GTLog.out.println("Cleanroom: Controller not centered (z-axis).");
            }
            return false;
        }
        if (GTValues.debugCleanroom) {
            GTLog.out.println("Cleanroom: dxMin = " + this.dxMin + ", dxMax = " + this.dxMax + ", dzMin = " + this.dzMin + ", dzMax = " + this.dzMax + ".");
        }
        return true;
    }

    protected boolean checkCeiling(IGregTechTileEntity aBaseMetaTileEntity) {
        for (int dx = this.dxMin; dx <= this.dxMax; ++dx) {
            for (int dz = this.dzMin; dz <= this.dzMax; ++dz) {
                if (dx == 0 && dz == 0 || !(dx == this.dxMin || dx == this.dxMax || dz == this.dzMin || dz == this.dzMax ? !this.addStructureBlock(aBaseMetaTileEntity, dx, 0, dz, 45) : !this.addStructureBlock(aBaseMetaTileEntity, dx, 0, dz, 2))) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean checkFloor(IGregTechTileEntity aBaseMetaTileEntity, int dy) {
        int addedCasings = 0;
        int addedOther = 0;
        ArrayList<IGregTechTileEntity> energy = new ArrayList<IGregTechTileEntity>();
        ArrayList<IGregTechTileEntity> maintenance = new ArrayList<IGregTechTileEntity>();
        for (int dx = this.dxMin + 1; dx <= this.dxMax - 1; ++dx) {
            block8: for (int dz = this.dzMin + 1; dz <= this.dzMax - 1; ++dz) {
                switch (this.getBlockType(aBaseMetaTileEntity, dx, dy, dz, 45)) {
                    case CASING: {
                        ++addedCasings;
                        continue block8;
                    }
                    case FILTER: 
                    case GLASS: 
                    case OTHER: 
                    case DOOR: 
                    case HATCH_DIODE: {
                        ++addedOther;
                        continue block8;
                    }
                    case HATCH_ENERGY: {
                        energy.add(aBaseMetaTileEntity.getIGregTechTileEntityOffset(dx, dy, dz));
                        ++addedOther;
                        continue block8;
                    }
                    case HATCH_MAINTENANCE: {
                        maintenance.add(aBaseMetaTileEntity.getIGregTechTileEntityOffset(dx, dy, dz));
                        ++addedOther;
                        continue block8;
                    }
                    case INVALID: {
                        return false;
                    }
                    default: {
                        throw new IllegalArgumentException("Cleanroom error: unknown block type at at offset (" + dx + ", " + dy + ", " + dz + ").");
                    }
                }
            }
        }
        this.casingCount += addedCasings;
        this.otherCount += addedOther;
        for (IGregTechTileEntity te : energy) {
            this.addEnergyInputToMachineList(te, 210);
        }
        for (IGregTechTileEntity te : maintenance) {
            this.addMaintenanceToMachineList(te, 210);
        }
        return true;
    }

    protected boolean checkWall(IGregTechTileEntity aBaseMetaTileEntity, int dy) {
        for (int dx = this.dxMin + 1; dx <= this.dxMax - 1; ++dx) {
            if (!this.addStructureBlock(aBaseMetaTileEntity, dx, dy, this.dzMin, 61)) {
                return false;
            }
            if (this.addStructureBlock(aBaseMetaTileEntity, dx, dy, this.dzMax, 61)) continue;
            return false;
        }
        for (int dz = this.dzMin + 1; dz <= this.dzMax - 1; ++dz) {
            if (!this.addStructureBlock(aBaseMetaTileEntity, this.dxMin, dy, dz, 61)) {
                return false;
            }
            if (this.addStructureBlock(aBaseMetaTileEntity, this.dxMax, dy, dz, 61)) continue;
            return false;
        }
        if (!this.addStructureBlock(aBaseMetaTileEntity, this.dxMin, dy, this.dzMin, 45)) {
            return false;
        }
        if (!this.addStructureBlock(aBaseMetaTileEntity, this.dxMin, dy, this.dzMax, 45)) {
            return false;
        }
        if (!this.addStructureBlock(aBaseMetaTileEntity, this.dxMax, dy, this.dzMin, 45)) {
            return false;
        }
        return this.addStructureBlock(aBaseMetaTileEntity, this.dxMax, dy, this.dzMax, 45);
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mUpdate = 100;
        this.cleanroomReceivers.forEach(r -> r.setCleanroom(null));
        this.cleanroomReceivers.clear();
        this.casingCount = 0;
        this.otherCount = 0;
        this.isDoorOpen = false;
        if (GTValues.debugCleanroom) {
            GTLog.out.println("Cleanroom: Starting structure check.");
        }
        if (this.dyMin == 0 || !this.checkCeiling(aBaseMetaTileEntity)) {
            if (!this.checkSize(aBaseMetaTileEntity)) {
                return false;
            }
            if (!this.checkCeiling(aBaseMetaTileEntity)) {
                return false;
            }
        }
        this.dyMin = -1;
        while (this.dyMin >= -14) {
            if (this.dyMin < -2 && this.checkFloor(aBaseMetaTileEntity, this.dyMin)) {
                for (int dx = this.dxMin; dx <= this.dxMax; ++dx) {
                    if (!this.addStructureBlock(aBaseMetaTileEntity, dx, this.dyMin, this.dzMin, 45)) {
                        return false;
                    }
                    if (this.addStructureBlock(aBaseMetaTileEntity, dx, this.dyMin, this.dzMax, 45)) continue;
                    return false;
                }
                for (int dz = this.dzMin + 1; dz <= this.dzMax - 1; ++dz) {
                    if (!this.addStructureBlock(aBaseMetaTileEntity, this.dxMin, this.dyMin, dz, 45)) {
                        return false;
                    }
                    if (this.addStructureBlock(aBaseMetaTileEntity, this.dxMax, this.dyMin, dz, 45)) continue;
                    return false;
                }
                break;
            }
            if (!this.checkWall(aBaseMetaTileEntity, this.dyMin)) {
                return false;
            }
            --this.dyMin;
        }
        if (this.dyMin < -14) {
            if (GTValues.debugCleanroom) {
                GTLog.out.println("Cleanroom: Too tall.");
            }
            return false;
        }
        this.mHeight = -this.dyMin + 1;
        if (GTValues.debugCleanroom) {
            GTLog.out.println("Cleanroom: Structure complete. Found " + this.casingCount + " casings, " + this.otherCount + " other blocks.");
        }
        if (this.mMaintenanceHatches.size() != 1 || this.mEnergyHatches.size() != 1) {
            if (GTValues.debugCleanroom) {
                GTLog.out.println("Cleanroom: Incorrect number of hatches.");
            }
            return false;
        }
        if (this.casingCount < MachineStats.cleanroom.minCasingCount) {
            if (GTValues.debugCleanroom) {
                GTLog.out.println("Cleanroom: Not enough plascrete blocks.");
            }
            return false;
        }
        if (this.otherCount * 100 / (this.casingCount + this.otherCount) > MachineStats.cleanroom.maxReplacementPercentage) {
            if (GTValues.debugCleanroom) {
                GTLog.out.println("Cleanroom: Too many non-plascrete blocks.");
            }
            return false;
        }
        if (this.isDoorOpen) {
            this.mEfficiency = Math.max(0, this.mEfficiency - 200);
        }
        for (ForgeDirection tSide : ForgeDirection.VALID_DIRECTIONS) {
            byte t = (byte)Math.max(1, (byte)(15.0f / (10000.0f / (float)this.mEfficiency)));
            aBaseMetaTileEntity.setInternalOutputRedstoneSignal(tSide, t);
        }
        for (int dy = this.dyMin + 1; dy < 0; ++dy) {
            for (int dx = this.dxMin + 1; dx <= this.dxMax - 1; ++dx) {
                for (int dz = this.dzMin + 1; dz <= this.dzMax - 1; ++dz) {
                    TileEntity te = aBaseMetaTileEntity.getTileEntityOffset(dx, dy, dz);
                    ICleanroomReceiver receiver = (ICleanroomReceiver)Capabilities.getCapability((TileEntity)te, ICleanroomReceiver.class);
                    if (receiver == null) continue;
                    receiver.setCleanroom(this);
                    this.cleanroomReceivers.add(receiver);
                }
            }
        }
        if (GTValues.debugCleanroom) {
            GTLog.out.println("Cleanroom: Check successful.");
        }
        return true;
    }

    @Override
    public boolean allowGeneralRedstoneOutput() {
        return true;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection sideDirection, ForgeDirection facingDirection, int colorIndex, boolean active, boolean redstoneLevel) {
        if ((sideDirection.flag & (ForgeDirection.UP.flag | ForgeDirection.DOWN.flag)) != 0) {
            return new ITexture[]{TextureFactory.of(Textures.BlockIcons.BLOCK_PLASCRETE), active ? TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_TOP_CLEANROOM_ACTIVE), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_TOP_CLEANROOM_ACTIVE_GLOW).glow().build()) : TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_TOP_CLEANROOM), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_TOP_CLEANROOM_GLOW).glow().build())};
        }
        return new ITexture[]{TextureFactory.of(Textures.BlockIcons.BLOCK_PLASCRETE)};
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        int i = Math.min(stackSize.field_77994_a, 7);
        IGregTechTileEntity baseEntity = this.getBaseMetaTileEntity();
        World world = baseEntity.getWorld();
        int x = baseEntity.getXCoord();
        int y = baseEntity.getYCoord();
        int z = baseEntity.getZCoord();
        int yoff = Math.max(i * 2, 3);
        for (int X2 = x - i; X2 <= x + i; ++X2) {
            for (int Y = y; Y >= y - yoff; --Y) {
                for (int Z = z - i; Z <= z + i; ++Z) {
                    if (X2 == x && Y == y && Z == z) continue;
                    if (X2 == x - i || X2 == x + i || Z == z - i || Z == z + i || Y == y - yoff) {
                        if (hintsOnly) {
                            StructureLibAPI.hintParticle((World)world, (int)X2, (int)Y, (int)Z, (Block)CASING_BLOCK, (int)2);
                            continue;
                        }
                        world.func_147465_d(X2, Y, Z, CASING_BLOCK, 2, 2);
                        continue;
                    }
                    if (Y != y) continue;
                    if (hintsOnly) {
                        StructureLibAPI.hintParticle((World)world, (int)X2, (int)Y, (int)Z, (Block)FILTER_BLOCK, (int)11);
                        continue;
                    }
                    world.func_147465_d(X2, Y, Z, FILTER_BLOCK, 11, 2);
                }
            }
        }
    }

    @Override
    public void onConfigLoad() {
        ALLOWED_BLOCKS.clear();
        Collections.addAll(ALLOWED_BLOCKS, MachineStats.cleanroom.allowedBlocks);
        CASING_BLOCK = GregTechAPI.sBlockReinforced;
        FILTER_BLOCK = GregTechAPI.sBlockCasings3;
    }

    protected int getDoorOrientation(IGregTechTileEntity aBaseMetaTileEntity, int dx, int dy, int dz) {
        int meta = aBaseMetaTileEntity.getMetaIDOffset(dx, dy, dz);
        if (meta < 4) {
            return meta;
        }
        if (meta < 8) {
            if (aBaseMetaTileEntity.getBlockOffset(dx, dy + 1, dz) instanceof BlockIC2Door) {
                return this.getDoorOrientation(meta, aBaseMetaTileEntity.getMetaIDOffset(dx, dy + 1, dz));
            }
            return -1;
        }
        if (meta < 10) {
            if (aBaseMetaTileEntity.getBlockOffset(dx, dy - 1, dz) instanceof BlockIC2Door) {
                return this.getDoorOrientation(aBaseMetaTileEntity.getMetaIDOffset(dx, dy - 1, dz), meta);
            }
            return -1;
        }
        return -1;
    }

    protected int getDoorOrientation(int bottomMeta, int topMeta) {
        if (bottomMeta < 4) {
            return bottomMeta;
        }
        if (bottomMeta < 8) {
            if (topMeta == 8) {
                return (bottomMeta + 1) % 4;
            }
            if (topMeta == 9) {
                return (bottomMeta - 1) % 4;
            }
        }
        return -1;
    }

    @Override
    protected void drawTexts(DynamicPositionedColumn screenElements, SlotWidget inventorySlot) {
        super.drawTexts(screenElements, inventorySlot);
        ((Column)screenElements.widget((Widget)new TextWidget().setStringSupplier(() -> StatCollector.func_74838_a((String)"GT5U.multiblock.efficiency") + ": " + GTUtility.formatNumbers((double)this.mEfficiency / 100.0) + "%").setTextAlignment(Alignment.CenterLeft).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()))).widget((Widget)new FakeSyncWidget.IntegerSyncer(() -> this.mEfficiency, eff -> {
            this.mEfficiency = eff;
        }));
    }

    private static enum CleanroomBlockType {
        CASING,
        FILTER,
        GLASS,
        OTHER,
        DOOR,
        HATCH_ENERGY,
        HATCH_MAINTENANCE,
        HATCH_DIODE,
        INVALID;

    }
}

