/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.automation;

import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEBuffer;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTUtility;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class MTEItemDistributor
extends MTEBuffer {
    private byte[] itemsPerSide = new byte[6];
    private ForgeDirection currentSide = ForgeDirection.DOWN;
    private byte currentSideItemCount = 0;

    public MTEItemDistributor(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 28, new String[]{"Distributes Items between different Machine Sides", "Default Items per Machine Side: 0", "Use Screwdriver to increase/decrease Items per Side"});
    }

    public MTEItemDistributor(String aName, int aTier, int aInvSlotCount, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aInvSlotCount, aDescription, aTextures);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEItemDistributor(this.mName, this.mTier, this.mInventory.length, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public ITexture getOverlayIcon() {
        return TextureFactory.of(TextureFactory.of(Textures.BlockIcons.AUTOMATION_ITEMDISTRIBUTOR), TextureFactory.builder().addIcon(Textures.BlockIcons.AUTOMATION_ITEMDISTRIBUTOR_GLOW).glow().build());
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return side == aBaseMetaTileEntity.getFrontFacing();
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection aFacing, int colorIndex, boolean aActive, boolean redstoneLevel) {
        if (side == aFacing) {
            return this.mTextures[0][colorIndex + 1];
        }
        return this.mTextures[1][colorIndex + 1];
    }

    @Override
    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        ITexture[][][] returnTextures = new ITexture[2][17][];
        ITexture baseIcon = this.getOverlayIcon();
        ITexture pipeIcon = TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE_OUT);
        for (int i = 0; i < 17; ++i) {
            returnTextures[0][i] = new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][i], baseIcon};
            returnTextures[1][i] = new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][i], pipeIcon, baseIcon};
        }
        return returnTextures;
    }

    @Override
    public boolean isInputFacing(ForgeDirection side) {
        return this.getBaseMetaTileEntity().getFrontFacing() == side || this.itemsPerSide[side.ordinal()] == 0;
    }

    @Override
    public boolean isOutputFacing(ForgeDirection side) {
        return this.getBaseMetaTileEntity().getFrontFacing() != side && this.itemsPerSide[side.ordinal()] > 0;
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.itemsPerSide = aNBT.func_74770_j("mItemsPerSide");
        if (this.itemsPerSide.length != 6) {
            this.itemsPerSide = new byte[6];
        }
        this.currentSide = ForgeDirection.getOrientation((int)aNBT.func_74771_c("mCurrentSide"));
        this.currentSideItemCount = aNBT.func_74771_c("mCurrentSideItemCount");
    }

    @Override
    protected void moveItems(IGregTechTileEntity aBaseMetaTileEntity, long aTimer) {
        int currentSideOrdinal = this.currentSide.ordinal();
        this.fillStacksIntoFirstSlots();
        TileEntity adjacentTileEntity = aBaseMetaTileEntity.getTileEntityAtSide(this.currentSide);
        int inspectedSides = 0;
        while (this.itemsPerSide[currentSideOrdinal] == 0) {
            currentSideOrdinal = (currentSideOrdinal + 1) % 6;
            this.currentSide = ForgeDirection.getOrientation((int)currentSideOrdinal);
            this.currentSideItemCount = 0;
            adjacentTileEntity = aBaseMetaTileEntity.getTileEntityAtSide(this.currentSide);
            if (++inspectedSides != 6) continue;
            return;
        }
        byte movedItems = GTUtility.moveOneItemStack(aBaseMetaTileEntity, adjacentTileEntity, this.currentSide, this.currentSide.getOpposite(), null, false, (byte)64, (byte)1, (byte)(this.itemsPerSide[currentSideOrdinal] - this.currentSideItemCount), (byte)1);
        this.currentSideItemCount = (byte)(this.currentSideItemCount + movedItems);
        if (this.currentSideItemCount >= this.itemsPerSide[currentSideOrdinal]) {
            currentSideOrdinal = (currentSideOrdinal + 1) % 6;
            this.currentSide = ForgeDirection.getOrientation((int)currentSideOrdinal);
            this.currentSideItemCount = 0;
        }
        if (movedItems > 0 || aBaseMetaTileEntity.hasInventoryBeenModified()) {
            this.mSuccess = 50;
        }
        this.fillStacksIntoFirstSlots();
    }

    @Override
    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aTool) {
        int ordinalSide;
        int n = ordinalSide = side.ordinal();
        this.itemsPerSide[n] = (byte)(this.itemsPerSide[n] + (aPlayer.func_70093_af() ? -1 : 1));
        this.itemsPerSide[ordinalSide] = (byte)((this.itemsPerSide[ordinalSide] + 128) % 128);
        GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("211", "Items per side: ") + this.itemsPerSide[ordinalSide]);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74773_a("mItemsPerSide", this.itemsPerSide);
        aNBT.func_74774_a("mCurrentSide", (byte)this.currentSide.ordinal());
        aNBT.func_74774_a("mCurrentSideItemCount", this.currentSideItemCount);
    }

    @Override
    public void setItemNBT(NBTTagCompound aNBT) {
        super.setItemNBT(aNBT);
        boolean hasSettings = false;
        for (byte i : this.itemsPerSide) {
            if (i == 0) continue;
            hasSettings = true;
            break;
        }
        if (hasSettings) {
            aNBT.func_74773_a("mItemsPerSide", this.itemsPerSide);
        }
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        super.addUIWidgets(builder, buildContext);
        this.addEmitRedstoneIfFullButton(builder);
        this.addInvertRedstoneButton(builder);
        builder.widget(new DrawableWidget().setDrawable((IDrawable)GTUITextures.PICTURE_ARROW_22_RED.apply(87, true)).setPos(62, 60).setSize(87, 22));
        this.addInventorySlots(builder);
    }
}

