/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.render.items;

import codechicken.lib.render.TextureUtils;
import gregtech.GTMod;
import gregtech.api.interfaces.IGT_ItemWithMaterialRenderer;
import gregtech.api.util.GTUtil;
import gregtech.common.render.items.GeneratedMaterialRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class TranscendentMetalRenderer
extends GeneratedMaterialRenderer {
    @Override
    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack aStack, Object ... data) {
        if (type == IItemRenderer.ItemRenderType.ENTITY && !Minecraft.func_71410_x().field_71474_y.field_74347_j) {
            if (RenderItem.field_82407_g) {
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
            GL11.glTranslatef((float)-0.5f, (float)-0.25f, (float)0.0421875f);
        }
        super.renderItem(type, aStack, data);
    }

    @Override
    protected void renderRegularItem(IItemRenderer.ItemRenderType type, ItemStack itemStack, IIcon icon, boolean shouldModulateColor) {
        Item item = itemStack.func_77973_b();
        if (!(item instanceof IGT_ItemWithMaterialRenderer)) {
            return;
        }
        IGT_ItemWithMaterialRenderer itemRenderer = (IGT_ItemWithMaterialRenderer)item;
        GL11.glPushMatrix();
        this.applyEffect(type, itemRenderer.getRGBa(itemStack), shouldModulateColor);
        if (shouldModulateColor) {
            short[] tModulation = itemRenderer.getRGBa(itemStack);
            GL11.glColor3f((float)((float)tModulation[0] / 255.0f), (float)((float)tModulation[1] / 255.0f), (float)((float)tModulation[2] / 255.0f));
        }
        if (type.equals((Object)IItemRenderer.ItemRenderType.INVENTORY)) {
            GL11.glScalef((float)16.0f, (float)16.0f, (float)32.0f);
        }
        ItemRenderer.func_78439_a((Tessellator)Tessellator.field_78398_a, (float)icon.func_94212_f(), (float)icon.func_94206_g(), (float)icon.func_94209_e(), (float)icon.func_94210_h(), (int)icon.func_94211_a(), (int)icon.func_94216_b(), (float)0.0625f);
        GL11.glPopMatrix();
    }

    @Override
    protected void renderContainedFluid(IItemRenderer.ItemRenderType type, FluidStack fluidStack, IIcon fluidIcon) {
        GL11.glPushMatrix();
        Fluid fluid = fluidStack.getFluid();
        this.applyEffect(type, GTUtil.getRGBaArray(fluid.getColor()), true);
        TextureUtils.bindAtlas((int)fluid.getSpriteNumber());
        GL11.glDepthFunc((int)514);
        if (type.equals((Object)IItemRenderer.ItemRenderType.INVENTORY)) {
            GL11.glScalef((float)16.0f, (float)16.0f, (float)32.0f);
        }
        ItemRenderer.func_78439_a((Tessellator)Tessellator.field_78398_a, (float)fluidIcon.func_94212_f(), (float)fluidIcon.func_94206_g(), (float)fluidIcon.func_94209_e(), (float)fluidIcon.func_94210_h(), (int)fluidIcon.func_94211_a(), (int)fluidIcon.func_94216_b(), (float)0.0625f);
        GL11.glDepthFunc((int)515);
        GL11.glPopMatrix();
    }

    @Override
    protected void renderItemOverlay(IItemRenderer.ItemRenderType type, IIcon overlay) {
        GL11.glPushMatrix();
        this.applyEffect(type, null, false);
        if (type.equals((Object)IItemRenderer.ItemRenderType.INVENTORY)) {
            GL11.glScalef((float)16.0f, (float)16.0f, (float)32.0f);
        }
        ItemRenderer.func_78439_a((Tessellator)Tessellator.field_78398_a, (float)overlay.func_94212_f(), (float)overlay.func_94206_g(), (float)overlay.func_94209_e(), (float)overlay.func_94210_h(), (int)overlay.func_94211_a(), (int)overlay.func_94216_b(), (float)0.0625f);
        GL11.glPopMatrix();
    }

    private void applyEffect(IItemRenderer.ItemRenderType type, short[] modulation, boolean shouldModulateColor) {
        if (RenderItem.field_82407_g) {
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.5f);
        }
        if (type.equals((Object)IItemRenderer.ItemRenderType.INVENTORY)) {
            GL11.glTranslatef((float)8.0f, (float)8.0f, (float)0.0f);
        } else {
            GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.0f);
        }
        GL11.glRotatef((float)((float)GTMod.clientProxy().getAnimationTicks() * 3.5f % 360.0f), (float)0.3f, (float)0.5f, (float)0.2f);
        GL11.glRotatef((float)180.0f, (float)0.5f, (float)0.0f, (float)0.0f);
        if (type.equals((Object)IItemRenderer.ItemRenderType.INVENTORY)) {
            GL11.glTranslatef((float)-8.0f, (float)-8.0f, (float)0.0f);
        } else {
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)0.0f);
        }
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.03125f);
        if (shouldModulateColor) {
            GL11.glColor4f((float)((float)modulation[0] / 255.0f), (float)((float)modulation[1] / 255.0f), (float)((float)modulation[2] / 255.0f), (float)255.0f);
        } else {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)255.0f);
        }
    }
}

